/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.mutable.primitive;

import java.io.Serializable;
import java.util.Collection;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.block.function.primitive.CharIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharIntPredicate;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.procedure.primitive.CharIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.api.list.primitive.CharList;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.stack.MutableStack;
import org.eclipse.collections.api.stack.primitive.ImmutableCharStack;
import org.eclipse.collections.api.stack.primitive.MutableCharStack;
import org.eclipse.collections.impl.factory.primitive.CharStacks;
import org.eclipse.collections.impl.iterator.UnmodifiableCharIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import org.eclipse.collections.impl.stack.mutable.primitive.UnmodifiableCharStack;

public class SynchronizedCharStack
implements MutableCharStack,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Object lock;
    private final MutableCharStack stack;

    public SynchronizedCharStack(MutableCharStack stack) {
        this(stack, null);
    }

    public SynchronizedCharStack(MutableCharStack stack, Object newLock) {
        this.stack = stack;
        this.lock = newLock == null ? this : newLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void push(char item) {
        Object object = this.lock;
        synchronized (object) {
            this.stack.push(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char pop() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharList pop(int count) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.pop(count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char peek() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.peek();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharList peek(int count) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.peek(count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char peekAt(int index) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.peekAt(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean notEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.notEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.stack.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(char value) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.contains(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(char ... source) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.containsAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(CharIterable source) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.containsAll(source);
        }
    }

    @Override
    public CharIterator charIterator() {
        return new UnmodifiableCharIterator(this.stack.charIterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void each(CharProcedure procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.stack.forEach(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int count(CharPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.count(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean anySatisfy(CharPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.anySatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean allSatisfy(CharPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.allSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean noneSatisfy(CharPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.noneSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char detectIfNone(CharPredicate predicate, char ifNone) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.detectIfNone(predicate, ifNone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableCharStack select(CharPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableCharStack reject(CharPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableStack<V> collect(CharToObjectFunction<? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.collect((CharToObjectFunction)function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long sum() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.sum();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char max() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.max();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char min() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.min();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char minIfEmpty(char defaultValue) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.minIfEmpty(defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char maxIfEmpty(char defaultValue) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.maxIfEmpty(defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double average() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.average();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double median() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.median();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableCharList toSortedList() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.toSortedList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char[] toSortedArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.toSortedArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char[] toArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char[] toArray(char[] target) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.toArray(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String makeString() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.makeString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String makeString(String separator) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.makeString(separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String makeString(String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.makeString(start, separator, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendString(Appendable appendable) {
        Object object = this.lock;
        synchronized (object) {
            this.stack.appendString(appendable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendString(Appendable appendable, String separator) {
        Object object = this.lock;
        synchronized (object) {
            this.stack.appendString(appendable, separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            this.stack.appendString(appendable, start, separator, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableCharList toList() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableCharSet toSet() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.toSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableCharBag toBag() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.toBag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object otherStack) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.equals(otherStack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyCharIterable asLazy() {
        Object object = this.lock;
        synchronized (object) {
            return new LazyCharIterableAdapter(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableCharStack asUnmodifiable() {
        Object object = this.lock;
        synchronized (object) {
            return new UnmodifiableCharStack(this);
        }
    }

    @Override
    public MutableCharStack asSynchronized() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableCharStack toImmutable() {
        Object object = this.lock;
        synchronized (object) {
            return CharStacks.immutable.withAllReversed(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableCharStack newEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.newEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.injectInto(injectedValue, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RichIterable<CharIterable> chunk(int size) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.chunk(size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char getFirst() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.getFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(char value) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.indexOf(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T injectIntoWithIndex(T injectedValue, ObjectCharIntToObjectFunction<? super T, ? extends T> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.injectIntoWithIndex(injectedValue, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEachWithIndex(CharIntProcedure procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.stack.forEachWithIndex(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableCharStack selectWithIndex(CharIntPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.selectWithIndex(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends MutableCharCollection> R selectWithIndex(CharIntPredicate predicate, R target) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.selectWithIndex(predicate, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableCharStack rejectWithIndex(CharIntPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.rejectWithIndex(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends MutableCharCollection> R rejectWithIndex(CharIntPredicate predicate, R target) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.rejectWithIndex(predicate, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableStack<V> collectWithIndex(CharIntToObjectFunction<? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.collectWithIndex((CharIntToObjectFunction)function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V, R extends Collection<V>> R collectWithIndex(CharIntToObjectFunction<? extends V> function, R target) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.collectWithIndex(function, target);
        }
    }
}

