/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.util.Arrays;

public class TimeSelector {
    private static final int MIN_DEFAULT_CAPACITY = 8;
    private final boolean ascending;
    private long[] timeHeap;
    private int heapSize;
    private long lastTime;

    public TimeSelector(int defaultCapacity, boolean isAscending) {
        this.ascending = isAscending;
        this.timeHeap = new long[Math.max(defaultCapacity, 8)];
        this.heapSize = 0;
        this.lastTime = Long.MIN_VALUE;
    }

    public boolean isEmpty() {
        while (this.heapSize != 0 && this.timeHeap[0] == this.lastTime) {
            this.timeHeap[0] = this.timeHeap[this.heapSize - 1];
            this.percolateDown(0, this.timeHeap[0]);
            --this.heapSize;
        }
        return this.heapSize == 0;
    }

    public void add(long time) {
        if (this.heapSize == 0) {
            this.timeHeap[0] = time;
        }
        if (this.percolateUp(this.heapSize, time)) {
            ++this.heapSize;
            this.checkExpansion();
        }
    }

    public long pollFirst() {
        long minTime = this.lastTime;
        while (minTime == this.lastTime) {
            minTime = this.timeHeap[0];
            this.timeHeap[0] = this.timeHeap[this.heapSize - 1];
            this.percolateDown(0, this.timeHeap[0]);
            --this.heapSize;
        }
        this.lastTime = minTime;
        return minTime;
    }

    private void checkExpansion() {
        if (this.heapSize == this.timeHeap.length) {
            this.timeHeap = Arrays.copyOf(this.timeHeap, this.timeHeap.length << 1);
        }
    }

    private boolean percolateUp(int index, long element) {
        if (index == 0) {
            return true;
        }
        int parentIndex = index - 1 >>> 1;
        long parent = this.timeHeap[parentIndex];
        if (parent == element) {
            return false;
        }
        if (this.ascending ? element < parent : parent < element) {
            this.timeHeap[index] = parent;
            this.timeHeap[parentIndex] = element;
            boolean isSuccessful = this.percolateUp(parentIndex, element);
            if (!isSuccessful) {
                this.timeHeap[index] = element;
                this.timeHeap[parentIndex] = parent;
            }
            return isSuccessful;
        }
        this.timeHeap[index] = element;
        return true;
    }

    private void percolateDown(int index, long element) {
        if (index == this.heapSize - 1) {
            return;
        }
        int childIndex = this.getSmallerChildIndex(index);
        if (childIndex != -1) {
            long child = this.timeHeap[childIndex];
            if (this.ascending ? child < element : element < child) {
                this.timeHeap[childIndex] = element;
                this.timeHeap[index] = child;
                this.percolateDown(childIndex, element);
            }
        }
    }

    private int getSmallerChildIndex(int index) {
        int leftChildIndex = (index << 1) + 1;
        int rightChildIndex = (index << 1) + 2;
        int smallerChildIndex = this.heapSize <= leftChildIndex ? -1 : (this.heapSize <= rightChildIndex ? leftChildIndex : (this.ascending ? (this.timeHeap[leftChildIndex] < this.timeHeap[rightChildIndex] ? leftChildIndex : rightChildIndex) : (this.timeHeap[leftChildIndex] < this.timeHeap[rightChildIndex] ? rightChildIndex : leftChildIndex)));
        return smallerChildIndex;
    }

    public String toString() {
        return Arrays.toString(this.timeHeap);
    }
}

