/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.seata.server.storage.db.store;

import org.apache.seata.common.loader.EnhancedServiceLoader;
import org.apache.seata.core.store.MappingDO;
import org.apache.seata.core.store.db.DataSourceProvider;
import org.apache.seata.server.BaseSpringBootTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledIfSystemProperty;

import javax.sql.DataSource;

@EnabledIfSystemProperty(named = "dbCaseEnabled", matches = "true")
public class VGroupMappingDataBaseDAOTest extends BaseSpringBootTest {

    private VGroupMappingDataBaseDAO vGroupMappingDataBaseDAO;

    @BeforeEach
    public void setUp() {
        DataSource dataSource =
                EnhancedServiceLoader.load(DataSourceProvider.class, "druid").provide();
        vGroupMappingDataBaseDAO = new VGroupMappingDataBaseDAO(dataSource);
    }

    @Test
    public void testInstanceCreation() {
        Assertions.assertNotNull(vGroupMappingDataBaseDAO);
    }

    @Test
    public void testInsertAndDeleteMappingDO() {
        MappingDO mappingDO = new MappingDO();
        mappingDO.setVGroup("test-vgroup");
        mappingDO.setNamespace("test-namespace");
        mappingDO.setCluster("test-cluster");

        boolean inserted = vGroupMappingDataBaseDAO.insertMappingDO(mappingDO);
        Assertions.assertTrue(inserted);

        boolean deleted = vGroupMappingDataBaseDAO.clearMappingDOByVGroup("test-vgroup");
        Assertions.assertTrue(deleted);
    }
}
