/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements. See the NOTICE file distributed with this
work for additional information regarding copyright ownership. The ASF
licenses this file to You under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
License for the specific language governing permissions and limitations
under the License.
*/
// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.28.0
// 	protoc        v3.21.1
// source: pdpb.proto

package hugegraph_pd_grpc

import (
	reflect "reflect"
	sync "sync"
	metaTask "vermeer/apps/protos/hugegraph-pd-grpc/metaTask"
	metapb "vermeer/apps/protos/hugegraph-pd-grpc/metapb"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type ErrorType int32

const (
	ErrorType_OK                           ErrorType = 0
	ErrorType_UNKNOWN                      ErrorType = 1
	ErrorType_NOT_LEADER                   ErrorType = 100
	ErrorType_STORE_ID_NOT_EXIST           ErrorType = 101
	ErrorType_NO_ACTIVE_STORE              ErrorType = 102
	ErrorType_NOT_FOUND                    ErrorType = 103
	ErrorType_PD_UNREACHABLE               ErrorType = 104
	ErrorType_LESS_ACTIVE_STORE            ErrorType = 105
	ErrorType_STORE_HAS_BEEN_REMOVED       ErrorType = 106
	ErrorType_STORE_PROHIBIT_DELETION      ErrorType = 111
	ErrorType_SET_CONFIG_SHARD_COUNT_ERROR ErrorType = 112
	ErrorType_UPDATE_STORE_STATE_ERROR     ErrorType = 113
	ErrorType_STORE_PROHIBIT_DUPLICATE     ErrorType = 114
	ErrorType_ROCKSDB_READ_ERROR           ErrorType = 1002
	ErrorType_ROCKSDB_WRITE_ERROR          ErrorType = 1003
	ErrorType_ROCKSDB_DEL_ERROR            ErrorType = 1004
	ErrorType_ROCKSDB_SAVE_SNAPSHOT_ERROR  ErrorType = 1005
	ErrorType_ROCKSDB_LOAD_SNAPSHOT_ERROR  ErrorType = 1006
	// 当前集群状态禁止分裂
	ErrorType_Cluster_State_Forbid_Splitting ErrorType = 1007
	// 正在分裂中
	ErrorType_Split_Partition_Doing ErrorType = 1008
	// store上分区数量超过上限
	ErrorType_Too_Many_Partitions_Per_Store ErrorType = 1009
	// license 错误
	ErrorType_LICENSE_ERROR ErrorType = 107
	// license 认证错误
	ErrorType_LICENSE_VERIFY_ERROR ErrorType = 108
	//分区下线正在进行
	ErrorType_Store_Tombstone_Doing ErrorType = 1010
	// 不合法的分裂个数
	ErrorType_Invalid_Split_Partition_Count ErrorType = 1011
)

// Enum value maps for ErrorType.
var (
	ErrorType_name = map[int32]string{
		0:    "OK",
		1:    "UNKNOWN",
		100:  "NOT_LEADER",
		101:  "STORE_ID_NOT_EXIST",
		102:  "NO_ACTIVE_STORE",
		103:  "NOT_FOUND",
		104:  "PD_UNREACHABLE",
		105:  "LESS_ACTIVE_STORE",
		106:  "STORE_HAS_BEEN_REMOVED",
		111:  "STORE_PROHIBIT_DELETION",
		112:  "SET_CONFIG_SHARD_COUNT_ERROR",
		113:  "UPDATE_STORE_STATE_ERROR",
		114:  "STORE_PROHIBIT_DUPLICATE",
		1002: "ROCKSDB_READ_ERROR",
		1003: "ROCKSDB_WRITE_ERROR",
		1004: "ROCKSDB_DEL_ERROR",
		1005: "ROCKSDB_SAVE_SNAPSHOT_ERROR",
		1006: "ROCKSDB_LOAD_SNAPSHOT_ERROR",
		1007: "Cluster_State_Forbid_Splitting",
		1008: "Split_Partition_Doing",
		1009: "Too_Many_Partitions_Per_Store",
		107:  "LICENSE_ERROR",
		108:  "LICENSE_VERIFY_ERROR",
		1010: "Store_Tombstone_Doing",
		1011: "Invalid_Split_Partition_Count",
	}
	ErrorType_value = map[string]int32{
		"OK":                             0,
		"UNKNOWN":                        1,
		"NOT_LEADER":                     100,
		"STORE_ID_NOT_EXIST":             101,
		"NO_ACTIVE_STORE":                102,
		"NOT_FOUND":                      103,
		"PD_UNREACHABLE":                 104,
		"LESS_ACTIVE_STORE":              105,
		"STORE_HAS_BEEN_REMOVED":         106,
		"STORE_PROHIBIT_DELETION":        111,
		"SET_CONFIG_SHARD_COUNT_ERROR":   112,
		"UPDATE_STORE_STATE_ERROR":       113,
		"STORE_PROHIBIT_DUPLICATE":       114,
		"ROCKSDB_READ_ERROR":             1002,
		"ROCKSDB_WRITE_ERROR":            1003,
		"ROCKSDB_DEL_ERROR":              1004,
		"ROCKSDB_SAVE_SNAPSHOT_ERROR":    1005,
		"ROCKSDB_LOAD_SNAPSHOT_ERROR":    1006,
		"Cluster_State_Forbid_Splitting": 1007,
		"Split_Partition_Doing":          1008,
		"Too_Many_Partitions_Per_Store":  1009,
		"LICENSE_ERROR":                  107,
		"LICENSE_VERIFY_ERROR":           108,
		"Store_Tombstone_Doing":          1010,
		"Invalid_Split_Partition_Count":  1011,
	}
)

func (x ErrorType) Enum() *ErrorType {
	p := new(ErrorType)
	*p = x
	return p
}

func (x ErrorType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ErrorType) Descriptor() protoreflect.EnumDescriptor {
	return file_pdpb_proto_enumTypes[0].Descriptor()
}

func (ErrorType) Type() protoreflect.EnumType {
	return &file_pdpb_proto_enumTypes[0]
}

func (x ErrorType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ErrorType.Descriptor instead.
func (ErrorType) EnumDescriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{0}
}

type OperationMode int32

const (
	OperationMode_Auto   OperationMode = 0
	OperationMode_Expert OperationMode = 1
)

// Enum value maps for OperationMode.
var (
	OperationMode_name = map[int32]string{
		0: "Auto",
		1: "Expert",
	}
	OperationMode_value = map[string]int32{
		"Auto":   0,
		"Expert": 1,
	}
)

func (x OperationMode) Enum() *OperationMode {
	p := new(OperationMode)
	*p = x
	return p
}

func (x OperationMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OperationMode) Descriptor() protoreflect.EnumDescriptor {
	return file_pdpb_proto_enumTypes[1].Descriptor()
}

func (OperationMode) Type() protoreflect.EnumType {
	return &file_pdpb_proto_enumTypes[1]
}

func (x OperationMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OperationMode.Descriptor instead.
func (OperationMode) EnumDescriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{1}
}

type RequestHeader struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// 集群 ID.
	ClusterId uint64 `protobuf:"varint,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// 发送者 ID.
	SenderId uint64 `protobuf:"varint,2,opt,name=sender_id,json=senderId,proto3" json:"sender_id,omitempty"`
}

func (x *RequestHeader) Reset() {
	*x = RequestHeader{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RequestHeader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RequestHeader) ProtoMessage() {}

func (x *RequestHeader) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RequestHeader.ProtoReflect.Descriptor instead.
func (*RequestHeader) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{0}
}

func (x *RequestHeader) GetClusterId() uint64 {
	if x != nil {
		return x.ClusterId
	}
	return 0
}

func (x *RequestHeader) GetSenderId() uint64 {
	if x != nil {
		return x.SenderId
	}
	return 0
}

type ResponseHeader struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// cluster_id is the ID of the cluster which sent the response.
	ClusterId uint64 `protobuf:"varint,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	Error     *Error `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *ResponseHeader) Reset() {
	*x = ResponseHeader{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResponseHeader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResponseHeader) ProtoMessage() {}

func (x *ResponseHeader) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResponseHeader.ProtoReflect.Descriptor instead.
func (*ResponseHeader) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{1}
}

func (x *ResponseHeader) GetClusterId() uint64 {
	if x != nil {
		return x.ClusterId
	}
	return 0
}

func (x *ResponseHeader) GetError() *Error {
	if x != nil {
		return x.Error
	}
	return nil
}

type Error struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type    ErrorType `protobuf:"varint,1,opt,name=type,proto3,enum=pdpb.ErrorType" json:"type,omitempty"`
	Message string    `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *Error) Reset() {
	*x = Error{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Error) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Error) ProtoMessage() {}

func (x *Error) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Error.ProtoReflect.Descriptor instead.
func (*Error) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{2}
}

func (x *Error) GetType() ErrorType {
	if x != nil {
		return x.Type
	}
	return ErrorType_OK
}

func (x *Error) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

type GetStoreRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header  *RequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	StoreId uint64         `protobuf:"varint,2,opt,name=store_id,json=storeId,proto3" json:"store_id,omitempty"`
}

func (x *GetStoreRequest) Reset() {
	*x = GetStoreRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetStoreRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetStoreRequest) ProtoMessage() {}

func (x *GetStoreRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetStoreRequest.ProtoReflect.Descriptor instead.
func (*GetStoreRequest) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{3}
}

func (x *GetStoreRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *GetStoreRequest) GetStoreId() uint64 {
	if x != nil {
		return x.StoreId
	}
	return 0
}

type GetStoreResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *ResponseHeader    `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	Store  *metapb.Store      `protobuf:"bytes,2,opt,name=store,proto3" json:"store,omitempty"`
	Stats  *metapb.StoreStats `protobuf:"bytes,3,opt,name=stats,proto3" json:"stats,omitempty"`
}

func (x *GetStoreResponse) Reset() {
	*x = GetStoreResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetStoreResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetStoreResponse) ProtoMessage() {}

func (x *GetStoreResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetStoreResponse.ProtoReflect.Descriptor instead.
func (*GetStoreResponse) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{4}
}

func (x *GetStoreResponse) GetHeader() *ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *GetStoreResponse) GetStore() *metapb.Store {
	if x != nil {
		return x.Store
	}
	return nil
}

func (x *GetStoreResponse) GetStats() *metapb.StoreStats {
	if x != nil {
		return x.Stats
	}
	return nil
}

type DetStoreRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header  *RequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	StoreId uint64         `protobuf:"varint,2,opt,name=store_id,json=storeId,proto3" json:"store_id,omitempty"`
}

func (x *DetStoreRequest) Reset() {
	*x = DetStoreRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DetStoreRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DetStoreRequest) ProtoMessage() {}

func (x *DetStoreRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DetStoreRequest.ProtoReflect.Descriptor instead.
func (*DetStoreRequest) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{5}
}

func (x *DetStoreRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *DetStoreRequest) GetStoreId() uint64 {
	if x != nil {
		return x.StoreId
	}
	return 0
}

type DetStoreResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	Store  *metapb.Store   `protobuf:"bytes,2,opt,name=store,proto3" json:"store,omitempty"`
}

func (x *DetStoreResponse) Reset() {
	*x = DetStoreResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DetStoreResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DetStoreResponse) ProtoMessage() {}

func (x *DetStoreResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DetStoreResponse.ProtoReflect.Descriptor instead.
func (*DetStoreResponse) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{6}
}

func (x *DetStoreResponse) GetHeader() *ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *DetStoreResponse) GetStore() *metapb.Store {
	if x != nil {
		return x.Store
	}
	return nil
}

type RegisterStoreRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *RequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	Store  *metapb.Store  `protobuf:"bytes,2,opt,name=store,proto3" json:"store,omitempty"`
}

func (x *RegisterStoreRequest) Reset() {
	*x = RegisterStoreRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RegisterStoreRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegisterStoreRequest) ProtoMessage() {}

func (x *RegisterStoreRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegisterStoreRequest.ProtoReflect.Descriptor instead.
func (*RegisterStoreRequest) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{7}
}

func (x *RegisterStoreRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *RegisterStoreRequest) GetStore() *metapb.Store {
	if x != nil {
		return x.Store
	}
	return nil
}

type RegisterStoreResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	// 初次注册，返回新的store_id
	StoreId uint64 `protobuf:"varint,2,opt,name=store_id,json=storeId,proto3" json:"store_id,omitempty"`
}

func (x *RegisterStoreResponse) Reset() {
	*x = RegisterStoreResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RegisterStoreResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegisterStoreResponse) ProtoMessage() {}

func (x *RegisterStoreResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegisterStoreResponse.ProtoReflect.Descriptor instead.
func (*RegisterStoreResponse) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{8}
}

func (x *RegisterStoreResponse) GetHeader() *ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *RegisterStoreResponse) GetStoreId() uint64 {
	if x != nil {
		return x.StoreId
	}
	return 0
}

type SetStoreRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *RequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	Store  *metapb.Store  `protobuf:"bytes,2,opt,name=store,proto3" json:"store,omitempty"`
}

func (x *SetStoreRequest) Reset() {
	*x = SetStoreRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetStoreRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetStoreRequest) ProtoMessage() {}

func (x *SetStoreRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetStoreRequest.ProtoReflect.Descriptor instead.
func (*SetStoreRequest) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{9}
}

func (x *SetStoreRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *SetStoreRequest) GetStore() *metapb.Store {
	if x != nil {
		return x.Store
	}
	return nil
}

type SetStoreResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	// 返回修改后的Store
	Store *metapb.Store `protobuf:"bytes,2,opt,name=store,proto3" json:"store,omitempty"`
}

func (x *SetStoreResponse) Reset() {
	*x = SetStoreResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetStoreResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetStoreResponse) ProtoMessage() {}

func (x *SetStoreResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetStoreResponse.ProtoReflect.Descriptor instead.
func (*SetStoreResponse) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{10}
}

func (x *SetStoreResponse) GetHeader() *ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *SetStoreResponse) GetStore() *metapb.Store {
	if x != nil {
		return x.Store
	}
	return nil
}

// 返回graph_name所在的所有store，如果graph_name为空值，则返回系统所有的store
type GetAllStoresRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header    *RequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	GraphName string         `protobuf:"bytes,2,opt,name=graph_name,json=graphName,proto3" json:"graph_name,omitempty"`
	// 是否返回离线的store
	ExcludeOfflineStores bool `protobuf:"varint,3,opt,name=exclude_offline_stores,json=excludeOfflineStores,proto3" json:"exclude_offline_stores,omitempty"`
}

func (x *GetAllStoresRequest) Reset() {
	*x = GetAllStoresRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAllStoresRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAllStoresRequest) ProtoMessage() {}

func (x *GetAllStoresRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAllStoresRequest.ProtoReflect.Descriptor instead.
func (*GetAllStoresRequest) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{11}
}

func (x *GetAllStoresRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *GetAllStoresRequest) GetGraphName() string {
	if x != nil {
		return x.GraphName
	}
	return ""
}

func (x *GetAllStoresRequest) GetExcludeOfflineStores() bool {
	if x != nil {
		return x.ExcludeOfflineStores
	}
	return false
}

type GetAllStoresResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	Stores []*metapb.Store `protobuf:"bytes,2,rep,name=stores,proto3" json:"stores,omitempty"`
}

func (x *GetAllStoresResponse) Reset() {
	*x = GetAllStoresResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAllStoresResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAllStoresResponse) ProtoMessage() {}

func (x *GetAllStoresResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAllStoresResponse.ProtoReflect.Descriptor instead.
func (*GetAllStoresResponse) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{12}
}

func (x *GetAllStoresResponse) GetHeader() *ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *GetAllStoresResponse) GetStores() []*metapb.Store {
	if x != nil {
		return x.Stores
	}
	return nil
}

type StoreHeartbeatRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *RequestHeader     `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	Stats  *metapb.StoreStats `protobuf:"bytes,2,opt,name=stats,proto3" json:"stats,omitempty"`
}

func (x *StoreHeartbeatRequest) Reset() {
	*x = StoreHeartbeatRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StoreHeartbeatRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StoreHeartbeatRequest) ProtoMessage() {}

func (x *StoreHeartbeatRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StoreHeartbeatRequest.ProtoReflect.Descriptor instead.
func (*StoreHeartbeatRequest) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{13}
}

func (x *StoreHeartbeatRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *StoreHeartbeatRequest) GetStats() *metapb.StoreStats {
	if x != nil {
		return x.Stats
	}
	return nil
}

type StoreHeartbeatResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header         *ResponseHeader      `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	ClusterVersion string               `protobuf:"bytes,3,opt,name=cluster_version,json=clusterVersion,proto3" json:"cluster_version,omitempty"`
	ClusterStats   *metapb.ClusterStats `protobuf:"bytes,4,opt,name=clusterStats,proto3" json:"clusterStats,omitempty"`
}

func (x *StoreHeartbeatResponse) Reset() {
	*x = StoreHeartbeatResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StoreHeartbeatResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StoreHeartbeatResponse) ProtoMessage() {}

func (x *StoreHeartbeatResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StoreHeartbeatResponse.ProtoReflect.Descriptor instead.
func (*StoreHeartbeatResponse) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{14}
}

func (x *StoreHeartbeatResponse) GetHeader() *ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *StoreHeartbeatResponse) GetClusterVersion() string {
	if x != nil {
		return x.ClusterVersion
	}
	return ""
}

func (x *StoreHeartbeatResponse) GetClusterStats() *metapb.ClusterStats {
	if x != nil {
		return x.ClusterStats
	}
	return nil
}

type GetPartitionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header    *RequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	GraphName string         `protobuf:"bytes,2,opt,name=graph_name,json=graphName,proto3" json:"graph_name,omitempty"`
	Key       []byte         `protobuf:"bytes,3,opt,name=key,proto3" json:"key,omitempty"`
}

func (x *GetPartitionRequest) Reset() {
	*x = GetPartitionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetPartitionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPartitionRequest) ProtoMessage() {}

func (x *GetPartitionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPartitionRequest.ProtoReflect.Descriptor instead.
func (*GetPartitionRequest) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{15}
}

func (x *GetPartitionRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *GetPartitionRequest) GetGraphName() string {
	if x != nil {
		return x.GraphName
	}
	return ""
}

func (x *GetPartitionRequest) GetKey() []byte {
	if x != nil {
		return x.Key
	}
	return nil
}

type GetPartitionByCodeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header    *RequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	GraphName string         `protobuf:"bytes,2,opt,name=graph_name,json=graphName,proto3" json:"graph_name,omitempty"`
	Code      uint64         `protobuf:"varint,3,opt,name=code,proto3" json:"code,omitempty"`
}

func (x *GetPartitionByCodeRequest) Reset() {
	*x = GetPartitionByCodeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetPartitionByCodeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPartitionByCodeRequest) ProtoMessage() {}

func (x *GetPartitionByCodeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPartitionByCodeRequest.ProtoReflect.Descriptor instead.
func (*GetPartitionByCodeRequest) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{16}
}

func (x *GetPartitionByCodeRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *GetPartitionByCodeRequest) GetGraphName() string {
	if x != nil {
		return x.GraphName
	}
	return ""
}

func (x *GetPartitionByCodeRequest) GetCode() uint64 {
	if x != nil {
		return x.Code
	}
	return 0
}

type GetPartitionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header    *ResponseHeader   `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	Partition *metapb.Partition `protobuf:"bytes,2,opt,name=partition,proto3" json:"partition,omitempty"`
	Leader    *metapb.Shard     `protobuf:"bytes,3,opt,name=leader,proto3" json:"leader,omitempty"`
	// 离线的Shard
	OfflineShards []*metapb.Shard `protobuf:"bytes,4,rep,name=offline_shards,json=offlineShards,proto3" json:"offline_shards,omitempty"`
}

func (x *GetPartitionResponse) Reset() {
	*x = GetPartitionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetPartitionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPartitionResponse) ProtoMessage() {}

func (x *GetPartitionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPartitionResponse.ProtoReflect.Descriptor instead.
func (*GetPartitionResponse) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{17}
}

func (x *GetPartitionResponse) GetHeader() *ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *GetPartitionResponse) GetPartition() *metapb.Partition {
	if x != nil {
		return x.Partition
	}
	return nil
}

func (x *GetPartitionResponse) GetLeader() *metapb.Shard {
	if x != nil {
		return x.Leader
	}
	return nil
}

func (x *GetPartitionResponse) GetOfflineShards() []*metapb.Shard {
	if x != nil {
		return x.OfflineShards
	}
	return nil
}

type GetPartitionByIDRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header      *RequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	GraphName   string         `protobuf:"bytes,2,opt,name=graph_name,json=graphName,proto3" json:"graph_name,omitempty"`
	PartitionId uint32         `protobuf:"varint,3,opt,name=partition_id,json=partitionId,proto3" json:"partition_id,omitempty"`
}

func (x *GetPartitionByIDRequest) Reset() {
	*x = GetPartitionByIDRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetPartitionByIDRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPartitionByIDRequest) ProtoMessage() {}

func (x *GetPartitionByIDRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPartitionByIDRequest.ProtoReflect.Descriptor instead.
func (*GetPartitionByIDRequest) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{18}
}

func (x *GetPartitionByIDRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *GetPartitionByIDRequest) GetGraphName() string {
	if x != nil {
		return x.GraphName
	}
	return ""
}

func (x *GetPartitionByIDRequest) GetPartitionId() uint32 {
	if x != nil {
		return x.PartitionId
	}
	return 0
}

type DelPartitionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header      *RequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	GraphName   string         `protobuf:"bytes,2,opt,name=graph_name,json=graphName,proto3" json:"graph_name,omitempty"`
	PartitionId uint32         `protobuf:"varint,3,opt,name=partition_id,json=partitionId,proto3" json:"partition_id,omitempty"`
}

func (x *DelPartitionRequest) Reset() {
	*x = DelPartitionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DelPartitionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DelPartitionRequest) ProtoMessage() {}

func (x *DelPartitionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DelPartitionRequest.ProtoReflect.Descriptor instead.
func (*DelPartitionRequest) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{19}
}

func (x *DelPartitionRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *DelPartitionRequest) GetGraphName() string {
	if x != nil {
		return x.GraphName
	}
	return ""
}

func (x *DelPartitionRequest) GetPartitionId() uint32 {
	if x != nil {
		return x.PartitionId
	}
	return 0
}

type DelPartitionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header    *ResponseHeader   `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	Partition *metapb.Partition `protobuf:"bytes,2,opt,name=partition,proto3" json:"partition,omitempty"`
}

func (x *DelPartitionResponse) Reset() {
	*x = DelPartitionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DelPartitionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DelPartitionResponse) ProtoMessage() {}

func (x *DelPartitionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DelPartitionResponse.ProtoReflect.Descriptor instead.
func (*DelPartitionResponse) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{20}
}

func (x *DelPartitionResponse) GetHeader() *ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *DelPartitionResponse) GetPartition() *metapb.Partition {
	if x != nil {
		return x.Partition
	}
	return nil
}

type UpdatePartitionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header    *RequestHeader      `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	Partition []*metapb.Partition `protobuf:"bytes,2,rep,name=partition,proto3" json:"partition,omitempty"`
}

func (x *UpdatePartitionRequest) Reset() {
	*x = UpdatePartitionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdatePartitionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdatePartitionRequest) ProtoMessage() {}

func (x *UpdatePartitionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdatePartitionRequest.ProtoReflect.Descriptor instead.
func (*UpdatePartitionRequest) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{21}
}

func (x *UpdatePartitionRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *UpdatePartitionRequest) GetPartition() []*metapb.Partition {
	if x != nil {
		return x.Partition
	}
	return nil
}

type UpdatePartitionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header    *ResponseHeader     `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	Partition []*metapb.Partition `protobuf:"bytes,2,rep,name=partition,proto3" json:"partition,omitempty"`
}

func (x *UpdatePartitionResponse) Reset() {
	*x = UpdatePartitionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdatePartitionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdatePartitionResponse) ProtoMessage() {}

func (x *UpdatePartitionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdatePartitionResponse.ProtoReflect.Descriptor instead.
func (*UpdatePartitionResponse) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{22}
}

func (x *UpdatePartitionResponse) GetHeader() *ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *UpdatePartitionResponse) GetPartition() []*metapb.Partition {
	if x != nil {
		return x.Partition
	}
	return nil
}

type ScanPartitionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header    *RequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	GraphName string         `protobuf:"bytes,2,opt,name=graph_name,json=graphName,proto3" json:"graph_name,omitempty"`
	StartKey  []byte         `protobuf:"bytes,3,opt,name=start_key,json=startKey,proto3" json:"start_key,omitempty"`
	EndKey    []byte         `protobuf:"bytes,4,opt,name=end_key,json=endKey,proto3" json:"end_key,omitempty"` // end_key is +inf when it is empty.
}

func (x *ScanPartitionsRequest) Reset() {
	*x = ScanPartitionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ScanPartitionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ScanPartitionsRequest) ProtoMessage() {}

func (x *ScanPartitionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ScanPartitionsRequest.ProtoReflect.Descriptor instead.
func (*ScanPartitionsRequest) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{23}
}

func (x *ScanPartitionsRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *ScanPartitionsRequest) GetGraphName() string {
	if x != nil {
		return x.GraphName
	}
	return ""
}

func (x *ScanPartitionsRequest) GetStartKey() []byte {
	if x != nil {
		return x.StartKey
	}
	return nil
}

func (x *ScanPartitionsRequest) GetEndKey() []byte {
	if x != nil {
		return x.EndKey
	}
	return nil
}

type ScanPartitionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header     *ResponseHeader          `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	Partitions []*metapb.PartitionShard `protobuf:"bytes,4,rep,name=partitions,proto3" json:"partitions,omitempty"`
}

func (x *ScanPartitionsResponse) Reset() {
	*x = ScanPartitionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ScanPartitionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ScanPartitionsResponse) ProtoMessage() {}

func (x *ScanPartitionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ScanPartitionsResponse.ProtoReflect.Descriptor instead.
func (*ScanPartitionsResponse) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{24}
}

func (x *ScanPartitionsResponse) GetHeader() *ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *ScanPartitionsResponse) GetPartitions() []*metapb.PartitionShard {
	if x != nil {
		return x.Partitions
	}
	return nil
}

type QueryPartitionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *RequestHeader         `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	Query  *metapb.PartitionQuery `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
}

func (x *QueryPartitionsRequest) Reset() {
	*x = QueryPartitionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryPartitionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryPartitionsRequest) ProtoMessage() {}

func (x *QueryPartitionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryPartitionsRequest.ProtoReflect.Descriptor instead.
func (*QueryPartitionsRequest) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{25}
}

func (x *QueryPartitionsRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *QueryPartitionsRequest) GetQuery() *metapb.PartitionQuery {
	if x != nil {
		return x.Query
	}
	return nil
}

type QueryPartitionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header     *ResponseHeader     `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	Partitions []*metapb.Partition `protobuf:"bytes,4,rep,name=partitions,proto3" json:"partitions,omitempty"`
}

func (x *QueryPartitionsResponse) Reset() {
	*x = QueryPartitionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryPartitionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryPartitionsResponse) ProtoMessage() {}

func (x *QueryPartitionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryPartitionsResponse.ProtoReflect.Descriptor instead.
func (*QueryPartitionsResponse) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{26}
}

func (x *QueryPartitionsResponse) GetHeader() *ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *QueryPartitionsResponse) GetPartitions() []*metapb.Partition {
	if x != nil {
		return x.Partitions
	}
	return nil
}

type GetGraphRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header    *RequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	GraphName string         `protobuf:"bytes,2,opt,name=graph_name,json=graphName,proto3" json:"graph_name,omitempty"`
}

func (x *GetGraphRequest) Reset() {
	*x = GetGraphRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetGraphRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGraphRequest) ProtoMessage() {}

func (x *GetGraphRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGraphRequest.ProtoReflect.Descriptor instead.
func (*GetGraphRequest) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{27}
}

func (x *GetGraphRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *GetGraphRequest) GetGraphName() string {
	if x != nil {
		return x.GraphName
	}
	return ""
}

type GetGraphResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	Graph  *metapb.Graph   `protobuf:"bytes,2,opt,name=graph,proto3" json:"graph,omitempty"`
}

func (x *GetGraphResponse) Reset() {
	*x = GetGraphResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetGraphResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGraphResponse) ProtoMessage() {}

func (x *GetGraphResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGraphResponse.ProtoReflect.Descriptor instead.
func (*GetGraphResponse) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{28}
}

func (x *GetGraphResponse) GetHeader() *ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *GetGraphResponse) GetGraph() *metapb.Graph {
	if x != nil {
		return x.Graph
	}
	return nil
}

type SetGraphRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *RequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	Graph  *metapb.Graph  `protobuf:"bytes,2,opt,name=graph,proto3" json:"graph,omitempty"`
}

func (x *SetGraphRequest) Reset() {
	*x = SetGraphRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetGraphRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetGraphRequest) ProtoMessage() {}

func (x *SetGraphRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetGraphRequest.ProtoReflect.Descriptor instead.
func (*SetGraphRequest) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{29}
}

func (x *SetGraphRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *SetGraphRequest) GetGraph() *metapb.Graph {
	if x != nil {
		return x.Graph
	}
	return nil
}

type SetGraphResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	Graph  *metapb.Graph   `protobuf:"bytes,2,opt,name=graph,proto3" json:"graph,omitempty"`
}

func (x *SetGraphResponse) Reset() {
	*x = SetGraphResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetGraphResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetGraphResponse) ProtoMessage() {}

func (x *SetGraphResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetGraphResponse.ProtoReflect.Descriptor instead.
func (*SetGraphResponse) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{30}
}

func (x *SetGraphResponse) GetHeader() *ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *SetGraphResponse) GetGraph() *metapb.Graph {
	if x != nil {
		return x.Graph
	}
	return nil
}

type DelGraphRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header    *RequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	GraphName string         `protobuf:"bytes,2,opt,name=graph_name,json=graphName,proto3" json:"graph_name,omitempty"`
}

func (x *DelGraphRequest) Reset() {
	*x = DelGraphRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DelGraphRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DelGraphRequest) ProtoMessage() {}

func (x *DelGraphRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DelGraphRequest.ProtoReflect.Descriptor instead.
func (*DelGraphRequest) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{31}
}

func (x *DelGraphRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *DelGraphRequest) GetGraphName() string {
	if x != nil {
		return x.GraphName
	}
	return ""
}

type DelGraphResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	Graph  *metapb.Graph   `protobuf:"bytes,2,opt,name=graph,proto3" json:"graph,omitempty"`
}

func (x *DelGraphResponse) Reset() {
	*x = DelGraphResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DelGraphResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DelGraphResponse) ProtoMessage() {}

func (x *DelGraphResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DelGraphResponse.ProtoReflect.Descriptor instead.
func (*DelGraphResponse) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{32}
}

func (x *DelGraphResponse) GetHeader() *ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *DelGraphResponse) GetGraph() *metapb.Graph {
	if x != nil {
		return x.Graph
	}
	return nil
}

type GetIdRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *RequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	Key    string         `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
	Delta  int32          `protobuf:"varint,3,opt,name=delta,proto3" json:"delta,omitempty"`
}

func (x *GetIdRequest) Reset() {
	*x = GetIdRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetIdRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetIdRequest) ProtoMessage() {}

func (x *GetIdRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetIdRequest.ProtoReflect.Descriptor instead.
func (*GetIdRequest) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{33}
}

func (x *GetIdRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *GetIdRequest) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *GetIdRequest) GetDelta() int32 {
	if x != nil {
		return x.Delta
	}
	return 0
}

type GetIdResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	Id     int64           `protobuf:"varint,2,opt,name=id,proto3" json:"id,omitempty"`
	Delta  int32           `protobuf:"varint,3,opt,name=delta,proto3" json:"delta,omitempty"`
}

func (x *GetIdResponse) Reset() {
	*x = GetIdResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetIdResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetIdResponse) ProtoMessage() {}

func (x *GetIdResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetIdResponse.ProtoReflect.Descriptor instead.
func (*GetIdResponse) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{34}
}

func (x *GetIdResponse) GetHeader() *ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *GetIdResponse) GetId() int64 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *GetIdResponse) GetDelta() int32 {
	if x != nil {
		return x.Delta
	}
	return 0
}

type ResetIdRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *RequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	Key    string         `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
}

func (x *ResetIdRequest) Reset() {
	*x = ResetIdRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResetIdRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResetIdRequest) ProtoMessage() {}

func (x *ResetIdRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResetIdRequest.ProtoReflect.Descriptor instead.
func (*ResetIdRequest) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{35}
}

func (x *ResetIdRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *ResetIdRequest) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

type ResetIdResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	Result int32           `protobuf:"varint,2,opt,name=result,proto3" json:"result,omitempty"`
}

func (x *ResetIdResponse) Reset() {
	*x = ResetIdResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResetIdResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResetIdResponse) ProtoMessage() {}

func (x *ResetIdResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResetIdResponse.ProtoReflect.Descriptor instead.
func (*ResetIdResponse) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{36}
}

func (x *ResetIdResponse) GetHeader() *ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *ResetIdResponse) GetResult() int32 {
	if x != nil {
		return x.Result
	}
	return 0
}

type GetMembersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *RequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
}

func (x *GetMembersRequest) Reset() {
	*x = GetMembersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetMembersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMembersRequest) ProtoMessage() {}

func (x *GetMembersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMembersRequest.ProtoReflect.Descriptor instead.
func (*GetMembersRequest) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{37}
}

func (x *GetMembersRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

type GetMembersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header  *ResponseHeader  `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	Members []*metapb.Member `protobuf:"bytes,2,rep,name=members,proto3" json:"members,omitempty"`
	Leader  *metapb.Member   `protobuf:"bytes,3,opt,name=leader,proto3" json:"leader,omitempty"`
}

func (x *GetMembersResponse) Reset() {
	*x = GetMembersResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetMembersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMembersResponse) ProtoMessage() {}

func (x *GetMembersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMembersResponse.ProtoReflect.Descriptor instead.
func (*GetMembersResponse) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{38}
}

func (x *GetMembersResponse) GetHeader() *ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *GetMembersResponse) GetMembers() []*metapb.Member {
	if x != nil {
		return x.Members
	}
	return nil
}

func (x *GetMembersResponse) GetLeader() *metapb.Member {
	if x != nil {
		return x.Leader
	}
	return nil
}

type GetPDConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header  *RequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	Version uint64         `protobuf:"varint,2,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *GetPDConfigRequest) Reset() {
	*x = GetPDConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetPDConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPDConfigRequest) ProtoMessage() {}

func (x *GetPDConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPDConfigRequest.ProtoReflect.Descriptor instead.
func (*GetPDConfigRequest) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{39}
}

func (x *GetPDConfigRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *GetPDConfigRequest) GetVersion() uint64 {
	if x != nil {
		return x.Version
	}
	return 0
}

type GetPDConfigResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header   *ResponseHeader  `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	PdConfig *metapb.PDConfig `protobuf:"bytes,2,opt,name=pd_config,json=pdConfig,proto3" json:"pd_config,omitempty"`
}

func (x *GetPDConfigResponse) Reset() {
	*x = GetPDConfigResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetPDConfigResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPDConfigResponse) ProtoMessage() {}

func (x *GetPDConfigResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPDConfigResponse.ProtoReflect.Descriptor instead.
func (*GetPDConfigResponse) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{40}
}

func (x *GetPDConfigResponse) GetHeader() *ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *GetPDConfigResponse) GetPdConfig() *metapb.PDConfig {
	if x != nil {
		return x.PdConfig
	}
	return nil
}

type SetPDConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header   *RequestHeader   `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	PdConfig *metapb.PDConfig `protobuf:"bytes,2,opt,name=pd_config,json=pdConfig,proto3" json:"pd_config,omitempty"`
}

func (x *SetPDConfigRequest) Reset() {
	*x = SetPDConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetPDConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetPDConfigRequest) ProtoMessage() {}

func (x *SetPDConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetPDConfigRequest.ProtoReflect.Descriptor instead.
func (*SetPDConfigRequest) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{41}
}

func (x *SetPDConfigRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *SetPDConfigRequest) GetPdConfig() *metapb.PDConfig {
	if x != nil {
		return x.PdConfig
	}
	return nil
}

type SetPDConfigResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
}

func (x *SetPDConfigResponse) Reset() {
	*x = SetPDConfigResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetPDConfigResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetPDConfigResponse) ProtoMessage() {}

func (x *SetPDConfigResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetPDConfigResponse.ProtoReflect.Descriptor instead.
func (*SetPDConfigResponse) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{42}
}

func (x *SetPDConfigResponse) GetHeader() *ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

type GetGraphSpaceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header           *RequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	Graph_Space_Name string         `protobuf:"bytes,2,opt,name=graph_Space_Name,json=graphSpaceName,proto3" json:"graph_Space_Name,omitempty"`
}

func (x *GetGraphSpaceRequest) Reset() {
	*x = GetGraphSpaceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetGraphSpaceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGraphSpaceRequest) ProtoMessage() {}

func (x *GetGraphSpaceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGraphSpaceRequest.ProtoReflect.Descriptor instead.
func (*GetGraphSpaceRequest) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{43}
}

func (x *GetGraphSpaceRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *GetGraphSpaceRequest) GetGraph_Space_Name() string {
	if x != nil {
		return x.Graph_Space_Name
	}
	return ""
}

type GetGraphSpaceResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header     *ResponseHeader      `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	GraphSpace []*metapb.GraphSpace `protobuf:"bytes,2,rep,name=graph_space,json=graphSpace,proto3" json:"graph_space,omitempty"`
}

func (x *GetGraphSpaceResponse) Reset() {
	*x = GetGraphSpaceResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetGraphSpaceResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGraphSpaceResponse) ProtoMessage() {}

func (x *GetGraphSpaceResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGraphSpaceResponse.ProtoReflect.Descriptor instead.
func (*GetGraphSpaceResponse) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{44}
}

func (x *GetGraphSpaceResponse) GetHeader() *ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *GetGraphSpaceResponse) GetGraphSpace() []*metapb.GraphSpace {
	if x != nil {
		return x.GraphSpace
	}
	return nil
}

type SetGraphSpaceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header     *RequestHeader     `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	GraphSpace *metapb.GraphSpace `protobuf:"bytes,2,opt,name=graph_space,json=graphSpace,proto3" json:"graph_space,omitempty"`
}

func (x *SetGraphSpaceRequest) Reset() {
	*x = SetGraphSpaceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetGraphSpaceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetGraphSpaceRequest) ProtoMessage() {}

func (x *SetGraphSpaceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetGraphSpaceRequest.ProtoReflect.Descriptor instead.
func (*SetGraphSpaceRequest) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{45}
}

func (x *SetGraphSpaceRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *SetGraphSpaceRequest) GetGraphSpace() *metapb.GraphSpace {
	if x != nil {
		return x.GraphSpace
	}
	return nil
}

type SetGraphSpaceResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
}

func (x *SetGraphSpaceResponse) Reset() {
	*x = SetGraphSpaceResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetGraphSpaceResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetGraphSpaceResponse) ProtoMessage() {}

func (x *SetGraphSpaceResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetGraphSpaceResponse.ProtoReflect.Descriptor instead.
func (*SetGraphSpaceResponse) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{46}
}

func (x *SetGraphSpaceResponse) GetHeader() *ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

type GetClusterStatsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *RequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
}

func (x *GetClusterStatsRequest) Reset() {
	*x = GetClusterStatsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetClusterStatsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetClusterStatsRequest) ProtoMessage() {}

func (x *GetClusterStatsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetClusterStatsRequest.ProtoReflect.Descriptor instead.
func (*GetClusterStatsRequest) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{47}
}

func (x *GetClusterStatsRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

type GetClusterStatsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header  *ResponseHeader      `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	Cluster *metapb.ClusterStats `protobuf:"bytes,2,opt,name=cluster,proto3" json:"cluster,omitempty"`
}

func (x *GetClusterStatsResponse) Reset() {
	*x = GetClusterStatsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetClusterStatsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetClusterStatsResponse) ProtoMessage() {}

func (x *GetClusterStatsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetClusterStatsResponse.ProtoReflect.Descriptor instead.
func (*GetClusterStatsResponse) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{48}
}

func (x *GetClusterStatsResponse) GetHeader() *ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *GetClusterStatsResponse) GetCluster() *metapb.ClusterStats {
	if x != nil {
		return x.Cluster
	}
	return nil
}

type ChangePeerListRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header    *RequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	Peer_List string         `protobuf:"bytes,2,opt,name=peer_List,json=peerList,proto3" json:"peer_List,omitempty"`
}

func (x *ChangePeerListRequest) Reset() {
	*x = ChangePeerListRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChangePeerListRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChangePeerListRequest) ProtoMessage() {}

func (x *ChangePeerListRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChangePeerListRequest.ProtoReflect.Descriptor instead.
func (*ChangePeerListRequest) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{49}
}

func (x *ChangePeerListRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *ChangePeerListRequest) GetPeer_List() string {
	if x != nil {
		return x.Peer_List
	}
	return ""
}

type GetChangePeerListResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
}

func (x *GetChangePeerListResponse) Reset() {
	*x = GetChangePeerListResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetChangePeerListResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetChangePeerListResponse) ProtoMessage() {}

func (x *GetChangePeerListResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetChangePeerListResponse.ProtoReflect.Descriptor instead.
func (*GetChangePeerListResponse) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{50}
}

func (x *GetChangePeerListResponse) GetHeader() *ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

type SplitDataParam struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// 被分裂的源分区ID
	PartitionId uint32 `protobuf:"varint,1,opt,name=partition_id,json=partitionId,proto3" json:"partition_id,omitempty"`
	//目标分区数量
	Count uint32 `protobuf:"varint,2,opt,name=count,proto3" json:"count,omitempty"`
}

func (x *SplitDataParam) Reset() {
	*x = SplitDataParam{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SplitDataParam) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SplitDataParam) ProtoMessage() {}

func (x *SplitDataParam) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SplitDataParam.ProtoReflect.Descriptor instead.
func (*SplitDataParam) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{51}
}

func (x *SplitDataParam) GetPartitionId() uint32 {
	if x != nil {
		return x.PartitionId
	}
	return 0
}

func (x *SplitDataParam) GetCount() uint32 {
	if x != nil {
		return x.Count
	}
	return 0
}

type SplitDataRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *RequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	//工作模式
	//  Auto：自动分裂，每个Store上分区数达到最大值
	//  Expert:专家模式，需要指定splitParams
	Mode  OperationMode     `protobuf:"varint,2,opt,name=mode,proto3,enum=pdpb.OperationMode" json:"mode,omitempty"`
	Param []*SplitDataParam `protobuf:"bytes,3,rep,name=param,proto3" json:"param,omitempty"`
}

func (x *SplitDataRequest) Reset() {
	*x = SplitDataRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SplitDataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SplitDataRequest) ProtoMessage() {}

func (x *SplitDataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SplitDataRequest.ProtoReflect.Descriptor instead.
func (*SplitDataRequest) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{52}
}

func (x *SplitDataRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *SplitDataRequest) GetMode() OperationMode {
	if x != nil {
		return x.Mode
	}
	return OperationMode_Auto
}

func (x *SplitDataRequest) GetParam() []*SplitDataParam {
	if x != nil {
		return x.Param
	}
	return nil
}

type SplitGraphDataRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *RequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	//工作模式
	GraphName string `protobuf:"bytes,2,opt,name=graph_name,json=graphName,proto3" json:"graph_name,omitempty"`
	ToCount   uint32 `protobuf:"varint,3,opt,name=to_count,json=toCount,proto3" json:"to_count,omitempty"`
}

func (x *SplitGraphDataRequest) Reset() {
	*x = SplitGraphDataRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SplitGraphDataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SplitGraphDataRequest) ProtoMessage() {}

func (x *SplitGraphDataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SplitGraphDataRequest.ProtoReflect.Descriptor instead.
func (*SplitGraphDataRequest) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{53}
}

func (x *SplitGraphDataRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *SplitGraphDataRequest) GetGraphName() string {
	if x != nil {
		return x.GraphName
	}
	return ""
}

func (x *SplitGraphDataRequest) GetToCount() uint32 {
	if x != nil {
		return x.ToCount
	}
	return 0
}

type SplitDataResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
}

func (x *SplitDataResponse) Reset() {
	*x = SplitDataResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SplitDataResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SplitDataResponse) ProtoMessage() {}

func (x *SplitDataResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SplitDataResponse.ProtoReflect.Descriptor instead.
func (*SplitDataResponse) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{54}
}

func (x *SplitDataResponse) GetHeader() *ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

type MovePartitionParam struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PartitionId uint32 `protobuf:"varint,1,opt,name=partition_id,json=partitionId,proto3" json:"partition_id,omitempty"`
	SrcStoreId  uint64 `protobuf:"varint,2,opt,name=src_store_id,json=srcStoreId,proto3" json:"src_store_id,omitempty"`
	DstStoreId  uint64 `protobuf:"varint,3,opt,name=dst_store_id,json=dstStoreId,proto3" json:"dst_store_id,omitempty"`
}

func (x *MovePartitionParam) Reset() {
	*x = MovePartitionParam{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MovePartitionParam) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MovePartitionParam) ProtoMessage() {}

func (x *MovePartitionParam) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MovePartitionParam.ProtoReflect.Descriptor instead.
func (*MovePartitionParam) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{55}
}

func (x *MovePartitionParam) GetPartitionId() uint32 {
	if x != nil {
		return x.PartitionId
	}
	return 0
}

func (x *MovePartitionParam) GetSrcStoreId() uint64 {
	if x != nil {
		return x.SrcStoreId
	}
	return 0
}

func (x *MovePartitionParam) GetDstStoreId() uint64 {
	if x != nil {
		return x.DstStoreId
	}
	return 0
}

type MovePartitionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *RequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	//工作模式
	//  Auto：自动转移，达到每个Store上分区数量相同
	//  Expert:专家模式，需要指定transferParams
	Mode  OperationMode         `protobuf:"varint,2,opt,name=mode,proto3,enum=pdpb.OperationMode" json:"mode,omitempty"`
	Param []*MovePartitionParam `protobuf:"bytes,3,rep,name=param,proto3" json:"param,omitempty"`
}

func (x *MovePartitionRequest) Reset() {
	*x = MovePartitionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MovePartitionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MovePartitionRequest) ProtoMessage() {}

func (x *MovePartitionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MovePartitionRequest.ProtoReflect.Descriptor instead.
func (*MovePartitionRequest) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{56}
}

func (x *MovePartitionRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *MovePartitionRequest) GetMode() OperationMode {
	if x != nil {
		return x.Mode
	}
	return OperationMode_Auto
}

func (x *MovePartitionRequest) GetParam() []*MovePartitionParam {
	if x != nil {
		return x.Param
	}
	return nil
}

type MovePartitionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
}

func (x *MovePartitionResponse) Reset() {
	*x = MovePartitionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MovePartitionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MovePartitionResponse) ProtoMessage() {}

func (x *MovePartitionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MovePartitionResponse.ProtoReflect.Descriptor instead.
func (*MovePartitionResponse) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{57}
}

func (x *MovePartitionResponse) GetHeader() *ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

type ReportTaskRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *RequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	Task   *metaTask.Task `protobuf:"bytes,2,opt,name=task,proto3" json:"task,omitempty"`
}

func (x *ReportTaskRequest) Reset() {
	*x = ReportTaskRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[58]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportTaskRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportTaskRequest) ProtoMessage() {}

func (x *ReportTaskRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[58]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportTaskRequest.ProtoReflect.Descriptor instead.
func (*ReportTaskRequest) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{58}
}

func (x *ReportTaskRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *ReportTaskRequest) GetTask() *metaTask.Task {
	if x != nil {
		return x.Task
	}
	return nil
}

type ReportTaskResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
}

func (x *ReportTaskResponse) Reset() {
	*x = ReportTaskResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[59]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportTaskResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportTaskResponse) ProtoMessage() {}

func (x *ReportTaskResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[59]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportTaskResponse.ProtoReflect.Descriptor instead.
func (*ReportTaskResponse) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{59}
}

func (x *ReportTaskResponse) GetHeader() *ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

type GetPartitionStatsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header      *RequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	PartitionId uint32         `protobuf:"varint,2,opt,name=partition_id,json=partitionId,proto3" json:"partition_id,omitempty"`
	// 如果未空，返回所有图的同一分区ID
	GraphName string `protobuf:"bytes,4,opt,name=graph_name,json=graphName,proto3" json:"graph_name,omitempty"`
}

func (x *GetPartitionStatsRequest) Reset() {
	*x = GetPartitionStatsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[60]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetPartitionStatsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPartitionStatsRequest) ProtoMessage() {}

func (x *GetPartitionStatsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[60]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPartitionStatsRequest.ProtoReflect.Descriptor instead.
func (*GetPartitionStatsRequest) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{60}
}

func (x *GetPartitionStatsRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *GetPartitionStatsRequest) GetPartitionId() uint32 {
	if x != nil {
		return x.PartitionId
	}
	return 0
}

func (x *GetPartitionStatsRequest) GetGraphName() string {
	if x != nil {
		return x.GraphName
	}
	return ""
}

type GetPartitionStatsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header         *ResponseHeader        `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	PartitionStats *metapb.PartitionStats `protobuf:"bytes,2,opt,name=partition_stats,json=partitionStats,proto3" json:"partition_stats,omitempty"`
}

func (x *GetPartitionStatsResponse) Reset() {
	*x = GetPartitionStatsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[61]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetPartitionStatsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPartitionStatsResponse) ProtoMessage() {}

func (x *GetPartitionStatsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[61]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPartitionStatsResponse.ProtoReflect.Descriptor instead.
func (*GetPartitionStatsResponse) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{61}
}

func (x *GetPartitionStatsResponse) GetHeader() *ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *GetPartitionStatsResponse) GetPartitionStats() *metapb.PartitionStats {
	if x != nil {
		return x.PartitionStats
	}
	return nil
}

type BalanceLeadersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *RequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
}

func (x *BalanceLeadersRequest) Reset() {
	*x = BalanceLeadersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[62]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BalanceLeadersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BalanceLeadersRequest) ProtoMessage() {}

func (x *BalanceLeadersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[62]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BalanceLeadersRequest.ProtoReflect.Descriptor instead.
func (*BalanceLeadersRequest) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{62}
}

func (x *BalanceLeadersRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

type BalanceLeadersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
}

func (x *BalanceLeadersResponse) Reset() {
	*x = BalanceLeadersResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[63]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BalanceLeadersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BalanceLeadersResponse) ProtoMessage() {}

func (x *BalanceLeadersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[63]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BalanceLeadersResponse.ProtoReflect.Descriptor instead.
func (*BalanceLeadersResponse) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{63}
}

func (x *BalanceLeadersResponse) GetHeader() *ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

type PutLicenseRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header  *RequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	Content []byte         `protobuf:"bytes,2,opt,name=content,proto3" json:"content,omitempty"`
}

func (x *PutLicenseRequest) Reset() {
	*x = PutLicenseRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[64]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PutLicenseRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PutLicenseRequest) ProtoMessage() {}

func (x *PutLicenseRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[64]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PutLicenseRequest.ProtoReflect.Descriptor instead.
func (*PutLicenseRequest) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{64}
}

func (x *PutLicenseRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *PutLicenseRequest) GetContent() []byte {
	if x != nil {
		return x.Content
	}
	return nil
}

type PutLicenseResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
}

func (x *PutLicenseResponse) Reset() {
	*x = PutLicenseResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[65]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PutLicenseResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PutLicenseResponse) ProtoMessage() {}

func (x *PutLicenseResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[65]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PutLicenseResponse.ProtoReflect.Descriptor instead.
func (*PutLicenseResponse) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{65}
}

func (x *PutLicenseResponse) GetHeader() *ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

type DbCompactionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header    *RequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	TableName string         `protobuf:"bytes,2,opt,name=tableName,proto3" json:"tableName,omitempty"`
}

func (x *DbCompactionRequest) Reset() {
	*x = DbCompactionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[66]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DbCompactionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DbCompactionRequest) ProtoMessage() {}

func (x *DbCompactionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[66]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DbCompactionRequest.ProtoReflect.Descriptor instead.
func (*DbCompactionRequest) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{66}
}

func (x *DbCompactionRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *DbCompactionRequest) GetTableName() string {
	if x != nil {
		return x.TableName
	}
	return ""
}

type DbCompactionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
}

func (x *DbCompactionResponse) Reset() {
	*x = DbCompactionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[67]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DbCompactionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DbCompactionResponse) ProtoMessage() {}

func (x *DbCompactionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[67]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DbCompactionResponse.ProtoReflect.Descriptor instead.
func (*DbCompactionResponse) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{67}
}

func (x *DbCompactionResponse) GetHeader() *ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

type CombineClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header  *RequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	ToCount uint32         `protobuf:"varint,2,opt,name=toCount,proto3" json:"toCount,omitempty"`
}

func (x *CombineClusterRequest) Reset() {
	*x = CombineClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[68]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CombineClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CombineClusterRequest) ProtoMessage() {}

func (x *CombineClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[68]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CombineClusterRequest.ProtoReflect.Descriptor instead.
func (*CombineClusterRequest) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{68}
}

func (x *CombineClusterRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *CombineClusterRequest) GetToCount() uint32 {
	if x != nil {
		return x.ToCount
	}
	return 0
}

type CombineClusterResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
}

func (x *CombineClusterResponse) Reset() {
	*x = CombineClusterResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[69]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CombineClusterResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CombineClusterResponse) ProtoMessage() {}

func (x *CombineClusterResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[69]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CombineClusterResponse.ProtoReflect.Descriptor instead.
func (*CombineClusterResponse) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{69}
}

func (x *CombineClusterResponse) GetHeader() *ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

type CombineGraphRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header    *RequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	GraphName string         `protobuf:"bytes,2,opt,name=graphName,proto3" json:"graphName,omitempty"`
	ToCount   uint32         `protobuf:"varint,3,opt,name=toCount,proto3" json:"toCount,omitempty"`
}

func (x *CombineGraphRequest) Reset() {
	*x = CombineGraphRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[70]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CombineGraphRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CombineGraphRequest) ProtoMessage() {}

func (x *CombineGraphRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[70]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CombineGraphRequest.ProtoReflect.Descriptor instead.
func (*CombineGraphRequest) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{70}
}

func (x *CombineGraphRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *CombineGraphRequest) GetGraphName() string {
	if x != nil {
		return x.GraphName
	}
	return ""
}

func (x *CombineGraphRequest) GetToCount() uint32 {
	if x != nil {
		return x.ToCount
	}
	return 0
}

type CombineGraphResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
}

func (x *CombineGraphResponse) Reset() {
	*x = CombineGraphResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[71]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CombineGraphResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CombineGraphResponse) ProtoMessage() {}

func (x *CombineGraphResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[71]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CombineGraphResponse.ProtoReflect.Descriptor instead.
func (*CombineGraphResponse) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{71}
}

func (x *CombineGraphResponse) GetHeader() *ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

type DeleteShardGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header  *RequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	GroupId uint32         `protobuf:"varint,2,opt,name=groupId,proto3" json:"groupId,omitempty"`
}

func (x *DeleteShardGroupRequest) Reset() {
	*x = DeleteShardGroupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[72]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteShardGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteShardGroupRequest) ProtoMessage() {}

func (x *DeleteShardGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[72]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteShardGroupRequest.ProtoReflect.Descriptor instead.
func (*DeleteShardGroupRequest) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{72}
}

func (x *DeleteShardGroupRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *DeleteShardGroupRequest) GetGroupId() uint32 {
	if x != nil {
		return x.GroupId
	}
	return 0
}

type DeleteShardGroupResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
}

func (x *DeleteShardGroupResponse) Reset() {
	*x = DeleteShardGroupResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[73]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteShardGroupResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteShardGroupResponse) ProtoMessage() {}

func (x *DeleteShardGroupResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[73]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteShardGroupResponse.ProtoReflect.Descriptor instead.
func (*DeleteShardGroupResponse) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{73}
}

func (x *DeleteShardGroupResponse) GetHeader() *ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

type GetShardGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header  *RequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	GroupId uint32         `protobuf:"varint,2,opt,name=group_id,json=groupId,proto3" json:"group_id,omitempty"`
}

func (x *GetShardGroupRequest) Reset() {
	*x = GetShardGroupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[74]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetShardGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetShardGroupRequest) ProtoMessage() {}

func (x *GetShardGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[74]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetShardGroupRequest.ProtoReflect.Descriptor instead.
func (*GetShardGroupRequest) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{74}
}

func (x *GetShardGroupRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *GetShardGroupRequest) GetGroupId() uint32 {
	if x != nil {
		return x.GroupId
	}
	return 0
}

type GetShardGroupResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header     *ResponseHeader    `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	ShardGroup *metapb.ShardGroup `protobuf:"bytes,2,opt,name=shardGroup,proto3" json:"shardGroup,omitempty"`
}

func (x *GetShardGroupResponse) Reset() {
	*x = GetShardGroupResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[75]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetShardGroupResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetShardGroupResponse) ProtoMessage() {}

func (x *GetShardGroupResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[75]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetShardGroupResponse.ProtoReflect.Descriptor instead.
func (*GetShardGroupResponse) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{75}
}

func (x *GetShardGroupResponse) GetHeader() *ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *GetShardGroupResponse) GetShardGroup() *metapb.ShardGroup {
	if x != nil {
		return x.ShardGroup
	}
	return nil
}

type UpdateShardGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header     *RequestHeader     `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	ShardGroup *metapb.ShardGroup `protobuf:"bytes,2,opt,name=shardGroup,proto3" json:"shardGroup,omitempty"`
}

func (x *UpdateShardGroupRequest) Reset() {
	*x = UpdateShardGroupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[76]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateShardGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateShardGroupRequest) ProtoMessage() {}

func (x *UpdateShardGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[76]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateShardGroupRequest.ProtoReflect.Descriptor instead.
func (*UpdateShardGroupRequest) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{76}
}

func (x *UpdateShardGroupRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *UpdateShardGroupRequest) GetShardGroup() *metapb.ShardGroup {
	if x != nil {
		return x.ShardGroup
	}
	return nil
}

type UpdateShardGroupResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
}

func (x *UpdateShardGroupResponse) Reset() {
	*x = UpdateShardGroupResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[77]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateShardGroupResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateShardGroupResponse) ProtoMessage() {}

func (x *UpdateShardGroupResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[77]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateShardGroupResponse.ProtoReflect.Descriptor instead.
func (*UpdateShardGroupResponse) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{77}
}

func (x *UpdateShardGroupResponse) GetHeader() *ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

type ChangeShardRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header  *RequestHeader  `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	GroupId uint32          `protobuf:"varint,2,opt,name=groupId,proto3" json:"groupId,omitempty"`
	Shards  []*metapb.Shard `protobuf:"bytes,3,rep,name=shards,proto3" json:"shards,omitempty"`
}

func (x *ChangeShardRequest) Reset() {
	*x = ChangeShardRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[78]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChangeShardRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChangeShardRequest) ProtoMessage() {}

func (x *ChangeShardRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[78]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChangeShardRequest.ProtoReflect.Descriptor instead.
func (*ChangeShardRequest) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{78}
}

func (x *ChangeShardRequest) GetHeader() *RequestHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *ChangeShardRequest) GetGroupId() uint32 {
	if x != nil {
		return x.GroupId
	}
	return 0
}

func (x *ChangeShardRequest) GetShards() []*metapb.Shard {
	if x != nil {
		return x.Shards
	}
	return nil
}

type ChangeShardResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header *ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
}

func (x *ChangeShardResponse) Reset() {
	*x = ChangeShardResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pdpb_proto_msgTypes[79]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChangeShardResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChangeShardResponse) ProtoMessage() {}

func (x *ChangeShardResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pdpb_proto_msgTypes[79]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChangeShardResponse.ProtoReflect.Descriptor instead.
func (*ChangeShardResponse) Descriptor() ([]byte, []int) {
	return file_pdpb_proto_rawDescGZIP(), []int{79}
}

func (x *ChangeShardResponse) GetHeader() *ResponseHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

var File_pdpb_proto protoreflect.FileDescriptor

var file_pdpb_proto_rawDesc = []byte{
	0x0a, 0x0a, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x04, 0x70, 0x64,
	0x70, 0x62, 0x1a, 0x0c, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x0e, 0x6d, 0x65, 0x74, 0x61, 0x54, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0x4b, 0x0a, 0x0d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64,
	0x12, 0x1b, 0x0a, 0x09, 0x73, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x04, 0x52, 0x08, 0x73, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x49, 0x64, 0x22, 0x52, 0x0a,
	0x0e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12,
	0x1d, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x04, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x21,
	0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0b, 0x2e,
	0x70, 0x64, 0x70, 0x62, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x22, 0x46, 0x0a, 0x05, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x23, 0x0a, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x0f, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e,
	0x45, 0x72, 0x72, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12,
	0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x59, 0x0a, 0x0f, 0x47, 0x65, 0x74,
	0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x06,
	0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70,
	0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x07, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x49, 0x64, 0x22, 0x8f, 0x01, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2c, 0x0a, 0x06, 0x68, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x70, 0x64, 0x70, 0x62,
	0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52,
	0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x23, 0x0a, 0x05, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e,
	0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x05, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x28, 0x0a, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x6d, 0x65,
	0x74, 0x61, 0x70, 0x62, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x73, 0x22, 0x59, 0x0a, 0x0f, 0x44, 0x65, 0x74, 0x53, 0x74, 0x6f,
	0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x06, 0x68, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x64, 0x70, 0x62,
	0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06,
	0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x07, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x49,
	0x64, 0x22, 0x65, 0x0a, 0x10, 0x44, 0x65, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2c, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x12, 0x23, 0x0a, 0x05, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x52, 0x05, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x22, 0x68, 0x0a, 0x14, 0x52, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x65, 0x72, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x2b, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x13, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x23, 0x0a,
	0x05, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x6d,
	0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x05, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x22, 0x60, 0x0a, 0x15, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x53, 0x74,
	0x6f, 0x72, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2c, 0x0a, 0x06, 0x68,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x70, 0x64,
	0x70, 0x62, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x07, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x49, 0x64, 0x22, 0x63, 0x0a, 0x0f, 0x53, 0x65, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x12, 0x23, 0x0a, 0x05, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x53, 0x74, 0x6f,
	0x72, 0x65, 0x52, 0x05, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x22, 0x65, 0x0a, 0x10, 0x53, 0x65, 0x74,
	0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2c, 0x0a,
	0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e,
	0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x23, 0x0a, 0x05, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x6d, 0x65, 0x74,
	0x61, 0x70, 0x62, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x05, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x22, 0x97, 0x01, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x41, 0x6c, 0x6c, 0x53, 0x74, 0x6f, 0x72, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x67, 0x72, 0x61, 0x70, 0x68, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x67, 0x72, 0x61, 0x70, 0x68,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x34, 0x0a, 0x16, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f,
	0x6f, 0x66, 0x66, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x4f, 0x66, 0x66,
	0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x22, 0x6b, 0x0a, 0x14, 0x47, 0x65,
	0x74, 0x41, 0x6c, 0x6c, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x2c, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x14, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x12, 0x25, 0x0a, 0x06, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x0d, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52,
	0x06, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x22, 0x6e, 0x0a, 0x15, 0x53, 0x74, 0x6f, 0x72, 0x65,
	0x48, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x2b, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x13, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x28, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x6d,
	0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73,
	0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x73, 0x22, 0xa9, 0x01, 0x0a, 0x16, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x48, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x2c, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x14, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x12, 0x27, 0x0a, 0x0f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x38, 0x0a, 0x0c, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x14, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x0c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x74,
	0x61, 0x74, 0x73, 0x22, 0x73, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x06, 0x68, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x64, 0x70,
	0x62, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52,
	0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x67, 0x72, 0x61, 0x70, 0x68,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x67, 0x72, 0x61,
	0x70, 0x68, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x22, 0x7b, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x79, 0x43, 0x6f, 0x64, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x67, 0x72, 0x61, 0x70, 0x68, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x67, 0x72, 0x61, 0x70, 0x68, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x12, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x52,
	0x04, 0x63, 0x6f, 0x64, 0x65, 0x22, 0xd2, 0x01, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2c,
	0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14,
	0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x2f, 0x0a, 0x09,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x11, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x09, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x25, 0x0a,
	0x06, 0x6c, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0d, 0x2e,
	0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x53, 0x68, 0x61, 0x72, 0x64, 0x52, 0x06, 0x6c, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x12, 0x34, 0x0a, 0x0e, 0x6f, 0x66, 0x66, 0x6c, 0x69, 0x6e, 0x65, 0x5f,
	0x73, 0x68, 0x61, 0x72, 0x64, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x6d,
	0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x53, 0x68, 0x61, 0x72, 0x64, 0x52, 0x0d, 0x6f, 0x66, 0x66,
	0x6c, 0x69, 0x6e, 0x65, 0x53, 0x68, 0x61, 0x72, 0x64, 0x73, 0x22, 0x88, 0x01, 0x0a, 0x17, 0x47,
	0x65, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x79, 0x49, 0x44, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x67, 0x72, 0x61, 0x70, 0x68, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x67, 0x72, 0x61, 0x70, 0x68, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0x84, 0x01, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a,
	0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e,
	0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x67, 0x72,
	0x61, 0x70, 0x68, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x67, 0x72, 0x61, 0x70, 0x68, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0x75, 0x0a, 0x14,
	0x44, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2c, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x12, 0x2f, 0x0a, 0x09, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x76, 0x0a, 0x16, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a,
	0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e,
	0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x2f, 0x0a, 0x09, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e,
	0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x09, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x78, 0x0a, 0x17, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2c, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x12, 0x2f, 0x0a, 0x09, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62,
	0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x99, 0x01, 0x0a, 0x15, 0x53, 0x63, 0x61, 0x6e, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x2b, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x13, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x1d, 0x0a, 0x0a,
	0x67, 0x72, 0x61, 0x70, 0x68, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x67, 0x72, 0x61, 0x70, 0x68, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x08,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x4b, 0x65, 0x79, 0x12, 0x17, 0x0a, 0x07, 0x65, 0x6e, 0x64, 0x5f,
	0x6b, 0x65, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x06, 0x65, 0x6e, 0x64, 0x4b, 0x65,
	0x79, 0x22, 0x7e, 0x0a, 0x16, 0x53, 0x63, 0x61, 0x6e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2c, 0x0a, 0x06, 0x68,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x70, 0x64,
	0x70, 0x62, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x36, 0x0a, 0x0a, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e,
	0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x68, 0x61, 0x72, 0x64, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x22, 0x73, 0x0a, 0x16, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x06, 0x68,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x64,
	0x70, 0x62, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x2c, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62,
	0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52,
	0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x22, 0x7a, 0x0a, 0x17, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x2c, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x14, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12,
	0x31, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x22, 0x5d, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x47, 0x72, 0x61, 0x70, 0x68, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x67, 0x72, 0x61, 0x70, 0x68, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x67, 0x72, 0x61, 0x70, 0x68, 0x4e, 0x61, 0x6d,
	0x65, 0x22, 0x65, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x47, 0x72, 0x61, 0x70, 0x68, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2c, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x12, 0x23, 0x0a, 0x05, 0x67, 0x72, 0x61, 0x70, 0x68, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x47, 0x72, 0x61, 0x70,
	0x68, 0x52, 0x05, 0x67, 0x72, 0x61, 0x70, 0x68, 0x22, 0x63, 0x0a, 0x0f, 0x53, 0x65, 0x74, 0x47,
	0x72, 0x61, 0x70, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x06, 0x68,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x64,
	0x70, 0x62, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x23, 0x0a, 0x05, 0x67, 0x72, 0x61, 0x70,
	0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62,
	0x2e, 0x47, 0x72, 0x61, 0x70, 0x68, 0x52, 0x05, 0x67, 0x72, 0x61, 0x70, 0x68, 0x22, 0x65, 0x0a,
	0x10, 0x53, 0x65, 0x74, 0x47, 0x72, 0x61, 0x70, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x2c, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x14, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12,
	0x23, 0x0a, 0x05, 0x67, 0x72, 0x61, 0x70, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0d,
	0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x47, 0x72, 0x61, 0x70, 0x68, 0x52, 0x05, 0x67,
	0x72, 0x61, 0x70, 0x68, 0x22, 0x5d, 0x0a, 0x0f, 0x44, 0x65, 0x6c, 0x47, 0x72, 0x61, 0x70, 0x68,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x67, 0x72, 0x61, 0x70, 0x68, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x67, 0x72, 0x61, 0x70, 0x68, 0x4e,
	0x61, 0x6d, 0x65, 0x22, 0x65, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x47, 0x72, 0x61, 0x70, 0x68, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2c, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x23, 0x0a, 0x05, 0x67, 0x72, 0x61, 0x70, 0x68, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x47, 0x72,
	0x61, 0x70, 0x68, 0x52, 0x05, 0x67, 0x72, 0x61, 0x70, 0x68, 0x22, 0x63, 0x0a, 0x0c, 0x47, 0x65,
	0x74, 0x49, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x06, 0x68, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x64, 0x70,
	0x62, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52,
	0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x64, 0x65, 0x6c,
	0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x64, 0x65, 0x6c, 0x74, 0x61, 0x22,
	0x63, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x49, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x2c, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x14, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x0e,
	0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x02, 0x69, 0x64, 0x12, 0x14,
	0x0a, 0x05, 0x64, 0x65, 0x6c, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x64,
	0x65, 0x6c, 0x74, 0x61, 0x22, 0x4f, 0x0a, 0x0e, 0x52, 0x65, 0x73, 0x65, 0x74, 0x49, 0x64, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x22, 0x57, 0x0a, 0x0f, 0x52, 0x65, 0x73, 0x65, 0x74, 0x49, 0x64,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2c, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06,
	0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x40,
	0x0a, 0x11, 0x47, 0x65, 0x74, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x22, 0x94, 0x01, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2c, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x28, 0x0a, 0x07, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e,
	0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x07, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x12,
	0x26, 0x0a, 0x06, 0x6c, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x0e, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52,
	0x06, 0x6c, 0x65, 0x61, 0x64, 0x65, 0x72, 0x22, 0x5b, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x50, 0x44,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a,
	0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e,
	0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x22, 0x72, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x50, 0x44, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2c, 0x0a, 0x06, 0x68,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x70, 0x64,
	0x70, 0x62, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x2d, 0x0a, 0x09, 0x70, 0x64, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x6d,
	0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x50, 0x44, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x08,
	0x70, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x70, 0x0a, 0x12, 0x53, 0x65, 0x74, 0x50,
	0x44, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2b,
	0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13,
	0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x2d, 0x0a, 0x09, 0x70,
	0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10,
	0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x50, 0x44, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x08, 0x70, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x43, 0x0a, 0x13, 0x53, 0x65,
	0x74, 0x50, 0x44, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x2c, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x14, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x22,
	0x6d, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x47, 0x72, 0x61, 0x70, 0x68, 0x53, 0x70, 0x61, 0x63, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x12, 0x28, 0x0a, 0x10, 0x67, 0x72, 0x61, 0x70, 0x68, 0x5f, 0x53, 0x70,
	0x61, 0x63, 0x65, 0x5f, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e,
	0x67, 0x72, 0x61, 0x70, 0x68, 0x53, 0x70, 0x61, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x7a,
	0x0a, 0x15, 0x47, 0x65, 0x74, 0x47, 0x72, 0x61, 0x70, 0x68, 0x53, 0x70, 0x61, 0x63, 0x65, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2c, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x33, 0x0a, 0x0b, 0x67, 0x72, 0x61, 0x70, 0x68, 0x5f, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x6d, 0x65, 0x74,
	0x61, 0x70, 0x62, 0x2e, 0x47, 0x72, 0x61, 0x70, 0x68, 0x53, 0x70, 0x61, 0x63, 0x65, 0x52, 0x0a,
	0x67, 0x72, 0x61, 0x70, 0x68, 0x53, 0x70, 0x61, 0x63, 0x65, 0x22, 0x78, 0x0a, 0x14, 0x53, 0x65,
	0x74, 0x47, 0x72, 0x61, 0x70, 0x68, 0x53, 0x70, 0x61, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x2b, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12,
	0x33, 0x0a, 0x0b, 0x67, 0x72, 0x61, 0x70, 0x68, 0x5f, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x47, 0x72,
	0x61, 0x70, 0x68, 0x53, 0x70, 0x61, 0x63, 0x65, 0x52, 0x0a, 0x67, 0x72, 0x61, 0x70, 0x68, 0x53,
	0x70, 0x61, 0x63, 0x65, 0x22, 0x45, 0x0a, 0x15, 0x53, 0x65, 0x74, 0x47, 0x72, 0x61, 0x70, 0x68,
	0x53, 0x70, 0x61, 0x63, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2c, 0x0a,
	0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e,
	0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x22, 0x45, 0x0a, 0x16, 0x47,
	0x65, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x22, 0x77, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2c, 0x0a,
	0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e,
	0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x2e, 0x0a, 0x07, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x6d,
	0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x52, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x22, 0x61, 0x0a, 0x15, 0x43,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x65, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x65, 0x65, 0x72, 0x5f, 0x4c, 0x69, 0x73, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x65, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x22, 0x49,
	0x0a, 0x19, 0x67, 0x65, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x65, 0x65, 0x72, 0x4c,
	0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2c, 0x0a, 0x06, 0x68,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x70, 0x64,
	0x70, 0x62, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x22, 0x49, 0x0a, 0x0e, 0x53, 0x70, 0x6c,
	0x69, 0x74, 0x44, 0x61, 0x74, 0x61, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x12, 0x21, 0x0a, 0x0c, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x14,
	0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x22, 0x94, 0x01, 0x0a, 0x10, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x44, 0x61,
	0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x06, 0x68, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x64, 0x70, 0x62,
	0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06,
	0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x27, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x13, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x12,
	0x2a, 0x0a, 0x05, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x14,
	0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x44, 0x61, 0x74, 0x61, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x52, 0x05, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x22, 0x7e, 0x0a, 0x15, 0x53,
	0x70, 0x6c, 0x69, 0x74, 0x47, 0x72, 0x61, 0x70, 0x68, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x67, 0x72, 0x61, 0x70, 0x68, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x67, 0x72, 0x61, 0x70, 0x68, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x19, 0x0a, 0x08, 0x74, 0x6f, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x07, 0x74, 0x6f, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x41, 0x0a, 0x11, 0x53,
	0x70, 0x6c, 0x69, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x2c, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x14, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x22, 0x7b,
	0x0a, 0x12, 0x4d, 0x6f, 0x76, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0b, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x20, 0x0a, 0x0c, 0x73, 0x72, 0x63, 0x5f, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0a, 0x73,
	0x72, 0x63, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x49, 0x64, 0x12, 0x20, 0x0a, 0x0c, 0x64, 0x73, 0x74,
	0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x52,
	0x0a, 0x64, 0x73, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x49, 0x64, 0x22, 0x9c, 0x01, 0x0a, 0x14,
	0x4d, 0x6f, 0x76, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x12, 0x27, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x13, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x12, 0x2e, 0x0a, 0x05, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x70, 0x64, 0x70, 0x62,
	0x2e, 0x4d, 0x6f, 0x76, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x52, 0x05, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x22, 0x45, 0x0a, 0x15, 0x4d, 0x6f,
	0x76, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x2c, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x22, 0x64, 0x0a, 0x11, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x61, 0x73, 0x6b, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x12, 0x22, 0x0a, 0x04, 0x74, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x0e, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x54, 0x61, 0x73, 0x6b, 0x2e, 0x54, 0x61, 0x73,
	0x6b, 0x52, 0x04, 0x74, 0x61, 0x73, 0x6b, 0x22, 0x42, 0x0a, 0x12, 0x52, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2c, 0x0a,
	0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e,
	0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x22, 0x89, 0x01, 0x0a, 0x18,
	0x47, 0x65, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0b, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x67, 0x72, 0x61, 0x70,
	0x68, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x67, 0x72,
	0x61, 0x70, 0x68, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x8a, 0x01, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2c, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x12, 0x3f, 0x0a, 0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x6d,
	0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x74, 0x61, 0x74, 0x73, 0x52, 0x0e, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x74, 0x61, 0x74, 0x73, 0x22, 0x44, 0x0a, 0x15, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x4c,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a,
	0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e,
	0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x22, 0x46, 0x0a, 0x16, 0x42, 0x61,
	0x6c, 0x61, 0x6e, 0x63, 0x65, 0x4c, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2c, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x22, 0x5a, 0x0a, 0x11, 0x50, 0x75, 0x74, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x22, 0x42,
	0x0a, 0x12, 0x50, 0x75, 0x74, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2c, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x22, 0x60, 0x0a, 0x13, 0x44, 0x62, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x06, 0x68, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x64, 0x70, 0x62,
	0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06,
	0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x4e, 0x61, 0x6d, 0x65, 0x22, 0x44, 0x0a, 0x14, 0x44, 0x62, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2c, 0x0a, 0x06,
	0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x70,
	0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x22, 0x5e, 0x0a, 0x15, 0x43, 0x6f,
	0x6d, 0x62, 0x69, 0x6e, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x12, 0x18, 0x0a, 0x07, 0x74, 0x6f, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x07, 0x74, 0x6f, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x46, 0x0a, 0x16, 0x43, 0x6f,
	0x6d, 0x62, 0x69, 0x6e, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2c, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x22, 0x7a, 0x0a, 0x13, 0x43, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x47, 0x72, 0x61,
	0x70, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x06, 0x68, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x64, 0x70, 0x62,
	0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06,
	0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x1c, 0x0a, 0x09, 0x67, 0x72, 0x61, 0x70, 0x68, 0x4e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x67, 0x72, 0x61, 0x70, 0x68,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x74, 0x6f, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x74, 0x6f, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x44,
	0x0a, 0x14, 0x43, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x47, 0x72, 0x61, 0x70, 0x68, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2c, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x22, 0x60, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x68,
	0x61, 0x72, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x2b, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x13, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x18, 0x0a, 0x07,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x49, 0x64, 0x22, 0x48, 0x0a, 0x18, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x53, 0x68, 0x61, 0x72, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x2c, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x14, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x22, 0x5e, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x53, 0x68, 0x61, 0x72, 0x64, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x64,
	0x22, 0x79, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x53, 0x68, 0x61, 0x72, 0x64, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2c, 0x0a, 0x06, 0x68, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x70, 0x64, 0x70, 0x62,
	0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52,
	0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x32, 0x0a, 0x0a, 0x73, 0x68, 0x61, 0x72, 0x64,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x6d, 0x65,
	0x74, 0x61, 0x70, 0x62, 0x2e, 0x53, 0x68, 0x61, 0x72, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52,
	0x0a, 0x73, 0x68, 0x61, 0x72, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x22, 0x7a, 0x0a, 0x17, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x68, 0x61, 0x72, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x12, 0x32, 0x0a, 0x0a, 0x73, 0x68, 0x61, 0x72, 0x64, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62,
	0x2e, 0x53, 0x68, 0x61, 0x72, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x0a, 0x73, 0x68, 0x61,
	0x72, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x22, 0x48, 0x0a, 0x18, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x53, 0x68, 0x61, 0x72, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x2c, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x22, 0x82, 0x01, 0x0a, 0x12, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x68, 0x61, 0x72,
	0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2b, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x64, 0x12,
	0x25, 0x0a, 0x06, 0x73, 0x68, 0x61, 0x72, 0x64, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x0d, 0x2e, 0x6d, 0x65, 0x74, 0x61, 0x70, 0x62, 0x2e, 0x53, 0x68, 0x61, 0x72, 0x64, 0x52, 0x06,
	0x73, 0x68, 0x61, 0x72, 0x64, 0x73, 0x22, 0x43, 0x0a, 0x13, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x53, 0x68, 0x61, 0x72, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2c, 0x0a,
	0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e,
	0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x2a, 0x8f, 0x05, 0x0a, 0x09,
	0x45, 0x72, 0x72, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x06, 0x0a, 0x02, 0x4f, 0x4b, 0x10,
	0x00, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x01, 0x12, 0x0e,
	0x0a, 0x0a, 0x4e, 0x4f, 0x54, 0x5f, 0x4c, 0x45, 0x41, 0x44, 0x45, 0x52, 0x10, 0x64, 0x12, 0x16,
	0x0a, 0x12, 0x53, 0x54, 0x4f, 0x52, 0x45, 0x5f, 0x49, 0x44, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x45,
	0x58, 0x49, 0x53, 0x54, 0x10, 0x65, 0x12, 0x13, 0x0a, 0x0f, 0x4e, 0x4f, 0x5f, 0x41, 0x43, 0x54,
	0x49, 0x56, 0x45, 0x5f, 0x53, 0x54, 0x4f, 0x52, 0x45, 0x10, 0x66, 0x12, 0x0d, 0x0a, 0x09, 0x4e,
	0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x10, 0x67, 0x12, 0x12, 0x0a, 0x0e, 0x50, 0x44,
	0x5f, 0x55, 0x4e, 0x52, 0x45, 0x41, 0x43, 0x48, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x68, 0x12, 0x15,
	0x0a, 0x11, 0x4c, 0x45, 0x53, 0x53, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x5f, 0x53, 0x54,
	0x4f, 0x52, 0x45, 0x10, 0x69, 0x12, 0x1a, 0x0a, 0x16, 0x53, 0x54, 0x4f, 0x52, 0x45, 0x5f, 0x48,
	0x41, 0x53, 0x5f, 0x42, 0x45, 0x45, 0x4e, 0x5f, 0x52, 0x45, 0x4d, 0x4f, 0x56, 0x45, 0x44, 0x10,
	0x6a, 0x12, 0x1b, 0x0a, 0x17, 0x53, 0x54, 0x4f, 0x52, 0x45, 0x5f, 0x50, 0x52, 0x4f, 0x48, 0x49,
	0x42, 0x49, 0x54, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x6f, 0x12, 0x20,
	0x0a, 0x1c, 0x53, 0x45, 0x54, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x5f, 0x53, 0x48, 0x41,
	0x52, 0x44, 0x5f, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x70,
	0x12, 0x1c, 0x0a, 0x18, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x5f, 0x53, 0x54, 0x4f, 0x52, 0x45,
	0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x71, 0x12, 0x1c,
	0x0a, 0x18, 0x53, 0x54, 0x4f, 0x52, 0x45, 0x5f, 0x50, 0x52, 0x4f, 0x48, 0x49, 0x42, 0x49, 0x54,
	0x5f, 0x44, 0x55, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x54, 0x45, 0x10, 0x72, 0x12, 0x17, 0x0a, 0x12,
	0x52, 0x4f, 0x43, 0x4b, 0x53, 0x44, 0x42, 0x5f, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x45, 0x52, 0x52,
	0x4f, 0x52, 0x10, 0xea, 0x07, 0x12, 0x18, 0x0a, 0x13, 0x52, 0x4f, 0x43, 0x4b, 0x53, 0x44, 0x42,
	0x5f, 0x57, 0x52, 0x49, 0x54, 0x45, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0xeb, 0x07, 0x12,
	0x16, 0x0a, 0x11, 0x52, 0x4f, 0x43, 0x4b, 0x53, 0x44, 0x42, 0x5f, 0x44, 0x45, 0x4c, 0x5f, 0x45,
	0x52, 0x52, 0x4f, 0x52, 0x10, 0xec, 0x07, 0x12, 0x20, 0x0a, 0x1b, 0x52, 0x4f, 0x43, 0x4b, 0x53,
	0x44, 0x42, 0x5f, 0x53, 0x41, 0x56, 0x45, 0x5f, 0x53, 0x4e, 0x41, 0x50, 0x53, 0x48, 0x4f, 0x54,
	0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0xed, 0x07, 0x12, 0x20, 0x0a, 0x1b, 0x52, 0x4f, 0x43,
	0x4b, 0x53, 0x44, 0x42, 0x5f, 0x4c, 0x4f, 0x41, 0x44, 0x5f, 0x53, 0x4e, 0x41, 0x50, 0x53, 0x48,
	0x4f, 0x54, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0xee, 0x07, 0x12, 0x23, 0x0a, 0x1e, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x53, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x46, 0x6f, 0x72,
	0x62, 0x69, 0x64, 0x5f, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x10, 0xef, 0x07,
	0x12, 0x1a, 0x0a, 0x15, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x5f, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x44, 0x6f, 0x69, 0x6e, 0x67, 0x10, 0xf0, 0x07, 0x12, 0x22, 0x0a, 0x1d,
	0x54, 0x6f, 0x6f, 0x5f, 0x4d, 0x61, 0x6e, 0x79, 0x5f, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x5f, 0x50, 0x65, 0x72, 0x5f, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x10, 0xf1, 0x07,
	0x12, 0x11, 0x0a, 0x0d, 0x4c, 0x49, 0x43, 0x45, 0x4e, 0x53, 0x45, 0x5f, 0x45, 0x52, 0x52, 0x4f,
	0x52, 0x10, 0x6b, 0x12, 0x18, 0x0a, 0x14, 0x4c, 0x49, 0x43, 0x45, 0x4e, 0x53, 0x45, 0x5f, 0x56,
	0x45, 0x52, 0x49, 0x46, 0x59, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x6c, 0x12, 0x1a, 0x0a,
	0x15, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x54, 0x6f, 0x6d, 0x62, 0x73, 0x74, 0x6f, 0x6e, 0x65,
	0x5f, 0x44, 0x6f, 0x69, 0x6e, 0x67, 0x10, 0xf2, 0x07, 0x12, 0x22, 0x0a, 0x1d, 0x49, 0x6e, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x5f, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x5f, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x10, 0xf3, 0x07, 0x2a, 0x25, 0x0a,
	0x0d, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x08,
	0x0a, 0x04, 0x41, 0x75, 0x74, 0x6f, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x45, 0x78, 0x70, 0x65,
	0x72, 0x74, 0x10, 0x01, 0x32, 0xb2, 0x17, 0x0a, 0x02, 0x50, 0x44, 0x12, 0x4a, 0x0a, 0x0d, 0x52,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x1a, 0x2e, 0x70,
	0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1b, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e,
	0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x3b, 0x0a, 0x08, 0x47, 0x65, 0x74, 0x53, 0x74,
	0x6f, 0x72, 0x65, 0x12, 0x15, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x74,
	0x6f, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x70, 0x64, 0x70,
	0x62, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x00, 0x12, 0x3b, 0x0a, 0x08, 0x53, 0x65, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x65,
	0x12, 0x15, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x53, 0x65, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x53,
	0x65, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x00, 0x12, 0x3b, 0x0a, 0x08, 0x44, 0x65, 0x6c, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x15, 0x2e,
	0x70, 0x64, 0x70, 0x62, 0x2e, 0x44, 0x65, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x44, 0x65, 0x74, 0x53,
	0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x47,
	0x0a, 0x0c, 0x47, 0x65, 0x74, 0x41, 0x6c, 0x6c, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x12, 0x19,
	0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x6c, 0x6c, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1a, 0x2e, 0x70, 0x64, 0x70, 0x62,
	0x2e, 0x47, 0x65, 0x74, 0x41, 0x6c, 0x6c, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x4d, 0x0a, 0x0e, 0x53, 0x74, 0x6f, 0x72, 0x65,
	0x48, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x12, 0x1b, 0x2e, 0x70, 0x64, 0x70, 0x62,
	0x2e, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x48, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1c, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x53, 0x74,
	0x6f, 0x72, 0x65, 0x48, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x47, 0x0a, 0x0c, 0x47, 0x65, 0x74, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x19, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x47, 0x65,
	0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1a, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12,
	0x53, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x79, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x1f, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x47, 0x65, 0x74,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x79, 0x43, 0x6f, 0x64, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1a, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x47, 0x65,
	0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x00, 0x12, 0x4f, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x79, 0x49, 0x44, 0x12, 0x1d, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e,
	0x47, 0x65, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x79, 0x49, 0x44,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1a, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x47,
	0x65, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x4d, 0x0a, 0x0e, 0x53, 0x63, 0x61, 0x6e, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1b, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x53,
	0x63, 0x61, 0x6e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1c, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x53, 0x63, 0x61, 0x6e,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x00, 0x12, 0x50, 0x0a, 0x0f, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x47, 0x0a, 0x0c, 0x44, 0x65, 0x6c, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x19, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x44, 0x65,
	0x6c, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1a, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x44, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12,
	0x50, 0x0a, 0x0f, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x1c, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x00, 0x12, 0x3b, 0x0a, 0x08, 0x47, 0x65, 0x74, 0x47, 0x72, 0x61, 0x70, 0x68, 0x12, 0x15, 0x2e,
	0x70, 0x64, 0x70, 0x62, 0x2e, 0x47, 0x65, 0x74, 0x47, 0x72, 0x61, 0x70, 0x68, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x47, 0x65, 0x74, 0x47,
	0x72, 0x61, 0x70, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x3b,
	0x0a, 0x08, 0x53, 0x65, 0x74, 0x47, 0x72, 0x61, 0x70, 0x68, 0x12, 0x15, 0x2e, 0x70, 0x64, 0x70,
	0x62, 0x2e, 0x53, 0x65, 0x74, 0x47, 0x72, 0x61, 0x70, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x16, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x53, 0x65, 0x74, 0x47, 0x72, 0x61, 0x70,
	0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x3b, 0x0a, 0x08, 0x44,
	0x65, 0x6c, 0x47, 0x72, 0x61, 0x70, 0x68, 0x12, 0x15, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x44,
	0x65, 0x6c, 0x47, 0x72, 0x61, 0x70, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16,
	0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x44, 0x65, 0x6c, 0x47, 0x72, 0x61, 0x70, 0x68, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x32, 0x0a, 0x05, 0x47, 0x65, 0x74, 0x49,
	0x64, 0x12, 0x12, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x64, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x13, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x47, 0x65, 0x74,
	0x49, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x38, 0x0a, 0x07,
	0x52, 0x65, 0x73, 0x65, 0x74, 0x49, 0x64, 0x12, 0x14, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52,
	0x65, 0x73, 0x65, 0x74, 0x49, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e,
	0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x73, 0x65, 0x74, 0x49, 0x64, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x41, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x4d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x73, 0x12, 0x17, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x47, 0x65, 0x74, 0x4d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x18, 0x2e,
	0x70, 0x64, 0x70, 0x62, 0x2e, 0x47, 0x65, 0x74, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x49, 0x0a, 0x0e, 0x47, 0x65, 0x74,
	0x53, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x19, 0x2e, 0x70, 0x64,
	0x70, 0x62, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x6c, 0x6c, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1a, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x47, 0x65,
	0x74, 0x41, 0x6c, 0x6c, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x00, 0x12, 0x44, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x50, 0x44, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x18, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x44,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x19, 0x2e,
	0x70, 0x64, 0x70, 0x62, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x44, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x44, 0x0a, 0x0b, 0x53, 0x65,
	0x74, 0x50, 0x44, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x18, 0x2e, 0x70, 0x64, 0x70, 0x62,
	0x2e, 0x53, 0x65, 0x74, 0x50, 0x44, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x19, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x53, 0x65, 0x74, 0x50, 0x44,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00,
	0x12, 0x4a, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x47, 0x72, 0x61, 0x70, 0x68, 0x53, 0x70, 0x61, 0x63,
	0x65, 0x12, 0x1a, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x47, 0x65, 0x74, 0x47, 0x72, 0x61, 0x70,
	0x68, 0x53, 0x70, 0x61, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1b, 0x2e,
	0x70, 0x64, 0x70, 0x62, 0x2e, 0x47, 0x65, 0x74, 0x47, 0x72, 0x61, 0x70, 0x68, 0x53, 0x70, 0x61,
	0x63, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x4a, 0x0a, 0x0d,
	0x53, 0x65, 0x74, 0x47, 0x72, 0x61, 0x70, 0x68, 0x53, 0x70, 0x61, 0x63, 0x65, 0x12, 0x1a, 0x2e,
	0x70, 0x64, 0x70, 0x62, 0x2e, 0x53, 0x65, 0x74, 0x47, 0x72, 0x61, 0x70, 0x68, 0x53, 0x70, 0x61,
	0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1b, 0x2e, 0x70, 0x64, 0x70, 0x62,
	0x2e, 0x53, 0x65, 0x74, 0x47, 0x72, 0x61, 0x70, 0x68, 0x53, 0x70, 0x61, 0x63, 0x65, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x50, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x1c, 0x2e, 0x70, 0x64,
	0x70, 0x62, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x70, 0x64, 0x70, 0x62,
	0x2e, 0x47, 0x65, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x50, 0x0a, 0x0e, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x50, 0x65, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x1b, 0x2e, 0x70,
	0x64, 0x70, 0x62, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x65, 0x65, 0x72, 0x4c, 0x69,
	0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1f, 0x2e, 0x70, 0x64, 0x70, 0x62,
	0x2e, 0x67, 0x65, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x65, 0x65, 0x72, 0x4c, 0x69,
	0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x3e, 0x0a, 0x09,
	0x53, 0x70, 0x6c, 0x69, 0x74, 0x44, 0x61, 0x74, 0x61, 0x12, 0x16, 0x2e, 0x70, 0x64, 0x70, 0x62,
	0x2e, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x17, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x44, 0x61,
	0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x48, 0x0a, 0x0e,
	0x53, 0x70, 0x6c, 0x69, 0x74, 0x47, 0x72, 0x61, 0x70, 0x68, 0x44, 0x61, 0x74, 0x61, 0x12, 0x1b,
	0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x47, 0x72, 0x61, 0x70, 0x68,
	0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x17, 0x2e, 0x70, 0x64,
	0x70, 0x62, 0x2e, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x4a, 0x0a, 0x0d, 0x4d, 0x6f, 0x76, 0x65, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x4d,
	0x6f, 0x76, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1b, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x4d, 0x6f, 0x76, 0x65, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x00, 0x12, 0x41, 0x0a, 0x0a, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x61, 0x73, 0x6b,
	0x12, 0x17, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x61,
	0x73, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x18, 0x2e, 0x70, 0x64, 0x70, 0x62,
	0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x56, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x1e, 0x2e, 0x70, 0x64, 0x70,
	0x62, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74,
	0x61, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1f, 0x2e, 0x70, 0x64, 0x70,
	0x62, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74,
	0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x4d, 0x0a,
	0x0e, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x4c, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x12,
	0x1b, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x4c, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1c, 0x2e, 0x70,
	0x64, 0x70, 0x62, 0x2e, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x4c, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x41, 0x0a, 0x0a,
	0x50, 0x75, 0x74, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x12, 0x17, 0x2e, 0x70, 0x64, 0x70,
	0x62, 0x2e, 0x50, 0x75, 0x74, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x18, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x50, 0x75, 0x74, 0x4c, 0x69,
	0x63, 0x65, 0x6e, 0x73, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12,
	0x47, 0x0a, 0x0c, 0x44, 0x62, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x19, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x44, 0x62, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1a, 0x2e, 0x70, 0x64, 0x70,
	0x62, 0x2e, 0x44, 0x62, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x4d, 0x0a, 0x0e, 0x43, 0x6f, 0x6d, 0x62,
	0x69, 0x6e, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x2e, 0x70, 0x64, 0x70,
	0x62, 0x2e, 0x43, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1c, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x43,
	0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x47, 0x0a, 0x0c, 0x43, 0x6f, 0x6d, 0x62, 0x69,
	0x6e, 0x65, 0x47, 0x72, 0x61, 0x70, 0x68, 0x12, 0x19, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x43,
	0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x47, 0x72, 0x61, 0x70, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1a, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x43, 0x6f, 0x6d, 0x62, 0x69, 0x6e,
	0x65, 0x47, 0x72, 0x61, 0x70, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00,
	0x12, 0x4a, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x53, 0x68, 0x61, 0x72, 0x64, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x12, 0x1a, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x68, 0x61, 0x72,
	0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1b, 0x2e,
	0x70, 0x64, 0x70, 0x62, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x68, 0x61, 0x72, 0x64, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x53, 0x0a, 0x10,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x68, 0x61, 0x72, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x12, 0x1d, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x68,
	0x61, 0x72, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1e, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x68, 0x61,
	0x72, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x00, 0x12, 0x53, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x68, 0x61, 0x72, 0x64,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x1d, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x53, 0x68, 0x61, 0x72, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x53, 0x68, 0x61, 0x72, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x4b, 0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x53, 0x68, 0x61, 0x72, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4f, 0x70, 0x12, 0x18, 0x2e, 0x70,
	0x64, 0x70, 0x62, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x68, 0x61, 0x72, 0x64, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x19, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x53, 0x68, 0x61, 0x72, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x00, 0x12, 0x44, 0x0a, 0x0b, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x68, 0x61,
	0x72, 0x64, 0x12, 0x18, 0x2e, 0x70, 0x64, 0x70, 0x62, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x53, 0x68, 0x61, 0x72, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x19, 0x2e, 0x70,
	0x64, 0x70, 0x62, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x68, 0x61, 0x72, 0x64, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x42, 0x31, 0x0a, 0x1b, 0x63, 0x6f, 0x6d,
	0x2e, 0x62, 0x61, 0x69, 0x64, 0x75, 0x2e, 0x68, 0x75, 0x67, 0x65, 0x67, 0x72, 0x61, 0x70, 0x68,
	0x2e, 0x70, 0x64, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x5a, 0x12, 0x2f, 0x68, 0x75, 0x67, 0x65, 0x67,
	0x72, 0x61, 0x70, 0x68, 0x2d, 0x70, 0x64, 0x2d, 0x67, 0x72, 0x70, 0x63, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_pdpb_proto_rawDescOnce sync.Once
	file_pdpb_proto_rawDescData = file_pdpb_proto_rawDesc
)

func file_pdpb_proto_rawDescGZIP() []byte {
	file_pdpb_proto_rawDescOnce.Do(func() {
		file_pdpb_proto_rawDescData = protoimpl.X.CompressGZIP(file_pdpb_proto_rawDescData)
	})
	return file_pdpb_proto_rawDescData
}

var file_pdpb_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_pdpb_proto_msgTypes = make([]protoimpl.MessageInfo, 80)
var file_pdpb_proto_goTypes = []interface{}{
	(ErrorType)(0),                    // 0: pdpb.ErrorType
	(OperationMode)(0),                // 1: pdpb.OperationMode
	(*RequestHeader)(nil),             // 2: pdpb.RequestHeader
	(*ResponseHeader)(nil),            // 3: pdpb.ResponseHeader
	(*Error)(nil),                     // 4: pdpb.Error
	(*GetStoreRequest)(nil),           // 5: pdpb.GetStoreRequest
	(*GetStoreResponse)(nil),          // 6: pdpb.GetStoreResponse
	(*DetStoreRequest)(nil),           // 7: pdpb.DetStoreRequest
	(*DetStoreResponse)(nil),          // 8: pdpb.DetStoreResponse
	(*RegisterStoreRequest)(nil),      // 9: pdpb.RegisterStoreRequest
	(*RegisterStoreResponse)(nil),     // 10: pdpb.RegisterStoreResponse
	(*SetStoreRequest)(nil),           // 11: pdpb.SetStoreRequest
	(*SetStoreResponse)(nil),          // 12: pdpb.SetStoreResponse
	(*GetAllStoresRequest)(nil),       // 13: pdpb.GetAllStoresRequest
	(*GetAllStoresResponse)(nil),      // 14: pdpb.GetAllStoresResponse
	(*StoreHeartbeatRequest)(nil),     // 15: pdpb.StoreHeartbeatRequest
	(*StoreHeartbeatResponse)(nil),    // 16: pdpb.StoreHeartbeatResponse
	(*GetPartitionRequest)(nil),       // 17: pdpb.GetPartitionRequest
	(*GetPartitionByCodeRequest)(nil), // 18: pdpb.GetPartitionByCodeRequest
	(*GetPartitionResponse)(nil),      // 19: pdpb.GetPartitionResponse
	(*GetPartitionByIDRequest)(nil),   // 20: pdpb.GetPartitionByIDRequest
	(*DelPartitionRequest)(nil),       // 21: pdpb.DelPartitionRequest
	(*DelPartitionResponse)(nil),      // 22: pdpb.DelPartitionResponse
	(*UpdatePartitionRequest)(nil),    // 23: pdpb.UpdatePartitionRequest
	(*UpdatePartitionResponse)(nil),   // 24: pdpb.UpdatePartitionResponse
	(*ScanPartitionsRequest)(nil),     // 25: pdpb.ScanPartitionsRequest
	(*ScanPartitionsResponse)(nil),    // 26: pdpb.ScanPartitionsResponse
	(*QueryPartitionsRequest)(nil),    // 27: pdpb.QueryPartitionsRequest
	(*QueryPartitionsResponse)(nil),   // 28: pdpb.QueryPartitionsResponse
	(*GetGraphRequest)(nil),           // 29: pdpb.GetGraphRequest
	(*GetGraphResponse)(nil),          // 30: pdpb.GetGraphResponse
	(*SetGraphRequest)(nil),           // 31: pdpb.SetGraphRequest
	(*SetGraphResponse)(nil),          // 32: pdpb.SetGraphResponse
	(*DelGraphRequest)(nil),           // 33: pdpb.DelGraphRequest
	(*DelGraphResponse)(nil),          // 34: pdpb.DelGraphResponse
	(*GetIdRequest)(nil),              // 35: pdpb.GetIdRequest
	(*GetIdResponse)(nil),             // 36: pdpb.GetIdResponse
	(*ResetIdRequest)(nil),            // 37: pdpb.ResetIdRequest
	(*ResetIdResponse)(nil),           // 38: pdpb.ResetIdResponse
	(*GetMembersRequest)(nil),         // 39: pdpb.GetMembersRequest
	(*GetMembersResponse)(nil),        // 40: pdpb.GetMembersResponse
	(*GetPDConfigRequest)(nil),        // 41: pdpb.GetPDConfigRequest
	(*GetPDConfigResponse)(nil),       // 42: pdpb.GetPDConfigResponse
	(*SetPDConfigRequest)(nil),        // 43: pdpb.SetPDConfigRequest
	(*SetPDConfigResponse)(nil),       // 44: pdpb.SetPDConfigResponse
	(*GetGraphSpaceRequest)(nil),      // 45: pdpb.GetGraphSpaceRequest
	(*GetGraphSpaceResponse)(nil),     // 46: pdpb.GetGraphSpaceResponse
	(*SetGraphSpaceRequest)(nil),      // 47: pdpb.SetGraphSpaceRequest
	(*SetGraphSpaceResponse)(nil),     // 48: pdpb.SetGraphSpaceResponse
	(*GetClusterStatsRequest)(nil),    // 49: pdpb.GetClusterStatsRequest
	(*GetClusterStatsResponse)(nil),   // 50: pdpb.GetClusterStatsResponse
	(*ChangePeerListRequest)(nil),     // 51: pdpb.ChangePeerListRequest
	(*GetChangePeerListResponse)(nil), // 52: pdpb.getChangePeerListResponse
	(*SplitDataParam)(nil),            // 53: pdpb.SplitDataParam
	(*SplitDataRequest)(nil),          // 54: pdpb.SplitDataRequest
	(*SplitGraphDataRequest)(nil),     // 55: pdpb.SplitGraphDataRequest
	(*SplitDataResponse)(nil),         // 56: pdpb.SplitDataResponse
	(*MovePartitionParam)(nil),        // 57: pdpb.MovePartitionParam
	(*MovePartitionRequest)(nil),      // 58: pdpb.MovePartitionRequest
	(*MovePartitionResponse)(nil),     // 59: pdpb.MovePartitionResponse
	(*ReportTaskRequest)(nil),         // 60: pdpb.ReportTaskRequest
	(*ReportTaskResponse)(nil),        // 61: pdpb.ReportTaskResponse
	(*GetPartitionStatsRequest)(nil),  // 62: pdpb.GetPartitionStatsRequest
	(*GetPartitionStatsResponse)(nil), // 63: pdpb.GetPartitionStatsResponse
	(*BalanceLeadersRequest)(nil),     // 64: pdpb.BalanceLeadersRequest
	(*BalanceLeadersResponse)(nil),    // 65: pdpb.BalanceLeadersResponse
	(*PutLicenseRequest)(nil),         // 66: pdpb.PutLicenseRequest
	(*PutLicenseResponse)(nil),        // 67: pdpb.PutLicenseResponse
	(*DbCompactionRequest)(nil),       // 68: pdpb.DbCompactionRequest
	(*DbCompactionResponse)(nil),      // 69: pdpb.DbCompactionResponse
	(*CombineClusterRequest)(nil),     // 70: pdpb.CombineClusterRequest
	(*CombineClusterResponse)(nil),    // 71: pdpb.CombineClusterResponse
	(*CombineGraphRequest)(nil),       // 72: pdpb.CombineGraphRequest
	(*CombineGraphResponse)(nil),      // 73: pdpb.CombineGraphResponse
	(*DeleteShardGroupRequest)(nil),   // 74: pdpb.DeleteShardGroupRequest
	(*DeleteShardGroupResponse)(nil),  // 75: pdpb.DeleteShardGroupResponse
	(*GetShardGroupRequest)(nil),      // 76: pdpb.GetShardGroupRequest
	(*GetShardGroupResponse)(nil),     // 77: pdpb.GetShardGroupResponse
	(*UpdateShardGroupRequest)(nil),   // 78: pdpb.UpdateShardGroupRequest
	(*UpdateShardGroupResponse)(nil),  // 79: pdpb.UpdateShardGroupResponse
	(*ChangeShardRequest)(nil),        // 80: pdpb.ChangeShardRequest
	(*ChangeShardResponse)(nil),       // 81: pdpb.ChangeShardResponse
	(*metapb.Store)(nil),              // 82: metapb.Store
	(*metapb.StoreStats)(nil),         // 83: metapb.StoreStats
	(*metapb.ClusterStats)(nil),       // 84: metapb.ClusterStats
	(*metapb.Partition)(nil),          // 85: metapb.Partition
	(*metapb.Shard)(nil),              // 86: metapb.Shard
	(*metapb.PartitionShard)(nil),     // 87: metapb.PartitionShard
	(*metapb.PartitionQuery)(nil),     // 88: metapb.PartitionQuery
	(*metapb.Graph)(nil),              // 89: metapb.Graph
	(*metapb.Member)(nil),             // 90: metapb.Member
	(*metapb.PDConfig)(nil),           // 91: metapb.PDConfig
	(*metapb.GraphSpace)(nil),         // 92: metapb.GraphSpace
	(*metaTask.Task)(nil),             // 93: metaTask.Task
	(*metapb.PartitionStats)(nil),     // 94: metapb.PartitionStats
	(*metapb.ShardGroup)(nil),         // 95: metapb.ShardGroup
}
var file_pdpb_proto_depIdxs = []int32{
	4,   // 0: pdpb.ResponseHeader.error:type_name -> pdpb.Error
	0,   // 1: pdpb.Error.type:type_name -> pdpb.ErrorType
	2,   // 2: pdpb.GetStoreRequest.header:type_name -> pdpb.RequestHeader
	3,   // 3: pdpb.GetStoreResponse.header:type_name -> pdpb.ResponseHeader
	82,  // 4: pdpb.GetStoreResponse.store:type_name -> metapb.Store
	83,  // 5: pdpb.GetStoreResponse.stats:type_name -> metapb.StoreStats
	2,   // 6: pdpb.DetStoreRequest.header:type_name -> pdpb.RequestHeader
	3,   // 7: pdpb.DetStoreResponse.header:type_name -> pdpb.ResponseHeader
	82,  // 8: pdpb.DetStoreResponse.store:type_name -> metapb.Store
	2,   // 9: pdpb.RegisterStoreRequest.header:type_name -> pdpb.RequestHeader
	82,  // 10: pdpb.RegisterStoreRequest.store:type_name -> metapb.Store
	3,   // 11: pdpb.RegisterStoreResponse.header:type_name -> pdpb.ResponseHeader
	2,   // 12: pdpb.SetStoreRequest.header:type_name -> pdpb.RequestHeader
	82,  // 13: pdpb.SetStoreRequest.store:type_name -> metapb.Store
	3,   // 14: pdpb.SetStoreResponse.header:type_name -> pdpb.ResponseHeader
	82,  // 15: pdpb.SetStoreResponse.store:type_name -> metapb.Store
	2,   // 16: pdpb.GetAllStoresRequest.header:type_name -> pdpb.RequestHeader
	3,   // 17: pdpb.GetAllStoresResponse.header:type_name -> pdpb.ResponseHeader
	82,  // 18: pdpb.GetAllStoresResponse.stores:type_name -> metapb.Store
	2,   // 19: pdpb.StoreHeartbeatRequest.header:type_name -> pdpb.RequestHeader
	83,  // 20: pdpb.StoreHeartbeatRequest.stats:type_name -> metapb.StoreStats
	3,   // 21: pdpb.StoreHeartbeatResponse.header:type_name -> pdpb.ResponseHeader
	84,  // 22: pdpb.StoreHeartbeatResponse.clusterStats:type_name -> metapb.ClusterStats
	2,   // 23: pdpb.GetPartitionRequest.header:type_name -> pdpb.RequestHeader
	2,   // 24: pdpb.GetPartitionByCodeRequest.header:type_name -> pdpb.RequestHeader
	3,   // 25: pdpb.GetPartitionResponse.header:type_name -> pdpb.ResponseHeader
	85,  // 26: pdpb.GetPartitionResponse.partition:type_name -> metapb.Partition
	86,  // 27: pdpb.GetPartitionResponse.leader:type_name -> metapb.Shard
	86,  // 28: pdpb.GetPartitionResponse.offline_shards:type_name -> metapb.Shard
	2,   // 29: pdpb.GetPartitionByIDRequest.header:type_name -> pdpb.RequestHeader
	2,   // 30: pdpb.DelPartitionRequest.header:type_name -> pdpb.RequestHeader
	3,   // 31: pdpb.DelPartitionResponse.header:type_name -> pdpb.ResponseHeader
	85,  // 32: pdpb.DelPartitionResponse.partition:type_name -> metapb.Partition
	2,   // 33: pdpb.UpdatePartitionRequest.header:type_name -> pdpb.RequestHeader
	85,  // 34: pdpb.UpdatePartitionRequest.partition:type_name -> metapb.Partition
	3,   // 35: pdpb.UpdatePartitionResponse.header:type_name -> pdpb.ResponseHeader
	85,  // 36: pdpb.UpdatePartitionResponse.partition:type_name -> metapb.Partition
	2,   // 37: pdpb.ScanPartitionsRequest.header:type_name -> pdpb.RequestHeader
	3,   // 38: pdpb.ScanPartitionsResponse.header:type_name -> pdpb.ResponseHeader
	87,  // 39: pdpb.ScanPartitionsResponse.partitions:type_name -> metapb.PartitionShard
	2,   // 40: pdpb.QueryPartitionsRequest.header:type_name -> pdpb.RequestHeader
	88,  // 41: pdpb.QueryPartitionsRequest.query:type_name -> metapb.PartitionQuery
	3,   // 42: pdpb.QueryPartitionsResponse.header:type_name -> pdpb.ResponseHeader
	85,  // 43: pdpb.QueryPartitionsResponse.partitions:type_name -> metapb.Partition
	2,   // 44: pdpb.GetGraphRequest.header:type_name -> pdpb.RequestHeader
	3,   // 45: pdpb.GetGraphResponse.header:type_name -> pdpb.ResponseHeader
	89,  // 46: pdpb.GetGraphResponse.graph:type_name -> metapb.Graph
	2,   // 47: pdpb.SetGraphRequest.header:type_name -> pdpb.RequestHeader
	89,  // 48: pdpb.SetGraphRequest.graph:type_name -> metapb.Graph
	3,   // 49: pdpb.SetGraphResponse.header:type_name -> pdpb.ResponseHeader
	89,  // 50: pdpb.SetGraphResponse.graph:type_name -> metapb.Graph
	2,   // 51: pdpb.DelGraphRequest.header:type_name -> pdpb.RequestHeader
	3,   // 52: pdpb.DelGraphResponse.header:type_name -> pdpb.ResponseHeader
	89,  // 53: pdpb.DelGraphResponse.graph:type_name -> metapb.Graph
	2,   // 54: pdpb.GetIdRequest.header:type_name -> pdpb.RequestHeader
	3,   // 55: pdpb.GetIdResponse.header:type_name -> pdpb.ResponseHeader
	2,   // 56: pdpb.ResetIdRequest.header:type_name -> pdpb.RequestHeader
	3,   // 57: pdpb.ResetIdResponse.header:type_name -> pdpb.ResponseHeader
	2,   // 58: pdpb.GetMembersRequest.header:type_name -> pdpb.RequestHeader
	3,   // 59: pdpb.GetMembersResponse.header:type_name -> pdpb.ResponseHeader
	90,  // 60: pdpb.GetMembersResponse.members:type_name -> metapb.Member
	90,  // 61: pdpb.GetMembersResponse.leader:type_name -> metapb.Member
	2,   // 62: pdpb.GetPDConfigRequest.header:type_name -> pdpb.RequestHeader
	3,   // 63: pdpb.GetPDConfigResponse.header:type_name -> pdpb.ResponseHeader
	91,  // 64: pdpb.GetPDConfigResponse.pd_config:type_name -> metapb.PDConfig
	2,   // 65: pdpb.SetPDConfigRequest.header:type_name -> pdpb.RequestHeader
	91,  // 66: pdpb.SetPDConfigRequest.pd_config:type_name -> metapb.PDConfig
	3,   // 67: pdpb.SetPDConfigResponse.header:type_name -> pdpb.ResponseHeader
	2,   // 68: pdpb.GetGraphSpaceRequest.header:type_name -> pdpb.RequestHeader
	3,   // 69: pdpb.GetGraphSpaceResponse.header:type_name -> pdpb.ResponseHeader
	92,  // 70: pdpb.GetGraphSpaceResponse.graph_space:type_name -> metapb.GraphSpace
	2,   // 71: pdpb.SetGraphSpaceRequest.header:type_name -> pdpb.RequestHeader
	92,  // 72: pdpb.SetGraphSpaceRequest.graph_space:type_name -> metapb.GraphSpace
	3,   // 73: pdpb.SetGraphSpaceResponse.header:type_name -> pdpb.ResponseHeader
	2,   // 74: pdpb.GetClusterStatsRequest.header:type_name -> pdpb.RequestHeader
	3,   // 75: pdpb.GetClusterStatsResponse.header:type_name -> pdpb.ResponseHeader
	84,  // 76: pdpb.GetClusterStatsResponse.cluster:type_name -> metapb.ClusterStats
	2,   // 77: pdpb.ChangePeerListRequest.header:type_name -> pdpb.RequestHeader
	3,   // 78: pdpb.getChangePeerListResponse.header:type_name -> pdpb.ResponseHeader
	2,   // 79: pdpb.SplitDataRequest.header:type_name -> pdpb.RequestHeader
	1,   // 80: pdpb.SplitDataRequest.mode:type_name -> pdpb.OperationMode
	53,  // 81: pdpb.SplitDataRequest.param:type_name -> pdpb.SplitDataParam
	2,   // 82: pdpb.SplitGraphDataRequest.header:type_name -> pdpb.RequestHeader
	3,   // 83: pdpb.SplitDataResponse.header:type_name -> pdpb.ResponseHeader
	2,   // 84: pdpb.MovePartitionRequest.header:type_name -> pdpb.RequestHeader
	1,   // 85: pdpb.MovePartitionRequest.mode:type_name -> pdpb.OperationMode
	57,  // 86: pdpb.MovePartitionRequest.param:type_name -> pdpb.MovePartitionParam
	3,   // 87: pdpb.MovePartitionResponse.header:type_name -> pdpb.ResponseHeader
	2,   // 88: pdpb.ReportTaskRequest.header:type_name -> pdpb.RequestHeader
	93,  // 89: pdpb.ReportTaskRequest.task:type_name -> metaTask.Task
	3,   // 90: pdpb.ReportTaskResponse.header:type_name -> pdpb.ResponseHeader
	2,   // 91: pdpb.GetPartitionStatsRequest.header:type_name -> pdpb.RequestHeader
	3,   // 92: pdpb.GetPartitionStatsResponse.header:type_name -> pdpb.ResponseHeader
	94,  // 93: pdpb.GetPartitionStatsResponse.partition_stats:type_name -> metapb.PartitionStats
	2,   // 94: pdpb.BalanceLeadersRequest.header:type_name -> pdpb.RequestHeader
	3,   // 95: pdpb.BalanceLeadersResponse.header:type_name -> pdpb.ResponseHeader
	2,   // 96: pdpb.PutLicenseRequest.header:type_name -> pdpb.RequestHeader
	3,   // 97: pdpb.PutLicenseResponse.header:type_name -> pdpb.ResponseHeader
	2,   // 98: pdpb.DbCompactionRequest.header:type_name -> pdpb.RequestHeader
	3,   // 99: pdpb.DbCompactionResponse.header:type_name -> pdpb.ResponseHeader
	2,   // 100: pdpb.CombineClusterRequest.header:type_name -> pdpb.RequestHeader
	3,   // 101: pdpb.CombineClusterResponse.header:type_name -> pdpb.ResponseHeader
	2,   // 102: pdpb.CombineGraphRequest.header:type_name -> pdpb.RequestHeader
	3,   // 103: pdpb.CombineGraphResponse.header:type_name -> pdpb.ResponseHeader
	2,   // 104: pdpb.DeleteShardGroupRequest.header:type_name -> pdpb.RequestHeader
	3,   // 105: pdpb.DeleteShardGroupResponse.header:type_name -> pdpb.ResponseHeader
	2,   // 106: pdpb.GetShardGroupRequest.header:type_name -> pdpb.RequestHeader
	3,   // 107: pdpb.GetShardGroupResponse.header:type_name -> pdpb.ResponseHeader
	95,  // 108: pdpb.GetShardGroupResponse.shardGroup:type_name -> metapb.ShardGroup
	2,   // 109: pdpb.UpdateShardGroupRequest.header:type_name -> pdpb.RequestHeader
	95,  // 110: pdpb.UpdateShardGroupRequest.shardGroup:type_name -> metapb.ShardGroup
	3,   // 111: pdpb.UpdateShardGroupResponse.header:type_name -> pdpb.ResponseHeader
	2,   // 112: pdpb.ChangeShardRequest.header:type_name -> pdpb.RequestHeader
	86,  // 113: pdpb.ChangeShardRequest.shards:type_name -> metapb.Shard
	3,   // 114: pdpb.ChangeShardResponse.header:type_name -> pdpb.ResponseHeader
	9,   // 115: pdpb.PD.RegisterStore:input_type -> pdpb.RegisterStoreRequest
	5,   // 116: pdpb.PD.GetStore:input_type -> pdpb.GetStoreRequest
	11,  // 117: pdpb.PD.SetStore:input_type -> pdpb.SetStoreRequest
	7,   // 118: pdpb.PD.DelStore:input_type -> pdpb.DetStoreRequest
	13,  // 119: pdpb.PD.GetAllStores:input_type -> pdpb.GetAllStoresRequest
	15,  // 120: pdpb.PD.StoreHeartbeat:input_type -> pdpb.StoreHeartbeatRequest
	17,  // 121: pdpb.PD.GetPartition:input_type -> pdpb.GetPartitionRequest
	18,  // 122: pdpb.PD.GetPartitionByCode:input_type -> pdpb.GetPartitionByCodeRequest
	20,  // 123: pdpb.PD.GetPartitionByID:input_type -> pdpb.GetPartitionByIDRequest
	25,  // 124: pdpb.PD.ScanPartitions:input_type -> pdpb.ScanPartitionsRequest
	23,  // 125: pdpb.PD.UpdatePartition:input_type -> pdpb.UpdatePartitionRequest
	21,  // 126: pdpb.PD.DelPartition:input_type -> pdpb.DelPartitionRequest
	27,  // 127: pdpb.PD.QueryPartitions:input_type -> pdpb.QueryPartitionsRequest
	29,  // 128: pdpb.PD.GetGraph:input_type -> pdpb.GetGraphRequest
	31,  // 129: pdpb.PD.SetGraph:input_type -> pdpb.SetGraphRequest
	33,  // 130: pdpb.PD.DelGraph:input_type -> pdpb.DelGraphRequest
	35,  // 131: pdpb.PD.GetId:input_type -> pdpb.GetIdRequest
	37,  // 132: pdpb.PD.ResetId:input_type -> pdpb.ResetIdRequest
	39,  // 133: pdpb.PD.GetMembers:input_type -> pdpb.GetMembersRequest
	13,  // 134: pdpb.PD.GetStoreStatus:input_type -> pdpb.GetAllStoresRequest
	41,  // 135: pdpb.PD.GetPDConfig:input_type -> pdpb.GetPDConfigRequest
	43,  // 136: pdpb.PD.SetPDConfig:input_type -> pdpb.SetPDConfigRequest
	45,  // 137: pdpb.PD.GetGraphSpace:input_type -> pdpb.GetGraphSpaceRequest
	47,  // 138: pdpb.PD.SetGraphSpace:input_type -> pdpb.SetGraphSpaceRequest
	49,  // 139: pdpb.PD.GetClusterStats:input_type -> pdpb.GetClusterStatsRequest
	51,  // 140: pdpb.PD.ChangePeerList:input_type -> pdpb.ChangePeerListRequest
	54,  // 141: pdpb.PD.SplitData:input_type -> pdpb.SplitDataRequest
	55,  // 142: pdpb.PD.SplitGraphData:input_type -> pdpb.SplitGraphDataRequest
	58,  // 143: pdpb.PD.MovePartition:input_type -> pdpb.MovePartitionRequest
	60,  // 144: pdpb.PD.ReportTask:input_type -> pdpb.ReportTaskRequest
	62,  // 145: pdpb.PD.GetPartitionStats:input_type -> pdpb.GetPartitionStatsRequest
	64,  // 146: pdpb.PD.BalanceLeaders:input_type -> pdpb.BalanceLeadersRequest
	66,  // 147: pdpb.PD.PutLicense:input_type -> pdpb.PutLicenseRequest
	68,  // 148: pdpb.PD.DbCompaction:input_type -> pdpb.DbCompactionRequest
	70,  // 149: pdpb.PD.CombineCluster:input_type -> pdpb.CombineClusterRequest
	72,  // 150: pdpb.PD.CombineGraph:input_type -> pdpb.CombineGraphRequest
	76,  // 151: pdpb.PD.GetShardGroup:input_type -> pdpb.GetShardGroupRequest
	78,  // 152: pdpb.PD.UpdateShardGroup:input_type -> pdpb.UpdateShardGroupRequest
	74,  // 153: pdpb.PD.DeleteShardGroup:input_type -> pdpb.DeleteShardGroupRequest
	80,  // 154: pdpb.PD.UpdateShardGroupOp:input_type -> pdpb.ChangeShardRequest
	80,  // 155: pdpb.PD.ChangeShard:input_type -> pdpb.ChangeShardRequest
	10,  // 156: pdpb.PD.RegisterStore:output_type -> pdpb.RegisterStoreResponse
	6,   // 157: pdpb.PD.GetStore:output_type -> pdpb.GetStoreResponse
	12,  // 158: pdpb.PD.SetStore:output_type -> pdpb.SetStoreResponse
	8,   // 159: pdpb.PD.DelStore:output_type -> pdpb.DetStoreResponse
	14,  // 160: pdpb.PD.GetAllStores:output_type -> pdpb.GetAllStoresResponse
	16,  // 161: pdpb.PD.StoreHeartbeat:output_type -> pdpb.StoreHeartbeatResponse
	19,  // 162: pdpb.PD.GetPartition:output_type -> pdpb.GetPartitionResponse
	19,  // 163: pdpb.PD.GetPartitionByCode:output_type -> pdpb.GetPartitionResponse
	19,  // 164: pdpb.PD.GetPartitionByID:output_type -> pdpb.GetPartitionResponse
	26,  // 165: pdpb.PD.ScanPartitions:output_type -> pdpb.ScanPartitionsResponse
	24,  // 166: pdpb.PD.UpdatePartition:output_type -> pdpb.UpdatePartitionResponse
	22,  // 167: pdpb.PD.DelPartition:output_type -> pdpb.DelPartitionResponse
	28,  // 168: pdpb.PD.QueryPartitions:output_type -> pdpb.QueryPartitionsResponse
	30,  // 169: pdpb.PD.GetGraph:output_type -> pdpb.GetGraphResponse
	32,  // 170: pdpb.PD.SetGraph:output_type -> pdpb.SetGraphResponse
	34,  // 171: pdpb.PD.DelGraph:output_type -> pdpb.DelGraphResponse
	36,  // 172: pdpb.PD.GetId:output_type -> pdpb.GetIdResponse
	38,  // 173: pdpb.PD.ResetId:output_type -> pdpb.ResetIdResponse
	40,  // 174: pdpb.PD.GetMembers:output_type -> pdpb.GetMembersResponse
	14,  // 175: pdpb.PD.GetStoreStatus:output_type -> pdpb.GetAllStoresResponse
	42,  // 176: pdpb.PD.GetPDConfig:output_type -> pdpb.GetPDConfigResponse
	44,  // 177: pdpb.PD.SetPDConfig:output_type -> pdpb.SetPDConfigResponse
	46,  // 178: pdpb.PD.GetGraphSpace:output_type -> pdpb.GetGraphSpaceResponse
	48,  // 179: pdpb.PD.SetGraphSpace:output_type -> pdpb.SetGraphSpaceResponse
	50,  // 180: pdpb.PD.GetClusterStats:output_type -> pdpb.GetClusterStatsResponse
	52,  // 181: pdpb.PD.ChangePeerList:output_type -> pdpb.getChangePeerListResponse
	56,  // 182: pdpb.PD.SplitData:output_type -> pdpb.SplitDataResponse
	56,  // 183: pdpb.PD.SplitGraphData:output_type -> pdpb.SplitDataResponse
	59,  // 184: pdpb.PD.MovePartition:output_type -> pdpb.MovePartitionResponse
	61,  // 185: pdpb.PD.ReportTask:output_type -> pdpb.ReportTaskResponse
	63,  // 186: pdpb.PD.GetPartitionStats:output_type -> pdpb.GetPartitionStatsResponse
	65,  // 187: pdpb.PD.BalanceLeaders:output_type -> pdpb.BalanceLeadersResponse
	67,  // 188: pdpb.PD.PutLicense:output_type -> pdpb.PutLicenseResponse
	69,  // 189: pdpb.PD.DbCompaction:output_type -> pdpb.DbCompactionResponse
	71,  // 190: pdpb.PD.CombineCluster:output_type -> pdpb.CombineClusterResponse
	73,  // 191: pdpb.PD.CombineGraph:output_type -> pdpb.CombineGraphResponse
	77,  // 192: pdpb.PD.GetShardGroup:output_type -> pdpb.GetShardGroupResponse
	79,  // 193: pdpb.PD.UpdateShardGroup:output_type -> pdpb.UpdateShardGroupResponse
	75,  // 194: pdpb.PD.DeleteShardGroup:output_type -> pdpb.DeleteShardGroupResponse
	81,  // 195: pdpb.PD.UpdateShardGroupOp:output_type -> pdpb.ChangeShardResponse
	81,  // 196: pdpb.PD.ChangeShard:output_type -> pdpb.ChangeShardResponse
	156, // [156:197] is the sub-list for method output_type
	115, // [115:156] is the sub-list for method input_type
	115, // [115:115] is the sub-list for extension type_name
	115, // [115:115] is the sub-list for extension extendee
	0,   // [0:115] is the sub-list for field type_name
}

func init() { file_pdpb_proto_init() }
func file_pdpb_proto_init() {
	if File_pdpb_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_pdpb_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RequestHeader); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResponseHeader); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Error); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetStoreRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetStoreResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DetStoreRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DetStoreResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RegisterStoreRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RegisterStoreResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetStoreRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetStoreResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAllStoresRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAllStoresResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StoreHeartbeatRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StoreHeartbeatResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetPartitionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetPartitionByCodeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetPartitionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetPartitionByIDRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DelPartitionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DelPartitionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdatePartitionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdatePartitionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ScanPartitionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ScanPartitionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryPartitionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryPartitionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetGraphRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetGraphResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetGraphRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetGraphResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DelGraphRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DelGraphResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetIdRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetIdResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResetIdRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResetIdResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetMembersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetMembersResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetPDConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetPDConfigResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetPDConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetPDConfigResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetGraphSpaceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetGraphSpaceResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetGraphSpaceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetGraphSpaceResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetClusterStatsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetClusterStatsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChangePeerListRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetChangePeerListResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SplitDataParam); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SplitDataRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[53].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SplitGraphDataRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SplitDataResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[55].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MovePartitionParam); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[56].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MovePartitionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[57].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MovePartitionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[58].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportTaskRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[59].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportTaskResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[60].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetPartitionStatsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[61].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetPartitionStatsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[62].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BalanceLeadersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[63].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BalanceLeadersResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[64].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PutLicenseRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[65].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PutLicenseResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[66].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DbCompactionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[67].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DbCompactionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[68].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CombineClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[69].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CombineClusterResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[70].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CombineGraphRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[71].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CombineGraphResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[72].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteShardGroupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[73].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteShardGroupResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[74].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetShardGroupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[75].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetShardGroupResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[76].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateShardGroupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[77].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateShardGroupResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[78].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChangeShardRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pdpb_proto_msgTypes[79].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChangeShardResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_pdpb_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   80,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_pdpb_proto_goTypes,
		DependencyIndexes: file_pdpb_proto_depIdxs,
		EnumInfos:         file_pdpb_proto_enumTypes,
		MessageInfos:      file_pdpb_proto_msgTypes,
	}.Build()
	File_pdpb_proto = out.File
	file_pdpb_proto_rawDesc = nil
	file_pdpb_proto_goTypes = nil
	file_pdpb_proto_depIdxs = nil
}
