/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.table;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite.internal.client.PayloadOutputChannel;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.client.proto.TuplePart;
import org.apache.ignite.internal.client.table.ClientColumn;
import org.apache.ignite.internal.client.table.ClientSchema;
import org.apache.ignite.internal.client.table.ClientTable;
import org.apache.ignite.internal.marshaller.BinaryMode;
import org.apache.ignite.internal.marshaller.ClientMarshallerReader;
import org.apache.ignite.internal.marshaller.ClientMarshallerWriter;
import org.apache.ignite.internal.marshaller.Marshaller;
import org.apache.ignite.internal.marshaller.MarshallerReader;
import org.apache.ignite.internal.marshaller.MarshallerWriter;
import org.apache.ignite.table.mapper.Mapper;
import org.apache.ignite.tx.Transaction;
import org.jetbrains.annotations.Nullable;

public class ClientRecordSerializer<R> {
    private final int tableId;
    private final Mapper<R> mapper;
    private final boolean oneColumnMode;

    ClientRecordSerializer(int tableId, Mapper<R> mapper) {
        assert (mapper != null);
        this.tableId = tableId;
        this.mapper = mapper;
        this.oneColumnMode = BinaryMode.forClass((Class)mapper.targetType()) != BinaryMode.POJO;
    }

    Mapper<R> mapper() {
        return this.mapper;
    }

    public static <R> void writeRecRaw(@Nullable R rec, Mapper<R> mapper, ClientSchema schema, ClientMessagePacker out, TuplePart part) {
        ClientRecordSerializer.writeRecRaw(rec, out, schema.getMarshaller(mapper, part), ClientRecordSerializer.columnCount(schema, part));
    }

    static <R> void writeRecRaw(@Nullable R rec, ClientMessagePacker out, Marshaller marshaller, int columnCount) {
        BinaryTupleBuilder builder = new BinaryTupleBuilder(columnCount);
        BitSet noValueSet = new BitSet();
        ClientMarshallerWriter writer = new ClientMarshallerWriter(builder, noValueSet);
        marshaller.writeObject(rec, (MarshallerWriter)writer);
        out.packBinaryTuple(builder, noValueSet);
    }

    void writeRecRaw(@Nullable R rec, ClientSchema schema, ClientMessagePacker out, TuplePart part) {
        ClientRecordSerializer.writeRecRaw(rec, this.mapper, schema, out, part);
    }

    void writeRec(@Nullable Transaction tx, @Nullable R rec, ClientSchema schema, PayloadOutputChannel out, TuplePart part) {
        out.out().packInt(this.tableId);
        ClientTable.writeTx(tx, out);
        out.out().packInt(schema.version());
        this.writeRecRaw(rec, schema, out.out(), part);
    }

    void writeRecs(@Nullable Transaction tx, @Nullable R rec, @Nullable R rec2, ClientSchema schema, PayloadOutputChannel out, TuplePart part) {
        out.out().packInt(this.tableId);
        ClientTable.writeTx(tx, out);
        out.out().packInt(schema.version());
        Marshaller marshaller = schema.getMarshaller(this.mapper, part);
        int columnCount = ClientRecordSerializer.columnCount(schema, part);
        ClientRecordSerializer.writeRecRaw(rec, out.out(), marshaller, columnCount);
        ClientRecordSerializer.writeRecRaw(rec2, out.out(), marshaller, columnCount);
    }

    void writeRecs(@Nullable Transaction tx, Collection<R> recs, ClientSchema schema, PayloadOutputChannel out, TuplePart part) {
        out.out().packInt(this.tableId);
        ClientTable.writeTx(tx, out);
        out.out().packInt(schema.version());
        out.out().packInt(recs.size());
        Marshaller marshaller = schema.getMarshaller(this.mapper, part);
        int columnCount = ClientRecordSerializer.columnCount(schema, part);
        for (R rec : recs) {
            ClientRecordSerializer.writeRecRaw(rec, out.out(), marshaller, columnCount);
        }
    }

    void writeStreamerRecs(int partitionId, Collection<R> recs, @Nullable BitSet deleted, ClientSchema schema, PayloadOutputChannel out) {
        ClientMessagePacker w = out.out();
        w.packInt(this.tableId);
        w.packInt(partitionId);
        w.packBitSetNullable(deleted);
        w.packInt(schema.version());
        w.packInt(recs.size());
        Marshaller marshaller = schema.getMarshaller(this.mapper, TuplePart.KEY_AND_VAL);
        Marshaller keyMarshaller = deleted == null || deleted.cardinality() == 0 ? null : schema.getMarshaller(this.mapper, TuplePart.KEY);
        int columnCount = schema.columns().length;
        int keyColumnCount = schema.keyColumns().length;
        int i = 0;
        for (R rec : recs) {
            boolean del = deleted != null && deleted.get(i++);
            int colCount = del ? keyColumnCount : columnCount;
            Marshaller marsh = del ? keyMarshaller : marshaller;
            ClientRecordSerializer.writeRecRaw(rec, w, marsh, colCount);
        }
    }

    List<R> readRecs(ClientSchema schema, ClientMessageUnpacker in, boolean nullable, TuplePart part) {
        int cnt = in.unpackInt();
        if (cnt == 0) {
            return Collections.emptyList();
        }
        ArrayList<Object> res = new ArrayList<Object>(cnt);
        Marshaller marshaller = schema.getMarshaller(this.mapper, part);
        for (int i = 0; i < cnt; ++i) {
            if (nullable && !in.unpackBoolean()) {
                res.add(null);
                continue;
            }
            ClientColumn[] columns = schema.columns(part);
            BinaryTupleReader tupleReader = new BinaryTupleReader(columns.length, in.readBinaryUnsafe());
            ClientMarshallerReader reader = new ClientMarshallerReader(tupleReader, columns, part);
            res.add(marshaller.readObject((MarshallerReader)reader, null));
        }
        return res;
    }

    R readRec(ClientSchema schema, ClientMessageUnpacker in, TuplePart partToRead, TuplePart dataPart) {
        Marshaller marshaller = schema.getMarshaller(this.mapper, partToRead);
        BinaryTupleReader tupleReader = new BinaryTupleReader(schema.columns().length, in.readBinaryUnsafe());
        ClientMarshallerReader reader = new ClientMarshallerReader(tupleReader, schema.columns(partToRead), dataPart);
        return (R)marshaller.readObject((MarshallerReader)reader, null);
    }

    R readValRec(R keyRec, ClientSchema schema, ClientMessageUnpacker in) {
        if (this.oneColumnMode) {
            return keyRec;
        }
        Marshaller valMarshaller = schema.getMarshaller(this.mapper, TuplePart.KEY_AND_VAL);
        BinaryTupleReader tupleReader = new BinaryTupleReader(schema.columns().length, in.readBinaryUnsafe());
        ClientMarshallerReader reader = new ClientMarshallerReader(tupleReader, schema.columns(), TuplePart.KEY_AND_VAL);
        return (R)valMarshaller.readObject((MarshallerReader)reader, null);
    }

    private static int columnCount(ClientSchema schema, TuplePart part) {
        return schema.columns(part).length;
    }
}

