/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.configuration;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.apache.ignite.configuration.validation.ConfigurationValidationException;
import org.apache.ignite.internal.configuration.rest.presentation.ConfigurationPresentation;
import org.apache.ignite.lang.IgniteException;

public abstract class AbstractConfigurationController {
    private final ConfigurationPresentation<String> cfgPresentation;

    public AbstractConfigurationController(ConfigurationPresentation<String> cfgPresentation) {
        this.cfgPresentation = cfgPresentation;
    }

    public String getConfiguration() {
        return this.cfgPresentation.represent();
    }

    public String getConfigurationByPath(String path) {
        try {
            return this.cfgPresentation.representByPath(path);
        }
        catch (IllegalArgumentException ex) {
            throw new IgniteException((Throwable)ex);
        }
    }

    public CompletableFuture<Void> updateConfiguration(String updatedConfiguration) {
        return this.cfgPresentation.update(updatedConfiguration).exceptionally(ex -> {
            Throwable cause;
            if (ex instanceof CompletionException && ((cause = ex.getCause()) instanceof IllegalArgumentException || cause instanceof ConfigurationValidationException)) {
                throw new IgniteException(cause);
            }
            throw new IgniteException(ex);
        });
    }
}

