/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.rel;

import java.util.BitSet;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Flow;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.exec.rel.AbstractNode;
import org.apache.ignite.internal.sql.engine.exec.rel.Downstream;
import org.apache.ignite.internal.sql.engine.exec.rel.Node;
import org.apache.ignite.internal.sql.engine.schema.InternalIgniteTable;
import org.apache.ignite.internal.table.InternalTable;
import org.apache.ignite.internal.util.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public class TableScanNode<RowT>
extends AbstractNode<RowT> {
    private static final int NOT_WAITING = -1;
    private final InternalTable physTable;
    private final InternalIgniteTable schemaTable;
    private final RowHandler.RowFactory<RowT> factory;
    private final int[] parts;
    private final Queue<RowT> inBuff = new LinkedBlockingQueue<RowT>(512);
    @Nullable
    private final Predicate<RowT> filters;
    @Nullable
    private final Function<RowT, RowT> rowTransformer;
    @Nullable
    private final BitSet requiredColumns;
    private int requested;
    private int waiting;
    private boolean inLoop;
    private Flow.Subscription activeSubscription;
    private int curPartIdx;

    public TableScanNode(ExecutionContext<RowT> ctx, RelDataType rowType, InternalIgniteTable schemaTable, int[] parts, @Nullable Predicate<RowT> filters, @Nullable Function<RowT, RowT> rowTransformer, @Nullable BitSet requiredColumns) {
        super(ctx, rowType);
        assert (!ArrayUtils.nullOrEmpty((int[])parts));
        assert (this.context().transaction() != null || this.context().transactionTime() != null) : "Transaction not initialized.";
        this.physTable = schemaTable.table();
        this.schemaTable = schemaTable;
        this.parts = parts;
        this.filters = filters;
        this.rowTransformer = rowTransformer;
        this.requiredColumns = requiredColumns;
        this.factory = ctx.rowHandler().factory(ctx.getTypeFactory(), rowType);
    }

    @Override
    public void request(int rowsCnt) throws Exception {
        assert (rowsCnt > 0 && this.requested == 0) : "rowsCnt=" + rowsCnt + ", requested=" + this.requested;
        this.checkState();
        this.requested = rowsCnt;
        if (!this.inLoop) {
            this.context().execute(this::push, this::onError);
        }
    }

    @Override
    public void closeInternal() {
        super.closeInternal();
        if (this.activeSubscription != null) {
            this.activeSubscription.cancel();
            this.activeSubscription = null;
        }
    }

    @Override
    protected void rewindInternal() {
        this.requested = 0;
        this.waiting = 0;
        this.curPartIdx = 0;
        if (this.activeSubscription != null) {
            this.activeSubscription.cancel();
            this.activeSubscription = null;
        }
    }

    @Override
    public void register(List<Node<RowT>> sources) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Downstream<RowT> requestDownstream(int idx) {
        throw new UnsupportedOperationException();
    }

    private void push() throws Exception {
        if (this.isClosed()) {
            return;
        }
        this.checkState();
        if (this.requested > 0 && !this.inBuff.isEmpty()) {
            this.inLoop = true;
            try {
                while (this.requested > 0 && !this.inBuff.isEmpty()) {
                    this.checkState();
                    RowT row = this.inBuff.poll();
                    if (this.filters != null && !this.filters.test(row)) continue;
                    if (this.rowTransformer != null) {
                        row = this.rowTransformer.apply(row);
                    }
                    --this.requested;
                    this.downstream().push(row);
                }
            }
            finally {
                this.inLoop = false;
            }
        }
        if (this.requested > 0 && (this.waiting == 0 || this.activeSubscription == null)) {
            this.requestNextBatch();
        }
        if (this.requested > 0 && this.waiting == -1) {
            if (this.inBuff.isEmpty()) {
                this.requested = 0;
                this.downstream().end();
            } else {
                this.context().execute(this::push, this::onError);
            }
        }
    }

    private void requestNextBatch() {
        Flow.Subscription subscription;
        if (this.waiting == -1) {
            return;
        }
        if (this.waiting == 0) {
            this.waiting = 512 - this.inBuff.size();
        }
        if ((subscription = this.activeSubscription) != null) {
            subscription.request(this.waiting);
        } else if (this.curPartIdx < this.parts.length) {
            if (this.context().transactionTime() != null) {
                this.physTable.scan(this.parts[this.curPartIdx++], this.context().transactionTime(), this.context().localNode()).subscribe(new SubscriberImpl());
            } else {
                this.physTable.scan(this.parts[this.curPartIdx++], this.context().transaction()).subscribe(new SubscriberImpl());
            }
        } else {
            this.waiting = -1;
        }
    }

    private RowT convert(BinaryRow binRow) {
        return this.schemaTable.toRow(this.context(), binRow, this.factory, this.requiredColumns);
    }

    private class SubscriberImpl
    implements Flow.Subscriber<BinaryRow> {
        private SubscriberImpl() {
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            assert (TableScanNode.this.activeSubscription == null);
            TableScanNode.this.activeSubscription = subscription;
            subscription.request(TableScanNode.this.waiting);
        }

        @Override
        public void onNext(BinaryRow binRow) {
            Object row = TableScanNode.this.convert(binRow);
            TableScanNode.this.inBuff.add(row);
            if (TableScanNode.this.inBuff.size() == 512) {
                TableScanNode.this.context().execute(() -> {
                    TableScanNode.this.waiting = 0;
                    TableScanNode.this.push();
                }, TableScanNode.this::onError);
            }
        }

        @Override
        public void onError(Throwable throwable) {
            TableScanNode.this.context().execute(() -> {
                throw throwable;
            }, TableScanNode.this::onError);
        }

        @Override
        public void onComplete() {
            TableScanNode.this.context().execute(() -> {
                TableScanNode.this.activeSubscription = null;
                TableScanNode.this.waiting = 0;
                TableScanNode.this.push();
            }, TableScanNode.this::onError);
        }
    }
}

