/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.call.configuration;

import jakarta.inject.Singleton;
import org.apache.ignite.internal.cli.call.configuration.NodeConfigUpdateCallInput;
import org.apache.ignite.internal.cli.core.call.Call;
import org.apache.ignite.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite.rest.client.api.NodeConfigurationApi;
import org.apache.ignite.rest.client.invoker.ApiException;
import org.apache.ignite.rest.client.invoker.Configuration;

@Singleton
public class NodeConfigUpdateCall
implements Call<NodeConfigUpdateCallInput, String> {
    @Override
    public DefaultCallOutput<String> execute(NodeConfigUpdateCallInput input) {
        NodeConfigurationApi client = this.createApiClient(input);
        try {
            return this.updateNodeConfig(client, input);
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, input.getNodeUrl()));
        }
    }

    private DefaultCallOutput<String> updateNodeConfig(NodeConfigurationApi api, NodeConfigUpdateCallInput input) throws ApiException {
        api.updateNodeConfiguration(input.getConfig());
        return DefaultCallOutput.success("Node configuration was updated successfully");
    }

    private NodeConfigurationApi createApiClient(NodeConfigUpdateCallInput input) {
        return new NodeConfigurationApi(Configuration.getDefaultApiClient().setBasePath(input.getNodeUrl()));
    }
}

