/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.sql;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.client.ReliableChannel;
import org.apache.ignite.internal.client.sql.ClientSession;
import org.apache.ignite.sql.Session;
import org.jetbrains.annotations.Nullable;

public class ClientSessionBuilder
implements Session.SessionBuilder {
    private final ReliableChannel ch;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private String defaultSchema;
    private Long defaultQueryTimeoutMs;
    private Long defaultSessionTimeoutMs;
    private Integer pageSize;

    public ClientSessionBuilder(ReliableChannel ch) {
        this.ch = ch;
    }

    public long defaultQueryTimeout(TimeUnit timeUnit) {
        Objects.requireNonNull(timeUnit);
        return timeUnit.convert(this.defaultQueryTimeoutMs == null ? 0L : this.defaultQueryTimeoutMs, TimeUnit.MILLISECONDS);
    }

    public Session.SessionBuilder defaultQueryTimeout(long timeout, TimeUnit timeUnit) {
        Objects.requireNonNull(timeUnit);
        this.defaultQueryTimeoutMs = TimeUnit.MILLISECONDS.convert(timeout, timeUnit);
        return this;
    }

    public long idleTimeout(TimeUnit timeUnit) {
        Objects.requireNonNull(timeUnit);
        return timeUnit.convert(this.defaultSessionTimeoutMs == null ? 0L : this.defaultSessionTimeoutMs, TimeUnit.MILLISECONDS);
    }

    public Session.SessionBuilder idleTimeout(long timeout, TimeUnit timeUnit) {
        Objects.requireNonNull(timeUnit);
        this.defaultSessionTimeoutMs = timeUnit.toMillis(timeout);
        return this;
    }

    public String defaultSchema() {
        return this.defaultSchema;
    }

    public Session.SessionBuilder defaultSchema(String schema) {
        this.defaultSchema = schema;
        return this;
    }

    public int defaultPageSize() {
        return this.pageSize == null ? 0 : this.pageSize;
    }

    public Session.SessionBuilder defaultPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Nullable
    public Object property(String name) {
        return this.properties.get(name);
    }

    public Session.SessionBuilder property(String name, @Nullable Object value) {
        this.properties.put(name, value);
        return this;
    }

    public Session build() {
        return new ClientSession(this.ch, this.pageSize, this.defaultSchema, this.defaultQueryTimeoutMs, this.defaultSessionTimeoutMs, new HashMap<String, Object>(this.properties));
    }
}

