/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import com.google.common.base.Objects;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.selection.SelectionColumnMapping;
import org.apache.cassandra.cql3.selection.Selector;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.transport.ProtocolVersion;

final class FieldSelector
extends Selector {
    protected static final Selector.SelectorDeserializer deserializer = new Selector.SelectorDeserializer(){

        @Override
        protected Selector deserialize(DataInputPlus in, int version, TableMetadata metadata) throws IOException {
            UserType type = (UserType)this.readType(metadata, in);
            int field = (int)in.readUnsignedVInt();
            Selector selected = Selector.serializer.deserialize(in, version, metadata);
            return new FieldSelector(type, field, selected);
        }
    };
    private final UserType type;
    private final int field;
    private final Selector selected;

    public static Selector.Factory newFactory(final UserType type, final int field, final Selector.Factory factory) {
        return new Selector.Factory(){

            @Override
            protected String getColumnName() {
                return String.format("%s.%s", factory.getColumnName(), type.fieldName(field));
            }

            @Override
            protected AbstractType<?> getReturnType() {
                return type.fieldType(field);
            }

            @Override
            protected void addColumnMapping(SelectionColumnMapping mapping, ColumnSpecification resultsColumn) {
                factory.addColumnMapping(mapping, resultsColumn);
            }

            @Override
            public Selector newInstance(QueryOptions options) throws InvalidRequestException {
                return new FieldSelector(type, field, factory.newInstance(options));
            }

            @Override
            public boolean isAggregateSelectorFactory() {
                return factory.isAggregateSelectorFactory();
            }

            @Override
            public boolean areAllFetchedColumnsKnown() {
                return factory.areAllFetchedColumnsKnown();
            }

            @Override
            public void addFetchedColumns(ColumnFilter.Builder builder) {
                factory.addFetchedColumns(builder);
            }
        };
    }

    @Override
    public void addFetchedColumns(ColumnFilter.Builder builder) {
        this.selected.addFetchedColumns(builder);
    }

    @Override
    public void addInput(ProtocolVersion protocolVersion, Selector.InputRow input) {
        this.selected.addInput(protocolVersion, input);
    }

    @Override
    public ByteBuffer getOutput(ProtocolVersion protocolVersion) {
        ByteBuffer value = this.selected.getOutput(protocolVersion);
        if (value == null) {
            return null;
        }
        ByteBuffer[] buffers = this.type.split(value);
        return this.field < buffers.length ? buffers[this.field] : null;
    }

    @Override
    public AbstractType<?> getType() {
        return this.type.fieldType(this.field);
    }

    @Override
    public void reset() {
        this.selected.reset();
    }

    @Override
    public boolean isTerminal() {
        return this.selected.isTerminal();
    }

    public String toString() {
        return String.format("%s.%s", this.selected, this.type.fieldName(this.field));
    }

    private FieldSelector(UserType type, int field, Selector selected) {
        super(Selector.Kind.FIELD_SELECTOR);
        this.type = type;
        this.field = field;
        this.selected = selected;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldSelector)) {
            return false;
        }
        FieldSelector s = (FieldSelector)o;
        return Objects.equal((Object)this.type, (Object)s.type) && Objects.equal((Object)this.field, (Object)s.field) && Objects.equal((Object)this.selected, (Object)s.selected);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.field, this.selected});
    }

    @Override
    protected int serializedSize(int version) {
        return FieldSelector.sizeOf(this.type) + TypeSizes.sizeofUnsignedVInt(this.field) + serializer.serializedSize(this.selected, version);
    }

    @Override
    protected void serialize(DataOutputPlus out, int version) throws IOException {
        FieldSelector.writeType(out, this.type);
        out.writeUnsignedVInt(this.field);
        serializer.serialize(this.selected, out, version);
    }
}

