/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.store.zk;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.zookeeper.data.Stat;

public class ZNode {
    public static final Stat ZERO_STAT = new Stat();
    final String _zkPath;
    private Stat _stat;
    Object _data;
    Set<String> _childSet;

    public ZNode(String zkPath, Object data, Stat stat) {
        this._zkPath = zkPath;
        this._childSet = Collections.emptySet();
        this._data = data;
        this._stat = stat;
    }

    public void removeChild(String child) {
        if (this._childSet != Collections.emptySet()) {
            this._childSet.remove(child);
        }
    }

    public void addChild(String child) {
        if (this._childSet == Collections.emptySet()) {
            this._childSet = new HashSet<String>();
        }
        this._childSet.add(child);
    }

    public void addChildren(List<String> children) {
        if (children != null && !children.isEmpty()) {
            if (this._childSet == Collections.emptySet()) {
                this._childSet = new HashSet<String>();
            }
            this._childSet.addAll(children);
        }
    }

    public boolean hasChild(String child) {
        return this._childSet.contains(child);
    }

    public Set<String> getChildSet() {
        return this._childSet;
    }

    public void setData(Object data) {
        this._data = data;
    }

    public Object getData() {
        return this._data;
    }

    public void setStat(Stat stat) {
        this._stat = stat;
    }

    public Stat getStat() {
        return this._stat;
    }

    public void setChildSet(List<String> childNames) {
        if (childNames != null && !childNames.isEmpty()) {
            if (this._childSet == Collections.emptySet()) {
                this._childSet = new HashSet<String>();
            }
            this._childSet.clear();
            this._childSet.addAll(childNames);
        }
    }

    public String toString() {
        return this._zkPath + ", " + this._data + ", " + this._childSet + ", " + this._stat;
    }
}

