/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.spark.example.rdd;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.spark.HBaseContext;
import org.apache.hadoop.hbase.spark.HBaseContext$;
import org.apache.hadoop.hbase.spark.HBaseRDDFunctions$;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.yetus.audience.InterfaceAudience;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@InterfaceAudience.Private
public final class HBaseMapPartitionExample$ {
    public static HBaseMapPartitionExample$ MODULE$;

    static {
        new HBaseMapPartitionExample$();
    }

    public void main(String[] args) {
        if (args.length < 1) {
            Predef$.MODULE$.println((Object)"HBaseMapPartitionExample {tableName} is missing an argument");
            return;
        }
        String tableName = args[0];
        SparkConf sparkConf = new SparkConf().setAppName(new StringBuilder(25).append("HBaseMapPartitionExample ").append(tableName).toString());
        SparkContext sc = new SparkContext(sparkConf);
        try {
            RDD rdd = sc.parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{Bytes.toBytes((String)"1"), Bytes.toBytes((String)"2"), Bytes.toBytes((String)"3"), Bytes.toBytes((String)"4"), Bytes.toBytes((String)"5"), Bytes.toBytes((String)"6"), Bytes.toBytes((String)"7")}), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
            Configuration conf = HBaseConfiguration.create();
            HBaseContext hbaseContext = new HBaseContext(sc, conf, HBaseContext$.MODULE$.$lessinit$greater$default$3());
            RDD getRdd = HBaseRDDFunctions$.MODULE$.GenericHBaseRDDFunctions(rdd).hbaseMapPartitions(hbaseContext, (Function2 & Serializable & scala.Serializable)(it, connection) -> {
                Table table = connection.getTable(TableName.valueOf((String)tableName));
                return it.map((Function1 & Serializable & scala.Serializable)r -> {
                    Result result = table.get(new Get(r));
                    Iterator it = result.listCells().iterator();
                    scala.collection.mutable.StringBuilder b = new scala.collection.mutable.StringBuilder();
                    b.append(new StringBuilder(1).append(Bytes.toString((byte[])result.getRow())).append(":").toString());
                    while (it.hasNext()) {
                        Cell cell = (Cell)it.next();
                        String q = Bytes.toString((byte[])cell.getQualifierArray());
                        scala.collection.mutable.StringBuilder stringBuilder = q.equals("counter") ? b.append(new StringBuilder(3).append("(").append(q).append(",").append(Bytes.toLong((byte[])cell.getValueArray())).append(")").toString()) : b.append(new StringBuilder(3).append("(").append(q).append(",").append(Bytes.toString((byte[])cell.getValueArray())).append(")").toString());
                    }
                    return b.toString();
                });
            }, ClassTag$.MODULE$.apply(String.class));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])getRdd.collect())).foreach((Function1 & Serializable & scala.Serializable)v -> {
                Predef$.MODULE$.println((Object)v);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            sc.stop();
        }
    }

    private HBaseMapPartitionExample$() {
        MODULE$ = this;
    }
}

