/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.spark.datasources;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.hbase.spark.AvroSerdes$;
import org.apache.hadoop.hbase.spark.datasources.Field;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.yetus.audience.InterfaceAudience;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@InterfaceAudience.Private
public final class Utils$ {
    public static Utils$ MODULE$;

    static {
        new Utils$();
    }

    public Object hbaseFieldToScalaType(Field f, byte[] src, int offset, int length) {
        Object object;
        if (f.exeSchema().isDefined()) {
            GenericRecord m = AvroSerdes$.MODULE$.deserialize(src, (Schema)f.exeSchema().get());
            Option n = f.avroToCatalyst().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.apply((Object)m));
            object = n.get();
        } else {
            Object object2;
            DataType dataType = f.dt();
            if (BooleanType$.MODULE$.equals(dataType)) {
                object2 = BoxesRunTime.boxToBoolean((src[offset] != 0 ? 1 : 0) != 0);
            } else if (ByteType$.MODULE$.equals(dataType)) {
                object2 = BoxesRunTime.boxToByte((byte)src[offset]);
            } else if (ShortType$.MODULE$.equals(dataType)) {
                object2 = BoxesRunTime.boxToShort((short)Bytes.toShort((byte[])src, (int)offset));
            } else if (IntegerType$.MODULE$.equals(dataType)) {
                object2 = BoxesRunTime.boxToInteger((int)Bytes.toInt((byte[])src, (int)offset));
            } else if (LongType$.MODULE$.equals(dataType)) {
                object2 = BoxesRunTime.boxToLong((long)Bytes.toLong((byte[])src, (int)offset));
            } else if (FloatType$.MODULE$.equals(dataType)) {
                object2 = BoxesRunTime.boxToFloat((float)Bytes.toFloat((byte[])src, (int)offset));
            } else if (DoubleType$.MODULE$.equals(dataType)) {
                object2 = BoxesRunTime.boxToDouble((double)Bytes.toDouble((byte[])src, (int)offset));
            } else if (DateType$.MODULE$.equals(dataType)) {
                object2 = new Date(Bytes.toLong((byte[])src, (int)offset));
            } else if (TimestampType$.MODULE$.equals(dataType)) {
                object2 = new Timestamp(Bytes.toLong((byte[])src, (int)offset));
            } else if (StringType$.MODULE$.equals(dataType)) {
                object2 = Bytes.toString((byte[])src, (int)offset, (int)length);
            } else if (BinaryType$.MODULE$.equals(dataType)) {
                byte[] newArray = new byte[length];
                System.arraycopy(src, offset, newArray, 0, length);
                object2 = newArray;
            } else {
                throw new Exception(new StringBuilder(22).append("unsupported data type ").append(f.dt()).toString());
            }
            object = object2;
        }
        return object;
    }

    public byte[] toBytes(Object input, Field field) {
        byte[] byArray;
        if (field.schema().isDefined()) {
            Object record = field.catalystToAvro().apply(input);
            byArray = AvroSerdes$.MODULE$.serialize(record, (Schema)field.schema().get());
        } else {
            byte[] byArray2;
            DataType dataType = field.dt();
            if (BooleanType$.MODULE$.equals(dataType)) {
                byArray2 = Bytes.toBytes((boolean)BoxesRunTime.unboxToBoolean((Object)input));
            } else if (ByteType$.MODULE$.equals(dataType)) {
                byArray2 = new byte[]{((Number)input).byteValue()};
            } else if (ShortType$.MODULE$.equals(dataType)) {
                byArray2 = Bytes.toBytes((short)((Number)input).shortValue());
            } else if (IntegerType$.MODULE$.equals(dataType)) {
                byArray2 = Bytes.toBytes((int)((Number)input).intValue());
            } else if (LongType$.MODULE$.equals(dataType)) {
                byArray2 = Bytes.toBytes((long)((Number)input).longValue());
            } else if (FloatType$.MODULE$.equals(dataType)) {
                byArray2 = Bytes.toBytes((float)((Number)input).floatValue());
            } else if (DoubleType$.MODULE$.equals(dataType)) {
                byArray2 = Bytes.toBytes((double)((Number)input).doubleValue());
            } else {
                boolean bl = DateType$.MODULE$.equals(dataType) ? true : TimestampType$.MODULE$.equals(dataType);
                if (bl) {
                    byArray2 = Bytes.toBytes((long)((java.util.Date)input).getTime());
                } else if (StringType$.MODULE$.equals(dataType)) {
                    byArray2 = Bytes.toBytes((String)input.toString());
                } else if (BinaryType$.MODULE$.equals(dataType)) {
                    byArray2 = (byte[])input;
                } else {
                    throw new Exception(new StringBuilder(22).append("unsupported data type ").append(field.dt()).toString());
                }
            }
            byArray = byArray2;
        }
        return byArray;
    }

    public byte[] incrementByteArray(byte[] array) {
        if (array.length == 0) {
            return null;
        }
        int index = -1;
        for (int a2 = array.length - 1; a2 >= 0; --a2) {
            if (array[a2] == (byte)-1) continue;
            index = a2;
            a2 = -1;
        }
        if (index < 0) {
            return null;
        }
        byte[] returnArray = new byte[array.length];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), index).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)a -> {
            returnArray$1[a] = array[a];
        });
        returnArray[index] = (byte)(array[index] + 1);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(index + 1), array.length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)a -> {
            returnArray$1[a] = (byte)0;
        });
        return returnArray;
    }

    private Utils$() {
        MODULE$ = this;
    }
}

