/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.kafka;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.kafka.DropRule;
import org.apache.hadoop.hbase.kafka.Rule;
import org.apache.hadoop.hbase.kafka.TopicRule;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@InterfaceAudience.Private
public class TopicRoutingRules {
    private List<DropRule> dropRules = new ArrayList<DropRule>();
    private List<TopicRule> routeRules = new ArrayList<TopicRule>();
    private File sourceFile;

    public TopicRoutingRules() {
    }

    public TopicRoutingRules(File source) throws Exception {
        this.sourceFile = source;
        this.reloadIfFile();
    }

    public void reloadIfFile() throws Exception {
        if (this.sourceFile != null) {
            List<DropRule> dropRulesSave = this.dropRules;
            List<TopicRule> routeRulesSave = this.routeRules;
            try (FileInputStream fin = new FileInputStream(this.sourceFile);){
                ArrayList<DropRule> dropRulesNew = new ArrayList<DropRule>();
                ArrayList<TopicRule> routeRulesNew = new ArrayList<TopicRule>();
                this.parseRules(fin, dropRulesNew, routeRulesNew);
                this.dropRules = dropRulesNew;
                this.routeRules = routeRulesNew;
            }
            catch (Exception e) {
                this.dropRules = dropRulesSave;
                this.routeRules = routeRulesSave;
                throw e;
            }
        }
    }

    public void parseRules(InputStream input) {
        ArrayList<DropRule> dropRulesNew = new ArrayList<DropRule>();
        ArrayList<TopicRule> routeRulesNew = new ArrayList<TopicRule>();
        this.parseRules(input, dropRulesNew, routeRulesNew);
        this.dropRules = dropRulesNew;
        this.routeRules = routeRulesNew;
    }

    public void parseRules(InputStream input, List<DropRule> dropRules, List<TopicRule> routeRules) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(input);
            NodeList nodList = doc.getElementsByTagName("rule");
            for (int i = 0; i < nodList.getLength(); ++i) {
                if (!(nodList.item(i) instanceof Element)) continue;
                this.parseRule((Element)nodList.item(i), dropRules, routeRules);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void parseRule(Element n, List<DropRule> dropRules, List<TopicRule> routeRules) {
        Rule r = null;
        if (n.getAttribute("action").equals("drop")) {
            r = new DropRule();
            dropRules.add((DropRule)r);
        } else {
            r = new TopicRule(n.getAttribute("topic"));
            routeRules.add((TopicRule)r);
        }
        if (n.hasAttribute("table")) {
            r.setTableName(TableName.valueOf((String)n.getAttribute("table")));
        }
        if (n.hasAttribute("columnFamily")) {
            r.setColumnFamily(Bytes.toBytes((String)n.getAttribute("columnFamily")));
        }
        if (n.hasAttribute("qualifier")) {
            String qual = n.getAttribute("qualifier");
            r.setQualifier(Bytes.toBytes((String)qual));
        }
    }

    public boolean isExclude(TableName table, byte[] columnFamily, byte[] qualifer) {
        for (DropRule r : this.getDropRules()) {
            if (!r.match(table, columnFamily, qualifer)) continue;
            return true;
        }
        return false;
    }

    public List<String> getTopics(TableName table, byte[] columnFamily, byte[] qualifer) {
        ArrayList<String> ret = new ArrayList<String>();
        for (TopicRule r : this.getRouteRules()) {
            if (!r.match(table, columnFamily, qualifer)) continue;
            ret.addAll(r.getTopics());
        }
        return ret;
    }

    public List<DropRule> getDropRules() {
        return this.dropRules;
    }

    public List<TopicRule> getRouteRules() {
        return this.routeRules;
    }
}

