/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.HFileInfo;
import org.apache.hadoop.hbase.regionserver.DataTieringException;
import org.apache.hadoop.hbase.regionserver.DataTieringType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DataTieringManager {
    private static final Logger LOG = LoggerFactory.getLogger(DataTieringManager.class);
    public static final String GLOBAL_DATA_TIERING_ENABLED_KEY = "hbase.regionserver.datatiering.enable";
    public static final boolean DEFAULT_GLOBAL_DATA_TIERING_ENABLED = false;
    public static final String DATATIERING_KEY = "hbase.hstore.datatiering.type";
    public static final String DATATIERING_HOT_DATA_AGE_KEY = "hbase.hstore.datatiering.hot.age.millis";
    public static final DataTieringType DEFAULT_DATATIERING = DataTieringType.NONE;
    public static final long DEFAULT_DATATIERING_HOT_DATA_AGE = 604800000L;
    private static DataTieringManager instance;
    private final Map<String, HRegion> onlineRegions;

    private DataTieringManager(Map<String, HRegion> onlineRegions) {
        this.onlineRegions = onlineRegions;
    }

    public static synchronized boolean instantiate(Configuration conf, Map<String, HRegion> onlineRegions) {
        if (DataTieringManager.isDataTieringFeatureEnabled(conf) && instance == null) {
            instance = new DataTieringManager(onlineRegions);
            LOG.info("DataTieringManager instantiated successfully.");
            return true;
        }
        LOG.warn("DataTieringManager is already instantiated.");
        return false;
    }

    public static synchronized DataTieringManager getInstance() {
        return instance;
    }

    public boolean isDataTieringEnabled(BlockCacheKey key) throws DataTieringException {
        Path hFilePath = key.getFilePath();
        if (hFilePath == null) {
            throw new DataTieringException("BlockCacheKey Doesn't Contain HFile Path");
        }
        return this.isDataTieringEnabled(hFilePath);
    }

    public boolean isDataTieringEnabled(Path hFilePath) throws DataTieringException {
        Configuration configuration = this.getConfiguration(hFilePath);
        DataTieringType dataTieringType = this.getDataTieringType(configuration);
        return !dataTieringType.equals((Object)DataTieringType.NONE);
    }

    public boolean isHotData(BlockCacheKey key) throws DataTieringException {
        Path hFilePath = key.getFilePath();
        if (hFilePath == null) {
            throw new DataTieringException("BlockCacheKey Doesn't Contain HFile Path");
        }
        return this.isHotData(hFilePath);
    }

    public boolean isHotData(long maxTimestamp, Configuration conf) {
        DataTieringType dataTieringType = this.getDataTieringType(conf);
        if (!dataTieringType.equals((Object)DataTieringType.NONE) && maxTimestamp != -1L) {
            return this.hotDataValidator(maxTimestamp, this.getDataTieringHotDataAge(conf));
        }
        return true;
    }

    public boolean isHotData(Path hFilePath) throws DataTieringException {
        Configuration configuration = this.getConfiguration(hFilePath);
        DataTieringType dataTieringType = this.getDataTieringType(configuration);
        if (!dataTieringType.equals((Object)DataTieringType.NONE)) {
            HStoreFile hStoreFile = this.getHStoreFile(hFilePath);
            if (hStoreFile == null) {
                throw new DataTieringException("Store file corresponding to " + hFilePath + " doesn't exist");
            }
            return this.hotDataValidator(dataTieringType.getInstance().getTimestamp(this.getHStoreFile(hFilePath)), this.getDataTieringHotDataAge(configuration));
        }
        return true;
    }

    public boolean isHotData(HFileInfo hFileInfo, Configuration configuration) {
        DataTieringType dataTieringType = this.getDataTieringType(configuration);
        if (hFileInfo != null && !dataTieringType.equals((Object)DataTieringType.NONE)) {
            return this.hotDataValidator(dataTieringType.getInstance().getTimestamp(hFileInfo), this.getDataTieringHotDataAge(configuration));
        }
        return true;
    }

    private boolean hotDataValidator(long maxTimestamp, long hotDataAge) {
        long currentTimestamp = this.getCurrentTimestamp();
        long diff = currentTimestamp - maxTimestamp;
        return diff <= hotDataAge;
    }

    private long getCurrentTimestamp() {
        return EnvironmentEdgeManager.getDelegate().currentTime();
    }

    public Set<String> getColdDataFiles(Set<BlockCacheKey> allCachedBlocks) throws DataTieringException {
        HashSet<String> coldHFiles = new HashSet<String>();
        for (BlockCacheKey key : allCachedBlocks) {
            if (coldHFiles.contains(key.getHfileName()) || this.isHotData(key)) continue;
            coldHFiles.add(key.getHfileName());
        }
        return coldHFiles;
    }

    private HRegion getHRegion(Path hFilePath) throws DataTieringException {
        String regionId;
        try {
            regionId = HRegionFileSystem.getRegionId(hFilePath);
        }
        catch (IOException e) {
            throw new DataTieringException(e.getMessage());
        }
        HRegion hRegion = this.onlineRegions.get(regionId);
        if (hRegion == null) {
            throw new DataTieringException("HRegion corresponding to " + hFilePath + " doesn't exist");
        }
        return hRegion;
    }

    private HStore getHStore(Path hFilePath) throws DataTieringException {
        String columnFamily;
        HRegion hRegion = this.getHRegion(hFilePath);
        HStore hStore = hRegion.getStore(Bytes.toBytes((String)(columnFamily = hFilePath.getParent().getName())));
        if (hStore == null) {
            throw new DataTieringException("HStore corresponding to " + hFilePath + " doesn't exist");
        }
        return hStore;
    }

    private HStoreFile getHStoreFile(Path hFilePath) throws DataTieringException {
        HStore hStore = this.getHStore(hFilePath);
        for (HStoreFile file : hStore.getStorefiles()) {
            if (!file.getPath().toUri().getPath().toString().equals(hFilePath.toString())) continue;
            return file;
        }
        return null;
    }

    private Configuration getConfiguration(Path hFilePath) throws DataTieringException {
        HStore hStore = this.getHStore(hFilePath);
        return hStore.getReadOnlyConfiguration();
    }

    private DataTieringType getDataTieringType(Configuration conf) {
        return DataTieringType.valueOf(conf.get(DATATIERING_KEY, DEFAULT_DATATIERING.name()));
    }

    private long getDataTieringHotDataAge(Configuration conf) {
        return Long.parseLong(conf.get(DATATIERING_HOT_DATA_AGE_KEY, String.valueOf(604800000L)));
    }

    public Map<String, String> getColdFilesList() {
        HashMap<String, String> coldFiles = new HashMap<String, String>();
        for (HRegion r : this.onlineRegions.values()) {
            for (HStore hStore : r.getStores()) {
                Configuration conf = hStore.getReadOnlyConfiguration();
                DataTieringType dataTieringType = this.getDataTieringType(conf);
                if (dataTieringType == DataTieringType.NONE) continue;
                Long hotDataAge = this.getDataTieringHotDataAge(conf);
                for (HStoreFile hStoreFile : hStore.getStorefiles()) {
                    String hFileName = hStoreFile.getFileInfo().getHFileInfo().getHFileContext().getHFileName();
                    long maxTimeStamp = dataTieringType.getInstance().getTimestamp(hStoreFile);
                    LOG.debug("Max TS for file {} is {}", (Object)hFileName, (Object)new Date(maxTimeStamp));
                    long currentTimestamp = EnvironmentEdgeManager.getDelegate().currentTime();
                    long fileAge = currentTimestamp - maxTimeStamp;
                    if (fileAge <= hotDataAge) continue;
                    coldFiles.put(hFileName, null);
                }
            }
        }
        return coldFiles;
    }

    private static boolean isDataTieringFeatureEnabled(Configuration conf) {
        return conf.getBoolean(GLOBAL_DATA_TIERING_ENABLED_KEY, false);
    }

    public static void resetForTestingOnly() {
        instance = null;
    }
}

