/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.SnapshotProcedure;
import org.apache.hadoop.hbase.master.procedure.TestSnapshotProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestSnapshotProcedureMasterRestarts
extends TestSnapshotProcedure {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSnapshotProcedureMasterRestarts.class);

    @Test
    public void testMasterRestarts() throws Exception {
        ProcedureExecutor procExec = this.master.getMasterProcedureExecutor();
        MasterProcedureEnv env = (MasterProcedureEnv)procExec.getEnvironment();
        SnapshotProcedure sp = new SnapshotProcedure(env, this.snapshotProto);
        SnapshotProcedure spySp = this.getDelayedOnSpecificStateSnapshotProcedure(sp, (MasterProcedureEnv)procExec.getEnvironment(), MasterProcedureProtos.SnapshotState.SNAPSHOT_SNAPSHOT_ONLINE_REGIONS);
        long procId = procExec.submitProcedure((Procedure)spySp);
        TEST_UTIL.waitFor(2000L, () -> env.getMasterServices().getProcedures().stream().map(Procedure::getProcId).collect(Collectors.toList()).contains(procId));
        TEST_UTIL.getHBaseCluster().killMaster(this.master.getServerName());
        TEST_UTIL.getHBaseCluster().waitForMasterToStop(this.master.getServerName(), 30000L);
        TEST_UTIL.getHBaseCluster().startMaster();
        TEST_UTIL.getHBaseCluster().waitForActiveAndReadyMaster();
        this.master = TEST_UTIL.getHBaseCluster().getMaster();
        Assert.assertTrue((boolean)this.master.getSnapshotManager().isTakingAnySnapshot());
        Assert.assertTrue((boolean)this.master.getSnapshotManager().isTableTakingAnySnapshot(this.TABLE_NAME));
        List unfinishedProcedures = this.master.getMasterProcedureExecutor().getProcedures().stream().filter(p -> p instanceof SnapshotProcedure).filter(p -> !p.isFinished()).map(p -> (SnapshotProcedure)p).collect(Collectors.toList());
        Assert.assertEquals((long)unfinishedProcedures.size(), (long)1L);
        long newProcId = ((SnapshotProcedure)unfinishedProcedures.get(0)).getProcId();
        Assert.assertEquals((long)procId, (long)newProcId);
        ProcedureTestingUtility.waitProcedure((ProcedureExecutor)this.master.getMasterProcedureExecutor(), (long)newProcId);
        Assert.assertFalse((boolean)this.master.getSnapshotManager().isTableTakingAnySnapshot(this.TABLE_NAME));
        List snapshots = this.master.getSnapshotManager().getCompletedSnapshots();
        Assert.assertEquals((long)1L, (long)snapshots.size());
        Assert.assertEquals((Object)this.SNAPSHOT_NAME, (Object)((SnapshotProtos.SnapshotDescription)snapshots.get(0)).getName());
        Assert.assertEquals((Object)this.TABLE_NAME, (Object)TableName.valueOf((String)((SnapshotProtos.SnapshotDescription)snapshots.get(0)).getTable()));
        SnapshotTestingUtils.confirmSnapshotValid(TEST_UTIL, this.snapshotProto, this.TABLE_NAME, this.CF);
    }
}

