/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.ByteBuffInputStream;
import org.apache.hadoop.hbase.io.TagCompressionContext;
import org.apache.hadoop.hbase.io.compress.ByteBuffDecompressor;
import org.apache.hadoop.hbase.io.compress.CanReinit;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.crypto.Cipher;
import org.apache.hadoop.hbase.io.crypto.Decryptor;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDecodingContext;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.util.BlockIOUtils;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.shaded.org.apache.commons.io.IOUtils;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class HFileBlockDefaultDecodingContext
implements HFileBlockDecodingContext {
    private final Configuration conf;
    private final HFileContext fileContext;
    private TagCompressionContext tagCompressionContext;

    public HFileBlockDefaultDecodingContext(Configuration conf, HFileContext fileContext) {
        this.conf = conf;
        this.fileContext = fileContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepareDecoding(int onDiskSizeWithoutHeader, int uncompressedSizeWithoutHeader, ByteBuff blockBufferWithoutHeader, ByteBuff onDiskBlock) throws IOException {
        block24: {
            if (this.canDecompressViaByteBuff(blockBufferWithoutHeader, onDiskBlock)) {
                this.decompressViaByteBuff(blockBufferWithoutHeader, onDiskBlock, onDiskSizeWithoutHeader);
                return;
            }
            ByteBuffInputStream byteBuffInputStream = new ByteBuffInputStream(onDiskBlock);
            InputStream dataInputStream = new DataInputStream(byteBuffInputStream);
            try {
                Compression.Algorithm compression;
                Encryption.Context cryptoContext = this.fileContext.getEncryptionContext();
                if (cryptoContext != Encryption.Context.NONE) {
                    Cipher cipher = cryptoContext.getCipher();
                    Decryptor decryptor = cipher.getDecryptor();
                    decryptor.setKey(cryptoContext.getKey());
                    int ivLength = ((InputStream)dataInputStream).read();
                    if (ivLength > 0) {
                        byte[] iv = new byte[ivLength];
                        IOUtils.readFully(dataInputStream, iv);
                        decryptor.setIv(iv);
                        decryptor.reset();
                        dataInputStream = decryptor.createDecryptionStream(dataInputStream);
                    }
                    onDiskSizeWithoutHeader -= 1 + ivLength;
                }
                if ((compression = this.fileContext.getCompression()) != Compression.Algorithm.NONE) {
                    Decompressor decompressor = null;
                    try {
                        decompressor = compression.getDecompressor();
                        if (decompressor instanceof CanReinit) {
                            ((CanReinit)((Object)decompressor)).reinit(this.conf);
                        }
                        try (InputStream is = compression.createDecompressionStream(dataInputStream, decompressor, 0);){
                            BlockIOUtils.readFullyWithHeapBuffer(is, blockBufferWithoutHeader, uncompressedSizeWithoutHeader);
                            break block24;
                        }
                    }
                    finally {
                        if (decompressor != null) {
                            compression.returnDecompressor(decompressor);
                        }
                    }
                }
                BlockIOUtils.readFullyWithHeapBuffer(dataInputStream, blockBufferWithoutHeader, onDiskSizeWithoutHeader);
            }
            finally {
                byteBuffInputStream.close();
                ((InputStream)dataInputStream).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decompressViaByteBuff(ByteBuff blockBufferWithoutHeader, ByteBuff onDiskBlock, int onDiskSizeWithoutHeader) throws IOException {
        Compression.Algorithm compression = this.fileContext.getCompression();
        ByteBuffDecompressor decompressor = compression.getByteBuffDecompressor();
        try {
            decompressor.reinit(this.fileContext.getDecompressionContext());
            decompressor.decompress(blockBufferWithoutHeader, onDiskBlock, onDiskSizeWithoutHeader);
        }
        finally {
            compression.returnByteBuffDecompressor(decompressor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canDecompressViaByteBuff(ByteBuff blockBufferWithoutHeader, ByteBuff onDiskBlock) {
        if (this.fileContext.getEncryptionContext() != Encryption.Context.NONE) {
            return false;
        }
        if (!this.fileContext.getCompression().supportsByteBuffDecompression()) {
            return false;
        }
        ByteBuffDecompressor decompressor = this.fileContext.getCompression().getByteBuffDecompressor();
        try {
            decompressor.reinit(this.fileContext.getDecompressionContext());
            boolean bl = decompressor.canDecompress(blockBufferWithoutHeader, onDiskBlock);
            return bl;
        }
        finally {
            this.fileContext.getCompression().returnByteBuffDecompressor(decompressor);
        }
    }

    @Override
    public HFileContext getHFileContext() {
        return this.fileContext;
    }

    public TagCompressionContext getTagCompressionContext() {
        return this.tagCompressionContext;
    }

    public void setTagCompressionContext(TagCompressionContext tagCompressionContext) {
        this.tagCompressionContext = tagCompressionContext;
    }
}

