/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import org.apache.hadoop.hbase.util.MD5Hash;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class MobFileName {
    private final String date;
    private final String startKey;
    private final String uuid;
    private final String fileName;
    private final String regionName;
    private static final int STARTKEY_END_INDEX = 32;
    private static final int DATE_END_INDEX = 40;
    private static final int UUID_END_INDEX = 72;
    public static final String REGION_SEP = "_";

    private MobFileName(byte[] startKey, String date, String uuid, String regionName) {
        this.startKey = MD5Hash.getMD5AsHex(startKey, 0, startKey.length);
        this.uuid = uuid;
        this.date = date;
        this.regionName = regionName;
        this.fileName = this.startKey + this.date + this.uuid + REGION_SEP + this.regionName;
    }

    private MobFileName(String startKey, String date, String uuid, String regionName) {
        this.startKey = startKey;
        this.uuid = uuid;
        this.date = date;
        this.regionName = regionName;
        this.fileName = this.startKey + this.date + this.uuid + REGION_SEP + this.regionName;
    }

    public static MobFileName create(byte[] startKey, String date, String uuid, String regionName) {
        return new MobFileName(startKey, date, uuid, regionName);
    }

    public static MobFileName create(String startKey, String date, String uuid, String regionName) {
        return new MobFileName(startKey, date, uuid, regionName);
    }

    public static MobFileName create(String fileName) {
        String startKey = fileName.substring(0, 32);
        String date = fileName.substring(32, 40);
        String uuid = fileName.substring(40, 72);
        String regionName = fileName.substring(73);
        return new MobFileName(startKey, date, uuid, regionName);
    }

    public static boolean isOldMobFileName(String name) {
        return name.indexOf(REGION_SEP) < 0;
    }

    public static String getStartKeyFromName(String fileName) {
        return fileName.substring(0, 32);
    }

    public static String getDateFromName(String fileName) {
        return fileName.substring(32, 40);
    }

    public String getStartKey() {
        return this.startKey;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public String getDate() {
        return this.date;
    }

    public int hashCode() {
        return this.fileName.hashCode();
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof MobFileName) {
            MobFileName another = (MobFileName)anObject;
            return this.getFileName().equals(another.getFileName());
        }
        return false;
    }

    public String getFileName() {
        return this.fileName;
    }
}

