/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.replication;

import java.io.IOException;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.PeerProcedureInterface;
import org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public abstract class AbstractPeerProcedure<TState>
extends StateMachineProcedure<MasterProcedureEnv, TState>
implements PeerProcedureInterface {
    protected String peerId;
    protected ProcedurePrepareLatch latch;

    protected AbstractPeerProcedure() {
    }

    protected AbstractPeerProcedure(String peerId) {
        this.peerId = peerId;
        this.latch = ProcedurePrepareLatch.createLatch(2, 0);
    }

    public ProcedurePrepareLatch getLatch() {
        return this.latch;
    }

    @Override
    public String getPeerId() {
        return this.peerId;
    }

    @Override
    protected boolean waitInitialized(MasterProcedureEnv env) {
        return env.waitInitialized(this);
    }

    @Override
    protected Procedure.LockState acquireLock(MasterProcedureEnv env) {
        if (env.getProcedureScheduler().waitPeerExclusiveLock(this, this.peerId)) {
            return Procedure.LockState.LOCK_EVENT_WAIT;
        }
        return Procedure.LockState.LOCK_ACQUIRED;
    }

    @Override
    protected void releaseLock(MasterProcedureEnv env) {
        env.getProcedureScheduler().wakePeerExclusiveLock(this, this.peerId);
    }

    @Override
    protected boolean holdLock(MasterProcedureEnv env) {
        return true;
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        serializer.serialize(MasterProcedureProtos.PeerProcedureStateData.newBuilder().setPeerId(this.peerId).build());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        this.peerId = serializer.deserialize(MasterProcedureProtos.PeerProcedureStateData.class).getPeerId();
    }

    protected final void checkPeerModificationEnabled(MasterProcedureEnv env) throws IOException {
        if (!env.getMasterServices().isReplicationPeerModificationEnabled()) {
            throw new IOException("Replication peer modification disabled");
        }
    }
}

