/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.master.MasterStateStore;
import org.apache.hadoop.hbase.master.region.MasterRegion;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
@SuppressWarnings(value={"UG_SYNC_SET_UNSYNC_GET"}, justification="the flag is volatile")
public abstract class BooleanStateStore
extends MasterStateStore {
    private volatile boolean on;

    protected BooleanStateStore(MasterRegion masterRegion, String stateName, ZKWatcher watcher, String zkPath) throws IOException, KeeperException, DeserializationException {
        super(masterRegion, stateName, watcher, zkPath);
        byte[] state = this.getState();
        this.on = state == null || this.parseFrom(state);
    }

    public boolean get() {
        return this.on;
    }

    public synchronized boolean set(boolean on) throws IOException {
        byte[] state = this.toByteArray(on);
        this.setState(state);
        boolean prevOn = this.on;
        this.on = on;
        return prevOn;
    }

    protected abstract byte[] toByteArray(boolean var1);

    protected abstract boolean parseFrom(byte[] var1) throws DeserializationException;
}

