/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.federation;

import java.io.StringWriter;
import javax.xml.bind.JAXBException;
import org.apache.hadoop.shaded.com.sun.jersey.api.json.JSONConfiguration;
import org.apache.hadoop.shaded.com.sun.jersey.api.json.JSONJAXBContext;
import org.apache.hadoop.shaded.com.sun.jersey.api.json.JSONMarshaller;
import org.apache.hadoop.yarn.server.federation.store.FederationStateStore;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterHeartbeatRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterState;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ClusterMetricsInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FederationStateStoreHeartbeat
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(FederationStateStoreHeartbeat.class);
    private SubClusterId subClusterId;
    private FederationStateStore stateStoreService;
    private final ResourceScheduler rs;
    private StringWriter currentClusterState;
    private JSONJAXBContext jc;
    private JSONMarshaller marshaller;
    private String capability;

    public FederationStateStoreHeartbeat(SubClusterId subClusterId, FederationStateStore stateStoreClient, ResourceScheduler scheduler) {
        this.stateStoreService = stateStoreClient;
        this.subClusterId = subClusterId;
        this.rs = scheduler;
        this.currentClusterState = new StringWriter();
        try {
            this.jc = new JSONJAXBContext(JSONConfiguration.mapped().rootUnwrapping(false).build(), ClusterMetricsInfo.class);
            this.marshaller = this.jc.createJSONMarshaller();
        }
        catch (JAXBException e) {
            LOG.warn("Exception while trying to initialize JAXB context.", (Throwable)e);
        }
        LOG.info("Initialized Federation membership for cluster with timestamp:  " + ResourceManager.getClusterTimeStamp());
    }

    private void updateClusterState() {
        try {
            this.currentClusterState.getBuffer().setLength(0);
            ClusterMetricsInfo clusterMetricsInfo = new ClusterMetricsInfo(this.rs);
            this.marshaller.marshallToJSON((Object)clusterMetricsInfo, this.currentClusterState);
            this.capability = this.currentClusterState.toString();
        }
        catch (Exception e) {
            LOG.warn("Exception while trying to generate cluster state, so reverting to last know state.", (Throwable)e);
        }
    }

    @Override
    public synchronized void run() {
        try {
            this.updateClusterState();
            SubClusterHeartbeatRequest request = SubClusterHeartbeatRequest.newInstance(this.subClusterId, SubClusterState.SC_RUNNING, this.capability);
            this.stateStoreService.subClusterHeartbeat(request);
            LOG.debug("Sending the heartbeat with capability: {}", (Object)this.capability);
        }
        catch (Exception e) {
            LOG.warn("Exception when trying to heartbeat: ", (Throwable)e);
        }
    }
}

