/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.ipc.CallerContext;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Resource;

public class RMAuditLogger {
    private static final Log LOG = LogFactory.getLog(RMAuditLogger.class);

    static String createSuccessLog(String user, String operation, String target, ApplicationId appId, ApplicationAttemptId attemptId, ContainerId containerId, Resource resource) {
        return RMAuditLogger.createSuccessLog(user, operation, target, appId, attemptId, containerId, resource, null, Server.getRemoteIp(), null, null);
    }

    private static StringBuilder createStringBuilderForSuccessEvent(String user, String operation, String target, InetAddress ip) {
        StringBuilder b = new StringBuilder();
        RMAuditLogger.start(Keys.USER, user, b);
        if (ip != null) {
            RMAuditLogger.add(Keys.IP, ip.getHostAddress(), b);
        }
        RMAuditLogger.add(Keys.OPERATION, operation, b);
        RMAuditLogger.add(Keys.TARGET, target, b);
        RMAuditLogger.add(Keys.RESULT, "SUCCESS", b);
        return b;
    }

    static String createSuccessLog(String user, String operation, String target, ApplicationId appId, ApplicationAttemptId attemptId, ContainerId containerId, Resource resource, CallerContext callerContext, InetAddress ip, String queueName, String partition) {
        StringBuilder b = RMAuditLogger.createStringBuilderForSuccessEvent(user, operation, target, ip);
        if (appId != null) {
            RMAuditLogger.add(Keys.APPID, appId.toString(), b);
        }
        if (attemptId != null) {
            RMAuditLogger.add(Keys.APPATTEMPTID, attemptId.toString(), b);
        }
        if (containerId != null) {
            RMAuditLogger.add(Keys.CONTAINERID, containerId.toString(), b);
        }
        if (resource != null) {
            RMAuditLogger.add(Keys.RESOURCE, resource.toString(), b);
        }
        RMAuditLogger.appendCallerContext(b, callerContext);
        if (queueName != null) {
            RMAuditLogger.add(Keys.QUEUENAME, queueName, b);
        }
        if (partition != null) {
            RMAuditLogger.add(Keys.NODELABEL, partition, b);
        }
        return b.toString();
    }

    private static void appendCallerContext(StringBuilder sb, CallerContext callerContext) {
        String context = null;
        byte[] signature = null;
        if (callerContext != null) {
            context = callerContext.getContext();
            signature = callerContext.getSignature();
        }
        if (context != null) {
            RMAuditLogger.add(Keys.CALLERCONTEXT, context, sb);
        }
        if (signature != null) {
            try {
                String sigStr = new String(signature, "UTF-8");
                RMAuditLogger.add(Keys.CALLERSIGNATURE, sigStr, sb);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    static String createSuccessLog(String user, String operation, String target, InetAddress ip, ArgsBuilder args) {
        StringBuilder b = RMAuditLogger.createStringBuilderForSuccessEvent(user, operation, target, ip);
        if (args != null) {
            RMAuditLogger.add(args, b);
        }
        return b.toString();
    }

    public static void logSuccess(String user, String operation, String target, ApplicationId appId, ContainerId containerId, Resource resource) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)RMAuditLogger.createSuccessLog(user, operation, target, appId, null, containerId, resource));
        }
    }

    public static void logSuccess(String user, String operation, String target, ApplicationId appId, ContainerId containerId, Resource resource, String queueName, String partition) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)RMAuditLogger.createSuccessLog(user, operation, target, appId, null, containerId, resource, null, Server.getRemoteIp(), queueName, partition));
        }
    }

    public static void logSuccess(String user, String operation, String target, ArgsBuilder args) {
        RMAuditLogger.logSuccess(user, operation, target, Server.getRemoteIp(), args);
    }

    public static void logSuccess(String user, String operation, String target, InetAddress ip, ArgsBuilder args) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)RMAuditLogger.createSuccessLog(user, operation, target, ip, args));
        }
    }

    public static void logSuccess(String user, String operation, String target, ApplicationId appId, CallerContext callerContext, String queueName, String partition) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)RMAuditLogger.createSuccessLog(user, operation, target, appId, null, null, null, callerContext, Server.getRemoteIp(), queueName, partition));
        }
    }

    public static void logSuccess(String user, String operation, String target, ApplicationId appId, ApplicationAttemptId attemptId) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)RMAuditLogger.createSuccessLog(user, operation, target, appId, attemptId, null, null));
        }
    }

    public static void logSuccess(String user, String operation, String target, ApplicationId appId, CallerContext callerContext) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)RMAuditLogger.createSuccessLog(user, operation, target, appId, null, null, null, callerContext, Server.getRemoteIp(), null, null));
        }
    }

    public static void logSuccess(String user, String operation, String target, ApplicationId appId, CallerContext callerContext, String queueName) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)RMAuditLogger.createSuccessLog(user, operation, target, appId, null, null, null, callerContext, Server.getRemoteIp(), queueName, null));
        }
    }

    public static void logSuccess(String user, String operation, String target, ApplicationId appId, InetAddress ip) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)RMAuditLogger.createSuccessLog(user, operation, target, appId, null, null, null, null, ip, null, null));
        }
    }

    public static void logSuccess(String user, String operation, String target, ApplicationId appId) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)RMAuditLogger.createSuccessLog(user, operation, target, appId, null, null, null));
        }
    }

    public static void logSuccess(String user, String operation, String target) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)RMAuditLogger.createSuccessLog(user, operation, target, null, null, null, null));
        }
    }

    private static StringBuilder createStringBuilderForFailureLog(String user, String operation, String target, String description, String perm) {
        StringBuilder b = new StringBuilder();
        RMAuditLogger.start(Keys.USER, user, b);
        RMAuditLogger.addRemoteIP(b);
        RMAuditLogger.add(Keys.OPERATION, operation, b);
        RMAuditLogger.add(Keys.TARGET, target, b);
        RMAuditLogger.add(Keys.RESULT, "FAILURE", b);
        RMAuditLogger.add(Keys.DESCRIPTION, description, b);
        RMAuditLogger.add(Keys.PERMISSIONS, perm, b);
        return b;
    }

    static String createFailureLog(String user, String operation, String perm, String target, String description, ApplicationId appId, ApplicationAttemptId attemptId, ContainerId containerId, Resource resource, CallerContext callerContext, String queueName, String partition) {
        StringBuilder b = RMAuditLogger.createStringBuilderForFailureLog(user, operation, target, description, perm);
        if (appId != null) {
            RMAuditLogger.add(Keys.APPID, appId.toString(), b);
        }
        if (attemptId != null) {
            RMAuditLogger.add(Keys.APPATTEMPTID, attemptId.toString(), b);
        }
        if (containerId != null) {
            RMAuditLogger.add(Keys.CONTAINERID, containerId.toString(), b);
        }
        if (resource != null) {
            RMAuditLogger.add(Keys.RESOURCE, resource.toString(), b);
        }
        RMAuditLogger.appendCallerContext(b, callerContext);
        if (queueName != null) {
            RMAuditLogger.add(Keys.QUEUENAME, queueName, b);
        }
        if (partition != null) {
            RMAuditLogger.add(Keys.NODELABEL, partition, b);
        }
        return b.toString();
    }

    static String createFailureLog(String user, String operation, String perm, String target, String description, ApplicationId appId, ApplicationAttemptId attemptId, ContainerId containerId, Resource resource) {
        return RMAuditLogger.createFailureLog(user, operation, perm, target, description, appId, attemptId, containerId, resource, null, null, null);
    }

    static String createFailureLog(String user, String operation, String perm, String target, String description, ArgsBuilder args) {
        StringBuilder b = RMAuditLogger.createStringBuilderForFailureLog(user, operation, target, description, perm);
        if (args != null) {
            RMAuditLogger.add(args, b);
        }
        return b.toString();
    }

    public static void logFailure(String user, String operation, String perm, String target, String description, ApplicationId appId, ContainerId containerId, Resource resource) {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)RMAuditLogger.createFailureLog(user, operation, perm, target, description, appId, null, containerId, resource));
        }
    }

    public static void logFailure(String user, String operation, String perm, String target, String description, ApplicationId appId, ApplicationAttemptId attemptId) {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)RMAuditLogger.createFailureLog(user, operation, perm, target, description, appId, attemptId, null, null));
        }
    }

    public static void logFailure(String user, String operation, String perm, String target, String description, ApplicationId appId, CallerContext callerContext) {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)RMAuditLogger.createFailureLog(user, operation, perm, target, description, appId, null, null, null, callerContext, null, null));
        }
    }

    public static void logFailure(String user, String operation, String perm, String target, String description, ApplicationId appId, CallerContext callerContext, String queueName) {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)RMAuditLogger.createFailureLog(user, operation, perm, target, description, appId, null, null, null, callerContext, queueName, null));
        }
    }

    public static void logFailure(String user, String operation, String perm, String target, String description, ApplicationId appId) {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)RMAuditLogger.createFailureLog(user, operation, perm, target, description, appId, null, null, null));
        }
    }

    public static void logFailure(String user, String operation, String perm, String target, String description, ApplicationId appId, String queueName) {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)RMAuditLogger.createFailureLog(user, operation, perm, target, description, appId, null, null, null, null, queueName, null));
        }
    }

    public static void logFailure(String user, String operation, String perm, String target, String description) {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)RMAuditLogger.createFailureLog(user, operation, perm, target, description, null, null, null, null));
        }
    }

    public static void logFailure(String user, String operation, String perm, String target, String description, ArgsBuilder args) {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)RMAuditLogger.createFailureLog(user, operation, perm, target, description, args));
        }
    }

    public static void logFailure(String user, String operation, String perm, String target, String description, ApplicationId appId, CallerContext callerContext, String queueName, String partition) {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)RMAuditLogger.createFailureLog(user, operation, perm, target, description, appId, null, null, null, callerContext, queueName, partition));
        }
    }

    static void addRemoteIP(StringBuilder b) {
        InetAddress ip = Server.getRemoteIp();
        if (ip != null) {
            RMAuditLogger.add(Keys.IP, ip.getHostAddress(), b);
        }
    }

    static void start(Keys key, String value, StringBuilder b) {
        b.append(key.name()).append("=").append(value);
    }

    static void add(Keys key, String value, StringBuilder b) {
        b.append('\t').append(key.name()).append("=").append(value);
    }

    static void add(ArgsBuilder args, StringBuilder b) {
        b.append('\t').append((CharSequence)args.getArgs());
    }

    public static class ArgsBuilder {
        private StringBuilder b = new StringBuilder();

        public ArgsBuilder append(Keys key, String value) {
            if (this.b.length() != 0) {
                this.b.append('\t');
            }
            this.b.append(key.name()).append("=").append(value);
            return this;
        }

        public StringBuilder getArgs() {
            return this.b;
        }
    }

    public static class AuditConstants {
        static final String SUCCESS = "SUCCESS";
        static final String FAILURE = "FAILURE";
        static final String KEY_VAL_SEPARATOR = "=";
        static final char PAIR_SEPARATOR = '\t';
        public static final String FAIL_ATTEMPT_REQUEST = "Fail Attempt Request";
        public static final String KILL_APP_REQUEST = "Kill Application Request";
        public static final String SUBMIT_APP_REQUEST = "Submit Application Request";
        public static final String MOVE_APP_REQUEST = "Move Application Request";
        public static final String GET_APP_STATE = "Get Application State";
        public static final String GET_APP_PRIORITY = "Get Application Priority";
        public static final String GET_APP_QUEUE = "Get Application Queue";
        public static final String GET_APP_ATTEMPTS = "Get Application Attempts";
        public static final String GET_APP_ATTEMPT_REPORT = "Get Application Attempt Report";
        public static final String GET_CONTAINERS = "Get Containers";
        public static final String GET_CONTAINER_REPORT = "Get Container Report";
        public static final String GET_QUEUE_INFO_REQUEST = "Get Queue Info Request";
        public static final String GET_APPLICATIONS_REQUEST = "Get Applications Request";
        public static final String FINISH_SUCCESS_APP = "Application Finished - Succeeded";
        public static final String FINISH_FAILED_APP = "Application Finished - Failed";
        public static final String FINISH_KILLED_APP = "Application Finished - Killed";
        public static final String REGISTER_AM = "Register App Master";
        public static final String AM_ALLOCATE = "App Master Heartbeats";
        public static final String UNREGISTER_AM = "Unregister App Master";
        public static final String ALLOC_CONTAINER = "AM Allocated Container";
        public static final String RELEASE_CONTAINER = "AM Released Container";
        public static final String UPDATE_APP_PRIORITY = "Update Application Priority";
        public static final String UPDATE_APP_TIMEOUTS = "Update Application Timeouts";
        public static final String GET_APP_TIMEOUTS = "Get Application Timeouts";
        public static final String CHANGE_CONTAINER_RESOURCE = "AM Changed Container Resource";
        public static final String SIGNAL_CONTAINER = "Signal Container Request";
        public static final String UNAUTHORIZED_USER = "Unauthorized user";
        public static final String CREATE_NEW_RESERVATION_REQUEST = "Create Reservation Request";
        public static final String SUBMIT_RESERVATION_REQUEST = "Submit Reservation Request";
        public static final String UPDATE_RESERVATION_REQUEST = "Update Reservation Request";
        public static final String DELETE_RESERVATION_REQUEST = "Delete Reservation Request";
        public static final String LIST_RESERVATION_REQUEST = "List Reservation Request";
    }

    static enum Keys {
        USER,
        OPERATION,
        TARGET,
        RESULT,
        IP,
        PERMISSIONS,
        DESCRIPTION,
        APPID,
        APPATTEMPTID,
        CONTAINERID,
        CALLERCONTEXT,
        CALLERSIGNATURE,
        RESOURCE,
        QUEUENAME,
        INCLUDEAPPS,
        INCLUDECHILDQUEUES,
        RECURSIVE,
        NODELABEL;

    }
}

