/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies.router;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.policies.FederationPolicyInitializationContext;
import org.apache.hadoop.yarn.server.federation.policies.FederationPolicyInitializationContextValidator;
import org.apache.hadoop.yarn.server.federation.policies.FederationPolicyUtils;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyInitializationException;
import org.apache.hadoop.yarn.server.federation.policies.router.AbstractRouterPolicy;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;

public class UniformRandomRouterPolicy
extends AbstractRouterPolicy {
    private Random rand = new Random(System.currentTimeMillis());

    @Override
    public void reinitialize(FederationPolicyInitializationContext policyContext) throws FederationPolicyInitializationException {
        FederationPolicyInitializationContextValidator.validate(policyContext, this.getClass().getCanonicalName());
        this.setPolicyContext(policyContext);
    }

    @Override
    public SubClusterId getHomeSubcluster(ApplicationSubmissionContext appSubmissionContext, List<SubClusterId> blackListSubClusters) throws YarnException {
        this.validate(appSubmissionContext);
        Map<SubClusterId, SubClusterInfo> activeSubclusters = this.getActiveSubclusters();
        ArrayList<SubClusterId> list = new ArrayList<SubClusterId>(activeSubclusters.keySet());
        FederationPolicyUtils.validateSubClusterAvailability(list, blackListSubClusters);
        if (blackListSubClusters != null) {
            for (SubClusterId scId : blackListSubClusters) {
                list.remove(scId);
            }
        }
        return (SubClusterId)list.get(this.rand.nextInt(list.size()));
    }
}

