/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink;

import java.util.Calendar;
import org.apache.commons.configuration.SubsetConfiguration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.metrics2.MetricsException;
import org.apache.hadoop.metrics2.impl.ConfigBuilder;
import org.apache.hadoop.metrics2.sink.RollingFileSystemSink;
import org.junit.Assert;
import org.junit.Test;

public class TestRollingFileSystemSink {
    @Test
    public void testInit() {
        ConfigBuilder builder = new ConfigBuilder();
        SubsetConfiguration conf = builder.add("sink.roll-interval", "10m").add("sink.roll-offset-interval-millis", "1").add("sink.basepath", "path").add("sink.ignore-error", "true").add("sink.allow-append", "true").add("sink.source", "src").subset("sink");
        RollingFileSystemSink sink = new RollingFileSystemSink();
        sink.init(conf);
        Assert.assertEquals((String)"The roll interval was not set correctly", (long)sink.rollIntervalMillis, (long)600000L);
        Assert.assertEquals((String)"The roll offset interval was not set correctly", (long)sink.rollOffsetIntervalMillis, (long)1L);
        Assert.assertEquals((String)"The base path was not set correctly", (Object)sink.basePath, (Object)new Path("path"));
        Assert.assertEquals((String)"ignore-error was not set correctly", (Object)sink.ignoreError, (Object)true);
        Assert.assertEquals((String)"allow-append was not set correctly", (Object)sink.allowAppend, (Object)true);
        Assert.assertEquals((String)"The source was not set correctly", (Object)sink.source, (Object)"src");
    }

    @Test
    public void testSetInitialFlushTime() {
        RollingFileSystemSink rfsSink = new RollingFileSystemSink(1000L, 0L);
        Calendar calendar = Calendar.getInstance();
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(10, 0);
        calendar.set(6, 1);
        calendar.set(1, 2016);
        Assert.assertNull((String)"Last flush time should have been null prior to calling init()", (Object)rfsSink.nextFlush);
        rfsSink.setInitialFlushTime(calendar.getTime());
        long diff = rfsSink.nextFlush.getTimeInMillis() - calendar.getTimeInMillis();
        Assert.assertEquals((String)"The initial flush time was calculated incorrectly", (long)0L, (long)diff);
        calendar.set(14, 10);
        rfsSink.setInitialFlushTime(calendar.getTime());
        diff = rfsSink.nextFlush.getTimeInMillis() - calendar.getTimeInMillis();
        Assert.assertEquals((String)"The initial flush time was calculated incorrectly", (long)-10L, (long)diff);
        calendar.set(13, 1);
        calendar.set(14, 10);
        rfsSink.setInitialFlushTime(calendar.getTime());
        diff = rfsSink.nextFlush.getTimeInMillis() - calendar.getTimeInMillis();
        Assert.assertEquals((String)"The initial flush time was calculated incorrectly", (long)-10L, (long)diff);
        rfsSink = new RollingFileSystemSink(1000L, 100L);
        Assert.assertNull((String)"Last flush time should have been null prior to calling init()", (Object)rfsSink.nextFlush);
        calendar.set(14, 0);
        calendar.set(13, 0);
        rfsSink.setInitialFlushTime(calendar.getTime());
        diff = rfsSink.nextFlush.getTimeInMillis() - calendar.getTimeInMillis();
        Assert.assertTrue((String)("The initial flush time was calculated incorrectly: " + diff), (diff == 0L || diff > -1000L && diff < -900L ? 1 : 0) != 0);
        calendar.set(14, 10);
        rfsSink.setInitialFlushTime(calendar.getTime());
        diff = rfsSink.nextFlush.getTimeInMillis() - calendar.getTimeInMillis();
        Assert.assertTrue((String)("The initial flush time was calculated incorrectly: " + diff), (diff >= -10L && diff <= 0L || diff > -1000L && diff < -910L ? 1 : 0) != 0);
        calendar.set(13, 1);
        calendar.set(14, 10);
        rfsSink.setInitialFlushTime(calendar.getTime());
        diff = rfsSink.nextFlush.getTimeInMillis() - calendar.getTimeInMillis();
        Assert.assertTrue((String)("The initial flush time was calculated incorrectly: " + diff), (diff >= -10L && diff <= 0L || diff > -1000L && diff < -910L ? 1 : 0) != 0);
        rfsSink = new RollingFileSystemSink(1000L, 1000000L);
        Assert.assertNull((String)"Last flush time should have been null prior to calling init()", (Object)rfsSink.nextFlush);
        calendar.set(14, 1);
        calendar.set(13, 0);
        rfsSink.setInitialFlushTime(calendar.getTime());
        diff = rfsSink.nextFlush.getTimeInMillis() - calendar.getTimeInMillis();
        Assert.assertTrue((String)("The initial flush time was calculated incorrectly: " + diff), (diff > -1000L && diff <= 0L ? 1 : 0) != 0);
    }

    @Test
    public void testUpdateRollTime() {
        RollingFileSystemSink rfsSink = new RollingFileSystemSink(1000L, 0L);
        Calendar calendar = Calendar.getInstance();
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(10, 0);
        calendar.set(6, 1);
        calendar.set(1, 2016);
        rfsSink.nextFlush = Calendar.getInstance();
        rfsSink.nextFlush.setTime(calendar.getTime());
        rfsSink.updateFlushTime(calendar.getTime());
        Assert.assertEquals((String)"The next roll time should have been 1 second in the future", (long)(calendar.getTimeInMillis() + 1000L), (long)rfsSink.nextFlush.getTimeInMillis());
        rfsSink.nextFlush.setTime(calendar.getTime());
        calendar.add(14, 10);
        rfsSink.updateFlushTime(calendar.getTime());
        Assert.assertEquals((String)"The next roll time should have been 990 ms in the future", (long)(calendar.getTimeInMillis() + 990L), (long)rfsSink.nextFlush.getTimeInMillis());
        rfsSink.nextFlush.setTime(calendar.getTime());
        calendar.add(13, 2);
        calendar.add(14, 10);
        rfsSink.updateFlushTime(calendar.getTime());
        Assert.assertEquals((String)"The next roll time should have been 990 ms in the future", (long)(calendar.getTimeInMillis() + 990L), (long)rfsSink.nextFlush.getTimeInMillis());
    }

    @Test
    public void testGetRollInterval() {
        this.doTestGetRollInterval(1, new String[]{"m", "min", "minute", "minutes"}, 60000L);
        this.doTestGetRollInterval(1, new String[]{"h", "hr", "hour", "hours"}, 3600000L);
        this.doTestGetRollInterval(1, new String[]{"d", "day", "days"}, 86400000L);
        ConfigBuilder builder = new ConfigBuilder();
        SubsetConfiguration conf = builder.add("sink.roll-interval", "1").subset("sink");
        RollingFileSystemSink sink = new RollingFileSystemSink();
        sink.init(conf);
        Assert.assertEquals((long)3600000L, (long)sink.getRollInterval());
        for (char c : "abcefgijklnopqrtuvwxyz".toCharArray()) {
            builder = new ConfigBuilder();
            conf = builder.add("sink.roll-interval", "90 " + c).subset("sink");
            try {
                sink.init(conf);
                sink.getRollInterval();
                Assert.fail((String)("Allowed flush interval with bad units: " + c));
            }
            catch (MetricsException metricsException) {
                // empty catch block
            }
        }
    }

    private void doTestGetRollInterval(int num, String[] units, long expected) {
        RollingFileSystemSink sink = new RollingFileSystemSink();
        ConfigBuilder builder = new ConfigBuilder();
        for (String unit : units) {
            sink.init(builder.add("sink.roll-interval", num + unit).subset("sink"));
            Assert.assertEquals((long)expected, (long)sink.getRollInterval());
            sink.init(builder.add("sink.roll-interval", num + unit.toUpperCase()).subset("sink"));
            Assert.assertEquals((long)expected, (long)sink.getRollInterval());
            sink.init(builder.add("sink.roll-interval", num + " " + unit).subset("sink"));
            Assert.assertEquals((long)expected, (long)sink.getRollInterval());
            sink.init(builder.add("sink.roll-interval", num + " " + unit.toUpperCase()).subset("sink"));
            Assert.assertEquals((long)expected, (long)sink.getRollInterval());
        }
    }
}

