/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router.security.token;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.router.security.token.HikariDataSourceConnectionFactory;
import org.apache.hadoop.hdfs.server.federation.router.security.token.SQLConnectionFactory;
import org.apache.hadoop.hdfs.server.federation.router.security.token.SQLDelegationTokenSecretManagerImpl;
import org.apache.hadoop.hdfs.server.federation.router.security.token.SQLSecretManagerRetriableHandler;
import org.apache.hadoop.hdfs.server.federation.router.security.token.SQLSecretManagerRetriableHandlerImpl;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenIdentifier;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenManager;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.Time;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSQLDelegationTokenSecretManagerImpl {
    private static final String CONNECTION_URL = "jdbc:derby:memory:TokenStore";
    private static final int TEST_MAX_RETRIES = 3;
    private static final int TOKEN_EXPIRATION_SECONDS = 1;
    private static final int TOKEN_EXPIRATION_SCAN_SECONDS = 1;
    private static Configuration conf;

    @Before
    public void init() throws SQLException {
        TestSQLDelegationTokenSecretManagerImpl.createTestDBTables();
    }

    @After
    public void cleanup() throws SQLException {
        TestSQLDelegationTokenSecretManagerImpl.dropTestDBTables();
    }

    @BeforeClass
    public static void initDatabase() throws SQLException {
        DriverManager.getConnection("jdbc:derby:memory:TokenStore;create=true");
        conf = new Configuration();
        conf.set("sql-dt-secret-manager.connection.url", CONNECTION_URL);
        conf.set("sql-dt-secret-manager.connection.username", "testuser");
        conf.set("sql-dt-secret-manager.connection.password", "testpassword");
        conf.set("sql-dt-secret-manager.connection.driver", "org.apache.derby.jdbc.EmbeddedDriver");
        conf.setInt("sql-dt-secret-manager.max-retries", 3);
        conf.setInt("sql-dt-secret-manager.retry-sleep-time-ms", 10);
        conf.setInt("delegation-token.removal-scan-interval.sec", 1);
    }

    @AfterClass
    public static void cleanupDatabase() {
        block2: {
            try {
                DriverManager.getConnection("jdbc:derby:memory:TokenStore;drop=true");
            }
            catch (SQLException e) {
                if (e.getMessage().contains("dropped")) break block2;
                throw new RuntimeException(e);
            }
        }
    }

    @Test
    public void testSingleSecretManager() throws Exception {
        DelegationTokenManager tokenManager = this.createTokenManager();
        try {
            Token token = tokenManager.createToken(UserGroupInformation.getCurrentUser(), "foo");
            this.validateToken(tokenManager, (Token<? extends AbstractDelegationTokenIdentifier>)token);
        }
        finally {
            this.stopTokenManager(tokenManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleSecretManagers() throws Exception {
        DelegationTokenManager tokenManager1 = this.createTokenManager();
        DelegationTokenManager tokenManager2 = this.createTokenManager();
        try {
            Token token1 = tokenManager1.createToken(UserGroupInformation.getCurrentUser(), "foo");
            Token token2 = tokenManager2.createToken(UserGroupInformation.getCurrentUser(), "foo");
            this.validateToken(tokenManager1, (Token<? extends AbstractDelegationTokenIdentifier>)token2);
            this.validateToken(tokenManager2, (Token<? extends AbstractDelegationTokenIdentifier>)token1);
        }
        finally {
            this.stopTokenManager(tokenManager1);
            this.stopTokenManager(tokenManager2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelToken() throws Exception {
        DelegationTokenManager tokenManager1 = this.createTokenManager(this.getShortLivedTokenConf());
        DelegationTokenManager tokenManager2 = this.createTokenManager(this.getShortLivedTokenConf());
        TestDelegationTokenSecretManager secretManager2 = (TestDelegationTokenSecretManager)tokenManager2.getDelegationTokenSecretManager();
        try {
            Token token1 = tokenManager1.createToken(UserGroupInformation.getCurrentUser(), "foo");
            tokenManager2.verifyToken(token1);
            tokenManager1.cancelToken(token1, "foo");
            secretManager2.waitForTokenEviction(token1.decodeIdentifier());
            LambdaTestUtils.intercept(SecretManager.InvalidToken.class, () -> tokenManager2.verifyToken(token1));
        }
        finally {
            this.stopTokenManager(tokenManager1);
            this.stopTokenManager(tokenManager2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenewToken() throws Exception {
        DelegationTokenManager tokenManager1 = this.createTokenManager(this.getShortLivedTokenConf());
        DelegationTokenManager tokenManager2 = this.createTokenManager(this.getShortLivedTokenConf());
        TestDelegationTokenSecretManager secretManager2 = (TestDelegationTokenSecretManager)tokenManager2.getDelegationTokenSecretManager();
        try {
            Token token1 = tokenManager1.createToken(UserGroupInformation.getCurrentUser(), "foo");
            long expirationTime = Time.monotonicNow() + TimeUnit.SECONDS.toMillis(1L) * 2L;
            tokenManager2.verifyToken(token1);
            AbstractDelegationTokenIdentifier token1Id = (AbstractDelegationTokenIdentifier)token1.decodeIdentifier();
            while (Time.monotonicNow() < expirationTime) {
                tokenManager1.renewToken(token1, "foo");
                this.callRemoveExpiredTokensAndValidateSQL(secretManager2, token1Id, true);
                secretManager2.waitForTokenEviction((TokenIdentifier)token1Id);
                tokenManager2.verifyToken(token1);
            }
            Thread.sleep(TimeUnit.SECONDS.toMillis(1L) * 2L);
            LambdaTestUtils.intercept(SecretManager.InvalidToken.class, () -> tokenManager2.verifyToken(token1));
            this.callRemoveExpiredTokensAndValidateSQL(secretManager2, token1Id, false);
        }
        finally {
            this.stopTokenManager(tokenManager1);
            this.stopTokenManager(tokenManager2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoveExpiredTokens() throws Exception {
        DelegationTokenManager tokenManager = this.createTokenManager(this.getShortLivedTokenConf());
        try {
            TestDelegationTokenSecretManager secretManager = (TestDelegationTokenSecretManager)tokenManager.getDelegationTokenSecretManager();
            Token token1 = tokenManager.createToken(UserGroupInformation.getCurrentUser(), "foo");
            AbstractDelegationTokenIdentifier tokenId1 = (AbstractDelegationTokenIdentifier)token1.decodeIdentifier();
            long expirationTime2 = Time.now();
            AbstractDelegationTokenIdentifier tokenId2 = this.storeToken(secretManager, 2, expirationTime2);
            long expirationTime3 = Time.now() + TimeUnit.SECONDS.toMillis(1L) * 10L;
            AbstractDelegationTokenIdentifier tokenId3 = this.storeToken(secretManager, 3, expirationTime3);
            GenericTestUtils.waitFor(() -> {
                try {
                    tokenManager.renewToken(token1, "foo");
                    return !this.isTokenInSQL(secretManager, tokenId2);
                }
                catch (IOException | SQLException e) {
                    throw new RuntimeException(e);
                }
            }, (long)100L, (long)6000L);
            Assert.assertTrue((String)"Renewed token must not be cleaned up", (boolean)this.isTokenInSQL(secretManager, tokenId1));
            Assert.assertTrue((String)"Token with future expiration must not be cleaned up", (boolean)this.isTokenInSQL(secretManager, tokenId3));
        }
        finally {
            this.stopTokenManager(tokenManager);
        }
    }

    private AbstractDelegationTokenIdentifier storeToken(TestDelegationTokenSecretManager secretManager, int sequenceNum, long expirationTime) throws IOException {
        DelegationTokenIdentifier tokenId = new DelegationTokenIdentifier(new Text("Test"));
        tokenId.setOwner(new Text("foo"));
        tokenId.setSequenceNumber(sequenceNum);
        AbstractDelegationTokenSecretManager.DelegationTokenInformation tokenInfo = new AbstractDelegationTokenSecretManager.DelegationTokenInformation(expirationTime, null);
        secretManager.storeToken((AbstractDelegationTokenIdentifier)tokenId, tokenInfo);
        return tokenId;
    }

    private Configuration getShortLivedTokenConf() {
        Configuration shortLivedConf = new Configuration(conf);
        shortLivedConf.setTimeDuration("sql-dt-secret-manager.token.loading.cache.expiration", 200L, TimeUnit.MILLISECONDS);
        shortLivedConf.setInt("delegation-token.renew-interval.sec", 1);
        return shortLivedConf;
    }

    private void callRemoveExpiredTokensAndValidateSQL(TestDelegationTokenSecretManager secretManager, AbstractDelegationTokenIdentifier tokenId, boolean expectedInSQL) throws SQLException {
        secretManager.removeExpiredStoredToken((TokenIdentifier)tokenId);
        Assert.assertEquals((Object)expectedInSQL, (Object)this.isTokenInSQL(secretManager, tokenId));
    }

    private boolean isTokenInSQL(TestDelegationTokenSecretManager secretManager, AbstractDelegationTokenIdentifier tokenId) throws SQLException {
        return secretManager.selectTokenInfo(tokenId.getSequenceNumber(), tokenId.getBytes()) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSequenceNumAllocation() throws Exception {
        int tokensPerManager = 50;
        HashSet<Integer> sequenceNums1 = new HashSet<Integer>();
        HashSet<Integer> sequenceNums2 = new HashSet<Integer>();
        HashSet<Integer> sequenceNums3 = new HashSet<Integer>();
        HashSet<Integer> sequenceNums = new HashSet<Integer>();
        DelegationTokenManager tokenManager1 = this.createTokenManager();
        DelegationTokenManager tokenManager2 = this.createTokenManager();
        DelegationTokenManager tokenManager3 = this.createTokenManager();
        try {
            for (int i = 0; i < tokensPerManager; ++i) {
                this.allocateSequenceNum(tokenManager1, sequenceNums1);
                this.allocateSequenceNum(tokenManager2, sequenceNums2);
                this.allocateSequenceNum(tokenManager3, sequenceNums3);
                sequenceNums.addAll(sequenceNums1);
                sequenceNums.addAll(sequenceNums2);
                sequenceNums.addAll(sequenceNums3);
            }
            Assert.assertEquals((String)"Verify that all tokens were created with unique sequence numbers", (long)(tokensPerManager * 3), (long)sequenceNums.size());
            Assert.assertEquals((String)"Verify that tokenManager1 generated unique sequence numbers", (long)tokensPerManager, (long)sequenceNums1.size());
            Assert.assertEquals((String)"Verify that tokenManager2 generated unique sequence number", (long)tokensPerManager, (long)sequenceNums2.size());
            Assert.assertEquals((String)"Verify that tokenManager3 generated unique sequence numbers", (long)tokensPerManager, (long)sequenceNums3.size());
            int batchSize = 10;
            int seqNum = 1;
            while (seqNum < tokensPerManager) {
                int i = 0;
                while (i < batchSize) {
                    Assert.assertTrue((boolean)sequenceNums1.contains(seqNum));
                    ++i;
                    ++seqNum;
                }
                i = 0;
                while (i < batchSize) {
                    Assert.assertTrue((boolean)sequenceNums2.contains(seqNum));
                    ++i;
                    ++seqNum;
                }
                i = 0;
                while (i < batchSize) {
                    Assert.assertTrue((boolean)sequenceNums3.contains(seqNum));
                    ++i;
                    ++seqNum;
                }
            }
            SQLDelegationTokenSecretManagerImpl secretManager = (SQLDelegationTokenSecretManagerImpl)tokenManager1.getDelegationTokenSecretManager();
            Assert.assertEquals((String)"Verify that the counter is set to the highest sequence number", (long)(tokensPerManager * 3), (long)secretManager.getDelegationTokenSeqNum());
        }
        finally {
            this.stopTokenManager(tokenManager1);
            this.stopTokenManager(tokenManager2);
            this.stopTokenManager(tokenManager3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSequenceNumRollover() throws Exception {
        int tokenBatch = 10;
        HashSet<Integer> sequenceNums = new HashSet<Integer>();
        DelegationTokenManager tokenManager = this.createTokenManager();
        try {
            int seqNum;
            SQLDelegationTokenSecretManagerImpl secretManager = (SQLDelegationTokenSecretManagerImpl)tokenManager.getDelegationTokenSecretManager();
            secretManager.setDelegationTokenSeqNum(Integer.MAX_VALUE - tokenBatch);
            for (seqNum = Integer.MAX_VALUE - tokenBatch; seqNum < Integer.MAX_VALUE; ++seqNum) {
                this.allocateSequenceNum(tokenManager, sequenceNums);
                Assert.assertTrue((boolean)sequenceNums.contains(seqNum + 1));
            }
            for (seqNum = 0; seqNum < tokenBatch; ++seqNum) {
                this.allocateSequenceNum(tokenManager, sequenceNums);
                Assert.assertTrue((boolean)sequenceNums.contains(seqNum + 1));
            }
        }
        finally {
            this.stopTokenManager(tokenManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDelegationKeyAllocation() throws Exception {
        DelegationTokenManager tokenManager1 = this.createTokenManager();
        try {
            SQLDelegationTokenSecretManagerImpl secretManager1 = (SQLDelegationTokenSecretManagerImpl)tokenManager1.getDelegationTokenSecretManager();
            ((TestDelegationTokenSecretManager)secretManager1).lockKeyRoll();
            int keyId1 = secretManager1.getCurrentKeyId();
            Token token1 = tokenManager1.createToken(UserGroupInformation.getCurrentUser(), "foo");
            this.validateKeyId((Token<? extends AbstractDelegationTokenIdentifier>)token1, keyId1);
            DelegationTokenManager tokenManager2 = this.createTokenManager();
            try {
                SQLDelegationTokenSecretManagerImpl secretManager2 = (SQLDelegationTokenSecretManagerImpl)tokenManager2.getDelegationTokenSecretManager();
                ((TestDelegationTokenSecretManager)secretManager2).lockKeyRoll();
                int keyId2 = secretManager2.getCurrentKeyId();
                Assert.assertNotEquals((String)"Each secret manager has its own key", (long)keyId1, (long)keyId2);
                Token token2 = tokenManager2.createToken(UserGroupInformation.getCurrentUser(), "foo");
                this.validateKeyId((Token<? extends AbstractDelegationTokenIdentifier>)token2, keyId2);
                token1 = tokenManager1.createToken(UserGroupInformation.getCurrentUser(), "foo");
                this.validateKeyId((Token<? extends AbstractDelegationTokenIdentifier>)token1, keyId1);
                token2 = tokenManager2.createToken(UserGroupInformation.getCurrentUser(), "foo");
                this.validateKeyId((Token<? extends AbstractDelegationTokenIdentifier>)token2, keyId2);
            }
            finally {
                this.stopTokenManager(tokenManager2);
            }
        }
        finally {
            this.stopTokenManager(tokenManager1);
        }
    }

    @Test
    public void testHikariConfigs() {
        HikariDataSourceConnectionFactory factory1 = new HikariDataSourceConnectionFactory(conf);
        int defaultMaximumPoolSize = factory1.getDataSource().getMaximumPoolSize();
        factory1.shutdown();
        Configuration hikariConf = new Configuration(conf);
        hikariConf.setInt("sql-dt-secret-manager.connection.hikari.maximumPoolSize", defaultMaximumPoolSize + 1);
        HikariDataSourceConnectionFactory factory2 = new HikariDataSourceConnectionFactory(hikariConf);
        Assert.assertEquals((long)factory2.getDataSource().getMaximumPoolSize(), (long)(defaultMaximumPoolSize + 1));
        factory2.shutdown();
    }

    @Test
    public void testRetries() throws Exception {
        DelegationTokenManager tokenManager = this.createTokenManager();
        TestDelegationTokenSecretManager secretManager = (TestDelegationTokenSecretManager)tokenManager.getDelegationTokenSecretManager();
        try {
            secretManager.lockKeyRoll();
            TestRetryHandler.resetExecutionAttemptCounter();
            tokenManager.createToken(UserGroupInformation.getCurrentUser(), "foo");
            Assert.assertEquals((long)1L, (long)TestRetryHandler.getExecutionAttempts());
            secretManager.setReadOnly(true);
            TestRetryHandler.resetExecutionAttemptCounter();
            tokenManager.createToken(UserGroupInformation.getCurrentUser(), "foo");
            Assert.assertEquals((long)4L, (long)TestRetryHandler.getExecutionAttempts());
        }
        finally {
            secretManager.setReadOnly(false);
            this.stopTokenManager(tokenManager);
        }
    }

    private DelegationTokenManager createTokenManager() {
        return this.createTokenManager(conf);
    }

    private DelegationTokenManager createTokenManager(Configuration config) {
        DelegationTokenManager tokenManager = new DelegationTokenManager(new Configuration(), null);
        tokenManager.setExternalDelegationTokenSecretManager((AbstractDelegationTokenSecretManager)new TestDelegationTokenSecretManager(config));
        return tokenManager;
    }

    private void allocateSequenceNum(DelegationTokenManager tokenManager, Set<Integer> sequenceNums) throws IOException {
        Token token = tokenManager.createToken(UserGroupInformation.getCurrentUser(), "foo");
        AbstractDelegationTokenIdentifier tokenIdentifier = (AbstractDelegationTokenIdentifier)token.decodeIdentifier();
        Assert.assertFalse((String)"Verify sequence number is unique", (boolean)sequenceNums.contains(tokenIdentifier.getSequenceNumber()));
        sequenceNums.add(tokenIdentifier.getSequenceNumber());
    }

    private void validateToken(DelegationTokenManager tokenManager, Token<? extends AbstractDelegationTokenIdentifier> token) throws Exception {
        SQLDelegationTokenSecretManagerImpl secretManager = (SQLDelegationTokenSecretManagerImpl)tokenManager.getDelegationTokenSecretManager();
        AbstractDelegationTokenIdentifier tokenIdentifier = (AbstractDelegationTokenIdentifier)token.decodeIdentifier();
        tokenManager.verifyToken(token);
        byte[] tokenInfo1 = secretManager.selectTokenInfo(tokenIdentifier.getSequenceNumber(), tokenIdentifier.getBytes());
        Assert.assertNotNull((String)"Verify token exists in database", (Object)tokenInfo1);
        tokenManager.renewToken(token, "foo");
        byte[] tokenInfo2 = secretManager.selectTokenInfo(tokenIdentifier.getSequenceNumber(), tokenIdentifier.getBytes());
        Assert.assertNotNull((String)"Verify token exists in database", (Object)tokenInfo2);
        Assert.assertFalse((String)"Verify token has been updated in database", (boolean)Arrays.equals(tokenInfo1, tokenInfo2));
        tokenManager.cancelToken(token, "foo");
        byte[] tokenInfo3 = secretManager.selectTokenInfo(tokenIdentifier.getSequenceNumber(), tokenIdentifier.getBytes());
        Assert.assertNull((String)"Verify token was removed from database", (Object)tokenInfo3);
    }

    private void validateKeyId(Token<? extends AbstractDelegationTokenIdentifier> token, int expectedKeyiD) throws IOException {
        AbstractDelegationTokenIdentifier tokenIdentifier = (AbstractDelegationTokenIdentifier)token.decodeIdentifier();
        Assert.assertEquals((String)"Verify that keyId is assigned to token", (long)tokenIdentifier.getMasterKeyId(), (long)expectedKeyiD);
    }

    private static Connection getTestDBConnection() {
        try {
            return DriverManager.getConnection(CONNECTION_URL);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void createTestDBTables() throws SQLException {
        TestSQLDelegationTokenSecretManagerImpl.execute("CREATE TABLE Tokens (sequenceNum INT NOT NULL, tokenIdentifier VARCHAR (255) FOR BIT DATA NOT NULL, tokenInfo VARCHAR (255) FOR BIT DATA NOT NULL, modifiedTime TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP, PRIMARY KEY(sequenceNum))");
        TestSQLDelegationTokenSecretManagerImpl.execute("CREATE TABLE DelegationKeys (keyId INT NOT NULL, delegationKey VARCHAR (255) FOR BIT DATA NOT NULL, modifiedTime TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP, PRIMARY KEY(keyId))");
        TestSQLDelegationTokenSecretManagerImpl.execute("CREATE TABLE LastSequenceNum (sequenceNum INT NOT NULL)");
        TestSQLDelegationTokenSecretManagerImpl.execute("INSERT INTO LastSequenceNum VALUES (0)");
        TestSQLDelegationTokenSecretManagerImpl.execute("CREATE TABLE LastDelegationKeyId (keyId INT NOT NULL)");
        TestSQLDelegationTokenSecretManagerImpl.execute("INSERT INTO LastDelegationKeyId VALUES (0)");
    }

    private static void dropTestDBTables() throws SQLException {
        TestSQLDelegationTokenSecretManagerImpl.execute("DROP TABLE Tokens");
        TestSQLDelegationTokenSecretManagerImpl.execute("DROP TABLE DelegationKeys");
        TestSQLDelegationTokenSecretManagerImpl.execute("DROP TABLE LastSequenceNum");
        TestSQLDelegationTokenSecretManagerImpl.execute("DROP TABLE LastDelegationKeyId");
    }

    private static void execute(String statement) throws SQLException {
        try (Connection connection = TestSQLDelegationTokenSecretManagerImpl.getTestDBConnection();){
            connection.createStatement().execute(statement);
        }
    }

    private void stopTokenManager(DelegationTokenManager tokenManager) {
        TestDelegationTokenSecretManager secretManager = (TestDelegationTokenSecretManager)tokenManager.getDelegationTokenSecretManager();
        secretManager.unlockKeyRoll();
        secretManager.stopThreads();
    }

    static class TestRetryHandler
    extends SQLSecretManagerRetriableHandlerImpl {
        private static AtomicInteger executionAttemptCounter = new AtomicInteger();

        TestRetryHandler() {
        }

        static void resetExecutionAttemptCounter() {
            executionAttemptCounter = new AtomicInteger();
        }

        static int getExecutionAttempts() {
            return executionAttemptCounter.get();
        }

        public void execute(SQLSecretManagerRetriableHandler.SQLCommandVoid command) throws SQLException {
            executionAttemptCounter.incrementAndGet();
            super.execute(command);
        }
    }

    static class TestConnectionFactory
    extends HikariDataSourceConnectionFactory {
        private boolean readOnly = false;

        TestConnectionFactory(Configuration conf) {
            super(conf);
        }

        public Connection getConnection() throws SQLException {
            Connection connection = super.getConnection();
            connection.setSchema("APP");
            connection.setReadOnly(this.readOnly);
            return connection;
        }
    }

    static class TestDelegationTokenSecretManager
    extends SQLDelegationTokenSecretManagerImpl {
        private ReentrantLock keyRollLock;

        private synchronized ReentrantLock getKeyRollLock() {
            if (this.keyRollLock == null) {
                this.keyRollLock = new ReentrantLock();
            }
            return this.keyRollLock;
        }

        TestDelegationTokenSecretManager(Configuration conf) {
            super(conf, (SQLConnectionFactory)new TestConnectionFactory(conf), SQLSecretManagerRetriableHandlerImpl.getInstance((Configuration)conf, (SQLSecretManagerRetriableHandlerImpl)new TestRetryHandler()));
        }

        public void lockKeyRoll() {
            this.getKeyRollLock().lock();
        }

        public void unlockKeyRoll() {
            if (this.getKeyRollLock().isHeldByCurrentThread()) {
                this.getKeyRollLock().unlock();
            }
        }

        protected void rollMasterKey() throws IOException {
            try {
                this.lockKeyRoll();
                super.rollMasterKey();
            }
            finally {
                this.unlockKeyRoll();
            }
        }

        public void waitForTokenEviction(TokenIdentifier tokenId) throws InterruptedException, TimeoutException {
            GenericTestUtils.waitFor(() -> !this.currentTokens.containsKey(tokenId), (long)100L, (long)5000L);
        }

        public void removeExpiredStoredToken(TokenIdentifier tokenId) {
            super.removeExpiredStoredToken((AbstractDelegationTokenIdentifier)tokenId);
        }

        public void storeToken(AbstractDelegationTokenIdentifier ident, AbstractDelegationTokenSecretManager.DelegationTokenInformation tokenInfo) throws IOException {
            super.storeToken(ident, tokenInfo);
        }

        public void setReadOnly(boolean readOnly) {
            ((TestConnectionFactory)this.getConnectionFactory()).readOnly = readOnly;
        }
    }
}

