/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.mapreduce.v2.api.records.AMInfo;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptCompletionEvent;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.jobhistory.JobIndexInfo;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartialJob
implements Job {
    private static final Logger LOG = LoggerFactory.getLogger(PartialJob.class);
    private JobIndexInfo jobIndexInfo = null;
    private JobId jobId = null;
    private JobReport jobReport = null;

    public PartialJob(JobIndexInfo jobIndexInfo, JobId jobId) {
        this.jobIndexInfo = jobIndexInfo;
        this.jobId = jobId;
        this.jobReport = (JobReport)RecordFactoryProvider.getRecordFactory(null).newRecordInstance(JobReport.class);
        this.jobReport.setSubmitTime(jobIndexInfo.getSubmitTime());
        this.jobReport.setStartTime(jobIndexInfo.getJobStartTime());
        this.jobReport.setFinishTime(jobIndexInfo.getFinishTime());
        this.jobReport.setJobState(this.getState());
    }

    public JobId getID() {
        return this.jobId;
    }

    public String getName() {
        return this.jobIndexInfo.getJobName();
    }

    public String getQueueName() {
        return this.jobIndexInfo.getQueueName();
    }

    public JobState getState() {
        JobState js = null;
        try {
            js = JobState.valueOf((String)this.jobIndexInfo.getJobStatus());
        }
        catch (Exception e) {
            LOG.warn("Exception while parsing job state. Defaulting to KILLED", (Throwable)e);
            js = JobState.KILLED;
        }
        return js;
    }

    public JobReport getReport() {
        return this.jobReport;
    }

    public float getProgress() {
        return 1.0f;
    }

    public Counters getAllCounters() {
        return null;
    }

    public Map<TaskId, Task> getTasks() {
        return null;
    }

    public Map<TaskId, Task> getTasks(TaskType taskType) {
        return null;
    }

    public Task getTask(TaskId taskID) {
        return null;
    }

    public List<String> getDiagnostics() {
        return null;
    }

    public int getTotalMaps() {
        return this.jobIndexInfo.getNumMaps();
    }

    public int getTotalReduces() {
        return this.jobIndexInfo.getNumReduces();
    }

    public int getCompletedMaps() {
        return this.jobIndexInfo.getNumMaps();
    }

    public int getCompletedReduces() {
        return this.jobIndexInfo.getNumReduces();
    }

    public boolean isUber() {
        return false;
    }

    public TaskAttemptCompletionEvent[] getTaskAttemptCompletionEvents(int fromEventId, int maxEvents) {
        return null;
    }

    public TaskCompletionEvent[] getMapAttemptCompletionEvents(int startIndex, int maxEvents) {
        return null;
    }

    public boolean checkAccess(UserGroupInformation callerUGI, JobACL jobOperation) {
        return true;
    }

    public String getUserName() {
        return this.jobIndexInfo.getUser();
    }

    public Path getConfFile() {
        throw new IllegalStateException("Not implemented yet");
    }

    public Configuration loadConfFile() {
        throw new IllegalStateException("Not implemented yet");
    }

    public Map<JobACL, AccessControlList> getJobACLs() {
        throw new IllegalStateException("Not implemented yet");
    }

    public List<AMInfo> getAMInfos() {
        return null;
    }

    public void setQueueName(String queueName) {
        throw new UnsupportedOperationException("Can't set job's queue name in history");
    }

    public void setJobPriority(Priority priority) {
        throw new UnsupportedOperationException("Can't set job's priority in history");
    }

    public int getFailedMaps() {
        return -1;
    }

    public int getFailedReduces() {
        return -1;
    }

    public int getKilledMaps() {
        return -1;
    }

    public int getKilledReduces() {
        return -1;
    }
}

