/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.server;

import com.linkedin.data.ByteString;
import com.linkedin.r2.message.stream.entitystream.AbortedException;
import com.linkedin.r2.message.stream.entitystream.ReadHandle;
import com.linkedin.r2.message.stream.entitystream.Reader;
import com.linkedin.r2.message.stream.entitystream.WriteHandle;
import com.linkedin.r2.message.stream.entitystream.Writer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;

public class SyncIOHandler
implements Writer,
Reader {
    private final ServletInputStream _is;
    private final ServletOutputStream _os;
    private final int _maxBufferedChunks;
    private final BlockingQueue<Event> _eventQueue;
    private volatile WriteHandle _wh;
    private volatile ReadHandle _rh;
    private boolean _forceExit;
    private boolean _requestReadFinished;
    private boolean _responseWriteFinished;
    private final long _timeout;

    public SyncIOHandler(ServletInputStream is, ServletOutputStream os, int maxBufferedChunks, long timeout) {
        this._is = is;
        this._os = os;
        this._maxBufferedChunks = maxBufferedChunks;
        this._eventQueue = new LinkedBlockingDeque<Event>();
        this._requestReadFinished = false;
        this._responseWriteFinished = false;
        this._forceExit = false;
        this._timeout = timeout;
    }

    @Override
    public void onInit(WriteHandle wh) {
        this._wh = wh;
    }

    @Override
    public void onWritePossible() {
        this._eventQueue.add(Event.WriteRequestPossibleEvent);
    }

    @Override
    public void onAbort(Throwable ex) {
        this._eventQueue.add(new Event(EventType.WriteRequestAborted, ex));
    }

    @Override
    public void onInit(ReadHandle rh) {
        this._rh = rh;
        this._rh.request(this._maxBufferedChunks);
    }

    @Override
    public void onDataAvailable(ByteString data) {
        this._eventQueue.add(new Event(EventType.ResponseDataAvailable, data));
    }

    @Override
    public void onDone() {
        this._eventQueue.add(Event.FullResponseReceivedEvent);
    }

    @Override
    public void onError(Throwable e) {
        this._eventQueue.add(new Event(EventType.ResponseDataError, e));
    }

    public void loop() throws ServletException, IOException {
        long startTime = System.currentTimeMillis();
        byte[] buf = new byte[8192];
        block11: while (this.shouldContinue() && !this._forceExit) {
            Event event;
            try {
                long timeSpent = System.currentTimeMillis() - startTime;
                long maxWaitTime = timeSpent < this._timeout ? this._timeout - timeSpent : 0L;
                event = this._eventQueue.poll(maxWaitTime, TimeUnit.MILLISECONDS);
                if (event == null) {
                    throw new TimeoutException("Timeout after " + this._timeout + " milliseconds.");
                }
            }
            catch (Exception ex) {
                throw new ServletException((Throwable)ex);
            }
            switch (event.getEventType()) {
                case ResponseDataAvailable: {
                    ByteString data = (ByteString)event.getData();
                    data.write((OutputStream)this._os);
                    this._rh.request(1);
                    continue block11;
                }
                case WriteRequestPossible: {
                    while (this._wh.remaining() > 0) {
                        int actualLen = this._is.read(buf);
                        if (actualLen < 0) {
                            this._wh.done();
                            this._requestReadFinished = true;
                            continue block11;
                        }
                        this._wh.write(ByteString.copy((byte[])buf, (int)0, (int)actualLen));
                    }
                    continue block11;
                }
                case FullResponseReceived: {
                    this._os.close();
                    this._responseWriteFinished = true;
                    continue block11;
                }
                case ResponseDataError: {
                    this._os.close();
                    this._responseWriteFinished = true;
                    continue block11;
                }
                case WriteRequestAborted: {
                    if (event.getData() instanceof AbortedException) {
                        this._eventQueue.add(Event.DrainRequestEvent);
                        continue block11;
                    }
                    throw new ServletException((Throwable)event.getData());
                }
                case DrainRequest: {
                    for (int i = 0; i < 10; ++i) {
                        int actualLen = this._is.read(buf);
                        if (actualLen >= 0) continue;
                        this._requestReadFinished = true;
                        break;
                    }
                    if (this._requestReadFinished) continue block11;
                    this._eventQueue.add(Event.DrainRequestEvent);
                    continue block11;
                }
                case ForceExit: {
                    this._forceExit = true;
                    continue block11;
                }
            }
            throw new IllegalStateException("Unknown event type:" + (Object)((Object)event.getEventType()));
        }
    }

    protected boolean shouldContinue() {
        return !this._responseWriteFinished || !this._requestReadFinished;
    }

    protected boolean responseWriteFinished() {
        return this._responseWriteFinished;
    }

    protected boolean requestReadFinished() {
        return this._requestReadFinished;
    }

    protected void exitLoop() {
        this._eventQueue.add(Event.ForceExitEvent);
    }

    private static class Event {
        private final EventType _eventType;
        private final Object _data;
        static final Event WriteRequestPossibleEvent = new Event(EventType.WriteRequestPossible);
        static final Event FullResponseReceivedEvent = new Event(EventType.FullResponseReceived);
        static final Event DrainRequestEvent = new Event(EventType.DrainRequest);
        static final Event ForceExitEvent = new Event(EventType.ForceExit);

        Event(EventType eventType) {
            this(eventType, null);
        }

        Event(EventType eventType, Object data) {
            this._eventType = eventType;
            this._data = data;
        }

        EventType getEventType() {
            return this._eventType;
        }

        Object getData() {
            return this._data;
        }
    }

    private static enum EventType {
        WriteRequestPossible,
        WriteRequestAborted,
        DrainRequest,
        FullResponseReceived,
        ResponseDataAvailable,
        ResponseDataError,
        ForceExit;

    }
}

