/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.common.bridge.server;

import com.linkedin.r2.transport.common.RestRequestHandler;
import com.linkedin.r2.transport.common.StreamRequestHandler;
import com.linkedin.r2.transport.common.StreamRequestHandlerAdapter;
import com.linkedin.r2.transport.common.bridge.server.TransportDispatcher;
import com.linkedin.r2.transport.common.bridge.server.TransportDispatcherImpl;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class TransportDispatcherBuilder {
    private final Map<URI, StreamRequestHandler> _streamHandlers;
    private final Map<URI, RestRequestHandler> _restHandlers;
    private final Map<URI, StreamRequestHandler> _adaptedHandlers;
    private final boolean _restOverStream;

    public TransportDispatcherBuilder() {
        this(true);
    }

    public TransportDispatcherBuilder(boolean restOverStream) {
        this(new HashMap<URI, RestRequestHandler>(), new HashMap<URI, StreamRequestHandler>(), restOverStream);
    }

    public TransportDispatcherBuilder(Map<URI, RestRequestHandler> restHandlers, Map<URI, StreamRequestHandler> streamHandlers, boolean restOverStream) {
        this._restHandlers = new HashMap<URI, RestRequestHandler>(restHandlers);
        this._streamHandlers = new HashMap<URI, StreamRequestHandler>(streamHandlers);
        this._adaptedHandlers = new HashMap<URI, StreamRequestHandler>();
        this._restOverStream = restOverStream;
    }

    public TransportDispatcherBuilder addRestHandler(URI uri, RestRequestHandler handler) {
        this._restHandlers.put(uri, handler);
        if (this._restOverStream) {
            this._adaptedHandlers.put(uri, new StreamRequestHandlerAdapter(handler));
        }
        return this;
    }

    public RestRequestHandler removeRestHandler(URI uri) {
        RestRequestHandler handler = this._restHandlers.remove(uri);
        if (this._restOverStream) {
            this._adaptedHandlers.remove(uri);
        }
        return handler;
    }

    public TransportDispatcherBuilder addStreamHandler(URI uri, StreamRequestHandler handler) {
        this._streamHandlers.put(uri, handler);
        return this;
    }

    public StreamRequestHandler removeStreamHandler(URI uri) {
        return this._streamHandlers.remove(uri);
    }

    public TransportDispatcherBuilder reset() {
        this._restHandlers.clear();
        this._adaptedHandlers.clear();
        this._streamHandlers.clear();
        return this;
    }

    public TransportDispatcher build() {
        HashMap<URI, StreamRequestHandler> mergedStreamHandlers = new HashMap<URI, StreamRequestHandler>(this._adaptedHandlers);
        mergedStreamHandlers.putAll(this._streamHandlers);
        return new TransportDispatcherImpl(this._restHandlers, mergedStreamHandlers);
    }
}

