/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.common;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.callback.FutureCallback;
import com.linkedin.r2.message.Messages;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.transport.common.Client;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Future;

public abstract class AbstractClient
implements Client {
    @Override
    public Future<RestResponse> restRequest(RestRequest request) {
        return this.restRequest(request, new RequestContext());
    }

    @Override
    public Future<RestResponse> restRequest(RestRequest request, RequestContext requestContext) {
        FutureCallback future = new FutureCallback();
        this.restRequest(request, requestContext, (Callback<RestResponse>)future);
        return future;
    }

    @Override
    public void restRequest(RestRequest request, Callback<RestResponse> callback) {
        this.restRequest(request, new RequestContext(), callback);
    }

    @Override
    public void streamRequest(StreamRequest request, Callback<StreamResponse> callback) {
        this.streamRequest(request, new RequestContext(), callback);
    }

    @Override
    public void restRequest(RestRequest request, RequestContext requestContext, Callback<RestResponse> callback) {
        StreamRequest streamRequest = Messages.toStreamRequest(request);
        requestContext.putLocalAttr("IS_FULL_REQUEST", true);
        this.streamRequest(streamRequest, requestContext, Messages.toStreamCallback(callback, true));
    }

    @Override
    public Map<String, Object> getMetadata(URI uri) {
        return Collections.emptyMap();
    }
}

