/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.filter.transport;

import com.linkedin.r2.filter.NextFilter;
import com.linkedin.r2.filter.message.rest.RestFilter;
import com.linkedin.r2.filter.message.stream.StreamFilter;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.transport.common.bridge.common.NullTransportCallback;
import com.linkedin.r2.transport.common.bridge.common.TransportCallback;
import com.linkedin.r2.transport.common.bridge.common.TransportResponseImpl;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseFilter
implements StreamFilter,
RestFilter {
    private static final String CALLBACK_ATTR = ResponseFilter.class.getName() + ".callback";
    private static final Logger _log = LoggerFactory.getLogger(ResponseFilter.class);

    public static <T> void registerCallback(TransportCallback<T> callback, RequestContext context) {
        context.putLocalAttr(CALLBACK_ATTR, callback);
    }

    @Override
    public void onRestResponse(RestResponse res, RequestContext requestContext, Map<String, String> wireAttrs, NextFilter<RestRequest, RestResponse> nextFilter) {
        TransportCallback<RestResponse> callback = this.getCallback(requestContext);
        callback.onResponse(TransportResponseImpl.success(res, wireAttrs));
        nextFilter.onResponse(res, requestContext, wireAttrs);
    }

    @Override
    public void onRestError(Throwable ex, RequestContext requestContext, Map<String, String> wireAttrs, NextFilter<RestRequest, RestResponse> nextFilter) {
        TransportCallback callback = this.getCallback(requestContext);
        callback.onResponse(TransportResponseImpl.error(ex, wireAttrs));
        nextFilter.onError(ex, requestContext, wireAttrs);
    }

    @Override
    public void onStreamResponse(StreamResponse res, RequestContext requestContext, Map<String, String> wireAttrs, NextFilter<StreamRequest, StreamResponse> nextFilter) {
        TransportCallback<StreamResponse> callback = this.getCallback(requestContext);
        callback.onResponse(TransportResponseImpl.success(res, wireAttrs));
        nextFilter.onResponse(res, requestContext, wireAttrs);
    }

    @Override
    public void onStreamError(Throwable ex, RequestContext requestContext, Map<String, String> wireAttrs, NextFilter<StreamRequest, StreamResponse> nextFilter) {
        TransportCallback callback = this.getCallback(requestContext);
        callback.onResponse(TransportResponseImpl.error(ex, wireAttrs));
        nextFilter.onError(ex, requestContext, wireAttrs);
    }

    private <T> TransportCallback<T> getCallback(RequestContext context) {
        NullTransportCallback callback = (NullTransportCallback)context.getLocalAttr(CALLBACK_ATTR);
        if (callback == null) {
            _log.error("No callback registered in local attributes. Caller will not get response. Attributes: " + context);
            callback = new NullTransportCallback();
        }
        return callback;
    }
}

