/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.filter.transport;

import com.linkedin.r2.filter.FilterChain;
import com.linkedin.r2.filter.transport.DispatcherRequestFilter;
import com.linkedin.r2.filter.transport.ResponseFilter;
import com.linkedin.r2.filter.transport.ServerQueryTunnelFilter;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.transport.common.bridge.common.TransportCallback;
import com.linkedin.r2.transport.common.bridge.server.TransportDispatcher;
import java.util.Map;

public class FilterChainDispatcher
implements TransportDispatcher {
    private final FilterChain _filters;

    public FilterChainDispatcher(TransportDispatcher dispatcher, FilterChain filters) {
        ServerQueryTunnelFilter serverQueryTunnelFilter = new ServerQueryTunnelFilter();
        ResponseFilter responseFilter = new ResponseFilter();
        DispatcherRequestFilter dispatcherRequestFilter = new DispatcherRequestFilter(dispatcher);
        this._filters = filters.addFirstRest(serverQueryTunnelFilter).addFirstRest(responseFilter).addLastRest(dispatcherRequestFilter).addFirst(serverQueryTunnelFilter).addFirst(responseFilter).addLast(dispatcherRequestFilter);
    }

    @Override
    public void handleRestRequest(RestRequest req, Map<String, String> wireAttrs, RequestContext requestContext, TransportCallback<RestResponse> callback) {
        ResponseFilter.registerCallback(callback, requestContext);
        this._filters.onRestRequest(req, requestContext, wireAttrs);
    }

    @Override
    public void handleStreamRequest(StreamRequest req, Map<String, String> wireAttrs, RequestContext requestContext, TransportCallback<StreamResponse> callback) {
        ResponseFilter.registerCallback(callback, requestContext);
        this._filters.onStreamRequest(req, requestContext, wireAttrs);
    }
}

