/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.service.modules.flow;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.typesafe.config.Config;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.runtime.api.FlowSpec;
import org.apache.gobblin.runtime.api.JobSpec;
import org.apache.gobblin.runtime.api.ServiceNode;
import org.apache.gobblin.runtime.api.Spec;
import org.apache.gobblin.runtime.api.SpecExecutor;
import org.apache.gobblin.runtime.api.TopologySpec;
import org.apache.gobblin.service.modules.flow.BaseFlowToJobSpecCompiler;
import org.slf4j.Logger;

@Alpha
public class IdentityFlowToJobSpecCompiler
extends BaseFlowToJobSpecCompiler {
    public IdentityFlowToJobSpecCompiler(Config config) {
        super(config, true);
    }

    public IdentityFlowToJobSpecCompiler(Config config, boolean instrumentationEnabled) {
        super(config, (Optional<Logger>)Optional.absent(), instrumentationEnabled);
    }

    public IdentityFlowToJobSpecCompiler(Config config, Optional<Logger> log) {
        super(config, log, true);
    }

    public IdentityFlowToJobSpecCompiler(Config config, Optional<Logger> log, boolean instrumentationEnabled) {
        super(config, log, instrumentationEnabled);
    }

    @Override
    public Map<Spec, SpecExecutor> compileFlow(Spec spec) {
        Preconditions.checkNotNull((Object)spec);
        Preconditions.checkArgument((boolean)(spec instanceof FlowSpec), (Object)"IdentityFlowToJobSpecCompiler only converts FlowSpec to JobSpec");
        long startTime = System.nanoTime();
        LinkedHashMap specExecutorMap = Maps.newLinkedHashMap();
        FlowSpec flowSpec = (FlowSpec)spec;
        String source = flowSpec.getConfig().getString("gobblin.flow.sourceIdentifier");
        String destination = flowSpec.getConfig().getString("gobblin.flow.destinationIdentifier");
        this.log.info(String.format("Compiling flow for source: %s and destination: %s", source, destination));
        JobSpec jobSpec = this.jobSpecGenerator(flowSpec);
        for (TopologySpec topologySpec : this.topologySpecMap.values()) {
            try {
                Map capabilities = (Map)topologySpec.getSpecExecutor().getCapabilities().get();
                for (Map.Entry capability : capabilities.entrySet()) {
                    this.log.info(String.format("Evaluating current JobSpec: %s against TopologySpec: %s with capability of source: %s and destination: %s ", jobSpec.getUri(), topologySpec.getUri(), capability.getKey(), capability.getValue()));
                    if (!source.equals(((ServiceNode)capability.getKey()).getNodeName()) || !destination.equals(((ServiceNode)capability.getValue()).getNodeName())) continue;
                    specExecutorMap.put(jobSpec, topologySpec.getSpecExecutor());
                    this.log.info(String.format("Current JobSpec: %s is executable on TopologySpec: %s. Added TopologySpec as candidate.", jobSpec.getUri(), topologySpec.getUri()));
                    this.log.info("Since we found a candidate executor, we will not try to compute more. (Intended limitation for IdentityFlowToJobSpecCompiler)");
                    return specExecutorMap;
                }
            }
            catch (InterruptedException | ExecutionException e) {
                Instrumented.markMeter((Optional)this.flowCompilationFailedMeter);
                throw new RuntimeException("Cannot determine topology capabilities", e);
            }
        }
        Instrumented.markMeter((Optional)this.flowCompilationSuccessFulMeter);
        Instrumented.updateTimer((Optional)this.flowCompilationTimer, (long)(System.nanoTime() - startTime), (TimeUnit)TimeUnit.NANOSECONDS);
        return specExecutorMap;
    }

    @Override
    protected void populateEdgeTemplateMap() {
        this.log.warn("No population of templates based on edge happen in this implementation");
    }
}

