/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.service.modules.flow;

import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValueFactory;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.instrumented.Instrumented;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.Tag;
import org.apache.gobblin.runtime.api.FlowSpec;
import org.apache.gobblin.runtime.api.JobCatalog;
import org.apache.gobblin.runtime.api.JobSpec;
import org.apache.gobblin.runtime.api.JobTemplate;
import org.apache.gobblin.runtime.api.Spec;
import org.apache.gobblin.runtime.api.SpecCompiler;
import org.apache.gobblin.runtime.api.SpecExecutor;
import org.apache.gobblin.runtime.api.SpecNotFoundException;
import org.apache.gobblin.runtime.api.TopologySpec;
import org.apache.gobblin.runtime.job_catalog.FSJobCatalog;
import org.apache.gobblin.runtime.job_spec.ResolvedJobSpec;
import org.apache.gobblin.service.modules.flow.IdentityFlowToJobSpecCompiler;
import org.apache.gobblin.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alpha
public abstract class BaseFlowToJobSpecCompiler
implements SpecCompiler {
    protected final Map<URI, TopologySpec> topologySpecMap;
    protected final Map<String, List<URI>> edgeTemplateMap;
    protected final Config config;
    protected final Logger log;
    protected final Optional<FSJobCatalog> templateCatalog;
    protected final MetricContext metricContext;
    protected Optional<Meter> flowCompilationSuccessFulMeter;
    protected Optional<Meter> flowCompilationFailedMeter;
    protected Optional<Timer> flowCompilationTimer;

    public BaseFlowToJobSpecCompiler(Config config) {
        this(config, true);
    }

    public BaseFlowToJobSpecCompiler(Config config, boolean instrumentationEnabled) {
        this(config, (Optional<Logger>)Optional.absent(), true);
    }

    public BaseFlowToJobSpecCompiler(Config config, Optional<Logger> log) {
        this(config, log, true);
    }

    public BaseFlowToJobSpecCompiler(Config config, Optional<Logger> log, boolean instrumentationEnabled) {
        Logger logger = this.log = log.isPresent() ? (Logger)log.get() : LoggerFactory.getLogger(this.getClass());
        if (instrumentationEnabled) {
            this.metricContext = Instrumented.getMetricContext((State)ConfigUtils.configToState((Config)config), IdentityFlowToJobSpecCompiler.class);
            this.flowCompilationSuccessFulMeter = Optional.of((Object)this.metricContext.meter("gobblin.service.flowCompilation.successful"));
            this.flowCompilationFailedMeter = Optional.of((Object)this.metricContext.meter("gobblin.service.flowCompilation.failed"));
            this.flowCompilationTimer = Optional.of((Object)this.metricContext.timer("gobblin.service.flowCompilation.time"));
        } else {
            this.metricContext = null;
            this.flowCompilationSuccessFulMeter = Optional.absent();
            this.flowCompilationFailedMeter = Optional.absent();
            this.flowCompilationTimer = Optional.absent();
        }
        this.topologySpecMap = Maps.newConcurrentMap();
        this.edgeTemplateMap = Maps.newConcurrentMap();
        this.config = config;
        try {
            if (this.config.hasPath("gobblin.service.templateCatalogs.fullyQualifiedPath") && StringUtils.isNotBlank((CharSequence)this.config.getString("gobblin.service.templateCatalogs.fullyQualifiedPath"))) {
                Config templateCatalogCfg = config.withValue("jobconf.fullyQualifiedPath", this.config.getValue("gobblin.service.templateCatalogs.fullyQualifiedPath"));
                this.templateCatalog = Optional.of((Object)new FSJobCatalog(templateCatalogCfg));
            } else {
                this.templateCatalog = Optional.absent();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not initialize FlowCompiler because of TemplateCatalog initialization failure", e);
        }
    }

    public synchronized void onAddSpec(Spec addedSpec) {
        TopologySpec spec = (TopologySpec)addedSpec;
        this.log.info("Loading topology {}", (Object)spec.toLongString());
        for (Map.Entry<Object, Object> entry : spec.getConfigAsProperties().entrySet()) {
            this.log.info("topo: {} --> {}", entry.getKey(), entry.getValue());
        }
        this.topologySpecMap.put(addedSpec.getUri(), (TopologySpec)addedSpec);
    }

    public synchronized void onDeleteSpec(URI deletedSpecURI, String deletedSpecVersion) {
        if (this.topologySpecMap.containsKey(deletedSpecURI)) {
            this.topologySpecMap.remove(deletedSpecURI);
        }
    }

    public synchronized void onUpdateSpec(Spec updatedSpec) {
        this.topologySpecMap.put(updatedSpec.getUri(), (TopologySpec)updatedSpec);
    }

    @Nonnull
    public MetricContext getMetricContext() {
        return this.metricContext;
    }

    public boolean isInstrumentationEnabled() {
        return null != this.metricContext;
    }

    public List<Tag<?>> generateTags(State state) {
        return Collections.emptyList();
    }

    public void switchMetricContext(List<Tag<?>> tags) {
        throw new UnsupportedOperationException();
    }

    public void switchMetricContext(MetricContext context) {
        throw new UnsupportedOperationException();
    }

    public Map<URI, TopologySpec> getTopologySpecMap() {
        return this.topologySpecMap;
    }

    public abstract Map<Spec, SpecExecutor> compileFlow(Spec var1);

    protected JobSpec jobSpecGenerator(FlowSpec flowSpec) {
        JobSpec jobSpec;
        JobSpec.Builder jobSpecBuilder = JobSpec.builder((URI)this.jobSpecURIGenerator(flowSpec)).withConfig(flowSpec.getConfig()).withDescription(flowSpec.getDescription()).withVersion(flowSpec.getVersion());
        if (flowSpec.getTemplateURIs().isPresent() && this.templateCatalog.isPresent()) {
            jobSpecBuilder = jobSpecBuilder.withTemplate((URI)((Set)flowSpec.getTemplateURIs().get()).iterator().next());
            try {
                jobSpec = new ResolvedJobSpec(jobSpecBuilder.build(), (JobCatalog)this.templateCatalog.get());
                this.log.info("Resolved JobSpec properties are: " + jobSpec.getConfigAsProperties());
            }
            catch (JobTemplate.TemplateException | SpecNotFoundException e) {
                throw new RuntimeException("Could not resolve template in JobSpec from TemplateCatalog", e);
            }
        } else {
            jobSpec = jobSpecBuilder.build();
            this.log.info("Unresolved JobSpec properties are: " + jobSpec.getConfigAsProperties());
        }
        jobSpec.setConfig(jobSpec.getConfig().withoutPath("job.schedule"));
        if (flowSpec.getConfig().hasPath("flow.name")) {
            jobSpec.setConfig(jobSpec.getConfig().withValue("job.name", flowSpec.getConfig().getValue("flow.name")));
        }
        if (flowSpec.getConfig().hasPath("flow.group")) {
            jobSpec.setConfig(jobSpec.getConfig().withValue("job.group", flowSpec.getConfig().getValue("flow.group")));
        }
        long flowExecutionId = System.currentTimeMillis();
        jobSpec.setConfig(jobSpec.getConfig().withValue("flow.executionId", ConfigValueFactory.fromAnyRef((Object)flowExecutionId)));
        jobSpec.setConfigAsProperties(ConfigUtils.configToProperties((Config)jobSpec.getConfig()));
        return jobSpec;
    }

    public URI jobSpecURIGenerator(Object ... objects) {
        return ((FlowSpec)objects[0]).getUri();
    }

    protected URI jobSpecTemplateURIGenerator(FlowSpec flowSpec) {
        return (URI)((Set)flowSpec.getTemplateURIs().get()).iterator().next();
    }

    protected abstract void populateEdgeTemplateMap();

    public Map<String, List<URI>> getEdgeTemplateMap() {
        return this.edgeTemplateMap;
    }

    public Optional<Meter> getFlowCompilationSuccessFulMeter() {
        return this.flowCompilationSuccessFulMeter;
    }

    public Optional<Meter> getFlowCompilationFailedMeter() {
        return this.flowCompilationFailedMeter;
    }

    public Optional<Timer> getFlowCompilationTimer() {
        return this.flowCompilationTimer;
    }
}

