/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.server.resources;

import com.linkedin.restli.internal.server.RestLiInternalException;
import com.linkedin.restli.internal.server.model.AnnotationSet;
import com.linkedin.restli.server.resources.BeanProvider;
import com.linkedin.restli.server.resources.InjectResourceFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jsr330Adapter {
    private static final Logger log = LoggerFactory.getLogger(InjectResourceFactory.class);
    private final BeanProvider _beanProvider;
    private final Map<Class<?>, InjectableConstructor> _constructorParameterDependencies = new HashMap();
    private final Map<Class<?>, Object[]> _constructorParameterBindings = new HashMap();
    private final Map<Class<?>, InjectableFields> _fieldDependencyDeclarations = new HashMap();
    private final Map<Class<?>, BeanDependencies> _fieldDependencyBindings = new HashMap();

    public Jsr330Adapter(Collection<Class<?>> managedBeans, BeanProvider beanProvider) {
        this._beanProvider = beanProvider;
        this.scan(managedBeans);
        this.validate();
    }

    public <T> T getBean(Class<T> beanClass) {
        BeanDependencies deps = this._fieldDependencyBindings.get(beanClass);
        if (deps == null) {
            throw new RestLiInternalException("Could not find bean of class '" + beanClass.getName() + "'");
        }
        try {
            Constructor<?> constructor = this._constructorParameterDependencies.get(beanClass).getConstructor();
            Object[] arguments = this._constructorParameterBindings.get(beanClass);
            Object bean = constructor.newInstance(arguments);
            for (Map.Entry<Field, Object> fieldDep : deps.iterator()) {
                Field f = fieldDep.getKey();
                f.setAccessible(true);
                f.set(bean, fieldDep.getValue());
            }
            return (T)bean;
        }
        catch (Throwable t) {
            throw new RestLiInternalException(String.format("Error initializing bean %s", beanClass.getName()), t);
        }
    }

    private void scan(Collection<Class<?>> managedBeans) {
        for (Class<?> beanClazz : managedBeans) {
            log.debug("Scanning class " + beanClazz.getName());
            this.scanInjectableConstructors(beanClazz);
            this.scanInjectableFields(beanClazz);
        }
    }

    private void scanInjectableConstructors(Class<?> beanClazz) {
        int annotatedConstructors = 0;
        for (Constructor<?> constructor : beanClazz.getConstructors()) {
            Inject injectAnnotation = constructor.getAnnotation(Inject.class);
            if (injectAnnotation == null) continue;
            if (++annotatedConstructors > 1) {
                throw new RestLiInternalException("Found multiple constructors annotated with @Inject in class '" + beanClazz.getCanonicalName() + "'.  At most one constructor can be annotated with @Inject.");
            }
            Class<?>[] parameters = constructor.getParameterTypes();
            Annotation[][] parameterAnnotations = constructor.getParameterAnnotations();
            ArrayList<DependencyDecl> parameterDecls = new ArrayList<DependencyDecl>(parameters.length);
            for (int i = 0; i < parameters.length; ++i) {
                Class<?> parameter = parameters[i];
                AnnotationSet annotations = new AnnotationSet(parameterAnnotations[i]);
                Named namedAnno = annotations.get(Named.class);
                parameterDecls.add(new DependencyDecl(parameter, namedAnno != null ? namedAnno.value() : null));
            }
            constructor.setAccessible(true);
            this._constructorParameterDependencies.put(beanClazz, new InjectableConstructor(constructor, parameterDecls));
        }
        if (annotatedConstructors == 0) {
            try {
                Constructor<?> defaultConstructor = beanClazz.getConstructor(new Class[0]);
                defaultConstructor.setAccessible(true);
                this._constructorParameterDependencies.put(beanClazz, new InjectableConstructor(defaultConstructor, Collections.emptyList()));
            }
            catch (NoSuchMethodException e) {
                throw new RestLiInternalException(String.format("No injectable constructor defined for class %s.  Classes must define either a default constructor or a constructor annotated with @Inject.", beanClazz.getName()), e);
            }
        }
    }

    private void scanInjectableFields(Class<?> beanClazz) {
        InjectableFields fieldDecls = new InjectableFields();
        ArrayList<Field> fieldsToScan = new ArrayList<Field>(Arrays.asList(beanClazz.getDeclaredFields()));
        for (Class<?> superclazz = beanClazz.getSuperclass(); superclazz != Object.class; superclazz = superclazz.getSuperclass()) {
            fieldsToScan.addAll(Arrays.asList(superclazz.getDeclaredFields()));
        }
        for (Field field : fieldsToScan) {
            log.debug("  Scanning field " + field.getName());
            if (field.getAnnotations().length <= 0) continue;
            Named namedAnno = field.getAnnotation(Named.class);
            if (namedAnno != null) {
                log.debug("    Using @Named: " + namedAnno.value());
                fieldDecls.add(field, field.getType(), namedAnno.value());
                continue;
            }
            log.debug("    Using @Inject");
            Inject injectAnno = field.getAnnotation(Inject.class);
            if (injectAnno == null) continue;
            fieldDecls.add(field, field.getType(), null);
        }
        this._fieldDependencyDeclarations.put(beanClazz, fieldDecls);
    }

    public void validate() {
        this.bindConstructorParameterDependencies();
        this.bindFieldDependencies();
    }

    private void bindConstructorParameterDependencies() {
        for (Map.Entry<Class<?>, InjectableConstructor> beanConstructor : this._constructorParameterDependencies.entrySet()) {
            Class<?> beanClazz = beanConstructor.getKey();
            List<DependencyDecl> dependencies = beanConstructor.getValue().getParameterDecls();
            Object[] bindings = new Object[dependencies.size()];
            int idx = 0;
            for (DependencyDecl dependency : dependencies) {
                String dependencyTarget = "constructor '" + beanConstructor.getValue().getConstructor() + "' parameter index " + idx;
                bindings[idx] = this.resolveDependency(dependency, beanClazz, dependencyTarget);
                ++idx;
            }
            this._constructorParameterBindings.put(beanClazz, bindings);
        }
    }

    private void bindFieldDependencies() {
        for (Map.Entry<Class<?>, InjectableFields> beanFields : this._fieldDependencyDeclarations.entrySet()) {
            BeanDependencies deps = new BeanDependencies();
            for (Map.Entry<Field, DependencyDecl> depDecl : beanFields.getValue().iterator()) {
                DependencyDecl decl = depDecl.getValue();
                Class<?> beanClazz = beanFields.getKey();
                String dependencyTarget = "field '" + depDecl.getKey() + "'";
                Object resolvedBean = this.resolveDependency(decl, beanClazz, dependencyTarget);
                deps.add(depDecl.getKey(), resolvedBean);
            }
            this._fieldDependencyBindings.put(beanFields.getKey(), deps);
        }
    }

    private Object resolveDependency(DependencyDecl decl, Class<?> beanClazz, String dependencyTarget) {
        Object resolvedBean;
        log.debug("Resolving bean for class " + beanClazz + ", " + dependencyTarget);
        if (decl.hasBeanName()) {
            resolvedBean = this._beanProvider.getBean(decl.getBeanName());
            if (resolvedBean == null) {
                throw new RestLiInternalException("Expected to find bean with name '" + decl.getBeanName() + "', but did not find such bean. This bean needs to be injected into class '" + beanClazz + "', " + dependencyTarget + ".");
            }
        } else {
            Map<String, ?> matchingBeans = this._beanProvider.getBeansOfType(decl.getBeanType());
            if (matchingBeans.size() != 1) {
                throw new RestLiInternalException("Expected to find exactly 1 bean of type '" + decl.getBeanType() + "', but found " + matchingBeans.size() + ". You can use the @Named annotation to further qualify ambiguous dependencies");
            }
            resolvedBean = matchingBeans.values().iterator().next();
        }
        return resolvedBean;
    }

    protected static class DependencyDecl {
        private final Class<?> _beanType;
        private final String _beanName;

        public DependencyDecl(Class<?> beanType, String beanName) {
            this._beanType = beanType;
            this._beanName = beanName;
        }

        public Class<?> getBeanType() {
            return this._beanType;
        }

        public boolean hasBeanName() {
            return this._beanName != null;
        }

        public String getBeanName() {
            return this._beanName;
        }
    }

    protected static class InjectableFields {
        Map<Field, DependencyDecl> _fieldMap = new HashMap<Field, DependencyDecl>();

        protected InjectableFields() {
        }

        public Iterable<Map.Entry<Field, DependencyDecl>> iterator() {
            return this._fieldMap.entrySet();
        }

        public void add(Field field, Class<?> type, String beanName) {
            this._fieldMap.put(field, new DependencyDecl(type, beanName));
        }

        public DependencyDecl get(Field field) {
            return this._fieldMap.get(field);
        }
    }

    protected static class InjectableConstructor {
        private final Constructor<?> _constructor;
        private final List<DependencyDecl> _parameterDecls;

        public InjectableConstructor(Constructor<?> constructor, List<DependencyDecl> parameterDecls) {
            this._constructor = constructor;
            this._parameterDecls = parameterDecls;
        }

        public Constructor<?> getConstructor() {
            return this._constructor;
        }

        public List<DependencyDecl> getParameterDecls() {
            return this._parameterDecls;
        }
    }

    protected static class BeanDependencies {
        Map<Field, Object> _dependencyMap = new HashMap<Field, Object>();

        protected BeanDependencies() {
        }

        public void add(Field field, Object bean) {
            this._dependencyMap.put(field, bean);
        }

        public Iterable<Map.Entry<Field, Object>> iterator() {
            return this._dependencyMap.entrySet();
        }

        public Object get(Field field) {
            return this._dependencyMap.get(field);
        }
    }
}

