/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.server.multiplexer;

import com.linkedin.data.template.StringMap;
import com.linkedin.parseq.BaseTask;
import com.linkedin.parseq.Context;
import com.linkedin.parseq.promise.Promise;
import com.linkedin.parseq.promise.Promises;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.restli.common.multiplexer.IndividualRequest;
import com.linkedin.restli.internal.common.HeaderUtil;
import java.util.Collection;
import java.util.Map;

final class InheritEnvelopeRequestTask
extends BaseTask<IndividualRequest> {
    private final RestRequest _envelopeRequest;
    private final BaseTask<IndividualRequest> _individualRequest;

    InheritEnvelopeRequestTask(RestRequest envelopeRequest, BaseTask<IndividualRequest> individualRequest) {
        this._envelopeRequest = envelopeRequest;
        this._individualRequest = individualRequest;
    }

    protected Promise<? extends IndividualRequest> run(Context context) throws Throwable {
        if (this._individualRequest.isFailed()) {
            return Promises.error((Throwable)this._individualRequest.getError());
        }
        IndividualRequest individualRequest = (IndividualRequest)this._individualRequest.get();
        InheritEnvelopeRequestTask.inheritHeaders(individualRequest, this._envelopeRequest);
        return Promises.value((Object)individualRequest);
    }

    private static void inheritHeaders(IndividualRequest individualRequest, RestRequest envelopeRequest) {
        Map envelopeHeaders = HeaderUtil.removeHeaders((Map)envelopeRequest.getHeaders(), (Collection)HeaderUtil.NONINHERITABLE_REQUEST_HEADERS);
        if (envelopeHeaders.size() > 0) {
            individualRequest.setHeaders(new StringMap(HeaderUtil.mergeHeaders((Map)envelopeHeaders, (Map)individualRequest.getHeaders())));
        }
    }
}

