/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.server;

import com.linkedin.common.callback.Callback;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.transport.common.RestRequestHandler;
import com.linkedin.r2.transport.common.StreamRequestHandler;
import com.linkedin.restli.internal.server.model.ResourceModel;
import com.linkedin.restli.server.RestLiConfig;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRestServer
implements RestRequestHandler,
StreamRequestHandler {
    private static final Logger log = LoggerFactory.getLogger(BaseRestServer.class);
    private final RestLiConfig _config;
    protected Map<String, ResourceModel> _rootResources;

    public BaseRestServer(RestLiConfig config) {
        this._config = config;
    }

    public void handleRequest(RestRequest request, RequestContext requestContext, Callback<RestResponse> callback) {
        try {
            this.doHandleRequest(request, requestContext, callback);
        }
        catch (Exception e) {
            log.error("Uncaught exception", (Throwable)e);
            callback.onError((Throwable)e);
        }
    }

    protected abstract void doHandleRequest(RestRequest var1, RequestContext var2, Callback<RestResponse> var3);

    public void handleRequest(StreamRequest request, RequestContext requestContext, Callback<StreamResponse> callback) {
        try {
            this.doHandleStreamRequest(request, requestContext, callback);
        }
        catch (Exception e) {
            log.error("Uncaught exception", (Throwable)e);
            callback.onError((Throwable)e);
        }
    }

    protected abstract void doHandleStreamRequest(StreamRequest var1, RequestContext var2, Callback<StreamResponse> var3);

    protected RestLiConfig getConfig() {
        return this._config;
    }
}

