/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server.model;

import com.linkedin.restli.internal.server.model.ResourceModel;
import com.linkedin.restli.internal.server.model.RestApiBuilder;
import com.linkedin.restli.internal.server.model.RestLiAnnotationReader;
import com.linkedin.restli.internal.server.model.RestLiClasspathScanner;
import com.linkedin.restli.server.ResourceConfigException;
import com.linkedin.restli.server.RestLiConfig;
import com.linkedin.restli.server.annotations.RestAnnotations;
import com.linkedin.restli.server.annotations.RestLiAssociation;
import com.linkedin.restli.server.annotations.RestLiCollection;
import com.linkedin.restli.server.annotations.RestLiSimpleResource;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestLiApiBuilder
implements RestApiBuilder {
    private static final Logger _log = LoggerFactory.getLogger(RestLiApiBuilder.class);
    private final Set<String> _packageNames;
    private final Set<String> _classNames;

    public RestLiApiBuilder(RestLiConfig config) {
        if (config.getResourcePackageNamesSet().isEmpty() && config.getResourceClassNamesSet().isEmpty()) {
            throw new ResourceConfigException("At least one package containing Rest.li annotated classes or one resource class must be specified");
        }
        this._packageNames = config.getResourcePackageNamesSet();
        this._classNames = config.getResourceClassNamesSet();
    }

    @Override
    public Map<String, ResourceModel> build() {
        Set<Class<?>> annotatedClasses;
        RestLiClasspathScanner scanner = new RestLiClasspathScanner(this._packageNames, this._classNames, Thread.currentThread().getContextClassLoader());
        scanner.scanPackages();
        String errorMessage = scanner.scanClasses();
        if (!errorMessage.isEmpty()) {
            _log.error(errorMessage);
        }
        if ((annotatedClasses = scanner.getMatchedClasses()).isEmpty()) {
            _log.info("Could not find any Rest.li annotated class in the configuration");
            return Collections.emptyMap();
        }
        return RestLiApiBuilder.buildResourceModels(annotatedClasses);
    }

    private static Class<?> getParentResourceClass(Class<?> resourceClass) {
        for (Annotation a : resourceClass.getAnnotations()) {
            if (a instanceof RestLiAssociation) {
                return ((RestLiAssociation)a).parent();
            }
            if (a instanceof RestLiCollection) {
                return ((RestLiCollection)a).parent();
            }
            if (!(a instanceof RestLiSimpleResource)) continue;
            return ((RestLiSimpleResource)a).parent();
        }
        return RestAnnotations.ROOT.class;
    }

    private static void processResourceInOrder(Class<?> annotatedClass, Map<Class<?>, ResourceModel> resourceModels, Map<String, ResourceModel> rootResourceModels) {
        ResourceModel model;
        if (resourceModels.containsKey(annotatedClass)) {
            return;
        }
        Class<?> parentClass = RestLiApiBuilder.getParentResourceClass(annotatedClass);
        if (parentClass != RestAnnotations.ROOT.class) {
            RestLiApiBuilder.processResourceInOrder(parentClass, resourceModels, rootResourceModels);
        }
        if ((model = RestLiAnnotationReader.processResource(annotatedClass, resourceModels.get(parentClass))).isRoot()) {
            String path = "/" + model.getName();
            ResourceModel existingResource = rootResourceModels.get(path);
            if (existingResource != null) {
                String errorMessage = String.format("Resource classes \"%s\" and \"%s\" clash on the resource name \"%s\".", existingResource.getResourceClass().getCanonicalName(), model.getResourceClass().getCanonicalName(), existingResource.getName());
                throw new ResourceConfigException(errorMessage);
            }
            rootResourceModels.put(path, model);
        }
        resourceModels.put(annotatedClass, model);
    }

    public static Map<String, ResourceModel> buildResourceModels(Set<Class<?>> restliAnnotatedClasses) {
        HashMap<String, ResourceModel> rootResourceModels = new HashMap<String, ResourceModel>();
        HashMap resourceModels = new HashMap();
        for (Class<?> annotatedClass : restliAnnotatedClasses) {
            RestLiApiBuilder.processResourceInOrder(annotatedClass, resourceModels, rootResourceModels);
        }
        return rootResourceModels;
    }
}

