/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server.model;

import com.linkedin.common.callback.Callback;
import com.linkedin.data.DataMap;
import com.linkedin.data.element.DataElement;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaUtil;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.DynamicRecordMetadata;
import com.linkedin.data.template.FieldDef;
import com.linkedin.data.template.HasTyperefInfo;
import com.linkedin.data.template.KeyCoercer;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.TemplateRuntimeException;
import com.linkedin.data.template.TyperefInfo;
import com.linkedin.data.transform.filter.request.MaskTree;
import com.linkedin.parseq.Task;
import com.linkedin.parseq.promise.Promise;
import com.linkedin.restli.common.ActionResponse;
import com.linkedin.restli.common.ComplexResourceKey;
import com.linkedin.restli.common.PatchRequest;
import com.linkedin.restli.common.ResourceMethod;
import com.linkedin.restli.common.RestConstants;
import com.linkedin.restli.common.attachments.RestLiAttachmentReader;
import com.linkedin.restli.common.validation.CreateOnly;
import com.linkedin.restli.common.validation.ReadOnly;
import com.linkedin.restli.common.validation.RestLiDataValidator;
import com.linkedin.restli.internal.common.ReflectionUtils;
import com.linkedin.restli.internal.server.PathKeysImpl;
import com.linkedin.restli.internal.server.RestLiInternalException;
import com.linkedin.restli.internal.server.model.AnnotationSet;
import com.linkedin.restli.internal.server.model.Parameter;
import com.linkedin.restli.internal.server.model.ResourceMethodDescriptor;
import com.linkedin.restli.internal.server.model.ResourceMethodLookup;
import com.linkedin.restli.internal.server.model.ResourceModel;
import com.linkedin.restli.internal.server.model.ResourceModelAnnotation;
import com.linkedin.restli.internal.server.model.ResourceType;
import com.linkedin.restli.internal.server.model.RestLiAnnotationData;
import com.linkedin.restli.internal.server.model.RestModelConstants;
import com.linkedin.restli.server.ActionResult;
import com.linkedin.restli.server.BatchCreateRequest;
import com.linkedin.restli.server.BatchDeleteRequest;
import com.linkedin.restli.server.BatchPatchRequest;
import com.linkedin.restli.server.BatchUpdateRequest;
import com.linkedin.restli.server.CollectionResult;
import com.linkedin.restli.server.NoMetadata;
import com.linkedin.restli.server.PagingContext;
import com.linkedin.restli.server.PathKeys;
import com.linkedin.restli.server.ResourceConfigException;
import com.linkedin.restli.server.ResourceContext;
import com.linkedin.restli.server.ResourceLevel;
import com.linkedin.restli.server.annotations.Action;
import com.linkedin.restli.server.annotations.ActionParam;
import com.linkedin.restli.server.annotations.AlternativeKey;
import com.linkedin.restli.server.annotations.AlternativeKeys;
import com.linkedin.restli.server.annotations.AssocKey;
import com.linkedin.restli.server.annotations.AssocKeyParam;
import com.linkedin.restli.server.annotations.CallbackParam;
import com.linkedin.restli.server.annotations.Context;
import com.linkedin.restli.server.annotations.Finder;
import com.linkedin.restli.server.annotations.HeaderParam;
import com.linkedin.restli.server.annotations.Key;
import com.linkedin.restli.server.annotations.Keys;
import com.linkedin.restli.server.annotations.MetadataProjectionParam;
import com.linkedin.restli.server.annotations.Optional;
import com.linkedin.restli.server.annotations.PagingContextParam;
import com.linkedin.restli.server.annotations.PagingProjectionParam;
import com.linkedin.restli.server.annotations.ParSeqContext;
import com.linkedin.restli.server.annotations.ParSeqContextParam;
import com.linkedin.restli.server.annotations.PathKeyParam;
import com.linkedin.restli.server.annotations.PathKeysParam;
import com.linkedin.restli.server.annotations.Projection;
import com.linkedin.restli.server.annotations.ProjectionParam;
import com.linkedin.restli.server.annotations.QueryParam;
import com.linkedin.restli.server.annotations.ResourceContextParam;
import com.linkedin.restli.server.annotations.RestAnnotations;
import com.linkedin.restli.server.annotations.RestLiActions;
import com.linkedin.restli.server.annotations.RestLiAssociation;
import com.linkedin.restli.server.annotations.RestLiAttachmentsParam;
import com.linkedin.restli.server.annotations.RestLiCollection;
import com.linkedin.restli.server.annotations.RestLiSimpleResource;
import com.linkedin.restli.server.annotations.RestLiTemplate;
import com.linkedin.restli.server.annotations.RestMethod;
import com.linkedin.restli.server.annotations.ValidatorParam;
import com.linkedin.restli.server.resources.ComplexKeyResource;
import com.linkedin.restli.server.resources.ComplexKeyResourceAsync;
import com.linkedin.restli.server.resources.ComplexKeyResourcePromise;
import com.linkedin.restli.server.resources.ComplexKeyResourceTask;
import com.linkedin.restli.server.resources.KeyValueResource;
import com.linkedin.restli.server.resources.SingleObjectResource;
import com.linkedin.util.CustomTypeUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RestLiAnnotationReader {
    private static final Logger log = LoggerFactory.getLogger(RestLiAnnotationReader.class);
    private static final Pattern INVALID_CHAR_PATTERN = Pattern.compile("\\W");
    private static final Set<ResourceMethod> POST_OR_PUT_RESOURCE_METHODS = new HashSet<ResourceMethod>(Arrays.asList(ResourceMethod.ACTION, ResourceMethod.BATCH_CREATE, ResourceMethod.BATCH_PARTIAL_UPDATE, ResourceMethod.BATCH_UPDATE, ResourceMethod.CREATE, ResourceMethod.PARTIAL_UPDATE, ResourceMethod.UPDATE));

    private RestLiAnnotationReader() {
    }

    public static ResourceModel processResource(Class<?> resourceClass) {
        return RestLiAnnotationReader.processResource(resourceClass, null);
    }

    public static ResourceModel processResource(Class<?> resourceClass, ResourceModel parentResourceModel) {
        ResourceModel model;
        Class<?> clazz;
        RestLiAnnotationReader.checkAnnotation(resourceClass);
        if (resourceClass.isAnnotationPresent(RestLiCollection.class) || resourceClass.isAnnotationPresent(RestLiAssociation.class)) {
            if (!KeyValueResource.class.isAssignableFrom(resourceClass)) {
                throw new RestLiInternalException("Resource class '" + resourceClass.getName() + "' declares RestLi annotation but does not implement " + KeyValueResource.class.getName() + " interface.");
            }
            clazz = resourceClass;
            model = RestLiAnnotationReader.processCollection(clazz, parentResourceModel);
        } else if (resourceClass.isAnnotationPresent(RestLiActions.class)) {
            model = RestLiAnnotationReader.processActions(resourceClass, parentResourceModel);
        } else if (resourceClass.isAnnotationPresent(RestLiSimpleResource.class)) {
            clazz = resourceClass;
            model = RestLiAnnotationReader.processSingleObjectResource(clazz, parentResourceModel);
        } else {
            throw new ResourceConfigException("Class '" + resourceClass.getName() + "' must be annotated with a valid @RestLi... annotation");
        }
        if (parentResourceModel != null) {
            parentResourceModel.addSubResource(model.getName(), model);
        }
        if (!model.isActions()) {
            RestLiAnnotationReader.checkRestLiDataAnnotations(resourceClass, (RecordDataSchema)RestLiAnnotationReader.getDataSchema(model.getValueClass(), null));
        }
        RestLiAnnotationReader.addAlternativeKeys(model, resourceClass);
        DataMap annotationsMap = ResourceModelAnnotation.getAnnotationsMap(resourceClass.getAnnotations());
        RestLiAnnotationReader.addDeprecatedAnnotation(annotationsMap, resourceClass);
        model.setCustomAnnotation(annotationsMap);
        return model;
    }

    private static void addAlternativeKeys(ResourceModel model, Class<?> resourceClass) {
        if (resourceClass.isAnnotationPresent(AlternativeKey.class) || resourceClass.isAnnotationPresent(AlternativeKeys.class)) {
            AlternativeKey[] alternativeKeyAnnotations = resourceClass.isAnnotationPresent(AlternativeKeys.class) ? resourceClass.getAnnotation(AlternativeKeys.class).alternativeKeys() : new AlternativeKey[]{resourceClass.getAnnotation(AlternativeKey.class)};
            HashMap alternativeKeyMap = new HashMap(alternativeKeyAnnotations.length);
            for (AlternativeKey altKeyAnnotation : alternativeKeyAnnotations) {
                com.linkedin.restli.server.AlternativeKey<?, ?> altKey = RestLiAnnotationReader.buildAlternativeKey(model.getName(), altKeyAnnotation);
                alternativeKeyMap.put(altKeyAnnotation.name(), altKey);
            }
            model.putAlternativeKeys(alternativeKeyMap);
        } else {
            model.putAlternativeKeys(new HashMap());
        }
    }

    private static com.linkedin.restli.server.AlternativeKey<?, ?> buildAlternativeKey(String resourceName, AlternativeKey altKeyAnnotation) {
        KeyCoercer keyCoercer;
        String keyName = altKeyAnnotation.name();
        Class<?> keyType = altKeyAnnotation.keyType();
        Class<? extends TyperefInfo> altKeyTyperef = altKeyAnnotation.keyTyperefClass();
        try {
            keyCoercer = altKeyAnnotation.keyCoercer().newInstance();
        }
        catch (InstantiationException e) {
            throw new ResourceConfigException(String.format("KeyCoercer for alternative key '%s' on resource %s cannot be instantiated, %s", keyName, resourceName, e.getMessage()), e);
        }
        catch (IllegalAccessException e) {
            throw new ResourceConfigException(String.format("KeyCoercer for alternative key '%s' on resource %s cannot be instantiated, %s", keyName, resourceName, e.getMessage()), e);
        }
        try {
            com.linkedin.restli.server.AlternativeKey altKey = new com.linkedin.restli.server.AlternativeKey(keyCoercer, keyType, RestLiAnnotationReader.getDataSchema(keyType, RestLiAnnotationReader.getSchemaFromTyperefInfo(altKeyTyperef)));
            return altKey;
        }
        catch (TemplateRuntimeException e) {
            throw new ResourceConfigException(String.format("DataSchema for alternative key '%s' of type %s on resource %s cannot be found; type is invalid or requires typeref.", keyName, keyType, resourceName), e);
        }
        catch (Exception e) {
            throw new ResourceConfigException(String.format("Typeref for alternative key '%s' on resource %s cannot be instantiated, %s", keyName, resourceName, e.getMessage()), e);
        }
    }

    private static void checkAnnotation(Class<?> resourceClass) {
        Class<?> templateClass = resourceClass;
        while (templateClass != Object.class) {
            RestLiTemplate templateAnnotation = (templateClass = templateClass.getSuperclass()).getAnnotation(RestLiTemplate.class);
            if (templateAnnotation == null) continue;
            Class<? extends Annotation> currentExpect = templateAnnotation.expectedAnnotation();
            if (currentExpect == RestLiCollection.class || currentExpect == RestLiAssociation.class || currentExpect == RestLiSimpleResource.class) {
                if (resourceClass.getAnnotation(currentExpect) == null) {
                    throw new ResourceConfigException(resourceClass.getName() + " is not annotated with " + currentExpect.getName() + ", expected by " + templateClass.getName());
                }
                return;
            }
            throw new ResourceConfigException("Unknown expected annotation " + currentExpect.getName() + " from " + templateClass.getName());
        }
    }

    private static DataMap addDeprecatedAnnotation(DataMap annotationsMap, Class<?> clazz) {
        if (clazz.isAnnotationPresent(Deprecated.class)) {
            annotationsMap.put((Object)"deprecated", (Object)new DataMap());
        }
        return annotationsMap;
    }

    private static DataMap addDeprecatedAnnotation(DataMap annotationsMap, AnnotatedElement annotatedElement) {
        if (annotatedElement.isAnnotationPresent(Deprecated.class)) {
            annotationsMap.put((Object)"deprecated", (Object)new DataMap());
        }
        return annotationsMap;
    }

    private static void checkPathsAgainstSchema(RecordDataSchema dataSchema, String resourceClassName, String annotationName, String[] paths) {
        for (String path : paths) {
            if (DataSchemaUtil.containsPath((DataSchema)dataSchema, (String)path)) continue;
            throw new ResourceConfigException("In resource class '" + resourceClassName + "', " + annotationName + " annotation " + path + " is not a valid path for " + dataSchema.getName() + ".");
        }
    }

    private static void checkRestLiDataAnnotations(Class<?> resourceClass, RecordDataSchema dataSchema) {
        HashMap<String, String[]> annotations = new HashMap<String, String[]>();
        if (resourceClass.isAnnotationPresent(ReadOnly.class)) {
            annotations.put(ReadOnly.class.getSimpleName(), resourceClass.getAnnotation(ReadOnly.class).value());
        }
        if (resourceClass.isAnnotationPresent(CreateOnly.class)) {
            annotations.put(CreateOnly.class.getSimpleName(), resourceClass.getAnnotation(CreateOnly.class).value());
        }
        String resourceClassName = resourceClass.getName();
        for (Map.Entry annotationEntry : annotations.entrySet()) {
            RestLiAnnotationReader.checkPathsAgainstSchema(dataSchema, resourceClassName, (String)annotationEntry.getKey(), (String[])annotationEntry.getValue());
        }
        HashMap<String, String> pathToAnnotation = new HashMap<String, String>();
        for (Map.Entry annotationEntry : annotations.entrySet()) {
            String[] paths;
            String annotationName = (String)annotationEntry.getKey();
            for (String path : paths = (String[])annotationEntry.getValue()) {
                String existingAnnotationName = (String)pathToAnnotation.get(path);
                if (existingAnnotationName != null) {
                    if (existingAnnotationName.equals(annotationName)) {
                        throw new ResourceConfigException("In resource class '" + resourceClassName + "', " + path + " is marked as " + annotationName + " multiple times.");
                    }
                    throw new ResourceConfigException("In resource class '" + resourceClassName + "', " + path + " is marked as both " + existingAnnotationName + " and " + annotationName + ".");
                }
                for (Map.Entry existingEntry : pathToAnnotation.entrySet()) {
                    String pathWithSeparator;
                    String existingPath = (String)existingEntry.getKey();
                    existingAnnotationName = (String)existingEntry.getValue();
                    String existingPathWithSeparator = existingPath + DataElement.SEPARATOR;
                    if (existingPathWithSeparator.startsWith(pathWithSeparator = path + DataElement.SEPARATOR)) {
                        throw new ResourceConfigException("In resource class '" + resourceClassName + "', " + existingPath + " is marked as " + existingAnnotationName + ", but is contained in a " + annotationName + " field " + path + ".");
                    }
                    if (!pathWithSeparator.startsWith(existingPathWithSeparator)) continue;
                    throw new ResourceConfigException("In resource class '" + resourceClassName + "', " + path + " is marked as " + annotationName + ", but is contained in a " + existingAnnotationName + " field " + existingPath + ".");
                }
                pathToAnnotation.put(path, annotationName);
            }
        }
    }

    private static ResourceModel processCollection(Class<? extends KeyValueResource<?, ?>> collectionResourceClass, ResourceModel parentResourceModel) {
        RestLiAnnotationData annotationData;
        Class<RecordTemplate> valueClass;
        Class<ComplexResourceKey> keyClass;
        Class<RecordTemplate> keyKeyClass = null;
        Class<RecordTemplate> keyParamsClass = null;
        Class complexKeyResourceBase = null;
        if (ComplexKeyResource.class.isAssignableFrom(collectionResourceClass)) {
            complexKeyResourceBase = ComplexKeyResource.class;
        } else if (ComplexKeyResourceAsync.class.isAssignableFrom(collectionResourceClass)) {
            complexKeyResourceBase = ComplexKeyResourceAsync.class;
        } else if (ComplexKeyResourceTask.class.isAssignableFrom(collectionResourceClass)) {
            complexKeyResourceBase = ComplexKeyResourceTask.class;
        } else if (ComplexKeyResourcePromise.class.isAssignableFrom(collectionResourceClass)) {
            complexKeyResourceBase = ComplexKeyResourcePromise.class;
        }
        if (complexKeyResourceBase != null) {
            List kvParams = complexKeyResourceBase.equals(ComplexKeyResource.class) ? ReflectionUtils.getTypeArguments(ComplexKeyResource.class, collectionResourceClass) : (complexKeyResourceBase.equals(ComplexKeyResourceAsync.class) ? ReflectionUtils.getTypeArguments(ComplexKeyResourceAsync.class, collectionResourceClass) : (complexKeyResourceBase.equals(ComplexKeyResourceTask.class) ? ReflectionUtils.getTypeArguments(ComplexKeyResourceTask.class, collectionResourceClass) : ReflectionUtils.getTypeArguments(ComplexKeyResourcePromise.class, collectionResourceClass)));
            keyClass = ComplexResourceKey.class;
            keyKeyClass = ((Class)kvParams.get(0)).asSubclass(RecordTemplate.class);
            keyParamsClass = ((Class)kvParams.get(1)).asSubclass(RecordTemplate.class);
            valueClass = ((Class)kvParams.get(2)).asSubclass(RecordTemplate.class);
        } else {
            List actualTypeArguments = ReflectionUtils.getTypeArgumentsParametrized(KeyValueResource.class, collectionResourceClass);
            keyClass = ReflectionUtils.getClass((Type)((Type)actualTypeArguments.get(0)));
            if (RecordTemplate.class.isAssignableFrom(keyClass)) {
                throw new ResourceConfigException("Class '" + collectionResourceClass.getName() + "' should implement 'ComplexKeyResource' as a complex key '" + keyClass.getName() + "' is being used.");
            }
            if (TyperefInfo.class.isAssignableFrom(keyClass)) {
                throw new ResourceConfigException("Typeref '" + keyClass.getName() + "' cannot be key type for class '" + collectionResourceClass.getName() + "'.");
            }
            if (keyClass.equals(ComplexResourceKey.class)) {
                Type[] typeArguments = ((ParameterizedType)actualTypeArguments.get(0)).getActualTypeArguments();
                keyKeyClass = ReflectionUtils.getClass((Type)typeArguments[0]).asSubclass(RecordTemplate.class);
                keyParamsClass = ReflectionUtils.getClass((Type)typeArguments[1]).asSubclass(RecordTemplate.class);
            }
            valueClass = ReflectionUtils.getClass((Type)((Type)actualTypeArguments.get(1))).asSubclass(RecordTemplate.class);
        }
        ResourceType resourceType = RestLiAnnotationReader.getResourceType(collectionResourceClass);
        if (collectionResourceClass.isAnnotationPresent(RestLiCollection.class)) {
            annotationData = new RestLiAnnotationData(collectionResourceClass.getAnnotation(RestLiCollection.class));
        } else if (collectionResourceClass.isAnnotationPresent(RestLiAssociation.class)) {
            annotationData = new RestLiAnnotationData(collectionResourceClass.getAnnotation(RestLiAssociation.class));
        } else {
            throw new ResourceConfigException("No valid annotation on resource class '" + collectionResourceClass.getName() + "'");
        }
        String name = annotationData.name();
        String namespace = annotationData.namespace();
        String keyName = annotationData.keyName() == null ? name + "Id" : annotationData.keyName();
        com.linkedin.restli.server.Key primaryKey = RestLiAnnotationReader.buildKey(name, keyName, keyClass, annotationData.typerefInfoClass());
        HashSet<com.linkedin.restli.server.Key> keys = new HashSet<com.linkedin.restli.server.Key>();
        if (annotationData.keys() == null) {
            keys.add(primaryKey);
        } else {
            keys.addAll(RestLiAnnotationReader.buildKeys(name, annotationData.keys()));
        }
        Class<?> parentResourceClass = annotationData.parent().equals(RestAnnotations.ROOT.class) ? null : annotationData.parent();
        ResourceModel collectionModel = new ResourceModel(primaryKey, keyKeyClass, keyParamsClass, keys, valueClass, collectionResourceClass, parentResourceClass, name, resourceType, namespace);
        collectionModel.setParentResourceModel(parentResourceModel);
        RestLiAnnotationReader.addResourceMethods(collectionResourceClass, collectionModel);
        log.info("Processed collection resource '" + collectionResourceClass.getName() + "'");
        return collectionModel;
    }

    private static ResourceModel processSingleObjectResource(Class<? extends SingleObjectResource<?>> singleObjectResourceClass, ResourceModel parentResource) {
        List kvParams = ReflectionUtils.getTypeArguments(SingleObjectResource.class, singleObjectResourceClass);
        Class<RecordTemplate> valueClass = ((Class)kvParams.get(0)).asSubclass(RecordTemplate.class);
        ResourceType resourceType = RestLiAnnotationReader.getResourceType(singleObjectResourceClass);
        if (!singleObjectResourceClass.isAnnotationPresent(RestLiSimpleResource.class)) {
            throw new ResourceConfigException("No valid annotation on resource class '" + singleObjectResourceClass.getName() + "'");
        }
        RestLiAnnotationData annotationData = new RestLiAnnotationData(singleObjectResourceClass.getAnnotation(RestLiSimpleResource.class));
        String name = annotationData.name();
        String namespace = annotationData.namespace();
        Class<?> parentResourceClass = annotationData.parent().equals(RestAnnotations.ROOT.class) ? null : annotationData.parent();
        ResourceModel singleObjectResourceModel = new ResourceModel(valueClass, singleObjectResourceClass, parentResourceClass, name, resourceType, namespace);
        singleObjectResourceModel.setParentResourceModel(parentResource);
        RestLiAnnotationReader.addResourceMethods(singleObjectResourceClass, singleObjectResourceModel);
        log.info("Processed single object resource '" + singleObjectResourceClass.getName() + "'");
        return singleObjectResourceModel;
    }

    private static ResourceType getResourceType(Class<?> resourceClass) {
        RestLiCollection collAnno = resourceClass.getAnnotation(RestLiCollection.class);
        RestLiAssociation assocAnno = resourceClass.getAnnotation(RestLiAssociation.class);
        RestLiSimpleResource simpleResourceAnno = resourceClass.getAnnotation(RestLiSimpleResource.class);
        if (resourceClass.isAnnotationPresent(RestLiActions.class)) {
            throw new ResourceConfigException("Resource class '" + resourceClass.getName() + "' cannot have both @RestLiCollection and @RestLiActions annotations.");
        }
        int annoCount = 0;
        annoCount += collAnno != null ? 1 : 0;
        annoCount += assocAnno != null ? 1 : 0;
        if ((annoCount += simpleResourceAnno != null ? 1 : 0) > 1) {
            throw new ResourceConfigException("Class '" + resourceClass.getName() + "' is annotated with too many RestLi annotations");
        }
        if (collAnno != null) {
            return ResourceType.COLLECTION;
        }
        if (assocAnno != null) {
            return ResourceType.ASSOCIATION;
        }
        if (simpleResourceAnno != null) {
            return ResourceType.SIMPLE;
        }
        throw new ResourceConfigException("Class '" + resourceClass.getName() + "' should be annotated with '" + RestLiAssociation.class.getName() + "' or '" + RestLiCollection.class.getName() + "' or '" + RestLiSimpleResource.class.getName() + "'");
    }

    private static Parameter<?> getPositionalParameter(ResourceModel model, ResourceMethod methodType, int idx, AnnotationSet annotations) {
        boolean isSingleObjectResource = model.getResourceType() == ResourceType.SIMPLE;
        Parameter<?> parameter = null;
        parameter = isSingleObjectResource ? RestLiAnnotationReader.getPositionalParameterForSingleObject(model, methodType, idx, annotations) : RestLiAnnotationReader.getPositionalParameterForCollection(model, methodType, idx, annotations);
        return parameter;
    }

    private static Parameter<?> getPositionalParameterForCollection(ResourceModel model, ResourceMethod methodType, int idx, AnnotationSet annotations) {
        switch (methodType) {
            case GET: {
                if (idx != 0) break;
                return RestLiAnnotationReader.makeKeyParam(model);
            }
            case CREATE: {
                if (idx != 0) break;
                return RestLiAnnotationReader.makeValueParam(model);
            }
            case UPDATE: {
                if (idx == 0) {
                    return RestLiAnnotationReader.makeKeyParam(model);
                }
                if (idx != 1) break;
                return RestLiAnnotationReader.makeValueParam(model);
            }
            case DELETE: {
                if (idx != 0) break;
                return RestLiAnnotationReader.makeKeyParam(model);
            }
            case PARTIAL_UPDATE: {
                if (idx == 0) {
                    return RestLiAnnotationReader.makeKeyParam(model);
                }
                if (idx != 1) break;
                return RestLiAnnotationReader.makePatchParam(annotations);
            }
            case BATCH_GET: {
                if (idx != 0) break;
                Parameter<Set> p = new Parameter<Set>("", Set.class, null, false, null, Parameter.ParamType.BATCH, false, annotations);
                return p;
            }
            case BATCH_CREATE: {
                if (idx != 0) break;
                Parameter<BatchCreateRequest> p = new Parameter<BatchCreateRequest>("", BatchCreateRequest.class, null, false, null, Parameter.ParamType.BATCH, false, annotations);
                return p;
            }
            case BATCH_UPDATE: {
                if (idx != 0) break;
                Parameter<BatchUpdateRequest> p = new Parameter<BatchUpdateRequest>("", BatchUpdateRequest.class, null, false, null, Parameter.ParamType.BATCH, false, annotations);
                return p;
            }
            case BATCH_DELETE: {
                if (idx != 0) break;
                Parameter<BatchDeleteRequest> p = new Parameter<BatchDeleteRequest>("", BatchDeleteRequest.class, null, false, null, Parameter.ParamType.BATCH, false, annotations);
                return p;
            }
            case BATCH_PARTIAL_UPDATE: {
                if (idx != 0) break;
                Parameter<BatchPatchRequest> p = new Parameter<BatchPatchRequest>("", BatchPatchRequest.class, null, false, null, Parameter.ParamType.BATCH, false, annotations);
                return p;
            }
        }
        return null;
    }

    private static Parameter<?> getPositionalParameterForSingleObject(ResourceModel model, ResourceMethod methodType, int idx, AnnotationSet annotations) {
        Parameter<?> parameter = null;
        switch (methodType) {
            case UPDATE: {
                if (idx != 0) break;
                return RestLiAnnotationReader.makeValueParam(model);
            }
            case PARTIAL_UPDATE: {
                if (idx != 0) break;
                return RestLiAnnotationReader.makePatchParam(annotations);
            }
        }
        return parameter;
    }

    private static Parameter<?> makeValueParam(ResourceModel model) {
        return new Parameter<RecordTemplate>("", model.getValueClass(), RestLiAnnotationReader.getDataSchema(model.getValueClass(), null), false, null, Parameter.ParamType.POST, false, AnnotationSet.EMPTY);
    }

    private static Parameter makeKeyParam(ResourceModel model) {
        return new Parameter(model.getKeyName(), model.getKeyClass(), model.getPrimaryKey().getDataSchema(), false, null, Parameter.ParamType.RESOURCE_KEY, false, AnnotationSet.EMPTY);
    }

    private static Parameter makePatchParam(AnnotationSet annotations) {
        return new Parameter<PatchRequest>("", PatchRequest.class, null, false, null, Parameter.ParamType.POST, false, annotations);
    }

    private static String getDefaultValueData(Optional optional) {
        if (optional == null || optional.value() == null || optional.value().equals("__DEFAULT__")) {
            return null;
        }
        return optional.value();
    }

    private static List<Parameter<?>> getParameters(ResourceModel model, Method method, ResourceMethod methodType) {
        HashSet<String> paramNames = new HashSet<String>();
        ArrayList queryParameters = new ArrayList();
        Annotation[][] paramsAnnos = method.getParameterAnnotations();
        for (int idx = 0; idx < paramsAnnos.length; ++idx) {
            AnnotationSet paramAnnotations = new AnnotationSet(paramsAnnos[idx]);
            Class<?> paramType = method.getParameterTypes()[idx];
            Parameter<Object> param = RestLiAnnotationReader.getPositionalParameter(model, methodType, idx, paramAnnotations);
            if (param == null) {
                if (paramAnnotations.contains(QueryParam.class)) {
                    param = RestLiAnnotationReader.buildQueryParam(method, paramAnnotations, paramType);
                } else if (paramAnnotations.contains(ActionParam.class)) {
                    param = RestLiAnnotationReader.buildActionParam(method, paramAnnotations, paramType);
                } else if (paramAnnotations.contains(AssocKey.class)) {
                    param = RestLiAnnotationReader.buildAssocKeyParam(model, method, paramAnnotations, paramType, AssocKey.class);
                } else if (paramAnnotations.contains(AssocKeyParam.class)) {
                    param = RestLiAnnotationReader.buildAssocKeyParam(model, method, paramAnnotations, paramType, AssocKeyParam.class);
                } else if (paramAnnotations.contains(Context.class)) {
                    param = RestLiAnnotationReader.buildPagingContextParam(paramAnnotations, paramType, Context.class);
                } else if (paramAnnotations.contains(PagingContextParam.class)) {
                    param = RestLiAnnotationReader.buildPagingContextParam(paramAnnotations, paramType, PagingContextParam.class);
                } else if (paramAnnotations.contains(CallbackParam.class)) {
                    param = RestLiAnnotationReader.buildCallbackParam(method, methodType, idx, paramType, paramAnnotations);
                } else if (paramAnnotations.contains(ParSeqContextParam.class)) {
                    param = RestLiAnnotationReader.buildParSeqContextParam(method, methodType, idx, paramType, paramAnnotations, ParSeqContextParam.class);
                } else if (paramAnnotations.contains(ParSeqContext.class)) {
                    param = RestLiAnnotationReader.buildParSeqContextParam(method, methodType, idx, paramType, paramAnnotations, ParSeqContext.class);
                } else if (paramAnnotations.contains(Projection.class)) {
                    param = RestLiAnnotationReader.buildProjectionParam(paramAnnotations, paramType, Parameter.ParamType.PROJECTION);
                } else if (paramAnnotations.contains(ProjectionParam.class)) {
                    param = RestLiAnnotationReader.buildProjectionParam(paramAnnotations, paramType, Parameter.ParamType.PROJECTION_PARAM);
                } else if (paramAnnotations.contains(MetadataProjectionParam.class)) {
                    param = RestLiAnnotationReader.buildProjectionParam(paramAnnotations, paramType, Parameter.ParamType.METADATA_PROJECTION_PARAM);
                } else if (paramAnnotations.contains(PagingProjectionParam.class)) {
                    param = RestLiAnnotationReader.buildProjectionParam(paramAnnotations, paramType, Parameter.ParamType.PAGING_PROJECTION_PARAM);
                } else if (paramAnnotations.contains(Keys.class)) {
                    param = RestLiAnnotationReader.buildPathKeysParam(paramAnnotations, paramType, Keys.class);
                } else if (paramAnnotations.contains(PathKeysParam.class)) {
                    param = RestLiAnnotationReader.buildPathKeysParam(paramAnnotations, paramType, PathKeysParam.class);
                } else if (paramAnnotations.contains(PathKeyParam.class)) {
                    param = RestLiAnnotationReader.buildPathKeyParam(model, paramAnnotations, paramType, PathKeyParam.class);
                } else if (paramAnnotations.contains(HeaderParam.class)) {
                    param = RestLiAnnotationReader.buildHeaderParam(paramAnnotations, paramType);
                } else if (paramAnnotations.contains(ResourceContextParam.class)) {
                    param = RestLiAnnotationReader.buildResourceContextParam(paramAnnotations, paramType);
                } else if (paramAnnotations.contains(ValidatorParam.class)) {
                    param = RestLiAnnotationReader.buildValidatorParam(paramAnnotations, paramType);
                } else if (paramAnnotations.contains(RestLiAttachmentsParam.class)) {
                    param = RestLiAnnotationReader.buildRestLiAttachmentsParam(paramAnnotations, paramType);
                } else {
                    throw new ResourceConfigException(RestLiAnnotationReader.buildMethodMessage(method) + " must annotate each parameter with @QueryParam, @ActionParam, @AssocKeyParam, @PagingContextParam, @ProjectionParam, @MetadataProjectionParam, @PagingProjectionParam, @PathKeysParam, @PathKeyParam, @HeaderParam, @CallbackParam, @ResourceContext, @ParSeqContextParam, @ValidatorParam, @RestLiAttachmentsParam, or @ValidateParam");
                }
            }
            if (param == null) continue;
            RestLiAnnotationReader.validateParameter(method, methodType, paramNames, paramAnnotations, param, paramType);
            queryParameters.add(param);
        }
        return queryParameters;
    }

    private static Parameter<ResourceContext> buildResourceContextParam(AnnotationSet annotations, Class<?> paramType) {
        if (!paramType.equals(ResourceContext.class)) {
            throw new ResourceConfigException("Incorrect data type for param: @" + ResourceContextParam.class.getSimpleName() + " parameter annotation must be of type " + ResourceContext.class.getName());
        }
        Optional optional = annotations.get(Optional.class);
        return new Parameter<ResourceContext>("", paramType, null, optional != null, null, Parameter.ParamType.RESOURCE_CONTEXT_PARAM, false, annotations);
    }

    private static Parameter<RestLiDataValidator> buildValidatorParam(AnnotationSet annotations, Class<?> paramType) {
        if (!paramType.equals(RestLiDataValidator.class)) {
            throw new ResourceConfigException("Incorrect data type for param: @" + ValidatorParam.class.getSimpleName() + " parameter annotation must be of type " + RestLiDataValidator.class.getName());
        }
        return new Parameter<RestLiDataValidator>("validator", paramType, null, false, null, Parameter.ParamType.VALIDATOR_PARAM, false, annotations);
    }

    private static Parameter<RestLiAttachmentReader> buildRestLiAttachmentsParam(AnnotationSet annotations, Class<?> paramType) {
        if (!paramType.equals(RestLiAttachmentReader.class)) {
            throw new ResourceConfigException("Incorrect data type for param: @" + RestLiAttachmentsParam.class.getSimpleName() + " parameter annotation must be of type " + RestLiAttachmentReader.class.getName());
        }
        return new Parameter<RestLiAttachmentReader>("RestLi Attachment Reader", paramType, null, false, null, Parameter.ParamType.RESTLI_ATTACHMENTS_PARAM, false, annotations);
    }

    private static Parameter buildCallbackParam(Method method, ResourceMethod methodType, int idx, Class<?> paramType, AnnotationSet annotations) {
        if (!Callback.class.equals(paramType)) {
            throw new ResourceConfigException(String.format("%s '%s' of class '%s' does not have a proper callback", methodType, method.getName(), method.getDeclaringClass().getName()));
        }
        Parameter param = new Parameter("", paramType, null, false, null, Parameter.ParamType.CALLBACK, false, annotations);
        return param;
    }

    private static Parameter<com.linkedin.parseq.Context> buildParSeqContextParam(Method method, ResourceMethod methodType, int idx, Class<?> paramType, AnnotationSet annotations, Class<?> paramAnnotationType) {
        if (!com.linkedin.parseq.Context.class.equals(paramType)) {
            throw new ResourceConfigException("Incorrect data type for param: @" + ParSeqContextParam.class.getSimpleName() + " or @" + ParSeqContext.class.getSimpleName() + " parameter annotation must be of type " + com.linkedin.parseq.Context.class.getName());
        }
        if (RestLiAnnotationReader.getInterfaceType(method) != ResourceMethodDescriptor.InterfaceType.PROMISE) {
            throw new ResourceConfigException("Cannot have ParSeq context on non-promise method");
        }
        Parameter.ParamType parameter = null;
        if (paramAnnotationType.equals(ParSeqContext.class)) {
            parameter = Parameter.ParamType.PARSEQ_CONTEXT;
        } else if (paramAnnotationType.equals(ParSeqContextParam.class)) {
            parameter = Parameter.ParamType.PARSEQ_CONTEXT_PARAM;
        } else {
            throw new ResourceConfigException("Param Annotation type must be 'ParseqContextParam' or the deprecated 'ParseqContext' for ParseqContext");
        }
        return new Parameter<com.linkedin.parseq.Context>("", com.linkedin.parseq.Context.class, null, false, null, parameter, false, annotations);
    }

    private static Integer annotationCount(AnnotationSet annotations) {
        return annotations.count(QueryParam.class, ActionParam.class, AssocKeyParam.class, PagingContextParam.class, CallbackParam.class, ParSeqContextParam.class, RestLiAttachmentsParam.class);
    }

    private static void validateParameter(Method method, ResourceMethod methodType, Set<String> paramNames, AnnotationSet annotations, Parameter<?> param, Class<?> actualParamType) {
        String paramName = param.getName();
        if (!paramName.isEmpty() && paramNames.contains(paramName)) {
            throw new ResourceConfigException("Parameter '" + paramName + "' on " + RestLiAnnotationReader.buildMethodMessage(method) + " is specified more than once");
        }
        paramNames.add(paramName);
        if (!actualParamType.isAssignableFrom(param.getType())) {
            throw new ResourceConfigException("Parameter '" + paramName + "' on " + RestLiAnnotationReader.buildMethodMessage(method) + " is not a valid type '" + actualParamType + "'.  Must be assignable from '" + param.getType() + "'.");
        }
        if (!POST_OR_PUT_RESOURCE_METHODS.contains(methodType) && annotations.contains(RestLiAttachmentsParam.class)) {
            throw new ResourceConfigException("Parameter '" + paramName + "' on " + RestLiAnnotationReader.buildMethodMessage(method) + " is only allowed within the following resource methods: " + POST_OR_PUT_RESOURCE_METHODS.toString());
        }
        if (methodType == ResourceMethod.ACTION) {
            if (annotations.contains(QueryParam.class)) {
                throw new ResourceConfigException("Parameter '" + paramName + "' on " + RestLiAnnotationReader.buildMethodMessage(method) + " is a @QueryParam but action method cannot have @QueryParam");
            }
            if (param.getParamType() == Parameter.ParamType.POST && !RestLiAnnotationReader.checkParameterType(param.getType(), RestModelConstants.VALID_ACTION_PARAMETER_TYPES) && !RestLiAnnotationReader.checkParameterHasTyperefSchema(param)) {
                throw new ResourceConfigException("Parameter '" + paramName + "' on " + RestLiAnnotationReader.buildMethodMessage(method) + " is not a valid type (" + param.getType() + ')');
            }
        } else {
            if (annotations.contains(ActionParam.class)) {
                throw new ResourceConfigException("Parameter '" + paramName + "' on " + RestLiAnnotationReader.buildMethodMessage(method) + " is a @ActionParam but non-action method cannot have @ActionParam");
            }
            if (param.getParamType() == Parameter.ParamType.QUERY && !RestLiAnnotationReader.checkParameterType(param.getType(), RestModelConstants.VALID_QUERY_PARAMETER_TYPES) && !RestLiAnnotationReader.checkParameterHasTyperefSchema(param)) {
                throw new ResourceConfigException("Parameter '" + paramName + "' on " + RestLiAnnotationReader.buildMethodMessage(method) + " is not a valid type (" + param.getType() + ')');
            }
        }
        if (param.getType().isPrimitive() && param.isOptional() && !param.hasDefaultValue()) {
            throw new ResourceConfigException("Parameter '" + paramName + "' on " + RestLiAnnotationReader.buildMethodMessage(method) + " is a primitive type, but does not specify a default value in the @Optional annotation");
        }
        String checkTyperefMessage = RestLiAnnotationReader.checkTyperefSchema(param.getType(), param.getDataSchema());
        if (checkTyperefMessage != null) {
            throw new ResourceConfigException("Parameter '" + paramName + "' on " + RestLiAnnotationReader.buildMethodMessage(method) + ", " + checkTyperefMessage);
        }
        if (RestLiAnnotationReader.annotationCount(annotations) > 1) {
            throw new ResourceConfigException(RestLiAnnotationReader.buildMethodMessage(method) + "' must declare only one of @QueryParam, @ActionParam, @AssocKeyParam, @PagingContextParam, @CallbackParam or @RestLiAttachmentsParam");
        }
    }

    private static boolean checkParameterHasTyperefSchema(Parameter<?> parameter) {
        boolean result = false;
        DataSchema dataSchema = parameter.getDataSchema();
        Class dataType = parameter.getType();
        if (dataType.isArray()) {
            if (dataSchema instanceof ArrayDataSchema) {
                dataSchema = ((ArrayDataSchema)dataSchema).getItems();
            } else {
                throw new ResourceConfigException("Array typed parameter " + parameter.getName() + " must have an array schema.");
            }
        }
        if (dataSchema instanceof TyperefDataSchema) {
            result = true;
        }
        return result;
    }

    private static Set<com.linkedin.restli.server.Key> buildKeys(String resourceName, Key[] annoKeys) {
        HashSet<com.linkedin.restli.server.Key> keys = new HashSet<com.linkedin.restli.server.Key>();
        for (Key key : annoKeys) {
            keys.add(RestLiAnnotationReader.buildKey(resourceName, key.name(), key.type(), key.typeref()));
        }
        return keys;
    }

    private static com.linkedin.restli.server.Key buildKey(String resourceName, String keyName, Class<?> keyType, Class<? extends TyperefInfo> typerefInfoClass) {
        try {
            if (typerefInfoClass != RestAnnotations.NULL_TYPEREF_INFO.class && DataSchemaUtil.classToPrimitiveDataSchema(keyType) == null) {
                Custom.initializeCustomClass(keyType);
            }
            return new com.linkedin.restli.server.Key(keyName, keyType, RestLiAnnotationReader.getDataSchema(keyType, RestLiAnnotationReader.getSchemaFromTyperefInfo(typerefInfoClass)));
        }
        catch (TemplateRuntimeException e) {
            throw new ResourceConfigException("DataSchema for key '" + keyName + "' of type " + keyType + " on resource " + resourceName + "cannot be found; type is invalid or requires typeref", e);
        }
        catch (Exception e) {
            throw new ResourceConfigException("Typeref for parameter '" + keyName + "' on resource " + resourceName + " cannot be instantiated, " + e.getMessage(), e);
        }
    }

    private static Parameter<?> buildProjectionParam(AnnotationSet annotations, Class<?> paramType, Parameter.ParamType projectionType) {
        if (!paramType.equals(MaskTree.class)) {
            throw new ResourceConfigException("Incorrect data type for param: @" + ProjectionParam.class.getSimpleName() + ", @" + Projection.class.getSimpleName() + ", @" + MetadataProjectionParam.class.getSimpleName() + " or @" + PagingProjectionParam.class.getSimpleName() + " parameter annotation must be of type " + MaskTree.class.getName());
        }
        Optional optional = annotations.get(Optional.class);
        Parameter param = new Parameter("", paramType, null, optional != null, null, projectionType, false, annotations);
        return param;
    }

    private static void checkIfKeyIsValid(String paramName, Class<?> paramType, ResourceModel model) {
        for (ResourceModel nextModel = model.getParentResourceModel(); nextModel != null; nextModel = nextModel.getParentResourceModel()) {
            Set<com.linkedin.restli.server.Key> keys = nextModel.getKeys();
            for (com.linkedin.restli.server.Key key : keys) {
                if (!key.getName().equals(paramName)) continue;
                return;
            }
        }
        throw new ResourceConfigException("Parameter " + paramName + " not found in path keys of class " + model.getResourceClass());
    }

    private static Parameter<?> buildPathKeyParam(ResourceModel model, AnnotationSet annotations, Class<?> paramType, Class<?> paramAnnotationType) {
        String paramName = annotations.get(PathKeyParam.class).value();
        RestLiAnnotationReader.checkIfKeyIsValid(paramName, paramType, model);
        Parameter param = new Parameter(paramName, paramType, null, annotations.get(Optional.class) != null, null, Parameter.ParamType.PATH_KEY_PARAM, false, annotations);
        return param;
    }

    private static Parameter<?> buildPathKeysParam(AnnotationSet annotations, Class<?> paramType, Class<?> paramAnnotationType) {
        if (!paramType.equals(PathKeys.class)) {
            throw new ResourceConfigException("Incorrect data type for param: @" + PathKeysParam.class.getSimpleName() + " or @" + Keys.class.getSimpleName() + " parameter annotation must be of type " + PathKeys.class.getName());
        }
        Optional optional = annotations.get(Optional.class);
        Parameter.ParamType parameter = null;
        if (paramAnnotationType.equals(Keys.class)) {
            parameter = Parameter.ParamType.PATH_KEYS;
        } else if (paramAnnotationType.equals(PathKeysParam.class)) {
            parameter = Parameter.ParamType.PATH_KEYS_PARAM;
        } else {
            throw new ResourceConfigException("Param Annotation type must be 'PathKeysParam' or the deprecated 'Keys' for PathKeys");
        }
        Parameter param = new Parameter("", paramType, null, optional != null, new PathKeysImpl(), parameter, false, annotations);
        return param;
    }

    private static Parameter<?> buildHeaderParam(AnnotationSet annotations, Class<?> paramType) {
        if (!paramType.equals(String.class)) {
            throw new ResourceConfigException("Incorrect data type for param: @" + HeaderParam.class.getSimpleName() + " parameter annotation must be of type String");
        }
        Optional optional = annotations.get(Optional.class);
        Parameter param = new Parameter("", paramType, null, optional != null, "", Parameter.ParamType.HEADER, false, annotations);
        return param;
    }

    private static Parameter<?> buildPagingContextParam(AnnotationSet annotations, Class<?> paramType, Class<?> paramAnnotationType) {
        if (!paramType.equals(PagingContext.class)) {
            throw new ResourceConfigException("Incorrect data type for param: @" + PagingContextParam.class.getSimpleName() + " or @" + Context.class.getSimpleName() + " parameter annotation must be of type " + PagingContext.class.getName());
        }
        PagingContext defaultContext = null;
        Parameter.ParamType parameter = null;
        if (paramAnnotationType.equals(PagingContextParam.class)) {
            PagingContextParam pagingContextParam = annotations.get(PagingContextParam.class);
            defaultContext = new PagingContext(pagingContextParam.defaultStart(), pagingContextParam.defaultCount(), false, false);
            parameter = Parameter.ParamType.PAGING_CONTEXT_PARAM;
        } else if (paramAnnotationType.equals(Context.class)) {
            Context contextParam = annotations.get(Context.class);
            defaultContext = new PagingContext(contextParam.defaultStart(), contextParam.defaultCount(), false, false);
            parameter = Parameter.ParamType.CONTEXT;
        } else {
            throw new ResourceConfigException("Param Annotation type must be 'PagingContextParam' or the deprecated 'Context' for PagingContext");
        }
        Optional optional = annotations.get(Optional.class);
        Parameter param = new Parameter("", paramType, null, optional != null, defaultContext, parameter, false, annotations);
        return param;
    }

    private static boolean checkAssocKey(Set<com.linkedin.restli.server.Key> keys, String assocKeyValue) {
        for (com.linkedin.restli.server.Key k : keys) {
            if (!k.getName().equals(assocKeyValue)) continue;
            return true;
        }
        return false;
    }

    private static Parameter<?> buildAssocKeyParam(ResourceModel model, Method method, AnnotationSet annotations, Class<?> paramType, Class<?> paramAnnotationType) {
        Parameter.ParamType parameter = null;
        String assocKeyParamValue = null;
        Class<? extends TyperefInfo> typerefInfoClass = null;
        if (paramAnnotationType.equals(AssocKey.class)) {
            parameter = Parameter.ParamType.KEY;
            assocKeyParamValue = annotations.get(AssocKey.class).value();
            typerefInfoClass = annotations.get(AssocKey.class).typeref();
        } else if (paramAnnotationType.equals(AssocKeyParam.class)) {
            parameter = Parameter.ParamType.ASSOC_KEY_PARAM;
            assocKeyParamValue = annotations.get(AssocKeyParam.class).value();
            typerefInfoClass = annotations.get(AssocKeyParam.class).typeref();
        } else {
            throw new ResourceConfigException("Param Annotation type must be 'AssocKeysParam' or the deprecated 'AssocKey' for AssocKey");
        }
        Optional optional = annotations.get(Optional.class);
        if (!RestLiAnnotationReader.checkAssocKey(model.getKeys(), assocKeyParamValue)) {
            throw new ResourceConfigException("Non-existing assocKey '" + assocKeyParamValue + "' on " + RestLiAnnotationReader.buildMethodMessage(method));
        }
        try {
            Parameter param = new Parameter(assocKeyParamValue, paramType, RestLiAnnotationReader.getDataSchema(paramType, RestLiAnnotationReader.getSchemaFromTyperefInfo(typerefInfoClass)), optional != null, RestLiAnnotationReader.getDefaultValueData(optional), parameter, true, annotations);
            return param;
        }
        catch (TemplateRuntimeException e) {
            throw new ResourceConfigException("DataSchema for assocKey '" + assocKeyParamValue + "' of type " + paramType.getSimpleName() + " on " + RestLiAnnotationReader.buildMethodMessage(method) + "cannot be found; type is invalid or requires typeref", e);
        }
        catch (Exception e) {
            throw new ResourceConfigException("Typeref for assocKey '" + assocKeyParamValue + "' on " + RestLiAnnotationReader.buildMethodMessage(method) + " cannot be instantiated, " + e.getMessage(), e);
        }
    }

    private static Parameter buildActionParam(Method method, AnnotationSet annotations, Class<?> paramType) {
        ActionParam actionParam = annotations.get(ActionParam.class);
        Optional optional = annotations.get(Optional.class);
        String paramName = actionParam.value();
        Class<? extends TyperefInfo> typerefInfoClass = actionParam.typeref();
        try {
            Parameter param = new Parameter(paramName, paramType, RestLiAnnotationReader.getDataSchema(paramType, RestLiAnnotationReader.getSchemaFromTyperefInfo(typerefInfoClass)), optional != null, RestLiAnnotationReader.getDefaultValueData(optional), Parameter.ParamType.POST, true, annotations);
            return param;
        }
        catch (TemplateRuntimeException e) {
            throw new ResourceConfigException("DataSchema for parameter '" + paramName + "' of type " + paramType.getSimpleName() + " on " + RestLiAnnotationReader.buildMethodMessage(method) + "cannot be found; type is invalid or requires typeref", e);
        }
        catch (Exception e) {
            throw new ResourceConfigException("Typeref for parameter '" + paramName + "' on " + RestLiAnnotationReader.buildMethodMessage(method) + " cannot be instantiated, " + e.getMessage(), e);
        }
    }

    private static TyperefDataSchema getSchemaFromTyperefInfo(Class<? extends TyperefInfo> typerefInfoClass) throws IllegalAccessException, InstantiationException {
        if (typerefInfoClass == null) {
            return null;
        }
        TyperefInfo typerefInfo = typerefInfoClass.newInstance();
        return typerefInfo.getSchema();
    }

    private static DataSchema getDataSchema(Class<?> type, TyperefDataSchema typerefDataSchema) {
        if (type == Void.TYPE) {
            return null;
        }
        if (typerefDataSchema != null) {
            if (type.isArray()) {
                return new ArrayDataSchema((DataSchema)typerefDataSchema);
            }
            return typerefDataSchema;
        }
        if (RestModelConstants.CLASSES_WITHOUT_SCHEMAS.contains(type)) {
            return null;
        }
        if (type.isArray()) {
            Object itemSchema = HasTyperefInfo.class.isAssignableFrom(type.getComponentType()) ? DataTemplateUtil.getTyperefInfo(type.getComponentType().asSubclass(DataTemplate.class)).getSchema() : DataTemplateUtil.getSchema(type.getComponentType());
            return new ArrayDataSchema(itemSchema);
        }
        return DataTemplateUtil.getSchema(type);
    }

    private static Parameter<?> buildQueryParam(Method method, AnnotationSet annotations, Class<?> paramType) {
        QueryParam queryParam = annotations.get(QueryParam.class);
        Optional optional = annotations.get(Optional.class);
        String paramName = queryParam.value();
        if (INVALID_CHAR_PATTERN.matcher(paramName).find()) {
            throw new ResourceConfigException("Unsupported character in the parameter name :" + paramName);
        }
        Class<? extends TyperefInfo> typerefInfoClass = queryParam.typeref();
        try {
            Parameter param = new Parameter(queryParam.value(), paramType, RestLiAnnotationReader.getDataSchema(paramType, RestLiAnnotationReader.getSchemaFromTyperefInfo(typerefInfoClass)), optional != null, RestLiAnnotationReader.getDefaultValueData(optional), Parameter.ParamType.QUERY, true, annotations);
            return param;
        }
        catch (TemplateRuntimeException e) {
            throw new ResourceConfigException("DataSchema for parameter '" + paramName + "' of type " + paramType.getSimpleName() + " on " + RestLiAnnotationReader.buildMethodMessage(method) + "cannot be found; type is invalid or requires typeref", e);
        }
        catch (Exception e) {
            throw new ResourceConfigException("Typeref for parameter '" + paramName + "' on " + RestLiAnnotationReader.buildMethodMessage(method) + " cannot be instantiated, " + e.getMessage(), e);
        }
    }

    private static String buildMethodMessage(Method method) {
        return "Method '" + method.getName() + "' method on class '" + method.getDeclaringClass().getName() + '\'';
    }

    private static void registerCoercerForPrimitiveTypeRefArray(ArrayDataSchema schema) {
        TyperefDataSchema typerefSchema;
        DataSchema elementSchema = schema.getItems();
        if (elementSchema instanceof TyperefDataSchema && RestModelConstants.PRIMITIVE_DATA_SCHEMA_TYPE_ALLOWED_TYPES.containsKey((typerefSchema = (TyperefDataSchema)elementSchema).getDereferencedType()) && CustomTypeUtil.getJavaCustomTypeClassNameFromSchema((DataSchema)typerefSchema) != null) {
            RestLiAnnotationReader.registerCoercer(typerefSchema);
        }
    }

    private static String checkTyperefSchema(Class<?> type, DataSchema dataSchema) {
        boolean ok;
        if (type.isArray() && dataSchema instanceof ArrayDataSchema) {
            RestLiAnnotationReader.registerCoercerForPrimitiveTypeRefArray((ArrayDataSchema)dataSchema);
        }
        if (!(dataSchema instanceof TyperefDataSchema)) {
            return null;
        }
        TyperefDataSchema typerefSchema = (TyperefDataSchema)dataSchema;
        DataSchema.Type schemaType = typerefSchema.getDereferencedType();
        Class<?>[] validTypes = RestModelConstants.PRIMITIVE_DATA_SCHEMA_TYPE_ALLOWED_TYPES.get(schemaType);
        if (validTypes != null) {
            String javaClassNameFromSchema = CustomTypeUtil.getJavaCustomTypeClassNameFromSchema((DataSchema)typerefSchema);
            if (javaClassNameFromSchema != null) {
                RestLiAnnotationReader.registerCoercer(typerefSchema);
                ok = type.getName().equals(javaClassNameFromSchema) || type.isArray() && type.getComponentType().getName().equals(javaClassNameFromSchema);
            } else {
                ok = RestLiAnnotationReader.checkParameterType(type, validTypes);
            }
        } else {
            try {
                DataSchema inferredSchema = DataTemplateUtil.getSchema(type);
                DataSchema derefSchema = typerefSchema.getDereferencedDataSchema();
                if (inferredSchema.equals((Object)derefSchema)) {
                    return null;
                }
                return "typeref " + typerefSchema + " is not compatible with (" + type + ") with schema " + derefSchema;
            }
            catch (TemplateRuntimeException templateRuntimeException) {
                ok = false;
            }
        }
        if (!ok) {
            return "typeref " + typerefSchema + " is not compatible with (" + type + ")";
        }
        return null;
    }

    private static void registerCoercer(TyperefDataSchema schema) {
        String coercerClassName = CustomTypeUtil.getJavaCoercerClassFromSchema((DataSchema)schema);
        String javaClassNameFromSchema = CustomTypeUtil.getJavaCustomTypeClassNameFromSchema((DataSchema)schema);
        try {
            Custom.initializeCustomClass(Class.forName(javaClassNameFromSchema, true, Thread.currentThread().getContextClassLoader()));
        }
        catch (ClassNotFoundException e) {
            throw new ResourceConfigException("Could not find class for type " + javaClassNameFromSchema, e);
        }
        if (coercerClassName != null) {
            try {
                Custom.initializeCoercerClass(Class.forName(coercerClassName, true, Thread.currentThread().getContextClassLoader()));
            }
            catch (ClassNotFoundException e) {
                throw new ResourceConfigException("Could not find coercer " + coercerClassName + " for type " + javaClassNameFromSchema, e);
            }
        }
    }

    private static boolean checkParameterType(Class<?> type, Class<?>[] validTypes) {
        for (Class<?> validType : validTypes) {
            if (!validType.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    private static void addResourceMethods(Class<?> resourceClass, ResourceModel model) {
        for (Method method : resourceClass.getDeclaredMethods()) {
            if (method.isSynthetic()) continue;
            RestLiAnnotationReader.addActionResourceMethod(model, method);
            RestLiAnnotationReader.addFinderResourceMethod(model, method);
            RestLiAnnotationReader.addTemplateResourceMethod(resourceClass, model, method);
            RestLiAnnotationReader.addCrudResourceMethod(resourceClass, model, method);
        }
        RestLiAnnotationReader.validateResourceModel(model);
    }

    private static void validateResourceModel(ResourceModel model) {
        RestLiAnnotationReader.validateAssociation(model);
        RestLiAnnotationReader.validateCrudMethods(model);
        RestLiAnnotationReader.validateSimpleResource(model);
    }

    private static void validateSimpleResource(ResourceModel model) {
        if (model.getResourceType() != ResourceType.SIMPLE) {
            return;
        }
        for (ResourceMethodDescriptor descriptor : model.getResourceMethodDescriptors()) {
            ResourceMethod type = descriptor.getType();
            if (RestConstants.SIMPLE_RESOURCE_METHODS.contains(type)) continue;
            throw new ResourceConfigException(String.format("Resource '%s' is a simple resource but it contains a method of type %s which is not supported on simple resources.", model.getName(), type.toString()));
        }
    }

    private static void validateAssociation(ResourceModel model) {
        if (model.getResourceType() != ResourceType.ASSOCIATION) {
            return;
        }
        if (model.getKeys().size() <= 1) {
            throw new ResourceConfigException(String.format("Association '%s' requires more than 1 key.", model.getName()));
        }
    }

    private static void validateCrudMethods(ResourceModel model) {
        HashMap<ResourceMethod, ResourceMethodDescriptor> crudMethods = new HashMap<ResourceMethod, ResourceMethodDescriptor>();
        block4: for (ResourceMethodDescriptor descriptor : model.getResourceMethodDescriptors()) {
            ResourceMethod type = descriptor.getType();
            switch (type) {
                case ACTION: {
                    continue block4;
                }
                case FINDER: {
                    continue block4;
                }
            }
            if (crudMethods.containsKey(type)) {
                ResourceMethodDescriptor oldDescriptor = (ResourceMethodDescriptor)crudMethods.get(type);
                throw new ResourceConfigException(String.format("Resource '%s' contains duplicate methods of type '%s'.  Methods are '%s' and '%s'.", model.getName(), type.toString(), oldDescriptor.getMethod().getName(), descriptor.getMethod().getName()));
            }
            crudMethods.put(type, descriptor);
        }
    }

    private static void addFinderResourceMethod(ResourceModel model, Method method) {
        Finder finderAnno = method.getAnnotation(Finder.class);
        if (finderAnno == null) {
            return;
        }
        String queryType = finderAnno.value();
        List<Parameter<?>> queryParameters = RestLiAnnotationReader.getParameters(model, method, ResourceMethod.FINDER);
        if (queryType != null) {
            List typeArguments;
            Class metadataClass;
            Class<RecordTemplate> metadataType = null;
            Class<?> returnClass = RestLiAnnotationReader.getLogicalReturnClass(method);
            if (CollectionResult.class.isAssignableFrom(returnClass) && !(metadataClass = (typeArguments = ReflectionUtils.getTypeArguments(CollectionResult.class, returnClass.asSubclass(CollectionResult.class))) == null || typeArguments.get(1) == null ? (Class)((ParameterizedType)RestLiAnnotationReader.getLogicalReturnType(method)).getActualTypeArguments()[1] : (Class)typeArguments.get(1)).equals(NoMetadata.class)) {
                metadataType = metadataClass.asSubclass(RecordTemplate.class);
            }
            DataMap annotationsMap = ResourceModelAnnotation.getAnnotationsMap(method.getAnnotations());
            RestLiAnnotationReader.addDeprecatedAnnotation(annotationsMap, method);
            ResourceMethodDescriptor finderMethodDescriptor = ResourceMethodDescriptor.createForFinder(method, queryParameters, queryType, metadataType, RestLiAnnotationReader.getInterfaceType(method), annotationsMap);
            RestLiAnnotationReader.validateFinderMethod(finderMethodDescriptor, model);
            if (!Modifier.isPublic(method.getModifiers())) {
                throw new ResourceConfigException(String.format("Resource '%s' contains non-public finder method '%s'.", model.getName(), method.getName()));
            }
            model.addResourceMethodDescriptor(finderMethodDescriptor);
        }
    }

    private static void addTemplateResourceMethod(Class<?> resourceClass, ResourceModel model, Method method) {
        if (!RestLiAnnotationReader.isResourceTemplateClass(resourceClass)) {
            return;
        }
        if (RestLiAnnotationReader.isRestMethodAnnotated(method)) {
            return;
        }
        List<Class<?>> parameterTypes = Arrays.asList(method.getParameterTypes());
        boolean partial = parameterTypes.contains(PatchRequest.class) || parameterTypes.contains(BatchPatchRequest.class);
        ResourceMethod resourceMethod = ResourceMethodLookup.fromResourceMethodName(method.getName(), partial);
        if (resourceMethod != null) {
            if (!Modifier.isPublic(method.getModifiers())) {
                throw new ResourceConfigException(String.format("Resource '%s' contains non-public CRUD method '%s'.", model.getName(), method.getName()));
            }
            DataMap annotationsMap = ResourceModelAnnotation.getAnnotationsMap(method.getAnnotations());
            RestLiAnnotationReader.addDeprecatedAnnotation(annotationsMap, method);
            List<Parameter<?>> parameters = RestLiAnnotationReader.getParameters(model, method, resourceMethod);
            model.addResourceMethodDescriptor(ResourceMethodDescriptor.createForRestful(resourceMethod, method, parameters, RestLiAnnotationReader.getInterfaceType(method), annotationsMap));
        }
    }

    private static boolean isRestMethodAnnotated(Method method) {
        Annotation[] methodAnnotations;
        for (Annotation annotation : methodAnnotations = method.getAnnotations()) {
            if (RestMethod.getResourceMethod(annotation.annotationType()) == null) continue;
            return true;
        }
        return false;
    }

    private static boolean isResourceTemplateClass(Class<?> resourceClass) {
        for (Class<?> c : RestModelConstants.FIXED_RESOURCE_CLASSES) {
            if (!c.isAssignableFrom(resourceClass)) continue;
            return true;
        }
        return false;
    }

    private static void addCrudResourceMethod(Class<?> resourceClass, ResourceModel model, Method method) {
        boolean restMethodAnnotationFound = false;
        for (Annotation methodAnnotation : method.getAnnotations()) {
            ResourceMethod resourceMethod = RestMethod.getResourceMethod(methodAnnotation.annotationType());
            if (resourceMethod == null) continue;
            if (restMethodAnnotationFound) {
                throw new ResourceConfigException("Multiple rest method annotations in method " + method.getName());
            }
            restMethodAnnotationFound = true;
            if (!Modifier.isPublic(method.getModifiers())) {
                throw new ResourceConfigException(String.format("Resource '%s' contains non-public CRUD method '%s'.", model.getName(), method.getName()));
            }
            DataMap annotationsMap = ResourceModelAnnotation.getAnnotationsMap(method.getAnnotations());
            RestLiAnnotationReader.addDeprecatedAnnotation(annotationsMap, method);
            List<Parameter<?>> parameters = RestLiAnnotationReader.getParameters(model, method, resourceMethod);
            model.addResourceMethodDescriptor(ResourceMethodDescriptor.createForRestful(resourceMethod, method, parameters, RestLiAnnotationReader.getInterfaceType(method), annotationsMap));
        }
    }

    private static void addActionResourceMethod(ResourceModel model, Method method) {
        RecordDataSchema actionReturnRecordDataSchema;
        FieldDef returnFieldDef;
        Action actionAnno = method.getAnnotation(Action.class);
        if (actionAnno == null) {
            return;
        }
        String actionName = actionAnno.name();
        List<Parameter<?>> parameters = RestLiAnnotationReader.getParameters(model, method, ResourceMethod.ACTION);
        Class<?> returnClass = RestLiAnnotationReader.getActionReturnClass(model, method, actionAnno, actionName);
        TyperefDataSchema returnTyperefSchema = RestLiAnnotationReader.getActionTyperefDataSchema(model, actionAnno, actionName);
        RestLiAnnotationReader.validateActionReturnType(model, method, returnClass, returnTyperefSchema);
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new ResourceConfigException(String.format("Resource '%s' contains non-public action method '%s'.", model.getName(), method.getName()));
        }
        RecordDataSchema recordDataSchema = DynamicRecordMetadata.buildSchema((String)method.getName(), parameters);
        if (returnClass != Void.TYPE) {
            FieldDef nonVoidFieldDef;
            returnFieldDef = nonVoidFieldDef = new FieldDef("value", returnClass, RestLiAnnotationReader.getDataSchema(returnClass, returnTyperefSchema));
            actionReturnRecordDataSchema = DynamicRecordMetadata.buildSchema((String)ActionResponse.class.getName(), Collections.singleton(returnFieldDef));
        } else {
            returnFieldDef = null;
            actionReturnRecordDataSchema = DynamicRecordMetadata.buildSchema((String)ActionResponse.class.getName(), Collections.emptyList());
        }
        if (model.getResourceLevel() == ResourceLevel.ENTITY && actionAnno.resourceLevel() == ResourceLevel.COLLECTION) {
            throw new ResourceConfigException(String.format("Resource '%s' is a simple resource, it cannot contain actions at resource level \"COLLECTION\".", model.getName()));
        }
        DataMap annotationsMap = ResourceModelAnnotation.getAnnotationsMap(method.getAnnotations());
        RestLiAnnotationReader.addDeprecatedAnnotation(annotationsMap, method);
        model.addResourceMethodDescriptor(ResourceMethodDescriptor.createForAction(method, parameters, actionName, RestLiAnnotationReader.getActionResourceLevel(actionAnno, model), returnFieldDef, actionReturnRecordDataSchema, recordDataSchema, RestLiAnnotationReader.getInterfaceType(method), annotationsMap));
    }

    private static TyperefDataSchema getActionTyperefDataSchema(ResourceModel model, Action actionAnno, String actionName) {
        TyperefDataSchema returnTyperefSchema = null;
        Class<? extends TyperefInfo> typerefInfoClass = actionAnno.returnTyperef();
        try {
            returnTyperefSchema = RestLiAnnotationReader.getSchemaFromTyperefInfo(typerefInfoClass);
        }
        catch (Exception e) {
            throw new ResourceConfigException("Typeref @Action method named '" + actionName + "' on class '" + model.getResourceClass().getName() + "' cannot be instantiated, " + e.getMessage());
        }
        return returnTyperefSchema;
    }

    private static Class<?> getActionReturnClass(ResourceModel model, Method method, Action actionAnno, String actionName) {
        Type returnType = RestLiAnnotationReader.getLogicalReturnType(method);
        ResourceMethodDescriptor existingMethodDescriptor = model.findActionMethod(actionName, RestLiAnnotationReader.getActionResourceLevel(actionAnno, model));
        if (existingMethodDescriptor != null) {
            throw new ResourceConfigException("Found duplicate @Action method named '" + actionName + "' on class '" + model.getResourceClass().getName() + '\'');
        }
        Class<Void> returnClass = RestLiAnnotationReader.getBoxedTypeFromPrimitive(RestLiAnnotationReader.getLogicalReturnClass(method));
        if (ActionResult.class.isAssignableFrom(returnClass)) {
            assert (returnType instanceof ParameterizedType);
            ParameterizedType paramReturnType = (ParameterizedType)returnType;
            Type[] actualReturnTypes = paramReturnType.getActualTypeArguments();
            assert (actualReturnTypes.length == 1);
            if (!(actualReturnTypes[0] instanceof Class)) {
                throw new ResourceConfigException("Unsupported type parameter for ActionResult<?>.");
            }
            returnClass = (Class<Void>)actualReturnTypes[0];
            if (returnClass == Void.class) {
                returnClass = Void.TYPE;
            }
        }
        return returnClass;
    }

    private static ResourceLevel getActionResourceLevel(Action annotation, ResourceModel definingModel) {
        return annotation.resourceLevel() == ResourceLevel.ANY ? definingModel.getResourceLevel() : annotation.resourceLevel();
    }

    private static Class<?> getBoxedTypeFromPrimitive(Class<?> type) {
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                return Boolean.class;
            }
            if (type == Byte.TYPE) {
                return Byte.class;
            }
            if (type == Character.TYPE) {
                return Character.class;
            }
            if (type == Double.TYPE) {
                return Double.class;
            }
            if (type == Float.TYPE) {
                return Float.class;
            }
            if (type == Integer.TYPE) {
                return Integer.class;
            }
            if (type == Long.TYPE) {
                return Long.class;
            }
            if (type == Short.TYPE) {
                return Short.class;
            }
        }
        return type;
    }

    private static void validateActionReturnType(ResourceModel model, Method method, Class<?> returnClass, TyperefDataSchema returnTyperefSchema) {
        Class<?> returnType;
        if (returnTyperefSchema == null && !RestLiAnnotationReader.checkParameterType(returnType = RestLiAnnotationReader.getLogicalReturnClass(method), RestModelConstants.VALID_ACTION_RETURN_TYPES)) {
            throw new ResourceConfigException("@Action method '" + method.getName() + "' on class '" + method.getDeclaringClass().getName() + "' has an invalid return type '" + returnType.getName() + "'. Expected a DataTemplate or a primitive");
        }
        String checkTyperefMessage = RestLiAnnotationReader.checkTyperefSchema(returnClass, (DataSchema)returnTyperefSchema);
        if (checkTyperefMessage != null) {
            throw new ResourceConfigException("Typeref @Action method named '" + method.getAnnotation(Action.class).name() + "' on class '" + model.getResourceClass().getName() + "', " + checkTyperefMessage);
        }
    }

    private static void validateFinderMethod(ResourceMethodDescriptor finderMethodDescriptor, ResourceModel resourceModel) {
        Class elementType;
        Class<?> returnType;
        Method method = finderMethodDescriptor.getMethod();
        Class<? extends RecordTemplate> valueClass = resourceModel.getValueClass();
        try {
            List typeArguments;
            returnType = RestLiAnnotationReader.getLogicalReturnClass(method);
            if (List.class.isAssignableFrom(returnType)) {
                typeArguments = ReflectionUtils.getTypeArguments(List.class, returnType.asSubclass(List.class));
            } else if (CollectionResult.class.isAssignableFrom(returnType)) {
                typeArguments = ReflectionUtils.getTypeArguments(CollectionResult.class, returnType.asSubclass(CollectionResult.class));
            } else {
                throw new ResourceConfigException("@Finder method '" + method.getName() + "' on class '" + resourceModel.getResourceClass().getName() + "' has an unsupported return type");
            }
            if (typeArguments == null || typeArguments.get(0) == null) {
                ParameterizedType collectionType = (ParameterizedType)RestLiAnnotationReader.getLogicalReturnType(method);
                elementType = (Class)collectionType.getActualTypeArguments()[0];
            } else {
                elementType = (Class)typeArguments.get(0);
            }
        }
        catch (ClassCastException e) {
            throw new ResourceConfigException("@Finder method '" + method.getName() + "' on class '" + resourceModel.getResourceClass().getName() + "' has an invalid return or a data template type", e);
        }
        if (!List.class.isAssignableFrom(returnType) && !CollectionResult.class.isAssignableFrom(returnType)) {
            throw new ResourceConfigException("@Finder method '" + method.getName() + "' on class '" + resourceModel.getResourceClass().getName() + "' has an invalid return type '" + returnType.getName() + "'. Expected List<" + valueClass.getName() + "> or CollectionResult<" + valueClass.getName() + ">");
        }
        String collectionClassName = returnType.getSimpleName();
        if (!RecordTemplate.class.isAssignableFrom(elementType) || !resourceModel.getValueClass().equals(elementType)) {
            throw new ResourceConfigException("@Finder method '" + method.getName() + "' on class '" + resourceModel.getResourceClass().getName() + "' has an invalid return type. Expected " + collectionClassName + "<" + valueClass.getName() + ">, but found " + collectionClassName + "<" + elementType + '>');
        }
        ResourceMethodDescriptor existingFinder = resourceModel.findNamedMethod(finderMethodDescriptor.getFinderName());
        if (existingFinder != null) {
            throw new ResourceConfigException("Found duplicate @Finder method named '" + finderMethodDescriptor.getFinderName() + "' on class '" + resourceModel.getResourceClass().getName() + '\'');
        }
    }

    private static ResourceModel processActions(Class<?> actionResourceClass, ResourceModel parentResourceModel) {
        RestLiActions actionsAnno = actionResourceClass.getAnnotation(RestLiActions.class);
        String name = actionsAnno.name();
        String namespace = actionsAnno.namespace();
        ResourceModel actionResourceModel = new ResourceModel(null, null, null, Collections.emptySet(), null, actionResourceClass, null, name, ResourceType.ACTIONS, namespace);
        actionResourceModel.setParentResourceModel(parentResourceModel);
        for (Method method : actionResourceClass.getDeclaredMethods()) {
            if (method.isSynthetic()) continue;
            RestLiAnnotationReader.addActionResourceMethod(actionResourceModel, method);
        }
        log.info("Processed actions resource '" + actionResourceClass.getName() + '\'');
        return actionResourceModel;
    }

    private static ResourceMethodDescriptor.InterfaceType getInterfaceType(Method method) {
        boolean promise = Promise.class.isAssignableFrom(method.getReturnType());
        boolean task = Task.class.isAssignableFrom(method.getReturnType());
        boolean callback = RestLiAnnotationReader.getParamIndex(method, Callback.class) != -1;
        boolean isVoid = method.getReturnType().equals(Void.TYPE);
        if (callback && !isVoid) {
            throw new ResourceConfigException(String.format("%s has both callback and return value", method));
        }
        if (callback) {
            return ResourceMethodDescriptor.InterfaceType.CALLBACK;
        }
        if (task) {
            return ResourceMethodDescriptor.InterfaceType.TASK;
        }
        if (promise) {
            return ResourceMethodDescriptor.InterfaceType.PROMISE;
        }
        return ResourceMethodDescriptor.InterfaceType.SYNC;
    }

    private static Type getCallbackParamType(Method method) {
        int i = RestLiAnnotationReader.getParamIndex(method, Callback.class);
        if (i == -1) {
            return null;
        }
        return method.getGenericParameterTypes()[i];
    }

    private static int getParamIndex(Method method, Class<?> type) {
        Type[] types = method.getGenericParameterTypes();
        int where = -1;
        for (int i = 0; i < types.length; ++i) {
            Class c = ReflectionUtils.getClass((Type)types[i]);
            if (c == null || !type.equals(c)) continue;
            if (where == -1) {
                where = i;
                continue;
            }
            throw new ResourceConfigException(String.format("method '%s' has too many '%s' parameters", method, type));
        }
        return where;
    }

    private static Class<?> getLogicalReturnClass(Method method) {
        Class c = ReflectionUtils.getClass((Type)RestLiAnnotationReader.getLogicalReturnType(method));
        return Void.class.equals((Object)c) ? Void.TYPE : c;
    }

    private static Type getLogicalReturnType(Method method) {
        switch (RestLiAnnotationReader.getInterfaceType(method)) {
            case CALLBACK: {
                ParameterizedType callbackType = (ParameterizedType)RestLiAnnotationReader.getCallbackParamType(method);
                return callbackType.getActualTypeArguments()[0];
            }
            case PROMISE: 
            case TASK: {
                ParameterizedType promiseType = (ParameterizedType)method.getGenericReturnType();
                return promiseType.getActualTypeArguments()[0];
            }
            case SYNC: {
                return method.getGenericReturnType();
            }
        }
        throw new AssertionError();
    }
}

