/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server.model;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.codec.JacksonDataCodec;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.validation.ValidateDataAgainstSchema;
import com.linkedin.data.schema.validation.ValidationOptions;
import com.linkedin.data.schema.validation.ValidationResult;
import com.linkedin.data.template.AbstractArrayTemplate;
import com.linkedin.data.template.AbstractMapTemplate;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.FieldDef;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.data.template.UnionTemplate;
import com.linkedin.restli.internal.common.ValueConverter;
import com.linkedin.restli.internal.server.model.AnnotationSet;
import com.linkedin.restli.internal.server.model.ResourceModelAnnotation;
import com.linkedin.restli.server.ResourceConfigException;
import java.io.IOException;

public class Parameter<T>
extends FieldDef<T> {
    private final boolean _optional;
    private final Object _defaultValue;
    private final Object _defaultValueData;
    private final ParamType _paramType;
    private final boolean _custom;
    private final boolean _isArray;
    private final Class<?> _itemType;
    private final AnnotationSet _annotations;
    private final DataMap _customAnnotations;
    private static final JacksonDataCodec _codec = new JacksonDataCodec();
    private static final ValidationOptions _defaultValOptions = new ValidationOptions();

    public Parameter(String name, Class<T> type, DataSchema dataSchema, boolean optional, Object defaultValueData, ParamType paramType, boolean custom, AnnotationSet annotations) {
        super(name, type, dataSchema);
        this._optional = optional;
        this._defaultValue = null;
        this._defaultValueData = defaultValueData;
        this._paramType = paramType;
        this._custom = custom;
        this._isArray = this.getType().isArray();
        this._itemType = this.getType().getComponentType();
        this._annotations = annotations;
        this._customAnnotations = ResourceModelAnnotation.getAnnotationsMap(annotations.getAll());
    }

    public boolean isOptional() {
        return this._optional;
    }

    public boolean hasDefaultValue() {
        return this._defaultValueData != null;
    }

    public Object getDefaultValue() {
        Object result;
        if (this._defaultValueData == null) {
            return null;
        }
        if (this._defaultValueData instanceof String) {
            String defaultValueString = (String)this._defaultValueData;
            try {
                if (this.getType().isArray()) {
                    DataList valueAsDataList = _codec.stringToList(defaultValueString);
                    result = DataTemplateUtil.convertDataListToArray((DataList)valueAsDataList, this.getItemType());
                }
                if (DataTemplate.class.isAssignableFrom(this.getType())) {
                    Object input = AbstractArrayTemplate.class.isAssignableFrom(this.getType()) ? _codec.stringToList(defaultValueString) : (AbstractMapTemplate.class.isAssignableFrom(this.getType()) || UnionTemplate.class.isAssignableFrom(this.getType()) || RecordTemplate.class.isAssignableFrom(this.getType()) ? _codec.stringToMap(defaultValueString) : defaultValueString);
                    result = DataTemplateUtil.wrap((Object)input, this.getType().asSubclass(DataTemplate.class));
                    Parameter.validate((DataTemplate)result, this.getType());
                }
                result = ValueConverter.coerceString((String)defaultValueString, (Class)this.getType());
            }
            catch (TemplateOutputCastException e) {
                throw new ResourceConfigException(e.getMessage(), e);
            }
            catch (IllegalArgumentException e) {
                throw new ResourceConfigException("Default value for parameter of type \"" + this.getType().getName() + "\" is not supported: " + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new ResourceConfigException("Default value for parameter of type \"" + this.getType().getName() + "\" is not supported: " + e.getMessage(), e);
            }
        } else {
            result = this._defaultValueData;
        }
        return result;
    }

    public Object getDefaultValueData() {
        return this._defaultValueData;
    }

    public ParamType getParamType() {
        return this._paramType;
    }

    public boolean isCustom() {
        return this._custom;
    }

    public boolean isArray() {
        return this._isArray;
    }

    public Class<?> getItemType() {
        return this._itemType;
    }

    public AnnotationSet getAnnotations() {
        return this._annotations;
    }

    public DataMap getCustomAnnotationData() {
        return this._customAnnotations;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(", defaultValue=").append(this._defaultValue).append(", isOptional=").append(this._optional).append(", paramType=").append((Object)this._paramType);
        return sb.toString();
    }

    private static void validate(DataTemplate<?> data, Class<?> clazz) {
        ValidationResult valResult = ValidateDataAgainstSchema.validate((Object)data.data(), (DataSchema)data.schema(), (ValidationOptions)_defaultValOptions);
        if (!valResult.isValid()) {
            throw new IllegalArgumentException("Coercing String \"" + data.data() + "\" to type " + clazz.getName() + " failed due to schema validation: " + valResult.getMessages());
        }
    }

    public static enum ParamType {
        QUERY,
        RESOURCE_KEY,
        KEY,
        ASSOC_KEY_PARAM,
        POST,
        CONTEXT,
        PAGING_CONTEXT_PARAM,
        CALLBACK,
        PARSEQ_CONTEXT,
        PARSEQ_CONTEXT_PARAM,
        BATCH,
        PROJECTION,
        PROJECTION_PARAM,
        PATH_KEYS,
        PATH_KEYS_PARAM,
        PATH_KEY_PARAM,
        RESOURCE_CONTEXT,
        RESOURCE_CONTEXT_PARAM,
        HEADER,
        METADATA_PROJECTION_PARAM,
        PAGING_PROJECTION_PARAM,
        VALIDATOR_PARAM,
        RESTLI_ATTACHMENTS_PARAM;

    }
}

