/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server.methods.arguments;

import com.linkedin.data.DataMap;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.r2.message.rest.RestMessage;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.restli.internal.common.ProtocolVersionUtil;
import com.linkedin.restli.internal.server.RoutingResult;
import com.linkedin.restli.internal.server.methods.arguments.ArgumentBuilder;
import com.linkedin.restli.internal.server.methods.arguments.RestLiArgumentBuilder;
import com.linkedin.restli.internal.server.util.ArgumentUtils;
import com.linkedin.restli.internal.server.util.DataMapUtils;
import com.linkedin.restli.server.BatchUpdateRequest;
import com.linkedin.restli.server.RestLiRequestData;
import com.linkedin.restli.server.RestLiRequestDataImpl;
import java.util.Map;
import java.util.Set;

public class BatchUpdateArgumentBuilder
implements RestLiArgumentBuilder {
    @Override
    public Object[] buildArguments(RestLiRequestData requestData, RoutingResult routingResult) {
        BatchUpdateRequest batchRequest = new BatchUpdateRequest(requestData.getBatchKeyEntityMap());
        Object[] positionalArgs = new Object[]{batchRequest};
        return ArgumentBuilder.buildArgs(positionalArgs, routingResult.getResourceMethod(), routingResult.getContext(), null);
    }

    @Override
    public RestLiRequestData extractRequestData(RoutingResult routingResult, RestRequest request) {
        Class<? extends RecordTemplate> valueClass = ArgumentUtils.getValueClass(routingResult);
        DataMap dataMap = DataMapUtils.readMap((RestMessage)request);
        Set ids = routingResult.getContext().getPathKeys().getBatchIds();
        Map<Object, ? extends RecordTemplate> inputMap = ArgumentBuilder.buildBatchRequestMap(routingResult, dataMap, valueClass, ids, ProtocolVersionUtil.extractProtocolVersion((Map)request.getHeaders()));
        RestLiRequestDataImpl.Builder builder = new RestLiRequestDataImpl.Builder();
        if (inputMap != null) {
            builder.batchKeyEntityMap(inputMap);
        }
        return builder.build();
    }
}

