/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server;

public class ResourceMethodMatchKey {
    private final String _httpMethod;
    private final String _restliMethod;
    private final boolean _hasActionParam;
    private final boolean _hasQueryParam;
    private final boolean _hasBatchKeys;
    private final boolean _hasEntitySegment;

    public ResourceMethodMatchKey(String httpMethod, String restliMethod, boolean hasActionParam, boolean hasQueryParam, boolean hasBatchKeys, boolean hasEntitySegment) {
        this._httpMethod = httpMethod.toUpperCase();
        this._restliMethod = restliMethod.toUpperCase();
        this._hasActionParam = hasActionParam;
        this._hasQueryParam = hasQueryParam;
        this._hasBatchKeys = hasBatchKeys;
        this._hasEntitySegment = hasEntitySegment;
    }

    public boolean equals(Object oref) {
        if (!(oref instanceof ResourceMethodMatchKey)) {
            return false;
        }
        ResourceMethodMatchKey ref = (ResourceMethodMatchKey)oref;
        return this._httpMethod.equals(ref._httpMethod) && this._restliMethod.equals(ref._restliMethod) && this._hasActionParam == ref._hasActionParam && this._hasQueryParam == ref._hasQueryParam && this._hasBatchKeys == ref._hasBatchKeys && this._hasEntitySegment == ref._hasEntitySegment;
    }

    public int hashCode() {
        int prime = 31;
        int result = this._httpMethod.hashCode();
        result = 31 * result + this._restliMethod.hashCode();
        result = 31 * result + (this._hasActionParam ? 0 : 1);
        result = 31 * result + (this._hasQueryParam ? 0 : 1);
        result = 31 * result + (this._hasBatchKeys ? 0 : 1);
        result = 31 * result + (this._hasEntitySegment ? 0 : 1);
        return result;
    }
}

