/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.gobblin.crypto.CredentialStore;
import org.apache.gobblin.crypto.KeyToStringCodec;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonCredentialStore
implements CredentialStore {
    private static final Logger log = LoggerFactory.getLogger(JsonCredentialStore.class);
    private static final ObjectMapper defaultMapper = new ObjectMapper();
    public static final String TAG = "json";
    private Map<String, byte[]> credentials = new HashMap<String, byte[]>();

    public JsonCredentialStore(String path, KeyToStringCodec codec) throws IOException {
        this(new Path(path), codec);
    }

    public JsonCredentialStore(Path path, KeyToStringCodec codec) throws IOException {
        FileSystem fs = path.getFileSystem(new Configuration());
        try (FSDataInputStream in = fs.open(path);){
            ObjectMapper jsonParser = defaultMapper;
            JsonNode tree = jsonParser.readTree((InputStream)in);
            if (!tree.isObject()) {
                throw new IllegalArgumentException("Json in " + path.toString() + " is not an object!");
            }
            Iterator it = tree.getFields();
            while (it.hasNext()) {
                Map.Entry field = (Map.Entry)it.next();
                String keyId = (String)field.getKey();
                byte[] key = codec.decodeKey(((JsonNode)field.getValue()).getTextValue());
                this.credentials.put(keyId, key);
            }
        }
        log.info("Initialized keystore from {} with {} keys", (Object)path.toString(), (Object)this.credentials.size());
    }

    public byte[] getEncodedKey(String id) {
        return this.credentials.get(id);
    }

    public Map<String, byte[]> getAllEncodedKeys() {
        return Collections.unmodifiableMap(this.credentials);
    }
}

