/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.source;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.gobblin.compaction.mapreduce.MRCompactionTaskFactory;
import org.apache.gobblin.compaction.source.CompactionFailedTask;
import org.apache.gobblin.compaction.suite.CompactionSuite;
import org.apache.gobblin.compaction.suite.CompactionSuiteUtils;
import org.apache.gobblin.compaction.verify.CompactionVerifier;
import org.apache.gobblin.config.ConfigBuilder;
import org.apache.gobblin.configuration.SourceState;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.data.management.dataset.DatasetUtils;
import org.apache.gobblin.data.management.dataset.DefaultFileSystemGlobFinder;
import org.apache.gobblin.data.management.dataset.SimpleDatasetRequest;
import org.apache.gobblin.data.management.dataset.SimpleDatasetRequestor;
import org.apache.gobblin.dataset.Dataset;
import org.apache.gobblin.dataset.DatasetsFinder;
import org.apache.gobblin.runtime.JobState;
import org.apache.gobblin.runtime.task.FailedTask;
import org.apache.gobblin.runtime.task.TaskUtils;
import org.apache.gobblin.source.WorkUnitStreamSource;
import org.apache.gobblin.source.extractor.Extractor;
import org.apache.gobblin.source.workunit.BasicWorkUnitStream;
import org.apache.gobblin.source.workunit.WorkUnit;
import org.apache.gobblin.source.workunit.WorkUnitStream;
import org.apache.gobblin.util.ClassAliasResolver;
import org.apache.gobblin.util.Either;
import org.apache.gobblin.util.ExecutorsUtils;
import org.apache.gobblin.util.HadoopUtils;
import org.apache.gobblin.util.executors.IteratorExecutor;
import org.apache.gobblin.util.reflection.GobblinConstructorUtils;
import org.apache.gobblin.util.request_allocation.GreedyAllocator;
import org.apache.gobblin.util.request_allocation.HierarchicalAllocator;
import org.apache.gobblin.util.request_allocation.HierarchicalPrioritizer;
import org.apache.gobblin.util.request_allocation.RequestAllocator;
import org.apache.gobblin.util.request_allocation.RequestAllocatorConfig;
import org.apache.gobblin.util.request_allocation.RequestAllocatorUtils;
import org.apache.gobblin.util.request_allocation.ResourceEstimator;
import org.apache.gobblin.util.request_allocation.ResourcePool;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.joda.time.DateTimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionSource
implements WorkUnitStreamSource<String, String> {
    private static final Logger log = LoggerFactory.getLogger(CompactionSource.class);
    public static final String COMPACTION_INIT_TIME = "compaction.init.time";
    private CompactionSuite suite;
    private Path tmpJobDir;
    private FileSystem fs;
    private RequestAllocator<SimpleDatasetRequest> allocator;

    public List<WorkUnit> getWorkunits(SourceState state) {
        throw new UnsupportedOperationException("Please use getWorkunitStream");
    }

    public WorkUnitStream getWorkunitStream(SourceState state) {
        try {
            this.fs = CompactionSource.getSourceFileSystem((State)state);
            state.setProp(COMPACTION_INIT_TIME, (Object)DateTimeUtils.currentTimeMillis());
            this.suite = CompactionSuiteUtils.getCompactionSuiteFactory((State)state).createSuite((State)state);
            this.initRequestAllocator((State)state);
            this.initJobDir(state);
            this.copyJarDependencies((State)state);
            DatasetsFinder finder = DatasetUtils.instantiateDatasetFinder((Properties)state.getProperties(), (FileSystem)CompactionSource.getSourceFileSystem((State)state), (String)DefaultFileSystemGlobFinder.class.getName(), (Object[])new Object[0]);
            List datasets = finder.findDatasets();
            CompactionWorkUnitIterator workUnitIterator = new CompactionWorkUnitIterator();
            new Thread((Runnable)new SingleWorkUnitGeneratorService(state, this.prioritize(datasets, (State)state), workUnitIterator), "SingleWorkUnitGeneratorService").start();
            return new BasicWorkUnitStream.Builder((Iterator)workUnitIterator).build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void initRequestAllocator(State state) {
        try {
            ResourceEstimator estimator = (ResourceEstimator)GobblinConstructorUtils.invokeLongestConstructor((Class)new ClassAliasResolver(ResourceEstimator.class).resolveClass(state.getProp("compaction.prioritization.estimator", SimpleDatasetRequest.SimpleDatasetCountEstimator.class.getName())), (Object[])new Object[0]);
            RequestAllocatorConfig.Builder configBuilder = RequestAllocatorConfig.builder((ResourceEstimator)estimator).allowParallelization(1).withLimitedScopeConfig(ConfigBuilder.create().loadProps(state.getProperties(), "compaction.prioritization.").build());
            if (!state.contains("compaction.prioritization.prioritizerAlias")) {
                this.allocator = new GreedyAllocator(configBuilder.build());
                return;
            }
            Comparator prioritizer = (Comparator)GobblinConstructorUtils.invokeLongestConstructor((Class)new ClassAliasResolver(Comparator.class).resolveClass(state.getProp("compaction.prioritization.prioritizerAlias")), (Object[])new Object[]{state});
            configBuilder.withPrioritizer(prioritizer);
            this.allocator = prioritizer instanceof HierarchicalPrioritizer ? new HierarchicalAllocator.Factory().createRequestAllocator(configBuilder.build()) : RequestAllocatorUtils.inferFromConfig((RequestAllocatorConfig)configBuilder.build());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot initialize allocator", e);
        }
    }

    private List<Dataset> prioritize(List<Dataset> datasets, State state) {
        double maxPool = state.getPropAsDouble("compaction.datasets.max.count", 1.0E9);
        ResourcePool pool = ResourcePool.builder().maxResource("count", Double.valueOf(maxPool)).build();
        Iterator newList = Iterators.transform((Iterator)this.allocator.allocateRequests(datasets.stream().map(SimpleDatasetRequestor::new).iterator(), pool), input -> input.getDataset());
        return Lists.newArrayList((Iterator)newList);
    }

    protected WorkUnit createWorkUnit(Dataset dataset) throws IOException {
        WorkUnit workUnit = new WorkUnit();
        TaskUtils.setTaskFactoryClass((State)workUnit, MRCompactionTaskFactory.class);
        this.suite.save(dataset, (State)workUnit);
        return workUnit;
    }

    protected WorkUnit createWorkUnitForFailure(Dataset dataset) throws IOException {
        FailedTask.FailedWorkUnit workUnit = new FailedTask.FailedWorkUnit();
        TaskUtils.setTaskFactoryClass((State)workUnit, CompactionFailedTask.CompactionFailedTaskFactory.class);
        this.suite.save(dataset, (State)workUnit);
        return workUnit;
    }

    protected WorkUnit createWorkUnitForFailure(Dataset dataset, String reason) throws IOException {
        FailedTask.FailedWorkUnit workUnit = new FailedTask.FailedWorkUnit();
        workUnit.setProp("compaction.verification.fail.reason", (Object)reason);
        TaskUtils.setTaskFactoryClass((State)workUnit, CompactionFailedTask.CompactionFailedTaskFactory.class);
        this.suite.save(dataset, (State)workUnit);
        return workUnit;
    }

    public Extractor getExtractor(WorkUnitState state) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void shutdown(SourceState state) {
        try {
            boolean f = this.fs.delete(this.tmpJobDir, true);
            log.info("Job dir is removed from {} with status {}", (Object)this.tmpJobDir, (Object)f);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static FileSystem getSourceFileSystem(State state) throws IOException {
        Configuration conf = HadoopUtils.getConfFromState((State)state);
        String uri = state.getProp("source.filebased.fs.uri", "file:///");
        return HadoopUtils.getOptionallyThrottledFileSystem((FileSystem)FileSystem.get((URI)URI.create(uri), (Configuration)conf), (State)state);
    }

    private void initJobDir(SourceState state) throws IOException {
        String tmpBase = state.getProp("compaction.tmp.dest.dir", "/tmp/gobblin-compaction");
        String jobId = state instanceof JobState ? ((JobState)state).getJobId() : UUID.randomUUID().toString();
        this.tmpJobDir = new Path(tmpBase, jobId);
        this.fs.mkdirs(this.tmpJobDir);
        state.setProp("compaction.tmp.job.dir", (Object)this.tmpJobDir.toString());
        log.info("Job dir is created under {}", (Object)this.tmpJobDir);
    }

    private void copyJarDependencies(State state) throws IOException {
        if (this.tmpJobDir == null) {
            throw new RuntimeException("Job directory is not created");
        }
        if (!state.contains("job.jars")) {
            return;
        }
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)HadoopUtils.getConfFromState((State)state));
        Path tmpJarFileDir = new Path(this.tmpJobDir, "_gobblin_compaction_jars");
        this.fs.mkdirs(tmpJarFileDir);
        state.setProp("compaction.jars", (Object)tmpJarFileDir.toString());
        for (String jarFile : state.getPropAsList("job.jars")) {
            for (FileStatus status : lfs.globStatus(new Path(jarFile))) {
                Path tmpJarFile = new Path(this.fs.makeQualified(tmpJarFileDir), status.getPath().getName());
                this.fs.copyFromLocalFile(status.getPath(), tmpJarFile);
                log.info(String.format("%s will be added to classpath", tmpJarFile));
            }
        }
    }

    private static class CompactionWorkUnitIterator
    implements Iterator<WorkUnit> {
        private LinkedBlockingDeque<WorkUnit> workUnits = new LinkedBlockingDeque();
        private WorkUnit last = null;
        private AtomicBoolean isDone = new AtomicBoolean(false);

        @Override
        public boolean hasNext() {
            try {
                while (true) {
                    if (this.last != null) {
                        return true;
                    }
                    if (this.isDone.get() && this.workUnits.isEmpty()) {
                        return false;
                    }
                    this.last = this.workUnits.poll(1L, TimeUnit.SECONDS);
                }
            }
            catch (InterruptedException e) {
                log.error(e.toString());
                return false;
            }
        }

        public void done() {
            this.isDone.set(true);
        }

        @Override
        public WorkUnit next() {
            if (this.hasNext()) {
                if (this.last != null) {
                    WorkUnit tmp = this.last;
                    this.last = null;
                    return tmp;
                }
                throw new IllegalStateException("last variable cannot be empty");
            }
            throw new NoSuchElementException("work units queue has been exhausted");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("No remove supported on " + this.getClass().getName());
        }

        protected void addWorkUnit(WorkUnit wu) {
            this.workUnits.add(wu);
        }
    }

    private class DatasetVerifier
    implements Callable {
        private Dataset dataset;
        private CompactionWorkUnitIterator workUnitIterator;
        private List<CompactionVerifier> verifiers;

        public VerifiedDataset call() throws DatasetVerificationException {
            try {
                VerifiedResult result = this.verify(this.dataset);
                if (result.allVerificationPassed) {
                    this.workUnitIterator.addWorkUnit(CompactionSource.this.createWorkUnit(this.dataset));
                }
                return new VerifiedDataset(this.dataset, result);
            }
            catch (Exception e) {
                throw new DatasetVerificationException(this.dataset, (Throwable)e);
            }
        }

        public VerifiedResult verify(Dataset dataset) throws Exception {
            boolean verificationPassed = true;
            boolean shouldRetry = true;
            String failedReason = "";
            if (this.verifiers != null) {
                for (CompactionVerifier verifier : this.verifiers) {
                    CompactionVerifier.Result rst = verifier.verify(dataset);
                    if (rst.isSuccessful()) continue;
                    verificationPassed = false;
                    failedReason = rst.getFailureReason();
                    if (verifier.isRetriable()) continue;
                    shouldRetry = false;
                    break;
                }
            }
            return new VerifiedResult(verificationPassed, shouldRetry, failedReason);
        }

        @ConstructorProperties(value={"dataset", "workUnitIterator", "verifiers"})
        public DatasetVerifier(Dataset dataset, CompactionWorkUnitIterator workUnitIterator, List<CompactionVerifier> verifiers) {
            this.dataset = dataset;
            this.workUnitIterator = workUnitIterator;
            this.verifiers = verifiers;
        }
    }

    private static class VerifiedResult {
        private boolean allVerificationPassed;
        private boolean shouldRetry;
        private String failedReason;

        @ConstructorProperties(value={"allVerificationPassed", "shouldRetry", "failedReason"})
        public VerifiedResult(boolean allVerificationPassed, boolean shouldRetry, String failedReason) {
            this.allVerificationPassed = allVerificationPassed;
            this.shouldRetry = shouldRetry;
            this.failedReason = failedReason;
        }
    }

    private static class VerifiedDataset {
        private Dataset dataset;
        private VerifiedResult verifiedResult;

        @ConstructorProperties(value={"dataset", "verifiedResult"})
        public VerifiedDataset(Dataset dataset, VerifiedResult verifiedResult) {
            this.dataset = dataset;
            this.verifiedResult = verifiedResult;
        }
    }

    private static class DatasetVerificationException
    extends Exception {
        private Dataset dataset;
        private Throwable cause;

        public DatasetVerificationException(Dataset dataset, Throwable cause) {
            super("Dataset:" + dataset.datasetURN() + " Exception:" + cause);
            this.dataset = dataset;
            this.cause = cause;
        }
    }

    private class SingleWorkUnitGeneratorService
    implements Runnable {
        private SourceState state;
        private List<Dataset> datasets;
        private CompactionWorkUnitIterator workUnitIterator;
        private IteratorExecutor executor;

        public SingleWorkUnitGeneratorService(SourceState state, List<Dataset> datasets, CompactionWorkUnitIterator workUnitIterator) {
            this.state = state;
            this.datasets = datasets;
            this.workUnitIterator = workUnitIterator;
        }

        @Override
        public void run() {
            try {
                Stopwatch stopwatch = Stopwatch.createStarted();
                int threads = this.state.getPropAsInt("compaction.verification.threads", 5);
                long timeOutInMinute = this.state.getPropAsLong("compaction.verification.timeoutMinutes", 30L);
                long iterationCountLimit = this.state.getPropAsLong("compaction.verification.iteration.countLimit", Integer.MAX_VALUE);
                long iteration = 0L;
                Map failedReasonMap = null;
                while (this.datasets.size() > 0 && iteration++ < iterationCountLimit) {
                    Iterator verifierIterator = Iterators.transform(this.datasets.iterator(), (Function)new Function<Dataset, Callable<VerifiedDataset>>(){

                        public Callable<VerifiedDataset> apply(Dataset dataset) {
                            return new DatasetVerifier(dataset, SingleWorkUnitGeneratorService.this.workUnitIterator, CompactionSource.this.suite.getDatasetsFinderVerifiers());
                        }
                    });
                    this.executor = new IteratorExecutor(verifierIterator, threads, ExecutorsUtils.newThreadFactory((Optional)Optional.of((Object)log), (Optional)Optional.of((Object)"Verifier-compaction-dataset-pool-%d")));
                    ArrayList failedDatasets = Lists.newArrayList();
                    failedReasonMap = Maps.newHashMap();
                    List futures = this.executor.executeAndGetResults();
                    for (Either either : futures) {
                        if (either instanceof Either.Right) {
                            ExecutionException exc = (ExecutionException)((Either.Right)either).getRight();
                            DatasetVerificationException dve = (DatasetVerificationException)exc.getCause();
                            failedDatasets.add(dve.dataset);
                            failedReasonMap.put(dve.dataset.getUrn(), ExceptionUtils.getFullStackTrace((Throwable)dve.cause));
                            continue;
                        }
                        VerifiedDataset vd = (VerifiedDataset)((Either.Left)either).getLeft();
                        if (vd.verifiedResult.allVerificationPassed) continue;
                        if (vd.verifiedResult.shouldRetry) {
                            log.debug("Dataset {} verification has failure but should retry", (Object)vd.dataset.datasetURN());
                            failedDatasets.add(vd.dataset);
                            failedReasonMap.put(vd.dataset.getUrn(), vd.verifiedResult.failedReason);
                            continue;
                        }
                        log.debug("Dataset {} verification has failure but no need to retry", (Object)vd.dataset.datasetURN());
                    }
                    this.datasets = CompactionSource.this.prioritize(failedDatasets, (State)this.state);
                    if (stopwatch.elapsed(TimeUnit.MINUTES) <= timeOutInMinute) continue;
                    break;
                }
                if (this.datasets.size() > 0) {
                    for (Dataset dataset : this.datasets) {
                        log.info("{} is timed out and give up the verification, adding a failed task", (Object)dataset.datasetURN());
                        this.workUnitIterator.addWorkUnit(CompactionSource.this.createWorkUnitForFailure(dataset, (String)failedReasonMap.get(dataset.getUrn())));
                    }
                }
                this.workUnitIterator.done();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

