/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.mapreduce.avro;

import java.io.IOException;
import java.lang.reflect.Method;
import org.apache.commons.io.FilenameUtils;
import org.apache.gobblin.compaction.mapreduce.avro.AvroKeyDedupReducer;
import org.apache.gobblin.compaction.mapreduce.avro.AvroKeyMapper;
import org.apache.gobblin.util.recordcount.CompactionRecordCountProvider;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroKeyCompactorOutputCommitter
extends FileOutputCommitter {
    private static final Logger LOG = LoggerFactory.getLogger(AvroKeyCompactorOutputCommitter.class);

    public AvroKeyCompactorOutputCommitter(Path output, TaskAttemptContext context) throws IOException {
        super(output, context);
    }

    public void commitTask(TaskAttemptContext context) throws IOException {
        Path workPath = this.getWorkPath();
        FileSystem fs = workPath.getFileSystem(context.getConfiguration());
        if (fs.exists(workPath)) {
            String fileNamePrefix;
            long recordCount = AvroKeyCompactorOutputCommitter.getRecordCountFromCounter(context, AvroKeyDedupReducer.EVENT_COUNTER.RECORD_COUNT);
            if (recordCount == 0L) {
                fileNamePrefix = "part-m-";
                recordCount = AvroKeyCompactorOutputCommitter.getRecordCountFromCounter(context, AvroKeyMapper.EVENT_COUNTER.RECORD_COUNT);
            } else {
                fileNamePrefix = "part-r-";
            }
            String fileName = CompactionRecordCountProvider.constructFileName((String)fileNamePrefix, (long)recordCount);
            for (FileStatus status : fs.listStatus(workPath, new PathFilter(){

                public boolean accept(Path path) {
                    return FilenameUtils.isExtension((String)path.getName(), (String)"avro");
                }
            })) {
                Path newPath = new Path(status.getPath().getParent(), fileName);
                LOG.info(String.format("Renaming %s to %s", status.getPath(), newPath));
                fs.rename(status.getPath(), newPath);
            }
        }
        super.commitTask(context);
    }

    private static long getRecordCountFromCounter(TaskAttemptContext context, Enum<?> counterName) {
        try {
            Method getCounterMethod = context.getClass().getMethod("getCounter", Enum.class);
            return ((Counter)getCounterMethod.invoke((Object)context, counterName)).getValue();
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading record count counter", e);
        }
    }
}

