/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.conditions;

import org.apache.gobblin.annotation.Alias;
import org.apache.gobblin.compaction.conditions.RecompactionCondition;
import org.apache.gobblin.compaction.conditions.RecompactionConditionFactory;
import org.apache.gobblin.compaction.dataset.Dataset;
import org.apache.gobblin.compaction.dataset.DatasetHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="RecompactionConditionBasedOnFileCount")
public class RecompactionConditionBasedOnFileCount
implements RecompactionCondition {
    private final int fileCountLimit;
    private static final Logger logger = LoggerFactory.getLogger(RecompactionConditionBasedOnFileCount.class);

    private RecompactionConditionBasedOnFileCount(Dataset dataset) {
        this.fileCountLimit = this.getOwnFileCountThreshold(dataset);
    }

    private int getOwnFileCountThreshold(Dataset dataset) {
        int count = dataset.jobProps().getPropAsInt("compaction.latedata.threshold.file.num", 1000);
        return count;
    }

    @Override
    public boolean isRecompactionNeeded(DatasetHelper datasetHelper) {
        long fileNum = datasetHelper.getLateOutputFileCount();
        logger.info("File count is " + fileNum + " and threshold is " + this.fileCountLimit);
        return fileNum >= (long)this.fileCountLimit;
    }

    @Alias(value="RecompactBasedOnFileCount")
    public static class Factory
    implements RecompactionConditionFactory {
        @Override
        public RecompactionCondition createRecompactionCondition(Dataset dataset) {
            return new RecompactionConditionBasedOnFileCount(dataset);
        }
    }
}

