/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.action;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.gobblin.compaction.action.CompactionCompleteAction;
import org.apache.gobblin.compaction.parser.CompactionPathParser;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.dataset.FileSystemDataset;
import org.apache.gobblin.hive.HiveRegister;
import org.apache.gobblin.hive.policy.HiveRegistrationPolicy;
import org.apache.gobblin.hive.policy.HiveRegistrationPolicyBase;
import org.apache.gobblin.hive.spec.HiveSpec;
import org.apache.gobblin.metrics.event.EventSubmitter;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionHiveRegistrationAction
implements CompactionCompleteAction<FileSystemDataset> {
    private static final Logger log = LoggerFactory.getLogger(CompactionHiveRegistrationAction.class);
    private final State state;
    private EventSubmitter eventSubmitter;

    public CompactionHiveRegistrationAction(State state) {
        if (!(state instanceof WorkUnitState)) {
            throw new UnsupportedOperationException(this.getClass().getName() + " only supports workunit state");
        }
        this.state = state;
    }

    @Override
    public void onCompactionJobComplete(FileSystemDataset dataset) throws IOException {
        if (this.state.contains("hive.registration.policy")) {
            HiveRegister hiveRegister = HiveRegister.get((State)this.state);
            HiveRegistrationPolicy hiveRegistrationPolicy = HiveRegistrationPolicyBase.getPolicy((State)this.state);
            CompactionPathParser.CompactionParserResult result = new CompactionPathParser(this.state).parse(dataset);
            ArrayList<String> paths = new ArrayList<String>();
            for (HiveSpec spec : hiveRegistrationPolicy.getHiveSpecs(new Path(result.getDstAbsoluteDir()))) {
                hiveRegister.register(spec);
                paths.add(spec.getPath().toUri().toASCIIString());
                log.info("Hive registration is done for {}", (Object)result.getDstAbsoluteDir());
            }
            if (this.eventSubmitter != null) {
                ImmutableMap eventMetadataMap = ImmutableMap.of((Object)"datasetUrn", (Object)dataset.datasetURN(), (Object)"hiveRegistrationPaths", (Object)Joiner.on((char)',').join(paths));
                this.eventSubmitter.submit("CompactionHiveRegistration", (Map)eventMetadataMap);
            }
        }
    }

    @Override
    public void addEventSubmitter(EventSubmitter submitter) {
        this.eventSubmitter = submitter;
    }
}

