/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.action;

import com.google.common.collect.ImmutableMap;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.gobblin.compaction.action.CompactionCompleteAction;
import org.apache.gobblin.compaction.mapreduce.CompactionAvroJobConfigurator;
import org.apache.gobblin.compaction.mapreduce.avro.AvroKeyMapper;
import org.apache.gobblin.compaction.parser.CompactionPathParser;
import org.apache.gobblin.compaction.verify.InputRecordCountHelper;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.dataset.FileSystemDataset;
import org.apache.gobblin.metrics.event.EventSubmitter;
import org.apache.gobblin.util.HadoopUtils;
import org.apache.gobblin.util.WriterUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionCompleteFileOperationAction
implements CompactionCompleteAction<FileSystemDataset> {
    private static final Logger log = LoggerFactory.getLogger(CompactionCompleteFileOperationAction.class);
    protected WorkUnitState state;
    private CompactionAvroJobConfigurator configurator;
    private InputRecordCountHelper helper;
    private EventSubmitter eventSubmitter;
    private FileSystem fs;

    public CompactionCompleteFileOperationAction(State state, CompactionAvroJobConfigurator configurator) {
        if (!(state instanceof WorkUnitState)) {
            throw new UnsupportedOperationException(this.getClass().getName() + " only supports workunit state");
        }
        this.state = (WorkUnitState)state;
        this.helper = new InputRecordCountHelper(state);
        this.configurator = configurator;
        this.fs = configurator.getFs();
    }

    @Override
    public void onCompactionJobComplete(FileSystemDataset dataset) throws IOException {
        if (this.configurator != null && this.configurator.isJobCreated()) {
            FsPermission permission;
            CompactionPathParser.CompactionParserResult result = new CompactionPathParser((State)this.state).parse(dataset);
            Path tmpPath = this.configurator.getMrOutputPath();
            Path dstPath = new Path(result.getDstAbsoluteDir());
            boolean appendDeltaOutput = this.state.getPropAsBoolean("compaction.rename.source.dir.enabled", false);
            Job job = this.configurator.getConfiguredJob();
            long newTotalRecords = 0L;
            long oldTotalRecords = this.helper.readRecordCount(new Path(result.getDstAbsoluteDir()));
            long executeCount = this.helper.readExecutionCount(new Path(result.getDstAbsoluteDir()));
            List<Path> goodPaths = CompactionAvroJobConfigurator.removeFailedPaths(job, tmpPath, this.fs);
            if (appendDeltaOutput) {
                permission = HadoopUtils.deserializeFsPermission((State)this.state, (String)"compaction.job.output.dir.permission", (FsPermission)FsPermission.getDefault());
                WriterUtils.mkdirsWithRecursivePermission((FileSystem)this.fs, (Path)dstPath, (FsPermission)permission);
                for (Path filePath : goodPaths) {
                    String fileName = filePath.getName();
                    log.info(String.format("Adding %s to %s", filePath.toString(), dstPath));
                    Path outPath = new Path(dstPath, fileName);
                    if (this.fs.rename(filePath, outPath)) continue;
                    throw new IOException(String.format("Unable to move %s to %s", filePath.toString(), outPath.toString()));
                }
                newTotalRecords = this.configurator.getFileNameRecordCount();
            } else {
                this.fs.delete(dstPath, true);
                permission = HadoopUtils.deserializeFsPermission((State)this.state, (String)"compaction.job.output.dir.permission", (FsPermission)FsPermission.getDefault());
                WriterUtils.mkdirsWithRecursivePermission((FileSystem)this.fs, (Path)dstPath.getParent(), (FsPermission)permission);
                if (!this.fs.rename(tmpPath, dstPath)) {
                    throw new IOException(String.format("Unable to move %s to %s", tmpPath, dstPath));
                }
                Counter counter = job.getCounters().findCounter((Enum)AvroKeyMapper.EVENT_COUNTER.RECORD_COUNT);
                newTotalRecords = counter.getValue();
            }
            State compactState = this.helper.loadState(new Path(result.getDstAbsoluteDir()));
            compactState.setProp("recordCountTotal", (Object)Long.toString(newTotalRecords));
            compactState.setProp("executionCountTotal", (Object)Long.toString(executeCount + 1L));
            compactState.setProp("mrJobId", (Object)this.configurator.getConfiguredJob().getJobID().toString());
            this.helper.saveState(new Path(result.getDstAbsoluteDir()), compactState);
            log.info("Updating record count from {} to {} in {} [{}]", new Object[]{oldTotalRecords, newTotalRecords, dstPath, executeCount + 1L});
            if (this.eventSubmitter != null) {
                ImmutableMap eventMetadataMap = ImmutableMap.of((Object)"datasetUrn", (Object)dataset.datasetURN(), (Object)"recordCountTotal", (Object)Long.toString(newTotalRecords), (Object)"prevRecordCountTotal", (Object)Long.toString(oldTotalRecords), (Object)"executionCountTotal", (Object)Long.toString(executeCount + 1L), (Object)"mrJobId", (Object)this.configurator.getConfiguredJob().getJobID().toString());
                this.eventSubmitter.submit("CompactionRecordCounts", (Map)eventMetadataMap);
            }
        }
    }

    @Override
    public void addEventSubmitter(EventSubmitter eventSubmitter) {
        this.eventSubmitter = eventSubmitter;
    }

    public String getName() {
        return CompactionCompleteFileOperationAction.class.getName();
    }

    @ConstructorProperties(value={"state", "configurator", "helper", "eventSubmitter", "fs"})
    public CompactionCompleteFileOperationAction(WorkUnitState state, CompactionAvroJobConfigurator configurator, InputRecordCountHelper helper, EventSubmitter eventSubmitter, FileSystem fs) {
        this.state = state;
        this.configurator = configurator;
        this.helper = helper;
        this.eventSubmitter = eventSubmitter;
        this.fs = fs;
    }
}

