/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.filter.compression.streaming;

import com.linkedin.r2.filter.compression.streaming.Bzip2Compressor;
import com.linkedin.r2.filter.compression.streaming.DeflateCompressor;
import com.linkedin.r2.filter.compression.streaming.GzipCompressor;
import com.linkedin.r2.filter.compression.streaming.NoopCompressor;
import com.linkedin.r2.filter.compression.streaming.SnappyCompressor;
import com.linkedin.r2.filter.compression.streaming.StreamingCompressor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;

public enum StreamEncodingType {
    GZIP("gzip"),
    DEFLATE("deflate"),
    SNAPPY_FRAMED("x-snappy-framed"),
    BZIP2("bzip2"),
    IDENTITY("identity"),
    ANY("*");

    private static final Map<String, StreamEncodingType> REVERSE_MAP;
    private final String _httpName;

    private StreamEncodingType(String httpName) {
        this._httpName = httpName;
    }

    public String getHttpName() {
        return this._httpName;
    }

    public StreamingCompressor getCompressor(Executor executor) {
        switch (this) {
            case GZIP: {
                return new GzipCompressor(executor);
            }
            case DEFLATE: {
                return new DeflateCompressor(executor);
            }
            case BZIP2: {
                return new Bzip2Compressor(executor);
            }
            case SNAPPY_FRAMED: {
                return new SnappyCompressor(executor);
            }
            case IDENTITY: {
                return new NoopCompressor();
            }
        }
        return null;
    }

    public static StreamEncodingType get(String httpName) {
        return REVERSE_MAP.get(httpName);
    }

    public static boolean isSupported(String encodingName) {
        return REVERSE_MAP.containsKey(encodingName);
    }

    static {
        HashMap<String, StreamEncodingType> reverseMap = new HashMap<String, StreamEncodingType>();
        for (StreamEncodingType t : StreamEncodingType.values()) {
            reverseMap.put(t.getHttpName(), t);
        }
        REVERSE_MAP = Collections.unmodifiableMap(reverseMap);
    }
}

