/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.filter.compression.streaming;

import com.linkedin.r2.filter.compression.streaming.AbstractCompressor;
import com.linkedin.r2.filter.compression.streaming.StreamEncodingType;
import com.linkedin.r2.filter.compression.streaming.StreamingDeflater;
import com.linkedin.r2.filter.compression.streaming.StreamingInflater;
import com.linkedin.r2.message.stream.entitystream.EntityStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Executor;
import org.iq80.snappy.SnappyFramedInputStream;
import org.iq80.snappy.SnappyFramedOutputStream;

public class SnappyCompressor
extends AbstractCompressor {
    private final Executor _executor;

    public SnappyCompressor(Executor executor) {
        this._executor = executor;
    }

    @Override
    public String getContentEncodingName() {
        return StreamEncodingType.SNAPPY_FRAMED.getHttpName();
    }

    @Override
    protected StreamingInflater createInflater(EntityStream underlying) {
        return new StreamingInflater(underlying, this._executor){

            @Override
            protected InputStream createInputStream(InputStream in) throws IOException {
                return new SnappyFramedInputStream(in, true);
            }
        };
    }

    @Override
    protected StreamingDeflater createDeflater(EntityStream underlying) {
        return new StreamingDeflater(underlying){

            @Override
            protected OutputStream createOutputStream(OutputStream out) throws IOException {
                return new SnappyFramedOutputStream(out);
            }
        };
    }
}

