/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.filter.compression;

import com.linkedin.r2.filter.compression.CompressionException;
import com.linkedin.r2.filter.compression.Compressor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.iq80.snappy.SnappyFramedInputStream;
import org.iq80.snappy.SnappyFramedOutputStream;

public class SnappyFramedCompressor
implements Compressor {
    private static final String HTTP_NAME = "x-snappy-framed";

    @Override
    public String getContentEncodingName() {
        return HTTP_NAME;
    }

    @Override
    public byte[] inflate(InputStream data) throws CompressionException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (SnappyFramedInputStream snappy = new SnappyFramedInputStream(data, true);){
            IOUtils.copy((InputStream)snappy, (OutputStream)out);
        }
        catch (IOException e) {
            throw new CompressionException("Cannot properly decode stream: " + this.getContentEncodingName(), e);
        }
        return out.toByteArray();
    }

    @Override
    public byte[] deflate(InputStream data) throws CompressionException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (SnappyFramedOutputStream snappy = new SnappyFramedOutputStream((OutputStream)out);){
            IOUtils.copy((InputStream)data, (OutputStream)snappy);
        }
        catch (IOException e) {
            throw new CompressionException("Cannot properly decode stream: " + this.getContentEncodingName(), e);
        }
        return out.toByteArray();
    }
}

